<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class JFormFieldUIDatepicker extends JFormFieldText
{
	protected $type = 'UIDatepicker';

	protected function getInput()
	{
		$config     = JFactory::getConfig();
		$user       = JFactory::getUser();
		$filter     = $this->getAttribute('filter', 'user_utc');
		$dateFormat = JComponentHelper::getParams('com_solidres')->get('date_format', 'd-m-Y');
		$jsFormat   = SRUtilities::convertDateFormatPattern($dateFormat);
		$nullDate   = JFactory::getDbo()->getNullDate();

		switch (strtoupper($filter))
		{
			case 'SERVER_UTC':

				if ($this->value && $this->value != $nullDate)
				{
					$date = JFactory::getDate($this->value, 'UTC');
					$date->setTimezone(new DateTimeZone($config->get('offset')));
					$this->value = $date->format('Y-m-d H:i:s', true, false);
				}

				break;

			case 'USER_UTC':

				if ($this->value && $this->value != $nullDate)
				{
					$date = JFactory::getDate($this->value, 'UTC');
					$date->setTimezone($user->getTimezone());
					$this->value = $date->format('Y-m-d H:i:s', true, false);
				}

				break;
		}

		if ($this->value && $this->value != $nullDate && strtotime($this->value) !== false)
		{
			$tz = date_default_timezone_get();
			date_default_timezone_set('UTC');
			$this->value = strftime('%Y-%m-%d', strtotime($this->value));
			date_default_timezone_set($tz);
			$formatValue = JFactory::getDate($this->value)->format($dateFormat, true, false);
		}
		else
		{
			$this->value = '';
			$formatValue = '';
		}

		$id      = preg_replace('/[^0-9a-z\_\-]/i', '', $this->id);
		$options = [
			'dateFormat' => $jsFormat,
			'altField'   => '#' . $id,
			'altFormat'  => 'yy-mm-dd',
		];

		$extraOptions = [
			'showButtonPanel' => false,
			'changeMonth'     => false,
			'changeYear'      => false,
			'numberOfMonths'  => 1,
		];

		foreach ($extraOptions as $name => $value)
		{
			$option         = $this->getAttribute($name, null);
			$options[$name] = null === $option ? $value : $option;

			if (is_numeric($options[$name]))
			{
				$options[$name] = (int) $options[$name];
			}
		}

		SRHtml::_('jquery.ui');
		JHtml::_('script', SRURI_MEDIA . '/assets/js/datePicker/localization/jquery.ui.datepicker-' . JFactory::getLanguage()->getTag() . '.js', false, false);
		JFactory::getDocument()->addScriptDeclaration('Solidres.jQuery(document).ready(function($){			
			$("#' . $id . '-alias").datepicker(' . json_encode($options) . ');			
			$("#' . $id . '-alias").on("change", function() {
			
				if (this.value == "") {
					$("#' . $id . '").val("");
				}
				
				$("#' . $id . '").trigger("change");
			});
			
		});');

		$onChange = empty($this->onchange) ? '' : ' onchange="' . $this->onchange . '"';

		return '<input type="text" id="' . $id . '-alias"' . ($this->hint ? ' class="form-control" placeholder="' . JText::_($this->hint) . '"' : '') . ' value="' . $formatValue . '" autocomplete="off"/>'
			. '<input type="hidden" name="' . $this->name . '" id="' . $id . '" value="' . $this->value . '"' . $onChange . '/>';
	}
}
