<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('JPATH_BASE') or die;

class JFormFieldModal_Media extends JFormField
{
	protected $type = 'Modal_Media';

	protected function getInput()
	{
		$html     = array();
		$href     = JUri::base(true) . '/index.php?option=com_solidres&view=medialist&layout=modal&tmpl=component';
		$required = $this->getAttribute('required');
		$required = $required && ($required != '0' || $required != 'false') ? ' required' : '';
		$class    = $this->getAttribute('class', '') . $required . ' input-medium';
		$html[]   = '<div class="input-append input-group' . $required . '">';
		$html[]   = '     <input type="text" name="' . $this->name . '" readonly id="' . $this->id . '" class="' . $class . '" value="' . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"' . $required . '/>';

		if (!empty($this->value))
		{
			$srMedia = SRFactory::get('solidres.media.media');
			$html[]  = '<a href="' . $srMedia->getMediaUrl($this->value) . '" class="btn btn-default sr-photo cboxElement"><i class="fa fa-image"></i></a>';
		}

		$html[] = '     <a href="#sr-media-modal-field" data-toggle="modal" class="btn btn-default"><span class="icon-file"></span> ' . JText::_('JSELECT') . '</a>';
		$html[] = '     <a href="#" id="' . $this->id . '_clear" class="btn btn-default' . (empty($this->value) ? ' hide' : '') . '"><span class="icon-remove"></span> ' . JText::_('JCLEAR') . '</a>';
		$html[] = '</div>';
		JFactory::getDocument()->addScriptDeclaration('
			Solidres.jQuery(document).ready(function($){	
				$("#' . $this->id . '_clear").on("click", function(e){
					e.preventDefault();
					$("#' . $this->id . '").val("")
						.next(".sr-photo").hide();
					$(this).addClass("hide");
				});
				
				if (!$("#sr-media-modal-field").length) {
					var modal = "<div id=\'sr-media-modal-field\' class=\'modal hide fade\'><div class=\'modal-header\'>"
							+ "<button type=\'button\' class=\'close\' data-dismiss=\'modal\' aria-hidden=\'true\'>&times;</button>"
							+ "<h3>' . JText::_('SR_MEDIA_MANAGER', true) . '</h3></div><div class=\'modal-body\'>"							
							+ "<iframe src=\'' . $href . '\'></iframe></div></div>";
					$("body").append(modal);
		                }
                        
				$("#sr-media-modal-field iframe").on("load", function(){
				        var iframe = $(this).contents();
				        iframe.find("#media-library-insert").attr("id", "media-modal-insert");
				        iframe.on("click", "[data-media-id]", function(e){
				            var media = $(this);     
				            iframe.find("#medialibrary .media-checkbox").prop("checked", false);
				            iframe.find("#medialibrary [data-media-id]").removeClass("media-selected");                           
				            media.addClass("media-selected");
				            media.find(".media-checkbox").prop("checked", true);
				        });
				        
				        iframe.on("dblclick", "[data-media-id]", function(e){
				            e.preventDefault();
				            var media = $(this);
				            if(media.hasClass("media-selected")){
				                $("#' . $this->id . '").val(media.data("mediaValue"));
				                $("#' . $this->id . '_clear").removeClass("hide");
					        $("#sr-media-modal-field").modal("hide");
					    }
				        });
				        
				        iframe.on("click", "#media-modal-insert", function(e){
				            e.preventDefault();
				            if(!iframe.find("[data-media-id].media-selected").length){
				                alert("' . JText::_('SR_NO_MEDIA_SELECTED') . '");
				                return false;
				            }
				            
				            iframe.find("[data-media-id].media-selected").trigger("dblclick");
				    	});
				});
			});
		');

		return join("\n", $html);
	}
}