<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * ---------------------
 *    $options         : (array)  Optional parameters
 *    $label           : (string) The html code for the label (not required if $options['hiddenLabel'] is true)
 *    $input           : (string) The input field html code
 */

if (!empty($options['showonEnabled']))
{
	JHtml::_('jquery.framework');

	if (SR_UIJ4)
	{
		JHtml::_('script', 'system/cms.min.js', array('version' => 'auto', 'relative' => true));
	}
	else
	{
		JHtml::_('script', 'jui/cms.js', false, true);
	}
}

$class = empty($options['class']) ? '' : ' ' . $options['class'];
$rel   = empty($options['rel']) ? '' : ' ' . $options['rel'];
?>

<?php if (empty($options['input_only'])): ?>
    <div class="control-group<?php echo $class; ?>"<?php echo $rel; ?>>
		<?php if (empty($options['hiddenLabel'])) : ?>
            <div class="control-label"><?php echo $label; ?></div>
		<?php endif; ?>
        <div class="controls"><?php echo $input; ?></div>
		<?php if (SR_UIJ4 && !empty($description)) : ?>
            <div>
                <small class="form-text text-muted"><?php echo $description; ?></small>
            </div>
		<?php endif; ?>
    </div>
<?php else: ?>
	<?php echo $input; ?>
<?php endif; ?>