<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 - 2019 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class SolidresControllerPaymentHistory extends JControllerLegacy
{
	public function getModel($name = 'PaymentHistory', $prefix = 'SolidresModel', $config = array('ignore_request' => true))
	{
		JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/models', 'SolidresModel');

		return JModelLegacy::getInstance($name, $prefix, $config);
	}

	public function save()
	{
		$app = JFactory::getApplication();

		try
		{
			if (!JSession::checkToken('get'))
			{
				throw new RuntimeException(JText::_('JINVALID_TOKEN'));
			}

			/**
			 * @var \SolidresModelPaymentHistory $model
			 * @var \Joomla\CMS\Form\Form        $form
			 */
			$model     = $this->getModel();
			$form      = $model->getForm();
			$data      = $app->input->get('paymentHistoryForm', array(), 'array');
			$validData = $form->filter($data);

			if (false === $form->validate($validData))
			{
				$errorMessage = '';

				foreach ($form->getErrors() as $error)
				{
					if ($error instanceof Exception)
					{
						$errorMessage .= '<li>' . $error->getMessage() . '</li>';
					}
					else
					{
						$errorMessage .= '<li>' . $error . '</li>';
					}
				}

				throw new RuntimeException('<ul>' . $errorMessage . '</ul>');
			}

			$resultsData = $model->save($validData);

			if (false === $resultsData)
			{
				throw new RuntimeException($model->getError());
			}

			ob_start();
			SolidresHelper::displayPaymentHistory($validData['reservation_id'], $validData['scope']);
			$responseData = array(
				'displayPaymentHistoryHTML' => ob_get_clean(),
				'reservationData'           => is_array($resultsData) ? $resultsData : array(),
			);

			if (is_array($resultsData) && !$validData['scope'])
			{
				JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');
				$currency = new SRCurrency($resultsData['total_paid'], $validData['currency_id']);

				$resultsData['totalPaidFormatted'] = $currency->format();
				$currency->setValue($resultsData['totalDue']);
				$resultsData['totalDueFormatted'] = $currency->format();
				$responseData['reservationData']  = $resultsData;
			}

			echo new JResponseJson($responseData);
		}
		catch (RuntimeException $e)
		{
			$layoutFile = new JLayoutFile('solidres.modal.bootstrap', JPATH_ADMINISTRATOR . '/components/com_solidres/layouts', array('option' => 'com_solidres'));
			echo new JResponseJson(new RuntimeException($layoutFile->render(array(
				'title' => '<i class="fa fa-warning"></i> Oop!',
				'body'  => '<div style="padding: 15px">' . $e->getMessage() . '</div>',
			))));
		}

		$app->close();
	}

	public function remove()
	{
		$app = JFactory::getApplication();

		try
		{
			if (!JSession::checkToken('get'))
			{
				throw new RuntimeException(JText::_('JINVALID_TOKEN'));
			}

			$id          = (int) $app->input->getUint('id', 0);
			$model       = $this->getModel();
			$resultsData = $model->delete($id);

			if (empty($resultsData))
			{
				throw new RuntimeException($model->getError());
			}

			$responseData = [
				'reservationData' => $resultsData,
			];

			if (isset($resultsData['reservation_asset_id']))
			{
				JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');
				$currency                          = new SRCurrency($resultsData['total_paid'], $resultsData['currency_id']);
				$resultsData['totalPaidFormatted'] = $currency->format();
				$currency->setValue($resultsData['totalDue']);
				$resultsData['totalDueFormatted'] = $currency->format();
				$responseData['reservationData']  = $resultsData;
			}

			echo new JResponseJson($responseData);
		}
		catch (RuntimeException $e)
		{
			echo new JResponseJson($e);
		}

		$app->close();
	}
}
