
--
-- Database: `indigo_v1_4`
--

-- --------------------------------------------------------

--
-- Table structure for table `#__action_logs`
--

DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE `#__action_logs` (
  `id` int(10) UNSIGNED NOT NULL,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__action_logs_extensions`
--

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) UNSIGNED NOT NULL,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__action_logs_extensions`
--

INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin');

-- --------------------------------------------------------

--
-- Table structure for table `#__action_logs_users`
--

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE `#__action_logs_users` (
  `user_id` int(11) UNSIGNED NOT NULL,
  `notify` tinyint(1) UNSIGNED NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__action_log_config`
--

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE `#__action_log_config` (
  `id` int(10) UNSIGNED NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__action_log_config`
--

INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');

-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 547, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 16, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(8, 1, 17, 150, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(9, 1, 151, 152, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 153, 154, 1, 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 155, 160, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
(12, 1, 161, 162, 1, 'com_login', 'com_login', '{}'),
(13, 1, 163, 164, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 165, 166, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 167, 168, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 169, 190, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
(17, 1, 191, 192, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 193, 292, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
(19, 1, 293, 296, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(20, 1, 297, 298, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
(21, 1, 299, 300, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
(22, 1, 301, 302, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 303, 304, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
(24, 1, 305, 308, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
(26, 1, 309, 310, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 18, 37, 2, 'com_content.category.2', 'Uncategorised', '{}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{}'),
(30, 19, 294, 295, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
(32, 24, 306, 307, 2, 'com_users.category.7', 'Uncategorised', '{}'),
(33, 1, 311, 312, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 313, 314, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(35, 1, 315, 316, 1, 'com_tags', 'com_tags', '{}'),
(36, 1, 317, 318, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 319, 320, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 321, 322, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 194, 195, 2, 'com_modules.module.2', 'Login', '{}'),
(41, 18, 196, 197, 2, 'com_modules.module.3', 'Popular Articles', '{}'),
(42, 18, 198, 199, 2, 'com_modules.module.4', 'Recently Added Articles', '{}'),
(43, 18, 200, 201, 2, 'com_modules.module.8', 'Toolbar', '{}'),
(44, 18, 202, 203, 2, 'com_modules.module.9', 'Quick Icons', '{}'),
(45, 18, 204, 205, 2, 'com_modules.module.10', 'Logged-in Users', '{}'),
(46, 18, 206, 207, 2, 'com_modules.module.12', 'Admin Menu', '{}'),
(47, 18, 208, 209, 2, 'com_modules.module.13', 'Admin Submenu', '{}'),
(48, 18, 210, 211, 2, 'com_modules.module.14', 'User Status', '{}'),
(49, 18, 212, 213, 2, 'com_modules.module.15', 'Title', '{}'),
(52, 18, 214, 215, 2, 'com_modules.module.79', 'Multilanguage status', '{}'),
(53, 18, 216, 217, 2, 'com_modules.module.86', 'Joomla Version', '{}'),
(54, 16, 170, 171, 2, 'com_menus.menu.1', 'Main Menu', '{}'),
(55, 18, 218, 219, 2, 'com_modules.module.87', 'Sample Data', '{}'),
(56, 1, 323, 514, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(58, 18, 220, 221, 2, 'com_modules.module.89', 'SP Page Builder', '{}'),
(59, 18, 222, 223, 2, 'com_modules.module.90', 'SP Page Builder Admin Menu', '{}'),
(60, 56, 324, 325, 2, 'com_sppagebuilder.page.1', 'Home Default', '{}'),
(61, 1, 515, 522, 1, 'com_spsimpleportfolio', 'SP Simple Portfolio', '{}'),
(62, 1, 523, 524, 1, 'com_speasyimagegallery', 'COM_SPEASYIMAGEGALLERY', '{}'),
(65, 1, 525, 526, 1, '#__speasyimagegallery_albums.1', '#__speasyimagegallery_albums.1', '{}'),
(69, 8, 38, 57, 2, 'com_content.category.8', 'Blog', '{}'),
(70, 69, 39, 40, 3, 'com_content.article.1', 'How Marching for Science Risks Politicizing It', '{}'),
(71, 69, 41, 42, 3, 'com_content.article.2', 'After Setbacks and Suits, Miami to Open Science Museum', '{}'),
(72, 69, 43, 44, 3, 'com_content.article.3', 'The New Threat to Wolves in and Around Yellowstone', '{}'),
(75, 16, 172, 173, 2, 'com_menus.menu.2', 'Company', '{}'),
(76, 16, 174, 175, 2, 'com_menus.menu.3', 'Quick Links', '{}'),
(78, 69, 45, 46, 3, 'com_content.article.4', 'Broke a Glass? Someday You Might 3-D-Print a New One', '{}'),
(79, 69, 47, 48, 3, 'com_content.article.5', 'Jimmy Kimmel Sheds Light on Health Coverage', '{}'),
(80, 69, 49, 50, 3, 'com_content.article.6', 'As Arctic Ice Vanishes, New Shipping Routes Open', '{}'),
(81, 69, 51, 52, 3, 'com_content.article.7', 'Want to Make More Baskets? Science Has the Answer', '{}'),
(82, 69, 53, 54, 3, 'com_content.article.8', 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', '{}'),
(83, 69, 55, 56, 3, 'com_content.article.9', 'The Making of a Legacy: First Steps in the Trump Era', '{}'),
(84, 18, 224, 225, 2, 'com_modules.module.96', 'Joomla Module', '{}'),
(88, 18, 226, 227, 2, 'com_modules.module.98', 'Latest Articles (Megamenu)', '{}'),
(89, 18, 228, 229, 2, 'com_modules.module.99', 'Offcanvas', '{}'),
(90, 1, 527, 528, 1, 'com_fields', 'com_fields', '{}'),
(91, 1, 529, 530, 1, 'com_associations', 'com_associations', '{}'),
(92, 1, 531, 532, 1, 'com_privacy', 'com_privacy', '{}'),
(93, 1, 533, 534, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(94, 16, 176, 177, 2, 'com_menus.menu.4', 'Secondary Menu', '{}'),
(95, 16, 178, 179, 2, 'com_menus.menu.5', 'Bottom-01', '{}'),
(96, 16, 180, 181, 2, 'com_menus.menu.6', 'Bottom-02', '{}'),
(97, 18, 230, 231, 2, 'com_modules.module.100', 'Bottom-01', '{}'),
(98, 18, 232, 233, 2, 'com_modules.module.101', 'Bottom-02', '{}'),
(99, 18, 234, 235, 2, 'com_modules.module.102', 'Contact Info', '{}'),
(100, 18, 236, 237, 2, 'com_modules.module.103', 'Subscribe to our newsletter', '{}'),
(101, 18, 238, 239, 2, 'com_modules.module.104', 'Footer-01', '{}'),
(102, 18, 240, 241, 2, 'com_modules.module.105', 'Footer-02', '{}'),
(103, 56, 326, 327, 2, 'com_sppagebuilder.page.6', 'About', '{}'),
(104, 56, 328, 329, 2, 'com_sppagebuilder.page.4', 'Footer-01', '{}'),
(105, 56, 330, 331, 2, 'com_sppagebuilder.page.7', 'Services', '{}'),
(106, 56, 332, 333, 2, 'com_sppagebuilder.page.8', 'Services 2', '{}'),
(107, 8, 58, 109, 2, 'com_content.category.9', 'Indigo', '{}'),
(108, 107, 59, 66, 3, 'com_content.category.10', 'Entertainment', '{}'),
(109, 107, 67, 92, 3, 'com_content.category.11', 'Life Style', '{}'),
(110, 107, 93, 96, 3, 'com_content.category.12', 'Sports', '{}'),
(111, 107, 97, 98, 3, 'com_content.category.13', 'Natural', '{}'),
(112, 107, 99, 100, 3, 'com_content.category.14', 'Photography', '{}'),
(113, 107, 101, 102, 3, 'com_content.category.15', 'Journal', '{}'),
(114, 107, 103, 104, 3, 'com_content.category.16', 'Uncategorised', '{}'),
(115, 108, 60, 61, 4, 'com_content.article.10', 'Cleaning And Organizing Your Computer', '{}'),
(116, 56, 334, 335, 2, 'com_sppagebuilder.page.10', 'Team', '{}'),
(117, 56, 336, 337, 2, 'com_sppagebuilder.page.11', 'Home agency', '{}'),
(119, 1, 535, 536, 1, '#__ucm_content.2', '#__ucm_content.2', '{}'),
(120, 108, 62, 63, 4, 'com_content.article.11', 'Pos Hardware More Options In Less Space', '{}'),
(121, 108, 64, 65, 4, 'com_content.article.12', 'Change Your Mind Change Your Luck', '{}'),
(122, 110, 94, 95, 4, 'com_content.article.13', 'Mind Power The Ultimate Success Formula', '{}'),
(123, 109, 82, 83, 4, 'com_content.article.14', 'Alabama Approves contract Extension', '{}'),
(124, 1, 537, 538, 1, '#__ucm_content.3', '#__ucm_content.3', '{}'),
(125, 109, 80, 81, 4, 'com_content.article.15', 'As Hulu Live Is Introduced, a Look at Tv', '{}'),
(126, 109, 78, 79, 4, 'com_content.article.16', 'Rising Seas Erode Shorelines Tasmania', '{}'),
(127, 109, 76, 77, 4, 'com_content.article.17', 'Champions League: Cristiano Ronaldo’s', '{}'),
(128, 109, 74, 75, 4, 'com_content.article.18', 'Daily Report: Removing Checks to the', '{}'),
(129, 109, 72, 73, 4, 'com_content.article.19', 'Far From France, Island Outpost Never', '{}'),
(130, 109, 70, 71, 4, 'com_content.article.20', 'Group Led Jeb Bush and Derek Jeter Is', '{}'),
(131, 109, 68, 69, 4, 'com_content.article.21', 'In Disposable Mucus Houses, These Zoo', '{}'),
(132, 109, 84, 85, 4, 'com_content.article.22', 'Kenny Sears, Knicks’ Two-Time Leading', '{}'),
(133, 109, 90, 91, 4, 'com_content.article.23', 'Luis Olmo, a Pionring Puerto Rican', '{}'),
(134, 109, 88, 89, 4, 'com_content.article.24', 'Meet Toronto’s Gavewelding, Shooting', '{}'),
(135, 109, 86, 87, 4, 'com_content.article.25', 'Pizzi Announces $1 Billion Fund to U.S.', '{}'),
(136, 18, 242, 243, 2, 'com_modules.module.106', 'Categories', '{}'),
(137, 18, 244, 245, 2, 'com_modules.module.107', 'Latest Post', '{}'),
(138, 18, 246, 247, 2, 'com_modules.module.108', 'Latest Portfolio', '{}'),
(140, 1, 539, 540, 1, 'com_j2store', 'J2Store', '{}'),
(141, 18, 248, 249, 2, 'com_modules.module.109', 'J2 Store Chart', '{}'),
(142, 18, 250, 251, 2, 'com_modules.module.110', 'J2 Store Stats Mini', '{}'),
(143, 18, 252, 253, 2, 'com_modules.module.111', 'J2 Store Orders', '{}'),
(144, 18, 254, 255, 2, 'com_modules.module.112', 'J2 Store Stats', '{}'),
(145, 18, 256, 257, 2, 'com_modules.module.113', 'J2Store Administrator Menu', '{}'),
(147, 18, 258, 259, 2, 'com_modules.module.115', 'J2 Store Cart', '{}'),
(148, 149, 111, 112, 3, 'com_content.article.26', 'Netus et malesuada fames ac turpis egestas', '{}'),
(149, 8, 110, 149, 2, 'com_content.category.17', 'Shop', '{}'),
(150, 61, 516, 517, 2, 'com_spsimpleportfolio.category.18', 'Client', '{}'),
(151, 56, 338, 339, 2, 'com_sppagebuilder.page.29', 'about 2', '{}'),
(152, 56, 340, 341, 2, 'com_sppagebuilder.page.30', 'Pricing', '{}'),
(153, 56, 342, 343, 2, 'com_sppagebuilder.page.31', 'Contact', '{}'),
(154, 56, 344, 345, 2, 'com_sppagebuilder.page.32', 'Contact 2', '{}'),
(155, 56, 346, 347, 2, 'com_sppagebuilder.page.33', 'Home Shop', '{}'),
(156, 56, 348, 349, 2, 'com_sppagebuilder.page.34', 'Matrix holistic deliverables', '{}'),
(157, 1, 541, 542, 1, '#__ucm_content.4', '#__ucm_content.4', '{}'),
(158, 61, 518, 519, 2, 'com_spsimpleportfolio.category.19', 'Projects', '{}'),
(161, 18, 260, 261, 2, 'com_modules.module.116', 'Featured Products', '{}'),
(164, 18, 262, 263, 2, 'com_modules.module.119', 'J2Store Categories', '{}'),
(171, 18, 264, 265, 2, 'com_modules.module.121', 'Latest Products', '{}'),
(173, 27, 19, 20, 3, 'com_content.article.34', 'Cras adipiscing enim eu turpis egestas', '{}'),
(174, 149, 113, 114, 3, 'com_content.article.35', 'Amazfit Bip Smartwatch with All-Day Battery Life', '{}'),
(175, 27, 21, 22, 3, 'com_content.article.36', 'Rapoo VM210 Neckband Waterproof and Sweatproof Wireless', '{}'),
(176, 149, 129, 130, 3, 'com_content.article.37', 'Micro Center 128GB Class 10 Micro SDXC', '{}'),
(177, 149, 137, 138, 3, 'com_content.article.38', 'Huawei Y6 Pro (2019) (Midnight Black)', '{}'),
(178, 149, 117, 118, 3, 'com_content.article.39', 'LETSCOM Bluetooth Headphones IPX7 Waterproof', '{}'),
(179, 27, 23, 24, 3, 'com_content.article.40', 'Amazfit Verge Smartwatch with Alexa Built-in, GPS Plus GLONASS', '{}'),
(180, 149, 141, 142, 3, 'com_content.article.41', 'Havit Wireless Keyboard & Mouse-KB653GCM(Black)', '{}'),
(181, 27, 25, 26, 3, 'com_content.article.42', 'SNAPTAIN A15 Foldable FPV WiFi Drone w/Voice ', '{}'),
(182, 56, 350, 351, 2, 'com_sppagebuilder.page.51', 'Home classic', '{}'),
(183, 149, 119, 120, 3, 'com_content.article.43', 'Bose SoundLink Around-ear Wireless Headphones', '{}'),
(184, 149, 133, 134, 3, 'com_content.article.44', 'Apple Watch Series 4 (GPS, 372mm) - Space Gray', '{}'),
(185, 27, 27, 28, 3, 'com_content.article.45', 'DJI Osmo Action 4K Camera with Deluxe', '{}'),
(186, 149, 121, 122, 3, 'com_content.article.46', 'Amazfit Verge Smartwatch with Alexa Built-in gps', '{}'),
(187, 149, 123, 124, 3, 'com_content.article.47', 'OEM Amazing 2019 Stereo Headphones for Samsung', '{}'),
(188, 27, 29, 30, 3, 'com_content.article.48', 'Apple iMac ME088LL/A 27-Inch, 1TB Hard ', '{}'),
(189, 27, 31, 32, 3, 'com_content.article.49', 'OtterBox Defender Series Case for Pixel 3a', '{}'),
(190, 149, 139, 140, 3, 'com_content.article.50', 'CVPKG Presents - Lid Organizer for Pelican 1535 Air.', '{}'),
(191, 149, 127, 128, 3, 'com_content.article.51', 'Onbio Bluetooth Headphones, Noise Cancelling Headphones', '{}'),
(192, 149, 125, 126, 3, 'com_content.article.52', 'Apple Watch Series 3 (GPS, 36mm) - Space Gray', '{}'),
(193, 149, 135, 136, 3, 'com_content.article.53', 'Lid Organizer for The Nanuk 935 Case.', '{}'),
(194, 149, 131, 132, 3, 'com_content.article.54', 'Honor 10 Lite (Sapphire Blue, 3GB RAM, 64GB Storage)', '{}'),
(195, 149, 147, 148, 3, 'com_content.article.55', 'OnePlus 7 (Mirror Grey, 6GB RAM, 128GB Storage)', '{}'),
(196, 27, 33, 34, 3, 'com_content.article.56', '2 Black Replacement latches for Pelican Cases. 2 Black Replacement latches for Pelican Cases.', '{}'),
(197, 149, 115, 116, 3, 'com_content.article.57', 'Apple Watch Series 3 (GPS, 42mm) - Space Gray', '{}'),
(198, 27, 35, 36, 3, 'com_content.article.58', 'Nest Aware', '{}'),
(199, 149, 143, 144, 3, 'com_content.article.59', 'OnePlus 7 (Mirror Grey, 6GB RAM, 128GB Storage)', '{}'),
(200, 149, 145, 146, 3, 'com_content.article.60', 'Honor 10 Lite (Sapphire Blue, 3GB RAM, 32GB Storage)', '{}'),
(201, 56, 352, 353, 2, 'com_sppagebuilder.category.20', 'Addon', '{}'),
(202, 56, 354, 355, 2, 'com_sppagebuilder.page.70', 'Icon', '{}'),
(203, 56, 356, 357, 2, 'com_sppagebuilder.page.71', 'Icons group', '{}'),
(204, 56, 358, 359, 2, 'com_sppagebuilder.page.72', 'Image', '{}'),
(205, 56, 360, 361, 2, 'com_sppagebuilder.page.73', 'Image content', '{}'),
(206, 56, 362, 363, 2, 'com_sppagebuilder.page.74', 'Image layouts', '{}'),
(207, 56, 364, 365, 2, 'com_sppagebuilder.page.75', 'Image overlay', '{}'),
(208, 56, 366, 367, 2, 'com_sppagebuilder.page.76', 'Instagram gallery', '{}'),
(209, 56, 368, 369, 2, 'com_sppagebuilder.page.77', 'Slideshow', '{}'),
(210, 56, 370, 371, 2, 'com_sppagebuilder.page.78', 'Modal popup', '{}'),
(211, 56, 372, 373, 2, 'com_sppagebuilder.page.79', 'Navigation', '{}'),
(212, 56, 374, 375, 2, 'com_sppagebuilder.page.80', 'Open street map', '{}'),
(213, 56, 376, 377, 2, 'com_sppagebuilder.page.81', 'Opt-in form', '{}'),
(214, 56, 378, 379, 2, 'com_sppagebuilder.page.82', 'Person', '{}'),
(215, 56, 380, 381, 2, 'com_sppagebuilder.page.83', 'Pie progress', '{}'),
(216, 56, 382, 383, 2, 'com_sppagebuilder.page.84', 'Price list', '{}'),
(217, 56, 384, 385, 2, 'com_sppagebuilder.page.85', 'Pricing table', '{}'),
(218, 56, 386, 387, 2, 'com_sppagebuilder.page.86', 'Progress bar', '{}'),
(219, 56, 388, 389, 2, 'com_sppagebuilder.page.87', 'Raw html', '{}'),
(220, 56, 390, 391, 2, 'com_sppagebuilder.page.88', 'Social share', '{}'),
(221, 56, 392, 393, 2, 'com_sppagebuilder.page.89', 'Soundcloud', '{}'),
(222, 56, 394, 395, 2, 'com_sppagebuilder.page.90', 'Tabs', '{}'),
(223, 56, 396, 397, 2, 'com_sppagebuilder.page.91', 'Testimonials', '{}'),
(224, 56, 398, 399, 2, 'com_sppagebuilder.page.92', 'Testimonial pro', '{}'),
(225, 56, 400, 401, 2, 'com_sppagebuilder.page.93', 'Text block', '{}'),
(226, 56, 402, 403, 2, 'com_sppagebuilder.page.94', 'Timeline', '{}'),
(227, 56, 404, 405, 2, 'com_sppagebuilder.page.95', 'Twitter feed', '{}'),
(228, 56, 406, 407, 2, 'com_sppagebuilder.page.96', 'Video', '{}'),
(229, 56, 408, 409, 2, 'com_sppagebuilder.page.97', 'Audio', '{}'),
(230, 56, 410, 411, 2, 'com_sppagebuilder.page.98', 'Block number', '{}'),
(231, 56, 412, 413, 2, 'com_sppagebuilder.page.99', 'Button', '{}'),
(232, 56, 414, 415, 2, 'com_sppagebuilder.page.100', 'Button group', '{}'),
(233, 56, 416, 417, 2, 'com_sppagebuilder.page.101', 'Carousel', '{}'),
(234, 56, 418, 419, 2, 'com_sppagebuilder.page.102', 'Carousel pro', '{}'),
(235, 56, 420, 421, 2, 'com_sppagebuilder.page.103', 'Clients', '{}'),
(236, 56, 422, 423, 2, 'com_sppagebuilder.page.104', 'Countdown', '{}'),
(237, 56, 424, 425, 2, 'com_sppagebuilder.page.105', 'Divider', '{}'),
(238, 56, 426, 427, 2, 'com_sppagebuilder.page.106', 'Empty space', '{}'),
(239, 56, 428, 429, 2, 'com_sppagebuilder.page.107', 'Feature box', '{}'),
(240, 56, 430, 431, 2, 'com_sppagebuilder.page.108', 'Flickr gallery', '{}'),
(241, 56, 432, 433, 2, 'com_sppagebuilder.page.109', 'Flip box', '{}'),
(242, 56, 434, 435, 2, 'com_sppagebuilder.page.110', 'Form builder', '{}'),
(243, 56, 436, 437, 2, 'com_sppagebuilder.page.111', 'Gallery', '{}'),
(244, 56, 438, 439, 2, 'com_sppagebuilder.page.112', 'Google map', '{}'),
(245, 56, 440, 441, 2, 'com_sppagebuilder.page.113', 'Articles scroller', '{}'),
(246, 56, 442, 443, 2, 'com_sppagebuilder.page.114', 'Articles', '{}'),
(247, 56, 444, 445, 2, 'com_sppagebuilder.page.115', 'Animated number', '{}'),
(248, 56, 446, 447, 2, 'com_sppagebuilder.page.116', 'Addon list', '{}'),
(249, 56, 448, 449, 2, 'com_sppagebuilder.page.117', 'Joomla module', '{}'),
(250, 56, 450, 451, 2, 'com_sppagebuilder.page.118', 'Contact form', '{}'),
(251, 56, 452, 453, 2, 'com_sppagebuilder.page.119', 'Alert', '{}'),
(252, 56, 454, 455, 2, 'com_sppagebuilder.page.120', 'Animated heading', '{}'),
(253, 56, 456, 457, 2, 'com_sppagebuilder.page.121', 'Heading', '{}'),
(254, 56, 458, 459, 2, 'com_sppagebuilder.page.122', 'Accordion', '{}'),
(255, 56, 460, 461, 2, 'com_sppagebuilder.page.123', 'Team 2', '{}'),
(256, 18, 266, 267, 2, 'com_modules.module.122', 'Login / Registration', '{}'),
(258, 56, 462, 463, 2, 'com_sppagebuilder.page.125', 'Home Creative', '{}'),
(259, 61, 520, 521, 2, 'com_spsimpleportfolio.category.21', 'Portfolios', '{}'),
(260, 18, 268, 269, 2, 'com_modules.module.124', 'Latest Portfolio', '{}'),
(261, 56, 464, 465, 2, 'com_sppagebuilder.page.126', 'sdfsdfsdfs', '{}'),
(262, 1, 543, 544, 1, '#__speasyimagegallery_albums.2', '#__speasyimagegallery_albums.2', '{}'),
(263, 56, 466, 467, 2, 'com_sppagebuilder.page.127', 'iaculis nunc sed augue lacus', '{}'),
(264, 56, 468, 469, 2, 'com_sppagebuilder.page.128', 'Id nibh tortor id aliquet lectus proin nibh nisl', '{}'),
(265, 56, 470, 471, 2, 'com_sppagebuilder.page.129', 'Vulputate dignissim suspendisse in est ante in nibh mauris', '{}'),
(266, 56, 472, 473, 2, 'com_sppagebuilder.page.130', 'Id venenatis a condimentum vitae sapien pellentesque habitant morbi', '{}'),
(267, 56, 474, 475, 2, 'com_sppagebuilder.page.132', 'nulla facilisi cras fermentum odio', '{}'),
(268, 56, 476, 477, 2, 'com_sppagebuilder.page.133', 'mauris sit amet massa vitae', '{}'),
(269, 56, 478, 479, 2, 'com_sppagebuilder.page.134', 'lorem mollis aliquam ut porttitor', '{}'),
(270, 56, 480, 481, 2, 'com_sppagebuilder.page.135', 'In ornare quam viverra orci', '{}'),
(271, 56, 482, 483, 2, 'com_sppagebuilder.page.136', 'Erat imperdiet sed euismod nisi', '{}'),
(272, 56, 484, 485, 2, 'com_sppagebuilder.page.137', 'Ornare lectus sit amet est', '{}'),
(273, 56, 486, 487, 2, 'com_sppagebuilder.page.138', 'Egestas integer eget aliquet nibh', '{}'),
(274, 56, 488, 489, 2, 'com_sppagebuilder.page.139', 'Ante in nibh mauris cursus', '{}'),
(275, 56, 490, 491, 2, 'com_sppagebuilder.page.140', 'Et molestie ac feugiat sed', '{}'),
(276, 56, 492, 493, 2, 'com_sppagebuilder.page.141', 'Eget lorem dolor sed viverra', '{}'),
(277, 56, 494, 495, 2, 'com_sppagebuilder.page.142', 'Nisl rhoncus mattis rhoncus urna neque viverra justo nec', '{}'),
(278, 56, 496, 497, 2, 'com_sppagebuilder.page.143', 'Dolor morbi non arcu risus quis varius quam quisque', '{}'),
(279, 56, 498, 499, 2, 'com_sppagebuilder.page.144', 'Nibh venenatis cras sed felis eget velit aliquet sagittis', '{}'),
(280, 56, 500, 501, 2, 'com_sppagebuilder.page.145', 'Diam maecenas ultricies mi eget mauris pharetra et ultrices', '{}'),
(281, 56, 502, 503, 2, 'com_sppagebuilder.page.146', 'Tortor aliquam nulla facilisi cras fermentum odio eu feugiat', '{}'),
(282, 56, 504, 505, 2, 'com_sppagebuilder.page.147', 'Diam phasellus vestibulum lorem sed risus ultricies tristique nulla', '{}'),
(283, 56, 506, 507, 2, 'com_sppagebuilder.page.148', 'Suspendisse ultrices gravida dictum fusce ut placerat orci nulla', '{}'),
(284, 56, 508, 509, 2, 'com_sppagebuilder.page.131', 'Arcu felis bibendum ut tristique et egestas quis ipsum', '{}'),
(285, 56, 510, 511, 2, 'com_sppagebuilder.page.149', 'Nulla facilisi morbi tempus iaculis', '{}'),
(286, 11, 156, 157, 2, 'com_languages.language.2', 'Arabic Unitag (العربية الموحدة)', '{}'),
(287, 16, 182, 183, 2, 'com_menus.menu.7', 'Home Ar', '{}'),
(288, 16, 184, 185, 2, 'com_menus.menu.8', 'Home En', '{}'),
(289, 18, 270, 271, 2, 'com_modules.module.125', 'Language Switcher', '{}'),
(290, 11, 158, 159, 2, 'com_languages.language.1', 'English (en-GB)', '{}'),
(291, 18, 272, 273, 2, 'com_modules.module.126', 'Latest Post', '{}'),
(293, 16, 186, 187, 2, 'com_menus.menu.9', 'Full Menu', '{}'),
(294, 18, 274, 275, 2, 'com_modules.module.127', 'Search', '{}'),
(295, 18, 276, 277, 2, 'com_modules.module.128', 'J2 Store Cart', '{}'),
(296, 18, 278, 279, 2, 'com_modules.module.129', 'Login / Registration', '{}'),
(297, 18, 280, 281, 2, 'com_modules.module.130', 'Language Switcher', '{}'),
(298, 18, 282, 283, 2, 'com_modules.module.131', 'Social Icons', '{}'),
(299, 56, 512, 513, 2, 'com_sppagebuilder.page.150', 'Social Icons', '{}'),
(300, 18, 284, 285, 2, 'com_modules.module.132', 'Latest Products', '{}'),
(302, 107, 105, 108, 3, 'com_content.category.22', 'Videos', '{}'),
(303, 302, 106, 107, 4, 'com_content.article.62', 'Pizzi Announces $1 Billion Fund to U.S.', '{}'),
(304, 1, 545, 546, 1, '#__ucm_content.6', '#__ucm_content.6', '{}'),
(305, 16, 188, 189, 2, 'com_menus.menu.10', 'Hidden Menu', '{}'),
(306, 18, 286, 287, 2, 'com_modules.module.133', 'Banner(Megamenu)', '{}'),
(307, 18, 288, 289, 2, 'com_modules.module.134', 'Blog Listing Top', '{}'),
(308, 18, 290, 291, 2, 'com_modules.module.135', 'Search Right Sidebar', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 41, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '{}', 336, '2020-01-21 05:51:17', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 9, 10, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 69, 1, 11, 12, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(9, 107, 1, 13, 30, 1, 'indigo', 'com_content', 'Indigo', 'indigo', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(10, 108, 9, 14, 15, 2, 'indigo/entertainment', 'com_content', 'Entertainment', 'entertainment', '', '', 1, 948, '2019-11-08 05:36:46', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 336, '2020-01-21 05:51:17', 0, '*', 1),
(11, 109, 9, 16, 17, 2, 'indigo/life-style', 'com_content', 'Life Style', 'life-style', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 336, '2020-01-21 05:51:17', 0, '*', 1),
(12, 110, 9, 18, 19, 2, 'indigo/sports', 'com_content', 'Sports', 'sports', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(13, 111, 9, 20, 21, 2, 'indigo/natural', 'com_content', 'Natural', 'natural', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(14, 112, 9, 22, 23, 2, 'indigo/photography', 'com_content', 'Photography', 'photography', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(15, 113, 9, 24, 25, 2, 'indigo/journal', 'com_content', 'Journal', 'journal', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(16, 114, 9, 26, 27, 2, 'indigo/uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(17, 149, 1, 31, 32, 1, 'shop', 'com_content', 'Shop', 'shop', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(18, 150, 1, 33, 34, 1, 'client', 'com_spsimpleportfolio', 'Client', 'client', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(19, 158, 1, 35, 36, 1, 'projects', 'com_spsimpleportfolio', 'Projects', 'projects', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(20, 201, 1, 37, 38, 1, 'addon', 'com_sppagebuilder', 'Addon', 'addon', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(21, 259, 1, 39, 40, 1, 'portfolios', 'com_spsimpleportfolio', 'Portfolios', 'portfolios', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1),
(22, 302, 9, 28, 29, 2, 'indigo/videos', 'com_content', 'Videos', 'videos', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 336, '2020-01-21 05:51:17', 0, '2020-01-21 05:51:17', 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact', 'contact', '', '', '', '', '', '', '', '', '', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 871, 4, 1, '', '', '', '', '', '*', '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 83);

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(1, 70, 'How Marching for Science Risks Politicizing It', 'how-marching-for-science-risks-politicizing-it', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog3.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 11, 9, '', '', 1, 37, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(2, 71, 'After Setbacks and Suits, Miami to Open Science Museum', 'after-setbacks-and-suits-miami-to-open-science-museum', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog2.jpg\",\"helix_ultimate_article_format\":\"audio\",\"helix_ultimate_audio\":\"<iframe scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/399014505&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\"><\\/iframe>\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 8, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(3, 72, 'The New Threat to Wolves in and Around Yellowstone', 'the-new-threat-to-wolves-in-and-around-yellowstone', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog12.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 10, 7, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(4, 78, 'Broke a Glass? Someday You Might 3-D-Print a New One', 'broke-a-glass-someday-you-might-3-d-print-a-new-one', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog4.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(5, 79, 'Jimmy Kimmel Sheds Light on Health Coverage', 'jimmy-kimmel-sheds-light-on-health-coverage', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog5.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 5, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(6, 80, 'As Arctic Ice Vanishes, New Shipping Routes Open', 'as-arctic-ice-vanishes-new-shipping-routes-open', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog6.jpg\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=YZcT74ZqkOA\"}', 6, 4, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(7, 81, 'Want to Make More Baskets? Science Has the Answer', 'want-to-make-more-baskets-science-has-the-answer', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog7.jpg\",\"helix_ultimate_article_format\":\"gallery\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2018\\/02\\/23\\/blog31.jpg\\\",\\\"images\\/2018\\/02\\/23\\/blog41.jpg\\\",\\\"images\\/2018\\/02\\/23\\/blog51.jpg\\\",\\\"images\\/2018\\/02\\/23\\/blog111.jpg\\\"]}\",\"helix_ultimate_video\":\"\"}', 6, 3, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(8, 82, 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', 'debate-over-paris-climate-deal-could-turn-on-a-single-phrase', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog10.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 2, '', '', 1, 11, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(9, 83, 'The Making of a Legacy: First Steps in the Trump Era', 'the-making-of-a-legacy-first-steps-in-the-trump-era', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog81.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 15, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(10, 115, 'Cleaning And Organizing Your Computer', 'cleaning-and-organizing-your-computer', '', '', 1, 10, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/13\\/blog-01.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 80, 10, '', '', 1, 85, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(11, 120, 'Pos Hardware More Options In Less Space', 'pos-hardware-more-options-in-less-space', '', '', 1, 10, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-02.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 9, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(12, 121, 'Change Your Mind Change Your Luck', 'change-your-mind-change-your-luck', '', '', 1, 10, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-03.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 8, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(13, 122, 'Mind Power The Ultimate Success Formula', 'mind-power-the-ultimate-success-formula', '', '', 1, 12, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-04.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 3, '', '', 1, 20, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(14, 123, 'Alabama Approves contract Extension', 'alabama-approves-contract-extension', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-05.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 12, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(15, 125, 'As Hulu Live Is Introduced, a Look at Tv', 'as-hulu-live-is-introduced-a-look-at-tv', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-06.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 11, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(16, 126, 'Rising Seas Erode Shorelines Tasmania', 'rising-seas-erode-shorelines-tasmania', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-07.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 10, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(17, 127, 'Champions League: Cristiano Ronaldo’s', 'champions-league-cristiano-ronaldo-s', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-08.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 9, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(18, 128, 'Daily Report: Removing Checks to the', 'daily-report-removing-checks-to-the', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-09.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 8, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(19, 129, 'Far From France, Island Outpost Never', 'far-from-france-island-outpost-never', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-10.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 7, '', '', 1, 12, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(20, 130, 'Group Led Jeb Bush and Derek Jeter Is', 'group-led-jeb-bush-and-derek-jeter-is', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-11.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 5, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(21, 131, 'In Disposable Mucus Houses, These Zoo', 'in-disposable-mucus-houses-these-zoo', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-12.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 3, '', '', 1, 9, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(22, 132, 'Kenny Sears, Knicks’ Two-Time Leading', 'kenny-sears-knicks-two-time-leading', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-01.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 1, '', '', 1, 22, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(23, 133, 'Luis Olmo, a Pionring Puerto Rican', 'luis-olmo-a-pionring-puerto-rican', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-021.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 6, 6, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(24, 134, 'Meet Toronto’s Gavewelding, Shooting', 'meet-toronto-s-gavelwelding-shooting', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-031.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 9, 4, '', '', 1, 29, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(25, 135, 'Pizzi Announces $1 Billion Fund to U.S.', 'pizzi-announces-1-billion-fund-to-u-s', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 11, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-041.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 12, 2, '', '', 1, 253, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(26, 148, 'Netus et malesuada fames ac turpis egestas', 'netus-et-malesuada-fames-ac-turpis-egestas', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 20, 9, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(34, 173, 'Cras adipiscing enim eu turpis egestas', 'cras-adipiscing-enim-eu-turpis-egestas', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 23, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(35, 174, 'Amazfit Bip Smartwatch with All-Day Battery Life', 'amazfit-bip-smartwatch-with-all-day-battery-life', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 14, 19, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(36, 175, 'Rapoo VM210 Neckband Waterproof and Sweatproof Wireless', 'rapoo-vm210-neckband-waterproof-and-sweatproof-wireless', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n<p>To know more, go to <strong>www.example.com</strong></p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 21, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(37, 176, 'Micro Center 128GB Class 10 Micro SDXC', 'micro-center-128gb-class-10-micro-sdxc', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 18, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(38, 177, 'Huawei Y6 Pro (2019) (Midnight Black)', 'huawei-y6-pro-2019-midnight-black', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 17, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(39, 178, 'LETSCOM Bluetooth Headphones IPX7 Waterproof', 'letscom-bluetooth-headphones-ipx7-waterproof', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 16, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(40, 179, 'Amazfit Verge Smartwatch with Alexa Built-in, GPS Plus GLONASS', 'amazfit-verge-smartwatch-with-alexa-built-in-gps-plus-glonass', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n<p>To know more, go to <strong>www.example.com</strong></p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 0, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 17, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(41, 180, 'Havit Wireless Keyboard & Mouse-KB653GCM(Black)', 'havit-wireless-keyboard-mouse-kb653gcm-black', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 9, 15, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(42, 181, 'SNAPTAIN A15 Foldable FPV WiFi Drone w/Voice ', 'snaptain-a15-foldable-fpv-wifi-drone-w-voice', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n<p>To know more, go to <strong>www.example.com</strong></p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 15, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(43, 183, 'Bose SoundLink Around-ear Wireless Headphones', 'bose-soundlink-around-ear-wireless-headphones', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 14, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(44, 184, 'Apple Watch Series 4 (GPS, 372mm) - Space Gray', 'apple-watch-series-4-gps-372mm-space-gray', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 13, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(45, 185, 'DJI Osmo Action 4K Camera with Deluxe', 'dji-osmo-action-4k-camera-with-deluxe', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n<p>To know more, go to <strong>www.example.com</strong></p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 12, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(46, 186, 'Amazfit Verge Smartwatch with Alexa Built-in gps', 'amazfit-verge-smartwatch-with-alexa-built-in-gps', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 12, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(47, 187, 'OEM Amazing 2019 Stereo Headphones for Samsung', 'oem-amazing-2019-stereo-headphones-for-samsung', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 11, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(48, 188, 'Apple iMac ME088LL/A 27-Inch, 1TB Hard ', 'apple-imac-me088ll-a-27-inch-1tb-hard', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n<p>To know more, go to <strong>www.example.com</strong></p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 9, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(49, 189, 'OtterBox Defender Series Case for Pixel 3a', 'otterbox-defender-series-case-for-pixel-3a', '<div class=\"column-section title viewed\">Rugged and ready.</div>\r\n<p class=\"column-section paragraph viewed\">A rugged polycarbonate shell and synthetic rubber slipcover work together to protect against drops, dust, and scratches.</p>\r\n<div class=\"column-section title viewed\"> </div>\r\n<div class=\"column-section title viewed\">Tough, trusted ally.</div>\r\n<p class=\"column-section paragraph viewed\">Thermal shock tests, abrasion tests, drop tests and more. Defender Series endured more than 24 rigorous assessments¹ over 238 hours, so this case works and plays as hard as you do.</p>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 8, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(50, 190, 'CVPKG Presents - Lid Organizer for Pelican 1535 Air.', 'cvpkg-presents-lid-organizer-for-pelican-1535-air', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 8, 10, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(51, 191, 'Onbio Bluetooth Headphones, Noise Cancelling Headphones', 'onbio-bluetooth-headphones-noise-cancelling-headphones', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 8, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(52, 192, 'Apple Watch Series 3 (GPS, 36mm) - Space Gray', 'apple-watch-series-3-gps-36mm-space-gray', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 9, 7, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(53, 193, 'Lid Organizer for The Nanuk 935 Case.', 'lid-organizer-for-the-nanuk-935-case', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(54, 194, 'Honor 10 Lite (Sapphire Blue, 3GB RAM, 64GB Storage)', 'honor-10-lite-sapphire-blue-3gb-ram-64gb-storage', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 7, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(55, 195, 'OnePlus 7 (Mirror Grey, 6GB RAM, 128GB Storage)', 'oneplus-7-mirror-grey-6gb-ram-128gb-storage', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 8, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(56, 196, '2 Black Replacement latches for Pelican Cases. 2 Black Replacement latches for Pelican Cases.', '2-black-replacement-latches-for-pelican-cases-2-black-replacement-latches-for-pelican-cases', '<div class=\"product-sdesc\">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam</p>\r\n</div>\r\n<div class=\"product-ldesc\">\r\n<p>In facilisis scelerisque dui vel dignissim. Sed nunc orci, ultricies congue vehicula quis, facilisis a orci. In aliquet facilisis condimentum. Donec at orci orci, a dictum justo. Sed a nunc non lectus fringilla suscipit. Vivamus pretium sapien sit amet mauris aliquet eleifend vel vitae arcu. Fusce pharetra dignissim nisl egestas pretium.</p>\r\n<p>Etiam aliquam sem ac velit feugiat elementum. Nunc eu elit velit, nec vestibulum nibh. Curabitur ultrices, diam non ullamcorper blandit, nunc lacus ornare nisi, egestas rutrum magna est id nunc. Pellentesque imperdiet malesuada quam, et rhoncus eros auctor eu. Nullam vehicula metus ac lacus rutrum nec fermentum urna congue. Vestibulum et risus at mi ultricies sagittis quis nec ligula. Suspendisse dignissim dignissim luctus. Duis ac dictum nibh. Etiam id massa magna. Morbi molestie posuere posuere.</p>\r\n<p>To know more, go to <strong>www.example.com</strong></p>\r\n</div>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(57, 197, 'Apple Watch Series 3 (GPS, 42mm) - Space Gray', 'apple-watch-series-3-gps-42mm-space-gray', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 8, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(58, 198, 'Nest Aware', 'nest-aware', '<p>It’s easy to buy a subscription with the Nest app or on the <a title=\"Nest Store\" href=\"https://store.nest.com/\">Nest Store</a>. Just sign in to your account in the Nest app and purchase a camera and subscription together, or purchase a subscription for a camera you already own. You can only purchase a subscription for a camera if you are the <a title=\"Owner of the Nest home\" href=\"https://nest.com/support/article/Learn-more-about-Family-Accounts-and-inviting-people-to-access-your-Nest-home#levels-of-shared-access\">Owner of the Nest home</a>. For detailed steps, see the article below.It’s easy to buy a subscription with the Nest app or on the <a title=\"Nest Store\" href=\"https://store.nest.com/\">Nest Store</a>. Just sign in to your account in the Nest app and purchase a camera and subscription together, or purchase a subscription for a camera you already own. You can only purchase a subscription for a camera if you are the <a title=\"Owner of the Nest home\" href=\"https://nest.com/support/article/Learn-more-about-Family-Accounts-and-inviting-people-to-access-your-Nest-home#levels-of-shared-access\">Owner of the Nest home</a>. For detailed steps, see the article below.</p>', '', 1, 2, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(59, 199, 'OnePlus 7 (Mirror Grey, 6GB RAM, 128GB Storage)', 'oneplus-7-mirror-grey-6gb-ram-128gb-storage-2', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 16, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', ''),
(60, 200, 'Honor 10 Lite (Sapphire Blue, 3GB RAM, 32GB Storage)', 'honor-10-lite-sapphire-blue-3gb-ram-32gb-storage', '<p>We\'re a team of makers, thinkers, explorers and theatre singers. We approach work and play with curiosity and experimentation, using what we learn to create meaningful digital products that connect with people, just like you.</p>\r\n', '\r\n<p>Are you ready to buy a home theater audio system? Here are several tips to help you find the right audio system for you.Spend some quality time with the room you are going to put your new home theater audio system. Believe it or not but the room is as much a component in your home theater system as any of the electronics you will ever buy. Ask yourself which room you will be putting your new system in. Consider whether or not this room is going to be used solely for you system or will it be used for other activities. Will there be any size considerations for the components.</p>', 1, 17, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 54, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(62, 303, 'Pizzi Announces $1 Billion Fund to U.S.', 'pizzi-announces-1-billion-fund-to-u-s-2', '', 'Having a baby can be a nerve wracking experience for new parents – not the nine months of pregnancy, I’m talking about after the infant is brought home from the hospital. It’s always the same thing, by the time they have their third child they have it all figured out, but with number one it’s a learning thing.\nAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.You will also lose the chance to make a whole new bunch of friends. You cannot expect them to take a second look at your profile. Thus before you lose the chance to make new friends, you should customize the profile as best as you can. You can choose from a great variety, as there are plenty of sites, which are dedicated to MySpace layouts.You can even make the profile theme based, depending on what you have in mind. For example you could be a fan of a popular actor, and you could use his image for your profile. It is definitely more exciting than looking at some boring default settings on the profile. By having good MySpace layouts on the profile, you will get a lot of curious visitors.\nPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENPhoto by Gamora Mag  /  ZIN NGUYENPhoto by Gamora Mag / ZIN NGUYENAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.\nThe profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking.Photo by ZIN NGUYEN / Gamora Mag\nPhoto by ZIN NGUYEN / Gamora MagAll users on MySpace will know that there are millions of people out there. Every day besides so many people joining this community, there are many others who will be looking out for friends. This will mean that they are naturally looking out for good people who are interesting enough. For this, the profile has to be very interesting.To make the profile unique, you can use good MySpace layouts. This will make a world of a difference to the profile. Imagine that someone visits your profile, and they find it without any good information or pictures. They would not spend another minute looking at it, and you will quickly lose your reputation.\nKomol Kuchkarov\nOut of many, one. Perhaps somebody told her along the way that the source of her mother\'s problems were blacks who were on welfare and too lazy to work, or Hispanics who were coming into the country illegally.', 1, 22, '2020-01-21 05:51:17', 336, '', '2020-01-21 05:51:17', 336, 336, '2020-01-23 11:22:26', '2020-01-21 05:51:17', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2019\\/06\\/14\\/blog-041.jpg\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=YZcT74ZqkOA\"}', 5, 0, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

--
-- Dumping data for table `#__contentitem_tag_map`
--

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 2, 10, 2, '2020-01-20 23:51:17', 1),
('com_content.article', 2, 10, 3, '2020-01-20 23:51:17', 1),
('com_content.article', 2, 10, 4, '2020-01-20 23:51:17', 1),
('com_content.article', 2, 10, 5, '2020-01-20 23:51:17', 1),
('com_content.article', 2, 10, 6, '2020-01-20 23:51:17', 1),
('com_content.article', 2, 10, 7, '2020-01-20 23:51:17', 1),
('com_content.article', 2, 10, 8, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 2, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 3, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 4, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 5, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 6, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 7, '2020-01-20 23:51:17', 1),
('com_content.article', 3, 14, 8, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 2, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 3, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 4, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 5, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 6, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 7, '2020-01-20 23:51:17', 1),
('com_content.article', 4, 25, 8, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 2, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 3, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 4, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 5, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 6, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 7, '2020-01-20 23:51:17', 1),
('com_content.article', 6, 62, 8, '2020-01-20 23:51:17', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(35, 2),
(39, 3),
(44, 4),
(47, 6),
(53, 5),
(55, 8),
(59, 7),
(60, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_rating`
--

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(1, 5, 1, '::1'),
(3, 5, 1, '::1'),
(9, 5, 1, '10.0.1.2');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(3, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(4, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', 'UsersHelperRoute::getUserRoute', ''),
(5, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(6, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(9, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(10, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(11, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(12, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(13, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"search_phrases\":\"1\",\"search_areas\":\"1\",\"show_date\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"0\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"1\",\"record_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":1,\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"debugUsers\":\"1\",\"debugGroups\":\"1\",\"sef_advanced\":0,\"custom_fields_enable\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"updatesource\":\"default\",\"customurl\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', 1, 1, 1, 1, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', 1, 1, 1, 1, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"099c88860c50906bfd4d90485c4da2bf\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.40.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2019\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"4.5.11\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":0,\"automatic_change\":1,\"item_associations\":1,\"alternate_meta\":1,\"xdefault\":1,\"xdefault_language\":\"default\",\"remove_default_prefix\":1,\"lang_cookie\":0}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1580361588}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"6d30f13db174eb0c94efb885594275cd80da3e3a\",\"interval\":12}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(481, 0, 'plg_fields_repeatable', 'plugin', 'repeatable', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_repeatable\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"repeatable\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(483, 0, 'PLG_SYSTEM_ACTIONLOGS', 'plugin', 'actionlogs', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_ACTIONLOGS\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(484, 0, 'PLG_ACTIONLOG_JOOMLA', 'plugin', 'joomla', 'actionlog', 0, 1, 1, 0, '{\"name\":\"PLG_ACTIONLOG_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1579585902}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(487, 0, 'plg_privacy_user', 'plugin', 'user', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(489, 0, 'plg_user_terms', 'plugin', 'terms', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(491, 0, 'plg_privacy_content', 'plugin', 'content', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(492, 0, 'plg_privacy_message', 'plugin', 'message', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"January 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.15\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"January 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.15\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"January 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2020 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.15\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"January 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2020 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.15.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10000, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"3.6.10\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{\"production_mode\":\"0\",\"addcontainer\":\"1\",\"gmap_api\":\"\",\"fontawesome\":\"1\",\"disableanimatecss\":\"0\",\"disablecss\":\"0\",\"disable_og\":\"0\",\"fb_app_id\":\"admin\",\"disable_tc\":\"0\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"demo\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2019 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10003, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10004, 0, 'System - Helix Ultimate Framework', 'plugin', 'helixultimate', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix Ultimate Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1.2\",\"description\":\"Helix Ultimate Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helixultimate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 0, 'Helix Ultimate based template installer', 'plugin', 'TmplHelixUltimate', 'system', 0, 0, 1, 0, '{\"name\":\"Helix Ultimate based template installer\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"\",\"description\":\"Shaper Helix Ultimate - Blank template of Helix Ultimate framework\",\"group\":\"\",\"filename\":\"TmplHelixUltimate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 0, 'SP Simple Portfolio', 'component', 'com_spsimpleportfolio', '', 1, 1, 0, 0, '{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2020 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.8\",\"description\":\"Simple Portfolio Component for Joomla 3.3+\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}', '{\"square\":\"586x470\",\"rectangle\":\"1270x866\",\"tower\":\"445X470\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10008, 0, 'COM_SPEASYIMAGEGALLERY', 'component', 'com_speasyimagegallery', '', 1, 1, 0, 0, '{\"name\":\"COM_SPEASYIMAGEGALLERY\",\"type\":\"component\",\"creationDate\":\"Mar 2017\",\"author\":\"JoomShaper\",\"copyright\":\"@JoomShaper 2010 - 2019. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.5.1\",\"description\":\"A simple image gallery component for Joomla.\",\"group\":\"\",\"filename\":\"speasyimagegallery\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10009, 0, 'SP Easy Image Gallery Module', 'module', 'mod_speasyimagegallery', '', 0, 1, 0, 0, '{\"name\":\"SP Easy Image Gallery Module\",\"type\":\"module\",\"creationDate\":\"Mar 2016\",\"author\":\"JoomShaper\",\"copyright\":\"@JoomShaper 2010 - 2017. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"Module to display albums or album images from SP Easy Image Gallery component.\",\"group\":\"\",\"filename\":\"mod_speasyimagegallery\"}', '{\"layout\":\"album\",\"albums_column\":\"3\",\"albums_column_sm\":\"4\",\"albums_column_xs\":\"6\",\"albums_gutter\":\"20\",\"albums_gutter_sm\":\"15\",\"albums_gutter_xs\":\"10\",\"album_limit\":\"8\",\"album_layout\":\"default\",\"album_column\":\"3\",\"album_column_sm\":\"4\",\"album_column_xs\":\"6\",\"album_gutter\":\"20\",\"album_gutter_sm\":\"15\",\"album_gutter_xs\":\"10\",\"show_title\":\"1\",\"show_desc\":\"1\",\"show_count\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10010, 0, 'SP Simple Portfolio Module', 'module', 'mod_spsimpleportfolio', '', 0, 1, 0, 0, '{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2020 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.8\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}', '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"popup_image\":\"default\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10011, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"28 April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2013 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.0.1\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10016, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10017, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10018, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10019, 0, 'indigo', 'template', 'indigo', '', 0, 1, 1, 0, '{\"name\":\"indigo\",\"type\":\"template\",\"creationDate\":\"July 2019\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2020 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.4\",\"description\":\"Indigo - Multipurpose Business & Corporate Agency Joomla Template.\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 0, 'Content - SP Page Builder', 'plugin', 'sppagebuilder', 'content', 0, 1, 1, 0, '{\"name\":\"Content - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.7\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 0, 'J2Store', 'component', 'com_j2store', '', 1, 1, 0, 0, '{\"name\":\"J2Store\",\"type\":\"component\",\"creationDate\":\"November 2019\",\"author\":\"Ramesh Elamathi\",\"copyright\":\"Copyright (c) 2019 Cartrabbit. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"3.3.11\",\"description\":\"<h3>J2 Store V3 Core<\\/h3>\\n      Flexible and native Joomla shopping cart solution. <br \\/>\\n      Use Joomla articles as products and get your shop online in less than 10 minutes. <br \\/>\\n      Start setting up your store now. <br \\/>\\n      Learn more from the <a target=\\\"_blank\\\" href=\\\"https:\\/\\/www.j2store.org\\/support\\/user-guide\\/getting-started-with-j2store.html\\\">Getting started guide<\\/a>\\n      If you have any questions, <a target=\\\"_blank\\\" href=\\\"https:\\/\\/www.j2store.org\\/support\\/community-forum.html\\\">get in touch with us<\\/a>\\n      \",\"group\":\"\",\"filename\":\"com_j2store\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'J2 Store Chart', 'module', 'mod_j2store_chart', '', 1, 1, 2, 0, '{\"name\":\"J2 Store Chart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Chart\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_chart\"}', '{\"chart_type\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10023, 0, 'J2 Store Stats Mini', 'module', 'mod_j2store_stats_mini', '', 1, 1, 2, 0, '{\"name\":\"J2 Store Stats Mini\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Stats\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_stats_mini\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10024, 0, 'J2 Store Orders', 'module', 'mod_j2store_orders', '', 1, 1, 2, 0, '{\"name\":\"J2 Store Orders\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Orders\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_orders\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10025, 0, 'J2 Store Stats', 'module', 'mod_j2store_stats', '', 1, 1, 2, 0, '{\"name\":\"J2 Store Stats\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Stats\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_stats\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10026, 0, 'J2Store Administrator Menu', 'module', 'mod_j2store_menu', '', 1, 1, 2, 0, '{\"name\":\"J2Store Administrator Menu\",\"type\":\"module\",\"creationDate\":\"June 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"MOD_J2STORE_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_j2store_menu\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 0, 'J2Store Currency', 'module', 'mod_j2store_currency', '', 0, 1, 0, 0, '{\"name\":\"J2Store Currency\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"Ramesh Elamathi\",\"copyright\":\"Copyright (c) 2013 - 2018 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2Store shopping cart currency switcher module\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_currency\"}', '{\"moduleclass_sfx\":\"\",\"background_color\":\"#FFFFFF\",\"text_color\":\"#000000\",\"link_color\":\"#CCCCCC\",\"link_hover_color\":\"#000000\",\"active_link_color\":\"#000000\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 0, 'J2 Store Cart', 'module', 'mod_j2store_cart', '', 0, 1, 0, 0, '{\"name\":\"J2 Store Cart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Sasi varna kumar\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Cart\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\t  \\n    \\t\\n\\t\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_cart\"}', '{\"moduleclass_sfx\":\"\",\"link_type\":\"link\",\"check_empty\":\"0\",\"quantity_count\":\"0\",\"show_thumbimage\":\"0\",\"show_product_qty\":\"0\",\"show_cart_remove\":\"0\",\"enable_checkout\":\"0\",\"enable_view_cart\":\"0\",\"minicart_cart_icon_class\":\"fa fa-shoppingcart\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 0, 'Content - J2Store', 'plugin', 'j2store', 'content', 0, 1, 1, 0, '{\"name\":\"Content - J2Store\",\"type\":\"plugin\",\"creationDate\":\"October 2014\",\"author\":\"J2Store Team\",\"copyright\":\"Copyright (c) 2014 - 2019 J2Store.org All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"Content plugin for J2Store.\",\"group\":\"\",\"filename\":\"j2store\"}', '{\"allow_frontend_product_edit\":\"0\",\"check_publish_date\":\"0\",\"category_product_options\":\"1\",\"category_product_block_position\":\"bottom\",\"category_display_j2store_images\":\"1\",\"category_image_type\":\"bottom\",\"category_link_image_to_product\":\"1\",\"category_enable_image_zoom\":\"1\",\"list_image_thumbnail_width\":\"120\",\"list_product_additional_image_width\":\"80\",\"item_product_block_position\":\"bottom\",\"item_display_j2store_images\":\"1\",\"item_image_placement\":\"bottom\",\"item_image_type\":\"main\",\"item_enable_image_zoom\":\"1\",\"item_product_additional_image_width\":\"100\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10030, 0, 'System - J2Store', 'plugin', 'j2store', 'system', 0, 1, 1, 0, '{\"name\":\"System - J2Store\",\"type\":\"plugin\",\"creationDate\":\"Jan 2012\",\"author\":\"Sasi varna kumar\",\"copyright\":\"(C) 2010-2015 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"2.0\",\"description\":\"System plugin that loads the required Javascript and other files required for J2Store.\",\"group\":\"\",\"filename\":\"j2store\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10031, 0, 'System - J2Page Cache', 'plugin', 'j2pagecache', 'system', 0, 0, 1, 0, '{\"name\":\"System - J2Page Cache\",\"type\":\"plugin\",\"creationDate\":\"JUN 2016\",\"author\":\"Alagesan\",\"copyright\":\"(C) 2016 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"1.0\",\"description\":\"System plugin that used to clear page cache.\",\"group\":\"\",\"filename\":\"j2pagecache\"}', '{\"conservative_cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10032, 0, 'System - Campaign Rabbit', 'plugin', 'campaignrabbit', 'system', 0, 1, 1, 0, '{\"name\":\"System - Campaign Rabbit\",\"type\":\"plugin\",\"creationDate\":\"DEC 2018\",\"author\":\"Alagesan\",\"copyright\":\"(C) 2018 J2Store\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.0.31\",\"description\":\"System plugin that loads Campaign Rabbit analysis script.\",\"group\":\"\",\"filename\":\"campaignrabbit\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 0, 'Search - J2Store ', 'plugin', 'j2store', 'search', 0, 0, 1, 0, '{\"name\":\"Search - J2Store \",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_SEARCH_J2STORE_DESCRIPTION\",\"group\":\"\",\"filename\":\"j2store\"}', '{\"redirect_to\":\"j2store\",\"search_limit\":\"50\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10034, 0, 'Finder - J2Store', 'plugin', 'j2store', 'finder', 0, 0, 1, 0, '{\"name\":\"Finder - J2Store\",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2010 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_FINDER_J2STORE_DESCRIPTION\",\"group\":\"\",\"filename\":\"j2store\"}', '{\"redirect_to\":\"j2store\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10035, 0, 'Free Shipping', 'plugin', 'shipping_free', 'j2store', 0, 0, 1, 0, '{\"name\":\"Free Shipping\",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.1\",\"description\":\"PLG_J2STORE_SHIPPING_FREE_DESCRIPTION\",\"group\":\"\",\"filename\":\"shipping_free\"}', '{\"display_name\":\"Free shipping\",\"min_subtotal\":\"0\",\"max_subtotal\":\"-1\",\"requires_coupon\":\"0\",\"check_shipping_product\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10036, 0, 'Standard Shipping methods', 'plugin', 'shipping_standard', 'j2store', 0, 1, 1, 0, '{\"name\":\"Standard Shipping methods\",\"type\":\"plugin\",\"creationDate\":\"December 2014\",\"author\":\"J2Store\",\"copyright\":\"2010 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_PLUGINDESC\",\"group\":\"\",\"filename\":\"shipping_standard\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10037, 0, 'Cash on Delivery', 'plugin', 'payment_cash', 'j2store', 0, 1, 1, 0, '{\"name\":\"Cash on Delivery\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_CASH_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_cash\"}', '{\"display_name\":\"\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"min_subtotal\":\"0.000\",\"max_subtotal\":\"-1.00\",\"payment_status\":\"4\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10038, 0, 'Money Order', 'plugin', 'payment_moneyorder', 'j2store', 0, 1, 1, 0, '{\"name\":\"Money Order\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_MONEYORDER_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_moneyorder\"}', '{\"display_name\":\"\",\"moneyorder_information\":\"\",\"enable_strip_tags\":\"0\",\"payment_status\":\"4\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10039, 0, 'Bank transfer', 'plugin', 'payment_banktransfer', 'j2store', 0, 1, 1, 0, '{\"name\":\"Bank transfer\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_BANKTRANSFER_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_banktransfer\"}', '{\"display_name\":\"\",\"bank_information\":\"\",\"enable_bank_transfer_strip_tags\":\"0\",\"payment_status\":\"4\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"geozone_id\":\"\",\"support_subscription\":\"1\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 0, 'Paymill', 'plugin', 'payment_paymill', 'j2store', 0, 1, 1, 0, '{\"name\":\"Paymill\",\"type\":\"plugin\",\"creationDate\":\"NOV 2017\",\"author\":\"j2store.org\",\"copyright\":\"2014 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.3\",\"description\":\"J2STORE_PAYMILL_PAYMENT_DESC\",\"group\":\"\",\"filename\":\"payment_paymill\"}', '{\"display_name\":\"\",\"registration\":\"\",\"live_private_key\":\"\",\"live_public_key\":\"\",\"sandbox\":\"0\",\"test_private_key\":\"\",\"test_public_key\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"debug\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10041, 0, 'SagePay Direct', 'plugin', 'payment_sagepay', 'j2store', 0, 1, 1, 0, '{\"name\":\"SagePay Direct\",\"type\":\"plugin\",\"creationDate\":\"January 2016\",\"author\":\"j2store.org\",\"copyright\":\"2013-2018 Weblogicx India Private Limited \",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"2.4\",\"description\":\"J2STORE_SAGEPAY_PLUGINDESC\",\"group\":\"\",\"filename\":\"payment_sagepay\"}', '{\"display_name\":\"\",\"merchant_email\":\"\",\"enc_password\":\"\",\"card_types\":\"Visa,Mastercard\",\"sandbox\":\"0\",\"articleid\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"debug\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10042, 0, 'Report Itemised', 'plugin', 'report_itemised', 'j2store', 0, 1, 1, 0, '{\"name\":\"Report Itemised\",\"type\":\"plugin\",\"creationDate\":\"May 2014\",\"author\":\"Gokila Priya\",\"copyright\":\"2014-19 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_J2STORE_PLUGIN_REPORT_ITEMISED_DESC\",\"group\":\"\",\"filename\":\"report_itemised\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 0, 'Localization Data for J2Store', 'plugin', 'app_localization_data', 'j2store', 0, 1, 1, 0, '{\"name\":\"Localization Data for J2Store\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2014-19 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_APP_LOCALIZATION_DATA_HELP_TEXT\",\"group\":\"\",\"filename\":\"app_localization_data\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10044, 0, 'Diagnostics Tool', 'plugin', 'app_diagnostics', 'j2store', 0, 1, 1, 0, '{\"name\":\"Diagnostics Tool\",\"type\":\"plugin\",\"creationDate\":\"February 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 Weblogicx India\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_DIAGNOSTICS_HELP_TEXT\",\"group\":\"\",\"filename\":\"app_diagnostics\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10045, 0, 'Currency Exchange Rates - Google Finance API', 'plugin', 'app_currencyupdater', 'j2store', 0, 1, 1, 0, '{\"name\":\"Currency Exchange Rates - Google Finance API\",\"type\":\"plugin\",\"creationDate\":\"NOV 2017\",\"author\":\"Alagesan\",\"copyright\":\"2017 CartRabbit International Pte Ltd\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0.1\",\"description\":\"This app used to update currency value\",\"group\":\"\",\"filename\":\"app_currencyupdater\"}', '{\"api_type\":\"msn\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'Campaign Rabbit', 'plugin', 'app_campaignrabbit', 'j2store', 0, 1, 1, 0, '{\"name\":\"Campaign Rabbit\",\"type\":\"plugin\",\"creationDate\":\"APR 2019\",\"author\":\"Alagesan\",\"copyright\":\"2019 Cartrabbit\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.0.33\",\"description\":\"Follow-up Emails, Email Marketing automation for J2Store\",\"group\":\"\",\"filename\":\"app_campaignrabbit\"}', '{\"enable_opt_in\":\"0\",\"enable_double_opt_in\":\"0\",\"opt_in_text\":\"J2STORE_CAMPAIGN_OPT_IN_TEXT_DEFAULT\",\"synch_zero_order\":\"1\",\"orderstatus\":\"*\",\"debug\":\"0\",\"syn_manual\":\"0\",\"patch_count\":\"20\",\"invoice_syn\":\"\",\"show_campaign_message\":1}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10047, 0, 'Retainful - Next order coupon', 'plugin', 'app_retainfulcoupon', 'j2store', 0, 0, 1, 0, '{\"name\":\"Retainful - Next order coupon\",\"type\":\"plugin\",\"creationDate\":\"JAN 2019\",\"author\":\"Sathyaseelan\",\"copyright\":\"2019 Cartrabbit Technologies\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0.1\",\"description\":\"PLG_J2STORE_APP_NEXTORDERCOUPON_DESC\",\"group\":\"\",\"filename\":\"app_retainfulcoupon\"}', '{\"retainful_app_id\":\"\",\"verify\":\"\",\"coupon_payment_status\":\"4\",\"coupon_amount\":\"\",\"is_retainful_connected\":\"0\",\"coupon_type\":\"0\",\"apply_coupon_to\":\"0\",\"coupon_message\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10049, 0, 'SP Simple Portfolio - SP Page Builder', 'plugin', 'sppagebuilder', 'spsimpleportfolio', 0, 1, 1, 0, '{\"name\":\"SP Simple Portfolio - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Mar 2019\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10050, 0, 'mod_j2products', 'module', 'mod_j2products', '', 0, 1, 0, 0, '{\"name\":\"mod_j2products\",\"type\":\"module\",\"creationDate\":\"FEB 2019\",\"author\":\"J2Store\",\"copyright\":\"Copyright (C) 2018 J2Store.org. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.25\",\"description\":\"MOD_J2PRODUCTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_j2products\"}', '{\"content_integration\":\"joomla\",\"sort_by\":\"\",\"product_source_type\":\"category\",\"include_subcategories\":\"1\",\"include_subcat_level\":\"0\",\"number_of_coloums\":\"3\",\"number_of_coloums_Desktop\":\"3\",\"number_of_coloums_DesktopSmall\":\"3\",\"number_of_coloums_Tablet\":\"3\",\"number_of_coloums_TabletSmall\":\"2\",\"number_of_coloums_Mobile\":\"1\",\"show_navigation\":\"0\",\"number_of_items\":\"6\",\"show_feature_only\":\"0\",\"show_title\":\"1\",\"link_title\":\"1\",\"show_sku\":\"0\",\"show_price\":\"1\",\"show_price_taxinfo\":\"1\",\"show_special_price\":\"1\",\"show_offers\":\"1\",\"show_stock\":\"0\",\"show_beforedisplaycontent\":\"1\",\"show_afterdisplaycontent\":\"1\",\"list_show_cart\":\"2\",\"show_introtext\":\"0\",\"introtext_limit\":\"50\",\"show_quickview\":\"0\",\"show_image\":\"1\",\"link_image\":\"1\",\"image_type\":\"thumbimage\",\"image_size_width\":\"80\",\"image_size_height\":\"80\",\"image_position\":\"top\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10051, 0, 'J2 Store Discount Order', 'module', 'mod_j2store_discountorder', '', 0, 1, 0, 0, '{\"name\":\"J2 Store Discount Order\",\"type\":\"module\",\"creationDate\":\"MAY 2017\",\"author\":\"Alagesan\",\"copyright\":\"Copyright (c) 2017 Cartrabbit Technologies Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n         J2Store Coupon and voucher apply module \\n    \",\"group\":\"\",\"filename\":\"mod_j2store_discountorder\"}', '{\"moduleclass_sfx\":\"\",\"enable_coupon\":\"1\",\"enable_voucher\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10052, 0, 'Detail Cart Advanced J2Store', 'module', 'mod_j2store_detailcart', '', 0, 1, 0, 0, '{\"name\":\"Detail Cart Advanced J2Store\",\"type\":\"module\",\"creationDate\":\"JAN 2019\",\"author\":\"ThemeParrot\",\"copyright\":\"Copyright (c) 2016 ThemeParrot Private Ltd. All rights reserved.\",\"authorEmail\":\"support@themeparrot.com\",\"authorUrl\":\"http:\\/\\/themeparrot.com\",\"version\":\"3.5\",\"description\":\"\\n\\t <p>J2Store Detail Cart Advanced module. Sponsored by <a href=\\\"http:\\/\\/themeparrot.com\\\">ThemeParrot<\\/a>, makers of premium Joomla templates<\\/p>\\n\\t\",\"group\":\"\",\"filename\":\"mod_j2store_detailcart\"}', '{\"moduleclass_sfx\":\"\",\"show_cartitem_name\":\"1\",\"show_cartitem_image\":\"1\",\"cartitem_image_width\":\"100\",\"show_cartitem_quantity\":\"1\",\"show_cartitem_sku\":\"1\",\"show_cartitem_price\":\"1\",\"show_cartitem_attribs\":\"1\",\"show_cartitem_tax\":\"1\",\"show_cartitem_total\":\"1\",\"show_cartitem_remove_option\":\"1\",\"show_checkout\":\"1\",\"show_estimateshipping\":\"1\",\"force_shipping\":\"1\",\"custom_forceshipping_message\":\"MOD_J2STORE_NO_SHIPPING_METHOD_MATCHES\",\"show_country\":\"1\",\"country_required\":\"1\",\"show_zone\":\"1\",\"zone_required\":\"1\",\"show_zip\":\"1\",\"postal_required\":\"1\",\"show_cart_link\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10053, 0, 'J2Store Categories', 'module', 'mod_j2store_categories', '', 0, 1, 0, 0, '{\"name\":\"J2Store Categories\",\"type\":\"module\",\"creationDate\":\"AUG 2018\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (C) 2016 ThemeParrot. All rights reserved.\",\"authorEmail\":\"support@themeparrot.com\",\"authorUrl\":\"www.themeparrot.com\",\"version\":\"1.7\",\"description\":\"MOD_J2STORE_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_j2store_categories\"}', '{\"menuitem_id\":\"0\",\"show_description\":\"0\",\"numitems\":\"0\",\"browse_link\":\"1\",\"show_children\":\"0\",\"category_bootstrap_version\":\"2\",\"category_display_view\":\"list_view\",\"categories_per_row\":\"4\",\"count\":\"4\",\"maxlevel\":\"0\",\"show_image\":\"1\",\"image_height\":\"40\",\"image_width\":\"40\",\"item_heading\":\"4\",\"owncache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10054, 0, 'J2Store Products search module ', 'module', 'mod_j2store_search', '', 0, 1, 0, 0, '{\"name\":\"J2Store Products search module \",\"type\":\"module\",\"creationDate\":\"JAN 2017\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2017 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.6\",\"description\":\"MOD_J2STORE_SEARCH\",\"group\":\"\",\"filename\":\"mod_j2store_search\"}', '{\"moduleclass_sfx\":\"\",\"show_label\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10055, 10057, 'ArabicUnitag', 'language', 'ar-AA', '', 0, 1, 0, 0, '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"31\\/07\\/2019\",\"author\":\"Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"\",\"version\":\"3.9.10.1\",\"description\":\"ar-AA - Site language\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10056, 10057, 'ArabicUnitag', 'language', 'ar-AA', '', 1, 1, 0, 0, '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"31\\/07\\/2019\",\"author\":\"Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"\",\"version\":\"3.9.10.1\",\"description\":\"ar-AA - Administration language\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10057, 0, 'ar-aa', 'package', 'pkg_ar-AA', '', 0, 1, 1, 0, '{\"name\":\"ar-aa\",\"type\":\"package\",\"creationDate\":\"31\\/07\\/2019\",\"author\":\"Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"\",\"version\":\"3.9.10.1\",\"description\":\"<div class=\\\"alert alert-info\\\">\\n<button type=\\\"button\\\" class=\\\"close\\\" data-dismiss=\\\"alert\\\">\\u00d7<\\/button>\\n<h4 class=\\\"alert-heading\\\" style=\\\"direction: rtl;\\\">\\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629<\\/h4>\\n<div class=\\\"alert-message\\\" style=\\\"direction: rtl;\\\">\\u062a\\u0645 \\u062a\\u0646\\u0635\\u064a\\u0628 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u062f\\u0627\\u0631\\u0629 \\u0645\\u062d\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0642\\u0639 \\u062c\\u0648\\u0645\\u0644\\u0627\\u060c \\u0628\\u0627\\u0644\\u0643\\u0648\\u062f \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f.<\\/div>\\n<\\/div>\",\"group\":\"\",\"filename\":\"pkg_ar-AA\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10058, 0, 'System - J2Store Canonical', 'plugin', 'j2canonical', 'system', 0, 0, 1, 0, '{\"name\":\"System - J2Store Canonical\",\"type\":\"plugin\",\"creationDate\":\"March 2017\",\"author\":\"Sasi varna kumar\",\"copyright\":\"Copyright (C) 2016 - 2020 http:\\/\\/j2store.org. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.3\",\"description\":\" This plugin solves the duplicate URL problem in search engines by adding appropriate Canonical tags for J2Store products and Articles. \",\"group\":\"\",\"filename\":\"j2canonical\"}', '{\"current_url_canonical\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10059, 0, 'F0F (NEW) DO NOT REMOVE', 'library', 'f0f', '', 0, 1, 1, 0, '{\"name\":\"F0F (NEW) DO NOT REMOVE\",\"type\":\"library\",\"creationDate\":\"2016-04-01\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revAA17947\",\"description\":\"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE \'FOF\' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.\",\"group\":\"\",\"filename\":\"lib_f0f\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_addresses`
--

DROP TABLE IF EXISTS `#__j2store_addresses`;
CREATE TABLE `#__j2store_addresses` (
  `j2store_address_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address_1` varchar(255) NOT NULL,
  `address_2` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `zip` varchar(255) NOT NULL,
  `zone_id` varchar(255) NOT NULL,
  `country_id` varchar(255) NOT NULL,
  `phone_1` varchar(255) NOT NULL,
  `phone_2` varchar(255) NOT NULL,
  `fax` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `tax_number` varchar(255) NOT NULL,
  `campaign_addr_id` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_addresses`
--

INSERT INTO `#__j2store_addresses` (`j2store_address_id`, `user_id`, `first_name`, `last_name`, `email`, `address_1`, `address_2`, `city`, `zip`, `zone_id`, `country_id`, `phone_1`, `phone_2`, `fax`, `type`, `company`, `tax_number`, `campaign_addr_id`) VALUES
(1, 0, '', '', '', 'California', '', 'USA', '111', '', '223', '', '', '', '', 'Apple', '', ''),
(2, 0, '', '', '', 'Korea', '', 'Seol', '', '', '113', '', '', '', '', 'Samsung', '', ''),
(3, 0, '', '', '', '', '', '', '', '3624', '223', '', '', '', '', 'Sony', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_cartitems`
--

DROP TABLE IF EXISTS `#__j2store_cartitems`;
CREATE TABLE `#__j2store_cartitems` (
  `j2store_cartitem_id` int(11) UNSIGNED NOT NULL,
  `cart_id` int(11) UNSIGNED NOT NULL,
  `product_id` int(11) UNSIGNED NOT NULL,
  `variant_id` int(11) UNSIGNED NOT NULL,
  `vendor_id` int(11) UNSIGNED NOT NULL,
  `product_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cartitem_params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_qty` decimal(12,4) NOT NULL,
  `product_options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__j2store_cartitems`
--

INSERT INTO `#__j2store_cartitems` (`j2store_cartitem_id`, `cart_id`, `product_id`, `variant_id`, `vendor_id`, `product_type`, `cartitem_params`, `product_qty`, `product_options`) VALUES
(3, 3, 1, 1, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(4, 3, 2, 2, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(5, 3, 3, 3, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(6, 2, 3, 3, 0, 'simple', '{}', '2.0000', 'YTowOnt9'),
(7, 2, 4, 4, 0, 'simple', '{}', '9.0000', 'YTowOnt9'),
(8, 4, 1, 1, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(11, 5, 14, 14, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(12, 5, 15, 15, 0, 'simple', '{}', '2.0000', 'YTowOnt9'),
(31, 7, 34, 34, 0, 'simple', '{}', '1.0000', 'YToyOntpOjE7czoxOiI0IjtpOjI7czoxOiI3Ijt9'),
(40, 24, 12, 12, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(41, 24, 20, 20, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(46, 44, 10, 10, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(47, 36, 34, 34, 0, 'simple', '{}', '1.0000', 'YToyOntpOjE7czoxOiI0IjtpOjI7czoxOiI4Ijt9'),
(48, 49, 33, 33, 0, 'simple', '{}', '2.0000', 'YTowOnt9'),
(49, 49, 30, 30, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(77, 70, 33, 33, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(81, 67, 30, 30, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(82, 2, 27, 27, 0, 'simple', '{}', '2.0000', 'YTowOnt9'),
(83, 73, 31, 31, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(84, 49, 18, 18, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(85, 49, 17, 17, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(86, 49, 26, 26, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(91, 88, 1, 1, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(92, 88, 10, 10, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(93, 94, 1, 1, 0, 'simple', '{}', '2.0000', 'YTowOnt9'),
(95, 101, 31, 31, 0, 'simple', '{}', '1.0000', 'YTowOnt9'),
(97, 126, 13, 13, 0, 'simple', '{}', '1.0000', 'YToyOntpOjMyO3M6MzoiMTI0IjtpOjMzO3M6MzoiMTI4Ijt9');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_carts`
--

DROP TABLE IF EXISTS `#__j2store_carts`;
CREATE TABLE `#__j2store_carts` (
  `j2store_cart_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_id` varchar(255) NOT NULL,
  `cart_voucher` varchar(255) DEFAULT NULL,
  `cart_coupon` varchar(255) DEFAULT NULL,
  `cart_type` varchar(255) NOT NULL DEFAULT 'cart',
  `created_on` datetime NOT NULL,
  `modified_on` datetime NOT NULL,
  `customer_ip` varchar(255) NOT NULL,
  `cart_params` text NOT NULL,
  `cart_browser` text NOT NULL,
  `cart_analytics` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_carts`
--

INSERT INTO `#__j2store_carts` (`j2store_cart_id`, `user_id`, `session_id`, `cart_voucher`, `cart_coupon`, `cart_type`, `created_on`, `modified_on`, `customer_ip`, `cart_params`, `cart_browser`, `cart_analytics`) VALUES
(2, 58, 'he2nou3emnq9qffg19tmbb0r4v', NULL, NULL, 'cart', '2019-06-24 07:19:48', '2019-07-08 10:41:12', '10.0.1.5', '', 'chrome', '{\"is_mobile\":false}'),
(3, 0, 'et3gq7k3v52bpuc4vkq839qjlf', NULL, NULL, 'cart', '2019-06-25 05:07:02', '2019-06-25 05:07:07', '10.0.1.13', '', 'chrome', '{\"is_mobile\":false}'),
(4, 0, 'iv3t7dmg1i1tm3nh5e85suev23', NULL, NULL, 'cart', '2019-06-26 11:37:18', '0000-00-00 00:00:00', '10.0.1.72', '', 'chrome', '{\"is_mobile\":false}'),
(5, 0, 'be8rmofcsnhv0s4kf9iac4fj2q', NULL, NULL, 'cart', '2019-06-27 12:46:15', '2019-07-01 11:20:00', '10.0.1.14', '', 'chrome', '{\"is_mobile\":false}'),
(6, 0, 'e5peb23jdesf8gfifmqojmtleg', NULL, NULL, 'cart', '2019-06-28 07:43:39', '2019-07-01 06:59:16', '10.0.1.36', '', 'chrome', '{\"is_mobile\":false}'),
(7, 0, 'svo1lr3kbjroped8cv4ko3c9ah', NULL, NULL, 'cart', '2019-07-01 05:28:51', '2019-07-01 14:11:27', '::1', '', 'edg', '{\"is_mobile\":false}'),
(11, 0, 'cm4inc7a9s7b7k9ikpck2pgmsc', NULL, NULL, 'cart', '2019-07-01 06:28:52', '2019-07-01 13:03:36', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(12, 0, 'ep11t3i4204li8gcolvvm0hkc2', NULL, NULL, 'cart', '2019-07-01 06:32:56', '2019-07-01 07:35:11', '10.0.1.12', '', 'chrome', '{\"is_mobile\":false}'),
(13, 0, 'bmcncingal40pg396r3ls0685c', NULL, NULL, 'cart', '2019-07-01 06:39:40', '2019-07-05 10:11:24', '10.0.1.18', '', 'chrome', '{\"is_mobile\":false}'),
(14, 0, 'nfibgmg6mppe8it2tk12ncqs7l', NULL, NULL, 'cart', '2019-07-01 06:54:36', '2019-07-01 06:54:47', '10.0.1.60', '', 'chrome', '{\"is_mobile\":false}'),
(15, 0, 're34dt2dqa39cqsophshb6gtfg', NULL, NULL, 'cart', '2019-07-01 07:05:20', '2019-07-01 10:14:41', '10.0.1.104', '', 'chrome', '{\"is_mobile\":false}'),
(17, 0, '37u5lahte0v140aqgavb3nahki', NULL, NULL, 'cart', '2019-07-01 09:32:53', '2019-07-01 09:34:57', '10.0.1.2', '', 'chrome', '{\"is_mobile\":false}'),
(18, 0, 'ktle8epqardv1edmivqfoik8at', NULL, NULL, 'cart', '2019-07-01 09:38:23', '2019-07-01 13:04:37', '10.0.1.17', '', 'edg', '{\"is_mobile\":false}'),
(19, 0, 'akv368rnmtl761nhfee5kv6e0d', NULL, NULL, 'cart', '2019-07-01 09:42:48', '2019-07-01 10:01:47', '10.0.1.13', '', 'chrome', '{\"is_mobile\":false}'),
(20, 0, 'uv8n2auqngtjkns8bc1m4fr49o', NULL, NULL, 'cart', '2019-07-02 04:39:45', '2019-07-03 12:28:44', '10.0.1.14', '', 'chrome', '{\"is_mobile\":false}'),
(23, 0, '1dskvm9ppoase33kb699vkq013', NULL, NULL, 'cart', '2019-07-02 05:08:26', '2019-07-02 14:45:15', '::1', '', 'edg', '{\"is_mobile\":false}'),
(24, 0, 'ucfbcqcvl5kd8qkr5rmp9qnh52', NULL, NULL, 'cart', '2019-07-02 05:53:03', '2019-07-02 13:44:09', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(25, 0, 'r29en6p2am2stcvset4cajd6vo', NULL, NULL, 'cart', '2019-07-02 05:58:15', '0000-00-00 00:00:00', '10.0.1.17', '', 'edg', '{\"is_mobile\":false}'),
(26, 0, 'rfko51okhqs8ng9lmc13dfuad1', NULL, NULL, 'cart', '2019-07-02 06:12:21', '2019-07-02 09:32:49', '10.0.1.104', '', 'chrome', '{\"is_mobile\":false}'),
(27, 0, 'nbih14psaehgv0o3ihdb0s678t', NULL, NULL, 'cart', '2019-07-02 06:35:41', '2019-07-08 07:26:08', '10.0.1.66', '', 'chrome', '{\"is_mobile\":false}'),
(28, 0, 'a984h0ngu5dim00n69518erg0u', NULL, NULL, 'cart', '2019-07-02 06:58:10', '0000-00-00 00:00:00', '10.0.1.11', '', 'chrome', '{\"is_mobile\":false}'),
(29, 0, 'hijaai8nnk82mccs0i0sdfv8gd', NULL, NULL, 'cart', '2019-07-02 07:42:33', '0000-00-00 00:00:00', '::1', '', 'safari', '{\"is_mobile\":false}'),
(32, 0, 'rj6nt4941292eo42tpp45vs075', NULL, NULL, 'cart', '2019-07-02 10:41:33', '2019-07-03 10:40:57', '10.0.1.36', '', 'chrome', '{\"is_mobile\":false}'),
(35, 0, 't5afrqijg5qokclr49f52q94b5', NULL, NULL, 'cart', '2019-07-03 05:01:25', '0000-00-00 00:00:00', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(36, 0, '4afjpn60i9lj9prpjnftu5l64c', NULL, NULL, 'cart', '2019-07-03 05:01:26', '2019-07-03 12:47:50', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(37, 0, 'gkpm1gntpphmpjuvlb472mc9f5', NULL, NULL, 'cart', '2019-07-03 05:20:03', '2019-07-03 14:15:51', '::1', '', 'edg', '{\"is_mobile\":false}'),
(39, 0, 'mtpeudc0o4usd3a8eheosnv77s', NULL, NULL, 'cart', '2019-07-03 06:50:38', '2019-07-03 06:51:22', '10.0.1.17', '', 'edg', '{\"is_mobile\":false}'),
(41, 0, '5ijeseqiieo9g0agcsjqk07s4g', NULL, NULL, 'cart', '2019-07-03 07:09:30', '2019-07-03 11:52:04', '10.0.1.104', '', 'chrome', '{\"is_mobile\":false}'),
(44, 0, 'nra81t8fep03ed6bmoj8pj94bj', NULL, NULL, 'cart', '2019-07-03 11:04:39', '2019-07-05 09:22:29', '10.0.1.12', '', 'chrome', '{\"is_mobile\":false}'),
(46, 0, 'drp3ueuhjk0j776ntve6fbvg2k', NULL, NULL, 'cart', '2019-07-03 12:29:10', '2019-07-05 11:27:54', '10.0.1.60', '', 'chrome', '{\"is_mobile\":false}'),
(49, 0, 'dgkt0td2egaj6e8r6mevg5hep6', NULL, NULL, 'cart', '2019-07-04 04:26:11', '2019-07-08 06:41:06', '10.0.1.14', '', 'chrome', '{\"is_mobile\":false}'),
(51, 0, '57qgfcdg99co7ffjmnneucfj63', NULL, NULL, 'cart', '2019-07-04 05:25:52', '2019-07-05 12:59:35', '10.0.1.36', '', 'chrome', '{\"is_mobile\":false}'),
(52, 0, '7135p22klqjq1i7k33t9189e8d', NULL, NULL, 'cart', '2019-07-04 05:31:48', '2019-07-04 11:49:44', '::1', '', 'edg', '{\"is_mobile\":false}'),
(53, 0, 'vtl7b5nrd4loha3796vuv5b8mv', NULL, NULL, 'cart', '2019-07-04 05:32:39', '2019-07-04 11:20:05', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(57, 0, 'tvbq0ra5pm8hamt5stfvfo4clv', NULL, NULL, 'cart', '2019-07-04 08:26:22', '2019-07-04 08:54:56', '10.0.1.4', '', 'chrome', '{\"is_mobile\":false}'),
(58, 0, 'fq3sjh56d9ae3l9hk6qnvj7k75', NULL, NULL, 'cart', '2019-07-04 09:22:33', '2019-07-05 03:55:11', '10.0.1.11', '', 'chrome', '{\"is_mobile\":false}'),
(61, 0, '516es5shj0tc5bi2me2hv9aio6', NULL, NULL, 'cart', '2019-07-04 09:32:45', '2019-07-04 10:04:29', '10.0.1.104', '', 'chrome', '{\"is_mobile\":false}'),
(67, 0, 'mfo7k6kfp9l33fhrn8niu2q9i0', NULL, NULL, 'cart', '2019-07-05 05:13:07', '2019-07-05 13:03:33', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(68, 0, '7tuobk5dlgnjtgl6i45tje4fme', NULL, NULL, 'cart', '2019-07-05 06:08:12', '2019-07-05 14:33:10', '::1', '', 'edg', '{\"is_mobile\":false}'),
(69, 0, 'ohr7rugqdr3h7sop1568t85i89', NULL, NULL, 'cart', '2019-07-05 10:39:52', '2019-07-05 12:19:43', '10.0.1.104', '', 'chrome', '{\"is_mobile\":false}'),
(70, 0, '1ap7pevss8hkd8poa28pldfpv7', NULL, NULL, 'cart', '2019-07-05 11:01:58', '2019-07-05 11:03:38', '::1', '', 'safari', '{\"is_mobile\":false}'),
(71, 0, 'vc2vefb4rs2at4mh6qfhrudnra', NULL, NULL, 'cart', '2019-07-05 12:19:41', '2019-07-05 12:39:17', '10.0.1.68', '', 'chrome', '{\"is_mobile\":false}'),
(73, 0, '8usovpppfha3hpoj2lfe2kqlnl', NULL, NULL, 'cart', '2019-07-05 13:26:21', '2019-07-05 13:38:20', '10.0.1.5', '', 'chrome', '{\"is_mobile\":false}'),
(74, 0, 'qu00mmtk4vnvbihq0p05b6hp07', NULL, NULL, 'cart', '2019-07-05 13:31:35', '2019-07-05 14:37:04', '10.0.1.75', '', 'chrome', '{\"is_mobile\":false}'),
(76, 0, 'mciq8dn5t9ovd2h961813r1rd0', NULL, NULL, 'cart', '2019-07-05 13:41:35', '0000-00-00 00:00:00', '10.0.1.17', '', 'edg', '{\"is_mobile\":false}'),
(77, 0, '9fbocsfp1hh5fqairo7khlrsk2', NULL, NULL, 'cart', '2019-07-05 13:50:35', '2019-07-05 13:53:05', '10.0.1.5', '', 'chrome', '{\"is_mobile\":false}'),
(79, 0, 'ia9kj3d9da6pj8hqod4cr4073l', NULL, NULL, 'cart', '2019-07-05 14:39:50', '0000-00-00 00:00:00', '::1', '', 'edg', '{\"is_mobile\":false}'),
(80, 0, '5hnklache11pjcf3273bl16f1i', NULL, NULL, 'cart', '2019-07-05 14:39:50', '0000-00-00 00:00:00', '::1', '', 'edg', '{\"is_mobile\":false}'),
(81, 0, 'gnl77j7idfcpp67jfdrsqt8eh9', NULL, NULL, 'cart', '2019-07-05 15:20:46', '0000-00-00 00:00:00', '10.0.1.75', '', 'chrome', '{\"is_mobile\":false}'),
(83, 0, '4t5rbcmjegthgs1o2hvqlontm0', NULL, NULL, 'cart', '2019-07-08 05:23:34', '2019-07-08 05:30:11', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(84, 0, 'ou9erdafheb3h624tee8ne2p1m', NULL, NULL, 'cart', '2019-07-08 05:31:34', '2019-07-08 10:46:04', '::1', '', 'edg', '{\"is_mobile\":false}'),
(85, 0, '2r416ahj2ui19rbratit47oclv', NULL, NULL, 'cart', '2019-07-08 10:46:18', '2019-07-08 11:04:34', '::1', '', 'edg', '{\"is_mobile\":false}'),
(86, 0, 'ar5lu9b5cuvmucqkb9sehb5tn1', NULL, NULL, 'cart', '2019-07-10 08:06:04', '0000-00-00 00:00:00', '::1', '', 'edg', '{\"is_mobile\":false}'),
(88, 235, 'q1a6a208vq43f3hb68v8i03tvt', NULL, NULL, 'cart', '2019-07-10 09:51:13', '2019-07-10 12:52:02', '::1', '', 'edg', '{\"is_mobile\":false}'),
(89, 0, 'gu2mcm9diuj2vvcgs8s71q81bk', NULL, NULL, 'cart', '2019-07-10 12:52:04', '2019-07-10 13:29:07', '::1', '', 'edg', '{\"is_mobile\":false}'),
(90, 0, 'm4aqfdnicebkqnosqnsaubr8a0', NULL, NULL, 'cart', '2019-07-11 07:38:40', '2019-07-11 08:13:50', '::1', '', 'edg', '{\"is_mobile\":false}'),
(91, 0, 'ethqj65dqilkvqo92aferioa6v', NULL, NULL, 'cart', '2019-08-08 06:01:28', '2019-08-08 06:08:46', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(92, 0, 'ho0hpnflvk98qnbq6tdmij13rk', NULL, NULL, 'cart', '2019-08-08 06:09:20', '2019-08-09 06:14:57', '10.0.1.6', '', 'chrome', '{\"is_mobile\":false}'),
(93, 0, 'rduhnl3dj02i7onh7uan8h485b', NULL, NULL, 'cart', '2019-08-08 06:15:25', '2019-08-08 06:25:31', '10.0.1.5', '', 'chrome', '{\"is_mobile\":false}'),
(94, 0, 'mt2bprhst0tm6aqrcg9ldkptnu', NULL, NULL, 'cart', '2019-08-09 05:46:58', '2019-08-09 05:57:23', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(95, 0, 'mj1ni7dpk4jelr2dch3rs8d1v8', NULL, NULL, 'cart', '2019-08-09 06:06:34', '2019-08-09 06:10:26', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(96, 0, 'na5htefivrv29p8n198v9cetic', NULL, NULL, 'cart', '2019-08-09 06:10:12', '2019-08-09 06:14:12', '10.0.1.5', '', 'chrome', '{\"is_mobile\":false}'),
(97, 0, 'n2oosg7eubr1dadhgd1csr1uqm', NULL, NULL, 'cart', '2019-08-09 07:44:45', '2019-08-09 07:55:46', '10.0.1.17', '', 'edg', '{\"is_mobile\":false}'),
(98, 0, '51eqrru4p6tmqqc808k8ar1e5p', NULL, NULL, 'cart', '2019-11-07 05:25:19', '2019-11-07 05:25:55', '10.0.1.16', '', 'chrome', '{\"is_mobile\":false}'),
(99, 0, 'u5m7oqecer72tani7o9l5p7j4s', NULL, NULL, 'cart', '2019-11-07 05:28:38', '2019-11-07 08:43:55', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(101, 948, 'oodbj1o48g647b0odv6b7kusoa', NULL, NULL, 'cart', '2019-11-07 05:48:42', '2019-11-08 12:30:27', '10.0.1.16', '', 'chrome', '{\"is_mobile\":false}'),
(102, 0, 'hl26o8ce2cavb67raef22rrt4f', NULL, NULL, 'cart', '2019-11-07 09:34:34', '2019-11-07 11:28:57', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(105, 0, 'og5fnhailksl4pa3i7mmubptu9', NULL, NULL, 'cart', '2019-11-08 06:40:13', '2019-11-08 12:32:23', '10.0.1.16', '', 'chrome', '{\"is_mobile\":false}'),
(106, 0, 'vhkrkm23mblvvbeoh6h43rpr4r', NULL, NULL, 'cart', '2019-11-08 06:40:57', '2019-11-08 06:59:12', '10.0.1.17', '', 'edg', '{\"is_mobile\":false}'),
(107, 0, '1si449jaf9mpifj9vdp5vjue9n', NULL, NULL, 'cart', '2019-11-08 09:18:05', '2019-11-08 09:19:21', '10.0.1.34', '', 'chrome', '{\"is_mobile\":true}'),
(108, 0, 'fldvtirg7c9t4ta62d9bok60s4', NULL, NULL, 'cart', '2019-11-11 10:15:56', '0000-00-00 00:00:00', '::1', '', 'firefox', '{\"is_mobile\":false}'),
(109, 0, '8gqss1m9baovd20el7pjkr19gq', NULL, NULL, 'cart', '2019-11-13 05:48:19', '2019-11-13 05:48:53', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(110, 0, 'pp4jq0q58ar89r748bafu68ftk', NULL, NULL, 'cart', '2019-11-14 04:58:09', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(111, 0, 'd4uuovfs8tetpbkmgg9se19abl', NULL, NULL, 'cart', '2019-11-20 07:50:41', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(112, 0, 'fak0kfn95vnm9ogbod4b280dk4', NULL, NULL, 'cart', '2019-11-20 08:47:25', '2019-11-20 08:49:10', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(113, 0, 'qa6dd1iv5bgklkuhvgah7ibpp5', NULL, NULL, 'cart', '2019-11-20 09:15:44', '2019-11-20 09:29:21', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(114, 0, 'r4009e24skatbhgq6to3i20c1p', NULL, NULL, 'cart', '2019-11-20 09:58:32', '2019-11-20 10:17:56', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(115, 0, 'l7dm35lndl7nssn0qonp8ltuss', NULL, NULL, 'cart', '2019-11-20 10:50:00', '2019-11-20 11:19:04', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(116, 0, '9952e5iosdj83tpcvod57a3e7k', NULL, NULL, 'cart', '2020-01-21 05:51:41', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(117, 0, 'k1eohrr6roqa1co6rsa2f5jhlp', NULL, NULL, 'cart', '2020-01-21 05:51:42', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(119, 0, '0i5ua71bnrium06n670crs9k6j', NULL, NULL, 'cart', '2020-01-22 07:09:02', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(120, 0, 'lgc2jfarbdunivj5at6acc2idb', NULL, NULL, 'cart', '2020-01-23 11:16:42', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(121, 0, '7o7vod3mm0ti47htt74l7fm3s0', NULL, NULL, 'cart', '2020-01-28 09:48:47', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(122, 0, 'b0m2vgaeja8ajg92f3akhtdoil', NULL, NULL, 'cart', '2020-01-28 10:04:05', '2020-01-28 10:54:07', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(123, 0, 's94pl15o8jpvlhhp4nh0i7m9pe', NULL, NULL, 'cart', '2020-01-28 11:42:08', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(124, 0, 'lu1d7mt88lkjt8orcg05etaj05', NULL, NULL, 'cart', '2020-01-29 05:03:28', '0000-00-00 00:00:00', '10.0.1.3', '', 'chrome', '{\"is_mobile\":false}'),
(125, 0, 'c0uuqce9c6jpo49u3g4rmrc8u4', NULL, NULL, 'cart', '2020-01-30 05:45:21', '0000-00-00 00:00:00', '::1', '', 'chrome', '{\"is_mobile\":false}'),
(126, 336, 'ivb6qq8654sr7gk1jqucduc6r5', NULL, NULL, 'cart', '2020-01-21 05:51:47', '2020-01-30 07:37:50', '::1', '', 'chrome', '{\"is_mobile\":false}');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_configurations`
--

DROP TABLE IF EXISTS `#__j2store_configurations`;
CREATE TABLE `#__j2store_configurations` (
  `config_meta_key` varchar(255) NOT NULL,
  `config_meta_value` text,
  `config_meta_default` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_configurations`
--

INSERT INTO `#__j2store_configurations` (`config_meta_key`, `config_meta_value`, `config_meta_default`) VALUES
('acceptlicense', 'on', ''),
('acceptsupport', 'on', ''),
('addtocart_action', '1', ''),
('addtocart_button_class', 'btn btn-primary', ''),
('addtocart_placement', 'default', ''),
('admin_email', 'install@test.com', ''),
('allow_guest_checkout', '0', ''),
('allow_password_validation', '0', ''),
('allow_registration', '1', ''),
('attachmentfolderpath', '', ''),
('auto_apply_shipping_rate', '0', ''),
('bootstrap_version', '3', ''),
('catalog_mode', '0', ''),
('checkout_price_display_options', '1', ''),
('clear_cart', 'order_placed', ''),
('clear_outdated_cart_data_term', '90', ''),
('config_cart_empty_redirect', 'cart', ''),
('config_cart_redirect_page_url', '', ''),
('config_continue_shopping_page', 'previous', ''),
('config_continue_shopping_page_url', '', ''),
('config_currency', 'USD', ''),
('config_currency_auto', '1', ''),
('config_including_tax', '0', ''),
('config_length_class_id', '1', ''),
('config_tax_default', 'billing', ''),
('config_tax_default_address', 'store', ''),
('config_weight_class_id', '1', ''),
('continue_cart_redirect_menu', '165', ''),
('continue_shopping_page_menu', '165', ''),
('country_id', '223', ''),
('coupon_update', '1', ''),
('date_format', 'Y-m-d H:i:s', ''),
('default_payment_method', 'payment_banktransfer', ''),
('display_price_with_tax_info', '0', ''),
('downloadid', '', ''),
('download_area', '1', ''),
('enable_falang_support', '0', ''),
('f7ef2e8d19dbe29939094265ef62352f', '1', ''),
('hide_shipping_untill_address_selection', '1', ''),
('image_for_product_options', '0', ''),
('installation_complete', '1', ''),
('invoice_prefix', '', ''),
('isregister', '0', ''),
('j2store_enable_css', '1', ''),
('jquery_ui_localisation', '0', ''),
('limit_orderstatuses', '*', ''),
('liveupdate', '', ''),
('load_bootstrap', '1', ''),
('load_fontawesome_ui', '1', ''),
('load_jquery_ui', '3', ''),
('load_minimal_bootstrap', '0', ''),
('option', 'com_j2store', ''),
('plugin_check_date', '2019-07-01', ''),
('postalcode_required', '1', ''),
('prepare_content', '0', ''),
('price_display_options', '1', ''),
('product_option_price', '1', ''),
('product_option_price_prefix', '1', ''),
('queue_key', '9b5f2be1571539cf422de3c6be210696', ''),
('queue_repeat_count', '10', ''),
('related_product_columns', '3', ''),
('shipping_mandatory', '0', ''),
('show_base_price', '1', ''),
('show_clear_cart_button', '0', ''),
('show_customer_note', '1', ''),
('show_item_tax', '0', ''),
('show_login_form', '1', ''),
('show_logout_myprofile', '0', ''),
('show_manufacturer', '1', ''),
('show_postpayment_orderlink', '1', ''),
('show_price_field', '1', ''),
('show_qty_field', '1', ''),
('show_shipping_address', '1', ''),
('show_sku', '1', ''),
('show_tax_calculator', '1', ''),
('show_terms', '1', ''),
('show_thumb_cart', '0', ''),
('show_thumb_email', '0', ''),
('store_address_1', '16192 Coastal Hwy', ''),
('store_address_2', '', ''),
('store_billing_layout', '', ''),
('store_city', 'Lewes', ''),
('store_name', 'Shaper Indigo', ''),
('store_payment_layout', '', ''),
('store_shipping_layout', '', ''),
('store_zip', '19958', ''),
('task', 'save', ''),
('termsid', '', ''),
('terms_display_type', 'link', ''),
('view', 'postconfig', ''),
('zone_id', '3627', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_countries`
--

DROP TABLE IF EXISTS `#__j2store_countries`;
CREATE TABLE `#__j2store_countries` (
  `j2store_country_id` int(11) NOT NULL,
  `country_name` varchar(255) NOT NULL,
  `country_isocode_2` varchar(5) NOT NULL,
  `country_isocode_3` varchar(5) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_countries`
--

INSERT INTO `#__j2store_countries` (`j2store_country_id`, `country_name`, `country_isocode_2`, `country_isocode_3`, `enabled`, `ordering`) VALUES
(1, 'Afghanistan', 'AF', 'AFG', 1, 0),
(2, 'Albania', 'AL', 'ALB', 1, 0),
(3, 'Algeria', 'DZ', 'DZA', 1, 0),
(4, 'American Samoa', 'AS', 'ASM', 1, 0),
(5, 'Andorra', 'AD', 'AND', 1, 0),
(6, 'Angola', 'AO', 'AGO', 1, 0),
(7, 'Anguilla', 'AI', 'AIA', 1, 0),
(8, 'Antarctica', 'AQ', 'ATA', 1, 0),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 1, 0),
(10, 'Argentina', 'AR', 'ARG', 1, 0),
(11, 'Armenia', 'AM', 'ARM', 1, 0),
(12, 'Aruba', 'AW', 'ABW', 1, 0),
(13, 'Australia', 'AU', 'AUS', 1, 0),
(14, 'Austria', 'AT', 'AUT', 1, 0),
(15, 'Azerbaijan', 'AZ', 'AZE', 1, 0),
(16, 'Bahamas', 'BS', 'BHS', 1, 0),
(17, 'Bahrain', 'BH', 'BHR', 1, 0),
(18, 'Bangladesh', 'BD', 'BGD', 1, 0),
(19, 'Barbados', 'BB', 'BRB', 1, 0),
(20, 'Belarus', 'BY', 'BLR', 1, 0),
(21, 'Belgium', 'BE', 'BEL', 1, 0),
(22, 'Belize', 'BZ', 'BLZ', 1, 0),
(23, 'Benin', 'BJ', 'BEN', 1, 0),
(24, 'Bermuda', 'BM', 'BMU', 1, 0),
(25, 'Bhutan', 'BT', 'BTN', 1, 0),
(26, 'Bolivia', 'BO', 'BOL', 1, 0),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', 1, 0),
(28, 'Botswana', 'BW', 'BWA', 1, 0),
(29, 'Bouvet Island', 'BV', 'BVT', 1, 0),
(30, 'Brazil', 'BR', 'BRA', 1, 0),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1, 0),
(32, 'Brunei Darussalam', 'BN', 'BRN', 1, 0),
(33, 'Bulgaria', 'BG', 'BGR', 1, 0),
(34, 'Burkina Faso', 'BF', 'BFA', 1, 0),
(35, 'Burundi', 'BI', 'BDI', 1, 0),
(36, 'Cambodia', 'KH', 'KHM', 1, 0),
(37, 'Cameroon', 'CM', 'CMR', 1, 0),
(38, 'Canada', 'CA', 'CAN', 1, 0),
(39, 'Cape Verde', 'CV', 'CPV', 1, 0),
(40, 'Cayman Islands', 'KY', 'CYM', 1, 0),
(41, 'Central African Republic', 'CF', 'CAF', 1, 0),
(42, 'Chad', 'TD', 'TCD', 1, 0),
(43, 'Chile', 'CL', 'CHL', 1, 0),
(44, 'China', 'CN', 'CHN', 1, 0),
(45, 'Christmas Island', 'CX', 'CXR', 1, 0),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1, 0),
(47, 'Colombia', 'CO', 'COL', 1, 0),
(48, 'Comoros', 'KM', 'COM', 1, 0),
(49, 'Congo', 'CG', 'COG', 1, 0),
(50, 'Cook Islands', 'CK', 'COK', 1, 0),
(51, 'Costa Rica', 'CR', 'CRI', 1, 0),
(52, 'Cote D\'Ivoire', 'CI', 'CIV', 1, 0),
(53, 'Croatia', 'HR', 'HRV', 1, 0),
(54, 'Cuba', 'CU', 'CUB', 1, 0),
(55, 'Cyprus', 'CY', 'CYP', 1, 0),
(56, 'Czech Republic', 'CZ', 'CZE', 1, 0),
(57, 'Denmark', 'DK', 'DNK', 1, 0),
(58, 'Djibouti', 'DJ', 'DJI', 1, 0),
(59, 'Dominica', 'DM', 'DMA', 1, 0),
(60, 'Dominican Republic', 'DO', 'DOM', 1, 0),
(61, 'East Timor', 'TP', 'TMP', 1, 0),
(62, 'Ecuador', 'EC', 'ECU', 1, 0),
(63, 'Egypt', 'EG', 'EGY', 1, 0),
(64, 'El Salvador', 'SV', 'SLV', 1, 0),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', 1, 0),
(66, 'Eritrea', 'ER', 'ERI', 1, 0),
(67, 'Estonia', 'EE', 'EST', 1, 0),
(68, 'Ethiopia', 'ET', 'ETH', 1, 0),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1, 0),
(70, 'Faroe Islands', 'FO', 'FRO', 1, 0),
(71, 'Fiji', 'FJ', 'FJI', 1, 0),
(72, 'Finland', 'FI', 'FIN', 1, 0),
(73, 'France', 'FR', 'FRA', 1, 0),
(74, 'France, Metropolitan', 'FX', 'FXX', 1, 0),
(75, 'French Guiana', 'GF', 'GUF', 1, 0),
(76, 'French Polynesia', 'PF', 'PYF', 1, 0),
(77, 'French Southern Territories', 'TF', 'ATF', 1, 0),
(78, 'Gabon', 'GA', 'GAB', 1, 0),
(79, 'Gambia', 'GM', 'GMB', 1, 0),
(80, 'Georgia', 'GE', 'GEO', 1, 0),
(81, 'Germany', 'DE', 'DEU', 1, 0),
(82, 'Ghana', 'GH', 'GHA', 1, 0),
(83, 'Gibraltar', 'GI', 'GIB', 1, 0),
(84, 'Greece', 'GR', 'GRC', 1, 0),
(85, 'Greenland', 'GL', 'GRL', 1, 0),
(86, 'Grenada', 'GD', 'GRD', 1, 0),
(87, 'Guadeloupe', 'GP', 'GLP', 1, 0),
(88, 'Guam', 'GU', 'GUM', 1, 0),
(89, 'Guatemala', 'GT', 'GTM', 1, 0),
(90, 'Guinea', 'GN', 'GIN', 1, 0),
(91, 'Guinea-bissau', 'GW', 'GNB', 1, 0),
(92, 'Guyana', 'GY', 'GUY', 1, 0),
(93, 'Haiti', 'HT', 'HTI', 1, 0),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1, 0),
(95, 'Honduras', 'HN', 'HND', 1, 0),
(96, 'Hong Kong', 'HK', 'HKG', 1, 0),
(97, 'Hungary', 'HU', 'HUN', 1, 0),
(98, 'Iceland', 'IS', 'ISL', 1, 0),
(99, 'India', 'IN', 'IND', 1, 0),
(100, 'Indonesia', 'ID', 'IDN', 1, 0),
(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1, 0),
(102, 'Iraq', 'IQ', 'IRQ', 1, 0),
(103, 'Ireland', 'IE', 'IRL', 1, 0),
(104, 'Israel', 'IL', 'ISR', 1, 0),
(105, 'Italy', 'IT', 'ITA', 1, 0),
(106, 'Jamaica', 'JM', 'JAM', 1, 0),
(107, 'Japan', 'JP', 'JPN', 1, 0),
(108, 'Jordan', 'JO', 'JOR', 1, 0),
(109, 'Kazakhstan', 'KZ', 'KAZ', 1, 0),
(110, 'Kenya', 'KE', 'KEN', 1, 0),
(111, 'Kiribati', 'KI', 'KIR', 1, 0),
(112, 'North Korea', 'KP', 'PRK', 1, 0),
(113, 'Korea, Republic of', 'KR', 'KOR', 1, 0),
(114, 'Kuwait', 'KW', 'KWT', 1, 0),
(115, 'Kyrgyzstan', 'KG', 'KGZ', 1, 0),
(116, 'Lao People\'s Democratic Republic', 'LA', 'LAO', 1, 0),
(117, 'Latvia', 'LV', 'LVA', 1, 0),
(118, 'Lebanon', 'LB', 'LBN', 1, 0),
(119, 'Lesotho', 'LS', 'LSO', 1, 0),
(120, 'Liberia', 'LR', 'LBR', 1, 0),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1, 0),
(122, 'Liechtenstein', 'LI', 'LIE', 1, 0),
(123, 'Lithuania', 'LT', 'LTU', 1, 0),
(124, 'Luxembourg', 'LU', 'LUX', 1, 0),
(125, 'Macau', 'MO', 'MAC', 1, 0),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MK', 'MKD', 1, 0),
(127, 'Madagascar', 'MG', 'MDG', 1, 0),
(128, 'Malawi', 'MW', 'MWI', 1, 0),
(129, 'Malaysia', 'MY', 'MYS', 1, 0),
(130, 'Maldives', 'MV', 'MDV', 1, 0),
(131, 'Mali', 'ML', 'MLI', 1, 0),
(132, 'Malta', 'MT', 'MLT', 1, 0),
(133, 'Marshall Islands', 'MH', 'MHL', 1, 0),
(134, 'Martinique', 'MQ', 'MTQ', 1, 0),
(135, 'Mauritania', 'MR', 'MRT', 1, 0),
(136, 'Mauritius', 'MU', 'MUS', 1, 0),
(137, 'Mayotte', 'YT', 'MYT', 1, 0),
(138, 'Mexico', 'MX', 'MEX', 1, 0),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', 1, 0),
(140, 'Moldova, Republic of', 'MD', 'MDA', 1, 0),
(141, 'Monaco', 'MC', 'MCO', 1, 0),
(142, 'Mongolia', 'MN', 'MNG', 1, 0),
(143, 'Montserrat', 'MS', 'MSR', 1, 0),
(144, 'Morocco', 'MA', 'MAR', 1, 0),
(145, 'Mozambique', 'MZ', 'MOZ', 1, 0),
(146, 'Myanmar', 'MM', 'MMR', 1, 0),
(147, 'Namibia', 'NA', 'NAM', 1, 0),
(148, 'Nauru', 'NR', 'NRU', 1, 0),
(149, 'Nepal', 'NP', 'NPL', 1, 0),
(150, 'Netherlands', 'NL', 'NLD', 1, 0),
(151, 'Netherlands Antilles', 'AN', 'ANT', 1, 0),
(152, 'New Caledonia', 'NC', 'NCL', 1, 0),
(153, 'New Zealand', 'NZ', 'NZL', 1, 0),
(154, 'Nicaragua', 'NI', 'NIC', 1, 0),
(155, 'Niger', 'NE', 'NER', 1, 0),
(156, 'Nigeria', 'NG', 'NGA', 1, 0),
(157, 'Niue', 'NU', 'NIU', 1, 0),
(158, 'Norfolk Island', 'NF', 'NFK', 1, 0),
(159, 'Northern Mariana Islands', 'MP', 'MNP', 1, 0),
(160, 'Norway', 'NO', 'NOR', 1, 0),
(161, 'Oman', 'OM', 'OMN', 1, 0),
(162, 'Pakistan', 'PK', 'PAK', 1, 0),
(163, 'Palau', 'PW', 'PLW', 1, 0),
(164, 'Panama', 'PA', 'PAN', 1, 0),
(165, 'Papua New Guinea', 'PG', 'PNG', 1, 0),
(166, 'Paraguay', 'PY', 'PRY', 1, 0),
(167, 'Peru', 'PE', 'PER', 1, 0),
(168, 'Philippines', 'PH', 'PHL', 1, 0),
(169, 'Pitcairn', 'PN', 'PCN', 1, 0),
(170, 'Poland', 'PL', 'POL', 1, 0),
(171, 'Portugal', 'PT', 'PRT', 1, 0),
(172, 'Puerto Rico', 'PR', 'PRI', 1, 0),
(173, 'Qatar', 'QA', 'QAT', 1, 0),
(174, 'Reunion', 'RE', 'REU', 1, 0),
(175, 'Romania', 'RO', 'ROM', 1, 0),
(176, 'Russian Federation', 'RU', 'RUS', 1, 0),
(177, 'Rwanda', 'RW', 'RWA', 1, 0),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1, 0),
(179, 'Saint Lucia', 'LC', 'LCA', 1, 0),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1, 0),
(181, 'Samoa', 'WS', 'WSM', 1, 0),
(182, 'San Marino', 'SM', 'SMR', 1, 0),
(183, 'Sao Tome and Principe', 'ST', 'STP', 1, 0),
(184, 'Saudi Arabia', 'SA', 'SAU', 1, 0),
(185, 'Senegal', 'SN', 'SEN', 1, 0),
(186, 'Seychelles', 'SC', 'SYC', 1, 0),
(187, 'Sierra Leone', 'SL', 'SLE', 1, 0),
(188, 'Singapore', 'SG', 'SGP', 1, 0),
(189, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1, 0),
(190, 'Slovenia', 'SI', 'SVN', 1, 0),
(191, 'Solomon Islands', 'SB', 'SLB', 1, 0),
(192, 'Somalia', 'SO', 'SOM', 1, 0),
(193, 'South Africa', 'ZA', 'ZAF', 1, 0),
(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1, 0),
(195, 'Spain', 'ES', 'ESP', 1, 0),
(196, 'Sri Lanka', 'LK', 'LKA', 1, 0),
(197, 'St. Helena', 'SH', 'SHN', 1, 0),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1, 0),
(199, 'Sudan', 'SD', 'SDN', 1, 0),
(200, 'Suriname', 'SR', 'SUR', 1, 0),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1, 0),
(202, 'Swaziland', 'SZ', 'SWZ', 1, 0),
(203, 'Sweden', 'SE', 'SWE', 1, 0),
(204, 'Switzerland', 'CH', 'CHE', 1, 0),
(205, 'Syrian Arab Republic', 'SY', 'SYR', 1, 0),
(206, 'Taiwan', 'TW', 'TWN', 1, 0),
(207, 'Tajikistan', 'TJ', 'TJK', 1, 0),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1, 0),
(209, 'Thailand', 'TH', 'THA', 1, 0),
(210, 'Togo', 'TG', 'TGO', 1, 0),
(211, 'Tokelau', 'TK', 'TKL', 1, 0),
(212, 'Tonga', 'TO', 'TON', 1, 0),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 1, 0),
(214, 'Tunisia', 'TN', 'TUN', 1, 0),
(215, 'Turkey', 'TR', 'TUR', 1, 0),
(216, 'Turkmenistan', 'TM', 'TKM', 1, 0),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1, 0),
(218, 'Tuvalu', 'TV', 'TUV', 1, 0),
(219, 'Uganda', 'UG', 'UGA', 1, 0),
(220, 'Ukraine', 'UA', 'UKR', 1, 0),
(221, 'United Arab Emirates', 'AE', 'ARE', 1, 0),
(222, 'United Kingdom', 'GB', 'GBR', 1, 0),
(223, 'United States', 'US', 'USA', 1, 0),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1, 0),
(225, 'Uruguay', 'UY', 'URY', 1, 0),
(226, 'Uzbekistan', 'UZ', 'UZB', 1, 0),
(227, 'Vanuatu', 'VU', 'VUT', 1, 0),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', 1, 0),
(229, 'Venezuela', 'VE', 'VEN', 1, 0),
(230, 'Viet Nam', 'VN', 'VNM', 1, 0),
(231, 'Virgin Islands (British)', 'VG', 'VGB', 1, 0),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1, 0),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1, 0),
(234, 'Western Sahara', 'EH', 'ESH', 1, 0),
(235, 'Yemen', 'YE', 'YEM', 1, 0),
(237, 'Zaire', 'ZR', 'ZAR', 1, 0),
(238, 'Zambia', 'ZM', 'ZMB', 1, 0),
(239, 'Zimbabwe', 'ZW', 'ZWE', 1, 0),
(240, 'Serbia', 'RS', 'SRB', 1, 0),
(241, 'Montenegro', 'ME', 'MNE', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_coupons`
--

DROP TABLE IF EXISTS `#__j2store_coupons`;
CREATE TABLE `#__j2store_coupons` (
  `j2store_coupon_id` int(11) NOT NULL,
  `coupon_name` varchar(255) NOT NULL,
  `coupon_code` varchar(255) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL,
  `value` decimal(12,4) NOT NULL,
  `value_type` varchar(255) DEFAULT NULL,
  `max_value` varchar(255) NOT NULL,
  `free_shipping` int(11) NOT NULL,
  `max_uses` int(11) NOT NULL,
  `max_quantity` int(11) DEFAULT NULL,
  `user_group` varchar(255) DEFAULT NULL,
  `logged` int(11) NOT NULL,
  `max_customer_uses` int(11) NOT NULL,
  `valid_from` datetime NOT NULL,
  `valid_to` datetime NOT NULL,
  `product_category` text,
  `products` text,
  `min_subtotal` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `mycategory` text NOT NULL,
  `brand_ids` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_currencies`
--

DROP TABLE IF EXISTS `#__j2store_currencies`;
CREATE TABLE `#__j2store_currencies` (
  `j2store_currency_id` int(11) NOT NULL,
  `currency_title` varchar(32) NOT NULL,
  `currency_code` varchar(3) NOT NULL,
  `currency_position` varchar(12) NOT NULL,
  `currency_symbol` varchar(255) NOT NULL,
  `currency_num_decimals` int(4) NOT NULL,
  `currency_decimal` varchar(12) NOT NULL,
  `currency_thousands` char(1) NOT NULL,
  `currency_value` decimal(15,8) DEFAULT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` bigint(20) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_currencies`
--

INSERT INTO `#__j2store_currencies` (`j2store_currency_id`, `currency_title`, `currency_code`, `currency_position`, `currency_symbol`, `currency_num_decimals`, `currency_decimal`, `currency_thousands`, `currency_value`, `enabled`, `ordering`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 'USD', 'USD', 'pre', '$', 2, '.', ',', '1.00000000', 1, 0, '2019-06-17 09:59:26', 58, '2019-07-04 11:18:34', 0, '0000-00-00 00:00:00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_customfields`
--

DROP TABLE IF EXISTS `#__j2store_customfields`;
CREATE TABLE `#__j2store_customfields` (
  `j2store_customfield_id` smallint(5) UNSIGNED NOT NULL,
  `field_table` varchar(50) DEFAULT NULL,
  `field_name` varchar(250) NOT NULL,
  `field_namekey` varchar(50) NOT NULL,
  `field_type` varchar(50) DEFAULT NULL,
  `field_value` longtext NOT NULL,
  `enabled` int(11) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `field_options` text,
  `field_core` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `field_required` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `field_default` varchar(250) DEFAULT NULL,
  `field_access` varchar(255) NOT NULL DEFAULT 'all',
  `field_categories` varchar(255) NOT NULL DEFAULT 'all',
  `field_with_sub_categories` tinyint(1) NOT NULL DEFAULT '0',
  `field_frontend` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `field_backend` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `field_display` text NOT NULL,
  `field_display_billing` smallint(5) NOT NULL DEFAULT '0',
  `field_display_register` smallint(5) NOT NULL DEFAULT '0',
  `field_display_shipping` smallint(5) NOT NULL DEFAULT '0',
  `field_display_guest` smallint(5) NOT NULL DEFAULT '0',
  `field_display_guest_shipping` smallint(5) NOT NULL DEFAULT '0',
  `field_display_payment` smallint(5) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_customfields`
--

INSERT INTO `#__j2store_customfields` (`j2store_customfield_id`, `field_table`, `field_name`, `field_namekey`, `field_type`, `field_value`, `enabled`, `ordering`, `field_options`, `field_core`, `field_required`, `field_default`, `field_access`, `field_categories`, `field_with_sub_categories`, `field_frontend`, `field_backend`, `field_display`, `field_display_billing`, `field_display_register`, `field_display_shipping`, `field_display_guest`, `field_display_guest_shipping`, `field_display_payment`) VALUES
(1, 'address', 'J2STORE_ADDRESS_FIRSTNAME', 'first_name', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(2, 'address', 'J2STORE_ADDRESS_LASTNAME', 'last_name', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(3, 'address', 'J2STORE_EMAIL', 'email', 'email', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:36:\"J2STORE_VALIDATION_ENTER_VALID_EMAIL\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 0, 1, 0, 0),
(4, 'address', 'J2STORE_ADDRESS_LINE1', 'address_1', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(5, 'address', 'J2STORE_ADDRESS_LINE2', 'address_2', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 0, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(6, 'address', 'J2STORE_ADDRESS_CITY', 'city', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(7, 'address', 'J2STORE_ADDRESS_ZIP', 'zip', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(8, 'address', 'J2STORE_ADDRESS_PHONE', 'phone_1', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:0:\"\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 0, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(9, 'address', 'J2STORE_ADDRESS_MOBILE', 'phone_2', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(10, 'address', 'J2STORE_ADDRESS_COMPANY_NAME', 'company', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:0:\"\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 0, '', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(11, 'address', 'J2STORE_ADDRESS_TAX_NUMBER', 'tax_number', 'text', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:0:\"\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 0, '', 'all', 'all', 0, 0, 1, '', 1, 1, 0, 1, 0, 0),
(12, 'address', 'J2STORE_ADDRESS_COUNTRY', 'country_id', 'zone', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:7:\"country\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '223', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0),
(13, 'address', 'J2STORE_ADDRESS_ZONE', 'zone_id', 'zone', '', 1, 99, 'a:8:{s:12:\"errormessage\";s:22:\"J2STORE_FIELD_REQUIRED\";s:9:\"filtering\";s:1:\"0\";s:9:\"maxlength\";s:1:\"0\";s:4:\"size\";s:0:\"\";s:4:\"cols\";s:0:\"\";s:9:\"zone_type\";s:4:\"zone\";s:6:\"format\";s:0:\"\";s:8:\"readonly\";s:1:\"0\";}', 1, 1, '3624', 'all', 'all', 0, 0, 1, '', 1, 1, 1, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_emailtemplates`
--

DROP TABLE IF EXISTS `#__j2store_emailtemplates`;
CREATE TABLE `#__j2store_emailtemplates` (
  `j2store_emailtemplate_id` int(11) NOT NULL,
  `email_type` varchar(255) NOT NULL,
  `receiver_type` varchar(255) NOT NULL DEFAULT '*',
  `orderstatus_id` varchar(255) NOT NULL,
  `group_id` varchar(255) NOT NULL,
  `paymentmethod` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `body_source` varchar(255) NOT NULL,
  `body_source_file` varchar(255) NOT NULL,
  `language` varchar(10) NOT NULL DEFAULT '*',
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_emailtemplates`
--

INSERT INTO `#__j2store_emailtemplates` (`j2store_emailtemplate_id`, `email_type`, `receiver_type`, `orderstatus_id`, `group_id`, `paymentmethod`, `subject`, `body`, `body_source`, `body_source_file`, `language`, `enabled`, `ordering`) VALUES
(1, '', '*', '*', '', '*', 'Hello [BILLING_FIRSTNAME] [BILLING_LASTNAME], your order has been placed with [SITENAME]', '<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr valign=\"top\">\r\n<td colspan=\"2\" rowspan=\"1\">\r\n<p>Hello [BILLING_FIRSTNAME] [BILLING_LASTNAME], we thank you for placing an order with [SITENAME]. Your Order ID is:<strong>[ORDERID]</strong>. We have now started processing your order. The details of your order are as follows:</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td>\r\n<h3>Order Information</h3>\r\n<p><strong>Order ID: </strong>[ORDERID]</p>\r\n<p><strong>Invoice Number: </strong>[INVOICENO]</p>\r\n<p><strong>Date: </strong>[ORDERDATE]</p>\r\n<p><strong>Order Amount: </strong>[ORDERAMOUNT]</p>\r\n<p><strong>Order Status: </strong>[ORDERSTATUS]</p>\r\n<p> </p>\r\n</td>\r\n<td>\r\n<h3>Customer Information</h3>\r\n<p>[BILLING_FIRSTNAME] [BILLING_LASTNAME]</p>\r\n<p>[BILLING_ADDRESS_1] [BILLING_ADDRESS_2]</p>\r\n<p>[BILLING_CITY], [BILLING_ZIP]</p>\r\n<p>[BILLING_STATE] [BILLING_COUNTRY]</p>\r\n<p>[BILLING_PHONE] [BILLING_MOBILE]</p>\r\n<p>[BILLING_COMPANY]</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td>\r\n<h3>Payment Information</h3>\r\n<p><strong>Payment Type: </strong>[PAYMENT_TYPE]</p>\r\n</td>\r\n<td>\r\n<h3>Shipping Information</h3>\r\n<p>[SHIPPING_FIRSTNAME] [SHIPPING_LASTNAME]</p>\r\n<p>[SHIPPING_ADDRESS_1] [SHIPPING_ADDRESS_2]</p>\r\n<p>[SHIPPING_CITY], [SHIPPING_ZIP]</p>\r\n<p>[SHIPPING_STATE] [SHIPPING_COUNTRY]</p>\r\n<p>[SHIPPING_PHONE] [SHIPPING_MOBILE]</p>\r\n<p>[SHIPPING_COMPANY]</p>\r\n<p>[SHIPPING_METHOD]</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td colspan=\"2\" rowspan=\"1\">\r\n<p>[ITEMS]</p>\r\n</td>\r\n</tr>\r\n<tr valign=\"top\">\r\n<td colspan=\"2\">\r\n<p>For any queries and details please get in touch with us. We will be glad to be of service. You can also view the order details by visiting [INVOICE_URL]</p>\r\n<p>You can use your email address and the following token to view the order [ORDER_TOKEN]</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '*', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_filtergroups`
--

DROP TABLE IF EXISTS `#__j2store_filtergroups`;
CREATE TABLE `#__j2store_filtergroups` (
  `j2store_filtergroup_id` int(11) NOT NULL,
  `group_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL,
  `enabled` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__j2store_filtergroups`
--

INSERT INTO `#__j2store_filtergroups` (`j2store_filtergroup_id`, `group_name`, `ordering`, `enabled`) VALUES
(1, 'Size', 0, 1),
(2, 'Color', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_filters`
--

DROP TABLE IF EXISTS `#__j2store_filters`;
CREATE TABLE `#__j2store_filters` (
  `j2store_filter_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `filter_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__j2store_filters`
--

INSERT INTO `#__j2store_filters` (`j2store_filter_id`, `group_id`, `filter_name`, `ordering`) VALUES
(1, 1, 'Xs', 1),
(2, 1, 'S', 2),
(3, 2, 'Red', 0),
(4, 2, 'Black', 0),
(5, 2, 'Purple', 0),
(6, 2, 'Yellow', 0),
(7, 1, 'L', 3),
(8, 1, 'M', 4);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_geozonerules`
--

DROP TABLE IF EXISTS `#__j2store_geozonerules`;
CREATE TABLE `#__j2store_geozonerules` (
  `j2store_geozonerule_id` int(11) NOT NULL,
  `geozone_id` int(11) NOT NULL,
  `country_id` int(11) NOT NULL,
  `zone_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_geozones`
--

DROP TABLE IF EXISTS `#__j2store_geozones`;
CREATE TABLE `#__j2store_geozones` (
  `j2store_geozone_id` int(11) NOT NULL,
  `geozone_name` varchar(255) NOT NULL,
  `enabled` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_invoicetemplates`
--

DROP TABLE IF EXISTS `#__j2store_invoicetemplates`;
CREATE TABLE `#__j2store_invoicetemplates` (
  `j2store_invoicetemplate_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `invoice_type` varchar(255) NOT NULL,
  `orderstatus_id` varchar(255) NOT NULL,
  `group_id` varchar(255) NOT NULL,
  `paymentmethod` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `language` varchar(10) NOT NULL DEFAULT '*',
  `enabled` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_lengths`
--

DROP TABLE IF EXISTS `#__j2store_lengths`;
CREATE TABLE `#__j2store_lengths` (
  `j2store_length_id` int(11) NOT NULL,
  `length_title` varchar(255) NOT NULL,
  `length_unit` varchar(4) NOT NULL,
  `length_value` decimal(15,8) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_lengths`
--

INSERT INTO `#__j2store_lengths` (`j2store_length_id`, `length_title`, `length_unit`, `length_value`, `enabled`, `ordering`) VALUES
(1, 'Centimetre', 'cm', '1.00000000', 1, 0),
(2, 'Inch', 'in', '0.39370000', 1, 0),
(3, 'Millimetre', 'mm', '10.00000000', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_manufacturers`
--

DROP TABLE IF EXISTS `#__j2store_manufacturers`;
CREATE TABLE `#__j2store_manufacturers` (
  `j2store_manufacturer_id` int(11) NOT NULL,
  `address_id` int(11) NOT NULL,
  `brand_desc_id` int(11) DEFAULT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_manufacturers`
--

INSERT INTO `#__j2store_manufacturers` (`j2store_manufacturer_id`, `address_id`, `brand_desc_id`, `enabled`, `ordering`) VALUES
(1, 1, 0, 1, 0),
(2, 2, 0, 1, 0),
(3, 3, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_metafields`
--

DROP TABLE IF EXISTS `#__j2store_metafields`;
CREATE TABLE `#__j2store_metafields` (
  `id` int(10) UNSIGNED NOT NULL,
  `metakey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `namespace` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scope` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metavalue` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `valuetype` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner_id` int(10) UNSIGNED NOT NULL,
  `owner_resource` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_options`
--

DROP TABLE IF EXISTS `#__j2store_options`;
CREATE TABLE `#__j2store_options` (
  `j2store_option_id` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `option_unique_name` varchar(255) NOT NULL,
  `option_name` varchar(255) NOT NULL,
  `ordering` int(11) NOT NULL,
  `enabled` int(11) NOT NULL,
  `option_params` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_options`
--

INSERT INTO `#__j2store_options` (`j2store_option_id`, `type`, `option_unique_name`, `option_name`, `ordering`, `enabled`, `option_params`) VALUES
(1, 'radio', 'Size', 'Size', 0, 1, '{\"place_holder\":\"\"}'),
(2, 'radio', 'Color', 'Color', 0, 1, '{\"place_holder\":\"\"}');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_optionvalues`
--

DROP TABLE IF EXISTS `#__j2store_optionvalues`;
CREATE TABLE `#__j2store_optionvalues` (
  `j2store_optionvalue_id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL,
  `optionvalue_name` varchar(255) NOT NULL,
  `optionvalue_image` longtext NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_optionvalues`
--

INSERT INTO `#__j2store_optionvalues` (`j2store_optionvalue_id`, `option_id`, `optionvalue_name`, `optionvalue_image`, `ordering`) VALUES
(1, 1, 'XS', '', 1),
(2, 1, 'S', '', 2),
(3, 1, 'L', '', 3),
(4, 1, 'M', '', 4),
(5, 2, 'Blue', '', 4),
(6, 2, 'Green', '', 2),
(7, 2, 'Yellow', '', 3),
(8, 2, 'Purple', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderdiscounts`
--

DROP TABLE IF EXISTS `#__j2store_orderdiscounts`;
CREATE TABLE `#__j2store_orderdiscounts` (
  `j2store_orderdiscount_id` int(11) UNSIGNED NOT NULL,
  `order_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_entity_id` int(11) UNSIGNED NOT NULL,
  `discount_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_value_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_customer_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) UNSIGNED NOT NULL,
  `discount_amount` decimal(12,4) NOT NULL,
  `discount_tax` decimal(12,4) DEFAULT NULL,
  `discount_params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderdownloads`
--

DROP TABLE IF EXISTS `#__j2store_orderdownloads`;
CREATE TABLE `#__j2store_orderdownloads` (
  `j2store_orderdownload_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `product_id` int(11) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `limit_count` bigint(20) NOT NULL,
  `access_granted` datetime NOT NULL,
  `access_expires` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderfees`
--

DROP TABLE IF EXISTS `#__j2store_orderfees`;
CREATE TABLE `#__j2store_orderfees` (
  `j2store_orderfee_id` int(11) UNSIGNED NOT NULL,
  `order_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(12,4) NOT NULL,
  `tax_class_id` int(11) UNSIGNED NOT NULL,
  `taxable` int(11) NOT NULL,
  `tax` decimal(12,4) NOT NULL,
  `tax_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderhistories`
--

DROP TABLE IF EXISTS `#__j2store_orderhistories`;
CREATE TABLE `#__j2store_orderhistories` (
  `j2store_orderhistory_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `order_state_id` int(11) NOT NULL,
  `notify_customer` int(11) NOT NULL,
  `comment` text NOT NULL,
  `created_on` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderinfos`
--

DROP TABLE IF EXISTS `#__j2store_orderinfos`;
CREATE TABLE `#__j2store_orderinfos` (
  `j2store_orderinfo_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `billing_company` varchar(255) DEFAULT NULL,
  `billing_last_name` varchar(255) DEFAULT NULL,
  `billing_first_name` varchar(255) DEFAULT NULL,
  `billing_middle_name` varchar(255) DEFAULT NULL,
  `billing_phone_1` varchar(255) DEFAULT NULL,
  `billing_phone_2` varchar(255) DEFAULT NULL,
  `billing_fax` varchar(255) DEFAULT NULL,
  `billing_address_1` varchar(255) NOT NULL DEFAULT '',
  `billing_address_2` varchar(255) DEFAULT NULL,
  `billing_city` varchar(255) NOT NULL DEFAULT '',
  `billing_zone_name` varchar(255) NOT NULL DEFAULT '',
  `billing_country_name` varchar(255) NOT NULL DEFAULT '',
  `billing_zone_id` int(11) NOT NULL DEFAULT '0',
  `billing_country_id` int(11) NOT NULL DEFAULT '0',
  `billing_zip` varchar(255) NOT NULL DEFAULT '',
  `billing_tax_number` varchar(255) DEFAULT NULL,
  `shipping_company` varchar(255) DEFAULT NULL,
  `shipping_last_name` varchar(255) DEFAULT NULL,
  `shipping_first_name` varchar(255) DEFAULT NULL,
  `shipping_middle_name` varchar(255) DEFAULT NULL,
  `shipping_phone_1` varchar(255) DEFAULT NULL,
  `shipping_phone_2` varchar(255) DEFAULT NULL,
  `shipping_fax` varchar(255) DEFAULT NULL,
  `shipping_address_1` varchar(255) NOT NULL DEFAULT '',
  `shipping_address_2` varchar(255) DEFAULT NULL,
  `shipping_city` varchar(255) NOT NULL DEFAULT '',
  `shipping_zip` varchar(255) NOT NULL,
  `shipping_zone_name` varchar(255) NOT NULL DEFAULT '',
  `shipping_country_name` varchar(255) NOT NULL DEFAULT '',
  `shipping_zone_id` int(11) NOT NULL DEFAULT '0',
  `shipping_country_id` int(11) NOT NULL DEFAULT '0',
  `shipping_id` varchar(255) NOT NULL DEFAULT '',
  `shipping_tax_number` varchar(255) DEFAULT NULL,
  `all_billing` longtext NOT NULL,
  `all_shipping` longtext NOT NULL,
  `all_payment` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderitemattributes`
--

DROP TABLE IF EXISTS `#__j2store_orderitemattributes`;
CREATE TABLE `#__j2store_orderitemattributes` (
  `j2store_orderitemattribute_id` int(11) NOT NULL,
  `orderitem_id` int(11) NOT NULL,
  `productattributeoption_id` int(11) NOT NULL,
  `productattributeoptionvalue_id` int(11) NOT NULL,
  `orderitemattribute_name` varchar(255) NOT NULL,
  `orderitemattribute_value` varchar(255) NOT NULL,
  `orderitemattribute_prefix` varchar(1) NOT NULL,
  `orderitemattribute_price` decimal(12,5) NOT NULL,
  `orderitemattribute_code` varchar(255) NOT NULL,
  `orderitemattribute_type` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderitems`
--

DROP TABLE IF EXISTS `#__j2store_orderitems`;
CREATE TABLE `#__j2store_orderitems` (
  `j2store_orderitem_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `orderitem_type` varchar(255) NOT NULL DEFAULT 'normal',
  `cart_id` int(11) NOT NULL,
  `cartitem_id` int(11) UNSIGNED NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_type` varchar(255) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `orderitem_sku` varchar(255) NOT NULL,
  `orderitem_name` varchar(255) NOT NULL,
  `orderitem_attributes` text NOT NULL,
  `orderitem_quantity` varchar(255) NOT NULL,
  `orderitem_taxprofile_id` int(11) NOT NULL,
  `orderitem_per_item_tax` decimal(12,4) NOT NULL,
  `orderitem_tax` decimal(12,4) NOT NULL,
  `orderitem_discount` decimal(12,4) NOT NULL,
  `orderitem_discount_tax` decimal(12,4) NOT NULL,
  `orderitem_price` decimal(12,5) NOT NULL,
  `orderitem_option_price` decimal(12,4) NOT NULL,
  `orderitem_finalprice` decimal(12,4) NOT NULL,
  `orderitem_finalprice_with_tax` decimal(12,4) NOT NULL,
  `orderitem_finalprice_without_tax` decimal(12,4) NOT NULL,
  `orderitem_params` text NOT NULL,
  `created_on` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `orderitem_weight` varchar(255) NOT NULL,
  `orderitem_weight_total` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orders`
--

DROP TABLE IF EXISTS `#__j2store_orders`;
CREATE TABLE `#__j2store_orders` (
  `j2store_order_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `order_type` varchar(255) NOT NULL DEFAULT 'normal',
  `parent_id` int(11) DEFAULT NULL,
  `subscription_id` int(10) NOT NULL,
  `cart_id` int(11) UNSIGNED NOT NULL,
  `invoice_prefix` varchar(255) NOT NULL,
  `invoice_number` int(11) NOT NULL,
  `token` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `order_total` decimal(12,4) NOT NULL,
  `order_subtotal` decimal(12,4) NOT NULL,
  `order_subtotal_ex_tax` decimal(12,4) DEFAULT NULL,
  `order_tax` decimal(12,4) NOT NULL,
  `order_shipping` decimal(12,4) NOT NULL,
  `order_shipping_tax` decimal(12,4) NOT NULL,
  `order_discount` decimal(12,4) NOT NULL,
  `order_discount_tax` decimal(12,4) DEFAULT NULL,
  `order_credit` decimal(12,4) NOT NULL,
  `order_refund` decimal(12,4) DEFAULT NULL,
  `order_surcharge` decimal(12,4) NOT NULL,
  `order_fees` decimal(12,4) DEFAULT NULL,
  `orderpayment_type` varchar(255) NOT NULL,
  `transaction_id` varchar(255) NOT NULL,
  `transaction_status` varchar(255) NOT NULL,
  `transaction_details` text NOT NULL,
  `currency_id` int(11) NOT NULL,
  `currency_code` varchar(255) NOT NULL,
  `currency_value` decimal(15,8) DEFAULT NULL,
  `ip_address` varchar(255) NOT NULL,
  `is_shippable` int(11) NOT NULL,
  `is_including_tax` int(11) NOT NULL,
  `customer_note` text NOT NULL,
  `customer_language` varchar(255) NOT NULL,
  `customer_group` varchar(255) NOT NULL,
  `order_state_id` int(11) NOT NULL,
  `order_state` varchar(255) NOT NULL COMMENT 'Legacy compatibility',
  `order_params` text,
  `created_on` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `modified_on` datetime NOT NULL,
  `modified_by` int(11) NOT NULL,
  `campaign_double_opt_in` int(10) NOT NULL,
  `campaign_order_id` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_ordershippings`
--

DROP TABLE IF EXISTS `#__j2store_ordershippings`;
CREATE TABLE `#__j2store_ordershippings` (
  `j2store_ordershipping_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL DEFAULT '0',
  `ordershipping_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'Element name of shipping plugin',
  `ordershipping_price` decimal(15,5) DEFAULT '0.00000',
  `ordershipping_name` varchar(255) NOT NULL DEFAULT '',
  `ordershipping_code` varchar(255) NOT NULL DEFAULT '',
  `ordershipping_tax` decimal(15,5) DEFAULT '0.00000',
  `ordershipping_extra` decimal(15,5) DEFAULT '0.00000',
  `ordershipping_tracking_id` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_orderstatuses`
--

DROP TABLE IF EXISTS `#__j2store_orderstatuses`;
CREATE TABLE `#__j2store_orderstatuses` (
  `j2store_orderstatus_id` int(11) NOT NULL,
  `orderstatus_name` varchar(32) NOT NULL,
  `orderstatus_cssclass` text NOT NULL,
  `orderstatus_core` int(1) NOT NULL DEFAULT '0',
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_orderstatuses`
--

INSERT INTO `#__j2store_orderstatuses` (`j2store_orderstatus_id`, `orderstatus_name`, `orderstatus_cssclass`, `orderstatus_core`, `enabled`, `ordering`) VALUES
(1, 'J2STORE_CONFIRMED', 'label-success', 1, 1, 1),
(2, 'J2STORE_PROCESSED', 'label-info', 1, 1, 2),
(3, 'J2STORE_FAILED', 'label-important', 1, 1, 3),
(4, 'J2STORE_PENDING', 'label-warning', 1, 1, 4),
(5, 'J2STORE_NEW', 'label-warning', 1, 1, 5),
(6, 'J2STORE_CANCELLED', 'label-warning', 1, 1, 6);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_ordertaxes`
--

DROP TABLE IF EXISTS `#__j2store_ordertaxes`;
CREATE TABLE `#__j2store_ordertaxes` (
  `j2store_ordertax_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `ordertax_title` varchar(255) NOT NULL,
  `ordertax_percent` decimal(12,4) NOT NULL,
  `ordertax_amount` decimal(12,4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_productfiles`
--

DROP TABLE IF EXISTS `#__j2store_productfiles`;
CREATE TABLE `#__j2store_productfiles` (
  `j2store_productfile_id` int(11) NOT NULL,
  `product_file_display_name` varchar(255) NOT NULL,
  `product_file_save_name` varchar(255) NOT NULL,
  `product_id` int(11) NOT NULL,
  `download_total` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_productimages`
--

DROP TABLE IF EXISTS `#__j2store_productimages`;
CREATE TABLE `#__j2store_productimages` (
  `j2store_productimage_id` int(11) NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `main_image` text,
  `main_image_alt` varchar(255) NOT NULL,
  `thumb_image` text,
  `thumb_image_alt` varchar(255) NOT NULL,
  `additional_images` longtext,
  `additional_images_alt` longtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_productimages`
--

INSERT INTO `#__j2store_productimages` (`j2store_productimage_id`, `product_id`, `main_image`, `main_image_alt`, `thumb_image`, `thumb_image_alt`, `additional_images`, `additional_images_alt`) VALUES
(1, 1, 'images/2018/02/23/Artboard.jpg', '', 'images/2018/02/Artboard.jpg', '', '{\"0\":\"images\\/Artboard_Copy_2.jpg\",\"2\":\"images\\/demo\\/products\\/product_13.jpg\",\"3\":\"images\\/demo\\/products\\/product_11.jpg\"}', '{\"0\":\"\",\"2\":\"\",\"3\":\"\"}'),
(10, 10, 'images/demo/products/product_14.jpg', '', 'images/demo/products/product_2.jpg', '', '[\"images\\/demo\\/products\\/product_11.jpg\",\"images\\/demo\\/products\\/product_13.jpg\",\"images\\/demo\\/products\\/product_1.jpg\"]', '[\"\",\"\",\"\"]'),
(11, 11, 'images/demo/products/product_15.jpg', '', 'images/demo/products/product_15.jpg', '', '[\"images\\/demo\\/products\\/product_16.jpg\",\"images\\/demo\\/products\\/product_17.jpg\",\"images\\/demo\\/products\\/product_18.jpg\"]', '[\"\",\"\",\"\"]'),
(12, 12, 'images/demo/products/product_11.jpg', '', 'images/demo/products/product_11.jpg', '', '[\"images\\/demo\\/products\\/product_14.jpg\",\"images\\/demo\\/products\\/product_13.jpg\",\"images\\/demo\\/products\\/product_3.jpg\"]', '[\"\",\"\",\"\"]'),
(13, 13, 'images/demo/products/product_19.jpg', '', 'images/demo/products/product_19.jpg', '', '[\"images\\/demo\\/products\\/product_4.jpg\",\"images\\/demo\\/products\\/product_6.jpg\",\"images\\/demo\\/products\\/product_6.jpg\"]', '[\"\",\"\",\"\"]'),
(14, 14, 'images/demo/products/product_9.jpg', '', 'images/demo/products/product_9.jpg', '', '[\"images\\/demo\\/products\\/product_2.jpg\",\"images\\/demo\\/products\\/product_2.jpg\",\"images\\/demo\\/products\\/product_3.jpg\"]', '[\"\",\"\",\"\"]'),
(15, 15, 'images/demo/products/product_17.jpg', '', 'images/demo/products/product_17.jpg', '', '[\"images\\/demo\\/products\\/product_9.jpg\",\"images\\/demo\\/products\\/product_3.jpg\",\"images\\/demo\\/products\\/product_4.jpg\"]', '[\"\",\"\",\"\"]'),
(16, 16, 'images/demo/products/product_11.jpg', '', 'images/demo/products/product_11.jpg', '', '[\"images\\/demo\\/products\\/product_12.jpg\",\"images\\/demo\\/products\\/product_13.jpg\",\"images\\/demo\\/products\\/product_14.jpg\"]', '[\"\",\"\",\"\"]'),
(17, 17, 'images/demo/products/product_5.jpg', '', 'images/demo/products/product_5.jpg', '', '[\"images\\/demo\\/products\\/product_6.jpg\",\"images\\/demo\\/products\\/product_2.jpg\",\"images\\/demo\\/products\\/product_17.jpg\"]', '[\"\",\"\",\"\"]'),
(18, 18, 'images/demo/products/product_11.jpg', '', 'images/demo/products/product_11.jpg', '', '[\"images\\/demo\\/products\\/product_9.jpg\",\"images\\/demo\\/products\\/product_7.jpg\",\"images\\/demo\\/products\\/product_6.jpg\"]', '[\"\",\"\",\"\"]'),
(19, 19, 'images/demo/products/product_12.jpg', '', 'images/demo/products/product_12.jpg', '', '{\"0\":\"images\\/demo\\/products\\/product_13.jpg\",\"2\":\"images\\/demo\\/products\\/product_14.jpg\",\"3\":\"images\\/demo\\/products\\/product_15.jpg\"}', '{\"0\":\"\",\"2\":\"\",\"3\":\"\"}'),
(20, 20, 'images/demo/products/product_13.jpg', '', 'images/demo/products/product_13.jpg', '', '[\"images\\/demo\\/products\\/product_14.jpg\",\"images\\/demo\\/products\\/product_6.jpg\",\"images\\/demo\\/products\\/product_6.jpg\"]', '[\"\",\"\",\"\"]'),
(21, 21, 'images/demo/products/product_14.jpg', '', 'images/demo/products/product_14.jpg', '', '[\"images\\/demo\\/products\\/product_13.jpg\",\"images\\/demo\\/products\\/product_9.jpg\",\"images\\/demo\\/products\\/product_1.jpg\"]', '[\"\",\"\",\"\"]'),
(22, 22, 'images/demo/products/product_2.jpg', '', 'images/demo/products/product_2.jpg', '', '[\"images\\/demo\\/products\\/product_16.jpg\",\"images\\/demo\\/products\\/product_5.jpg\",\"images\\/demo\\/products\\/product_6.jpg\"]', '[\"\",\"\",\"\"]'),
(23, 23, 'images/demo/products/product_6.jpg', '', 'images/demo/products/product_6.jpg', '', '[\"images\\/demo\\/products\\/product_5.jpg\",\"images\\/demo\\/products\\/product_4.jpg\",\"images\\/demo\\/products\\/product_3.jpg\"]', '[\"\",\"\",\"\"]'),
(24, 24, 'images/demo/products/product_3.jpg', '', 'images/demo/products/product_3.jpg', '', '[\"images\\/demo\\/products\\/product_4.jpg\",\"images\\/demo\\/products\\/product_5.jpg\",\"images\\/demo\\/products\\/product_6.jpg\"]', '[\"\",\"\",\"\"]'),
(25, 25, 'images/demo/products/product_14.jpg', '', 'images/demo/products/product_14.jpg', '', '{\"0\":\"images\\/demo\\/products\\/product_15.jpg\",\"2\":\"images\\/demo\\/products\\/product_13.jpg\",\"3\":\"images\\/demo\\/products\\/product_17.jpg\"}', '{\"0\":\"\",\"2\":\"\",\"3\":\"\"}'),
(26, 26, 'images/demo/products/product_15.jpg', '', 'images/demo/products/product_15.jpg', '', '[\"images\\/demo\\/products\\/product_6.jpg\",\"images\\/demo\\/products\\/product_17.jpg\",\"images\\/demo\\/products\\/product_2.jpg\"]', '[\"\",\"\",\"\"]'),
(27, 27, 'images/demo/products/product_2.jpg', '', 'images/demo/products/product_2.jpg', '', '{\"0\":\"images\\/demo\\/products\\/product_17.jpg\",\"2\":\"images\\/demo\\/products\\/product_11.jpg\",\"3\":\"images\\/demo\\/products\\/product_11.jpg\"}', '{\"0\":\"\",\"2\":\"\",\"3\":\"\"}'),
(28, 28, 'images/demo/products/product_14.jpg', '', 'images/demo/products/product_14.jpg', '', '[\"images\\/demo\\/products\\/product_15.jpg\",\"images\\/demo\\/products\\/product_20.jpg\",\"images\\/demo\\/products\\/product_4.jpg\"]', '[\"\",\"\",\"\"]'),
(29, 29, 'images/demo/products/product_17.jpg', '', 'images/demo/products/product_17.jpg', '', '{\"0\":\"images\\/demo\\/products\\/product_18.jpg\",\"2\":\"images\\/demo\\/products\\/product_19.jpg\",\"3\":\"images\\/demo\\/products\\/product_20.jpg\"}', '{\"0\":\"\",\"2\":\"\",\"3\":\"\"}'),
(30, 30, 'images/demo/products/product_9.jpg', '', 'images/demo/products/product_9.jpg', '', '[\"images\\/demo\\/products\\/product_15.jpg\",\"images\\/demo\\/products\\/product_13.jpg\",\"images\\/demo\\/products\\/product_20.jpg\"]', '[\"\",\"\",\"\"]'),
(31, 31, 'images/demo/products/product_17.jpg', '', 'images/demo/products/product_17.jpg', '', '[\"images\\/demo\\/products\\/product_11.jpg\",\"images\\/demo\\/products\\/product_19.jpg\",\"images\\/demo\\/products\\/product_2.jpg\"]', '[\"\",\"\",\"\"]'),
(32, 32, 'images/demo/products/product_12.jpg', '', 'images/demo/products/product_12.jpg', '', '[\"images\\/demo\\/products\\/product_17.jpg\",\"images\\/demo\\/products\\/product_15.jpg\",\"images\\/demo\\/products\\/product_4.jpg\"]', '[\"\",\"\",\"\"]'),
(33, 33, 'images/demo/products/product_17.jpg', '', 'images/demo/products/product_17.jpg', '', '[\"images\\/demo\\/products\\/product_18.jpg\",\"images\\/demo\\/products\\/product_19.jpg\",\"images\\/demo\\/products\\/product_2.jpg\"]', '[\"\",\"\",\"\"]'),
(34, 34, 'images/demo/products/product_8.jpg', '', 'images/demo/products/product_8.jpg', '', '{\"0\":\"images\\/demo\\/products\\/product_1.jpg\",\"2\":\"images\\/demo\\/products\\/product_11.jpg\",\"4\":\"images\\/Artboard_Copy_3.jpg\"}', '{\"0\":\"\",\"2\":\"\",\"4\":\"\"}');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_productprice_index`
--

DROP TABLE IF EXISTS `#__j2store_productprice_index`;
CREATE TABLE `#__j2store_productprice_index` (
  `product_id` int(11) NOT NULL,
  `min_price` decimal(12,4) NOT NULL,
  `max_price` decimal(12,4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_productquantities`
--

DROP TABLE IF EXISTS `#__j2store_productquantities`;
CREATE TABLE `#__j2store_productquantities` (
  `j2store_productquantity_id` int(11) NOT NULL,
  `product_attributes` text NOT NULL COMMENT 'A CSV of productattributeoption_id values, always in numerical order',
  `variant_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `on_hold` int(11) NOT NULL,
  `sold` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_productquantities`
--

INSERT INTO `#__j2store_productquantities` (`j2store_productquantity_id`, `product_attributes`, `variant_id`, `quantity`, `on_hold`, `sold`) VALUES
(2, '', 3, 0, 0, 0),
(3, '', 4, 0, 0, 0),
(4, '', 5, 0, 0, 0),
(5, '', 6, 0, 0, 0),
(6, '', 7, 0, 0, 0),
(7, '', 8, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_products`
--

DROP TABLE IF EXISTS `#__j2store_products`;
CREATE TABLE `#__j2store_products` (
  `j2store_product_id` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `product_source` varchar(255) DEFAULT NULL,
  `product_source_id` int(11) DEFAULT NULL,
  `product_type` varchar(255) DEFAULT NULL,
  `main_tag` varchar(255) NOT NULL,
  `taxprofile_id` int(11) DEFAULT NULL,
  `manufacturer_id` int(11) DEFAULT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `has_options` int(11) DEFAULT NULL,
  `addtocart_text` varchar(255) NOT NULL,
  `enabled` int(11) DEFAULT NULL,
  `plugins` text,
  `params` text,
  `created_on` varchar(255) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_on` varchar(45) DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `up_sells` varchar(255) NOT NULL,
  `cross_sells` varchar(255) NOT NULL,
  `productfilter_ids` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_products`
--

INSERT INTO `#__j2store_products` (`j2store_product_id`, `visibility`, `product_source`, `product_source_id`, `product_type`, `main_tag`, `taxprofile_id`, `manufacturer_id`, `vendor_id`, `has_options`, `addtocart_text`, `enabled`, `plugins`, `params`, `created_on`, `created_by`, `modified_on`, `modified_by`, `up_sells`, `cross_sells`, `productfilter_ids`) VALUES
(1, 1, 'com_content', 26, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-17 10:07:40', 58, '2019-07-05 14:32:53', 58, '', '', ''),
(10, 1, 'com_content', 35, 'simple', '', 0, 3, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:26:02', 58, '2019-07-05 14:30:31', 58, '', '', ''),
(11, 1, 'com_content', 36, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:27:39', 58, '2019-06-26 11:33:07', 58, '', '', ''),
(12, 1, 'com_content', 37, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:30:55', 58, '2019-07-05 14:28:10', 58, '', '', ''),
(13, 1, 'com_content', 38, 'simple', '', 0, 3, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:37:05', 58, '2019-07-05 14:25:19', 58, '', '', ''),
(14, 1, 'com_content', 39, 'simple', '', 0, 2, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:39:16', 58, '2019-07-05 14:23:08', 58, '', '', ''),
(15, 1, 'com_content', 41, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:40:58', 58, '2019-07-05 14:20:23', 58, '', '', ''),
(16, 1, 'com_content', 42, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:41:19', 58, '2019-06-26 11:43:51', 58, '', '', ''),
(17, 1, 'com_content', 43, 'simple', '', 0, 3, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:42:43', 58, '2019-07-05 14:15:31', 58, '', '', ''),
(18, 1, 'com_content', 44, 'simple', '', 0, 2, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:43:51', 58, '2019-07-05 14:12:54', 58, '', '', ''),
(19, 1, 'com_content', 45, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:45:11', 58, '2019-06-26 11:46:51', 58, '', '', ''),
(20, 1, 'com_content', 46, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:45:28', 58, '2019-07-05 14:09:39', 58, '', '', ''),
(21, 1, 'com_content', 47, 'simple', '', 0, 3, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:45:37', 58, '2019-07-05 14:06:36', 58, '', '', ''),
(22, 1, 'com_content', 48, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:46:17', 58, '2019-06-26 11:47:52', 58, '', '', ''),
(23, 1, 'com_content', 49, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:47:46', 58, '2019-06-26 11:49:18', 58, '', '', ''),
(24, 1, 'com_content', 51, 'simple', '', 0, 3, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:48:28', 58, '2019-07-05 13:58:52', 58, '', '', ''),
(25, 1, 'com_content', 50, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:48:44', 58, '2019-07-05 14:01:46', 58, '', '', ''),
(26, 1, 'com_content', 52, 'simple', '', 0, 2, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:50:43', 58, '2019-07-05 13:55:03', 58, '', '', ''),
(27, 1, 'com_content', 53, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:51:15', 58, '2019-07-05 13:52:20', 58, '', '', ''),
(28, 1, 'com_content', 54, 'simple', '', 0, 3, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:52:12', 58, '2019-07-05 13:49:42', 58, '', '', ''),
(29, 1, 'com_content', 56, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:53:49', 58, '2019-06-26 11:55:22', 58, '', '', ''),
(30, 1, 'com_content', 57, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:53:49', 58, '2019-07-05 13:38:41', 58, '', '', ''),
(31, 1, 'com_content', 55, 'simple', '', 0, 2, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:54:40', 58, '2019-07-05 13:45:23', 58, '', '', ''),
(32, 1, 'com_content', 58, 'simple', '', 0, 0, NULL, NULL, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 11:55:06', 58, '2019-07-01 12:29:59', 58, '', '', ''),
(33, 1, 'com_content', 59, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 12:07:06', 58, '2019-07-05 15:21:46', 58, '', '', ''),
(34, 1, 'com_content', 60, 'simple', '', 0, 1, NULL, 1, '', 1, NULL, '{\"product_css_class\":\"\"}', '2019-06-26 12:36:00', 58, '2019-07-05 11:55:42', 58, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_product_filters`
--

DROP TABLE IF EXISTS `#__j2store_product_filters`;
CREATE TABLE `#__j2store_product_filters` (
  `product_id` int(11) NOT NULL,
  `filter_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__j2store_product_filters`
--

INSERT INTO `#__j2store_product_filters` (`product_id`, `filter_id`) VALUES
(30, 1),
(30, 3),
(34, 1),
(34, 2),
(34, 3),
(34, 4),
(34, 5),
(34, 6),
(34, 7),
(34, 8);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_product_options`
--

DROP TABLE IF EXISTS `#__j2store_product_options`;
CREATE TABLE `#__j2store_product_options` (
  `j2store_productoption_id` int(11) NOT NULL,
  `option_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `ordering` tinyint(7) NOT NULL,
  `required` int(11) NOT NULL,
  `is_variant` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_product_options`
--

INSERT INTO `#__j2store_product_options` (`j2store_productoption_id`, `option_id`, `parent_id`, `product_id`, `ordering`, `required`, `is_variant`) VALUES
(1, 1, 0, 34, 0, 0, 0),
(2, 2, 0, 34, 0, 0, 0),
(3, 1, 0, 33, 0, 0, 0),
(4, 2, 0, 33, 0, 0, 0),
(5, 1, 0, 30, 0, 0, 0),
(6, 2, 0, 30, 0, 0, 0),
(9, 1, 0, 31, 0, 0, 0),
(10, 2, 0, 31, 0, 0, 0),
(11, 1, 0, 28, 0, 0, 0),
(12, 2, 0, 28, 0, 0, 0),
(13, 1, 0, 27, 0, 0, 0),
(14, 2, 0, 26, 0, 0, 0),
(15, 1, 0, 24, 0, 0, 0),
(16, 2, 0, 24, 0, 0, 0),
(17, 1, 0, 25, 0, 0, 0),
(18, 2, 0, 25, 0, 0, 0),
(19, 1, 0, 21, 0, 0, 0),
(20, 2, 0, 21, 0, 0, 0),
(21, 1, 0, 20, 0, 0, 0),
(22, 2, 0, 20, 0, 0, 0),
(23, 1, 0, 18, 0, 0, 0),
(24, 2, 0, 18, 0, 0, 0),
(25, 1, 0, 17, 0, 0, 0),
(26, 2, 0, 17, 0, 0, 0),
(28, 2, 0, 15, 0, 0, 0),
(29, 1, 0, 15, 0, 0, 0),
(30, 1, 0, 14, 0, 0, 0),
(31, 2, 0, 14, 0, 0, 0),
(32, 1, 0, 13, 0, 0, 0),
(33, 2, 0, 13, 0, 0, 0),
(34, 1, 0, 12, 0, 0, 0),
(35, 2, 0, 12, 0, 0, 0),
(36, 1, 0, 10, 0, 0, 0),
(37, 2, 0, 10, 0, 0, 0),
(38, 1, 0, 1, 0, 0, 0),
(39, 2, 0, 1, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_product_optionvalues`
--

DROP TABLE IF EXISTS `#__j2store_product_optionvalues`;
CREATE TABLE `#__j2store_product_optionvalues` (
  `j2store_product_optionvalue_id` int(11) NOT NULL,
  `productoption_id` int(11) NOT NULL,
  `optionvalue_id` int(11) NOT NULL,
  `parent_optionvalue` text NOT NULL,
  `product_optionvalue_price` decimal(15,8) NOT NULL,
  `product_optionvalue_prefix` varchar(255) NOT NULL,
  `product_optionvalue_weight` decimal(15,8) NOT NULL,
  `product_optionvalue_weight_prefix` varchar(255) NOT NULL,
  `product_optionvalue_sku` varchar(255) NOT NULL,
  `product_optionvalue_default` int(11) NOT NULL,
  `ordering` tinyint(7) NOT NULL DEFAULT '0',
  `product_optionvalue_attribs` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_product_optionvalues`
--

INSERT INTO `#__j2store_product_optionvalues` (`j2store_product_optionvalue_id`, `productoption_id`, `optionvalue_id`, `parent_optionvalue`, `product_optionvalue_price`, `product_optionvalue_prefix`, `product_optionvalue_weight`, `product_optionvalue_weight_prefix`, `product_optionvalue_sku`, `product_optionvalue_default`, `ordering`, `product_optionvalue_attribs`) VALUES
(3, 1, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(4, 1, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(5, 1, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(6, 1, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(7, 2, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(8, 2, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(9, 2, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(10, 2, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(11, 3, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(12, 3, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(13, 3, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(14, 3, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(15, 4, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(16, 4, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(17, 4, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(18, 4, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(19, 5, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(20, 5, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(21, 5, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(22, 5, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(23, 6, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(24, 6, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(25, 6, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(26, 6, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(27, 9, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(28, 9, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(29, 9, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(30, 9, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(31, 10, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(32, 10, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(33, 10, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(34, 10, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(35, 11, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(36, 11, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(37, 11, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(38, 11, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(39, 12, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(40, 12, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(41, 12, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(42, 12, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(43, 13, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(44, 13, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(45, 13, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(46, 13, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(47, 14, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(48, 14, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(49, 14, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(50, 14, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(51, 15, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(52, 15, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(53, 15, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(54, 15, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(55, 16, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(56, 16, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(57, 16, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(58, 16, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(59, 17, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(60, 17, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(61, 17, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(62, 17, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(63, 18, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(64, 18, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(65, 18, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(66, 18, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(67, 19, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(68, 19, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(69, 19, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(70, 19, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(71, 20, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(72, 20, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(73, 20, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(74, 20, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(75, 21, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(76, 21, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(77, 21, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(78, 21, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(79, 22, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(80, 22, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(81, 22, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(82, 22, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(83, 23, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(84, 23, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(85, 23, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(86, 23, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(87, 24, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(88, 24, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(89, 24, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(90, 24, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(91, 25, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(92, 25, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(93, 25, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(94, 25, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(95, 26, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(96, 26, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(97, 26, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(98, 26, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(107, 28, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(108, 28, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(109, 28, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(110, 28, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(111, 29, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(112, 29, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(113, 29, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(114, 29, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(115, 30, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(116, 30, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(117, 30, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(118, 30, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(119, 31, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(120, 31, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(121, 31, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(122, 31, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(123, 32, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(124, 32, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(125, 32, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(126, 32, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(127, 33, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(128, 33, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(129, 33, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(130, 33, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(131, 34, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(132, 34, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(133, 34, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(134, 34, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(135, 35, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(136, 35, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(137, 35, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(138, 35, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(139, 36, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(140, 36, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(141, 36, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(142, 36, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(143, 37, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(144, 37, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(145, 37, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(146, 37, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(147, 38, 1, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(148, 38, 2, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(149, 38, 3, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(150, 38, 4, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(151, 39, 5, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(152, 39, 6, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(153, 39, 7, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}'),
(154, 39, 8, '', '0.00000000', '+', '0.00000000', '+', '', 0, 0, '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_product_prices`
--

DROP TABLE IF EXISTS `#__j2store_product_prices`;
CREATE TABLE `#__j2store_product_prices` (
  `j2store_productprice_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `quantity_from` decimal(15,5) DEFAULT NULL,
  `quantity_to` decimal(15,5) DEFAULT NULL,
  `date_from` datetime DEFAULT NULL,
  `date_to` datetime DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `price` decimal(15,5) DEFAULT NULL,
  `params` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_product_variant_optionvalues`
--

DROP TABLE IF EXISTS `#__j2store_product_variant_optionvalues`;
CREATE TABLE `#__j2store_product_variant_optionvalues` (
  `variant_id` int(11) NOT NULL,
  `product_optionvalue_ids` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_queues`
--

DROP TABLE IF EXISTS `#__j2store_queues`;
CREATE TABLE `#__j2store_queues` (
  `j2store_queue_id` int(11) NOT NULL,
  `relation_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int(11) NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repeat_count` int(11) NOT NULL DEFAULT '0',
  `expired` datetime NOT NULL,
  `created_on` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_on` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_retainfulcoupons`
--

DROP TABLE IF EXISTS `#__j2store_retainfulcoupons`;
CREATE TABLE `#__j2store_retainfulcoupons` (
  `j2store_retainfulcoupon_id` int(11) NOT NULL,
  `coupon` varchar(255) NOT NULL,
  `is_used` enum('0','1') NOT NULL DEFAULT '0',
  `order_id` varchar(255) NOT NULL,
  `created_to` varchar(500) NOT NULL,
  `created_on` datetime DEFAULT NULL,
  `coupon_amount` varchar(255) NOT NULL,
  `coupon_type` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_shippingmethods`
--

DROP TABLE IF EXISTS `#__j2store_shippingmethods`;
CREATE TABLE `#__j2store_shippingmethods` (
  `j2store_shippingmethod_id` int(11) NOT NULL,
  `shipping_method_name` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `shipping_method_type` tinyint(1) NOT NULL,
  `params` longtext NOT NULL,
  `tax_class_id` int(11) NOT NULL,
  `address_override` varchar(255) NOT NULL,
  `subtotal_minimum` decimal(15,3) NOT NULL,
  `subtotal_maximum` decimal(15,3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_shippingrates`
--

DROP TABLE IF EXISTS `#__j2store_shippingrates`;
CREATE TABLE `#__j2store_shippingrates` (
  `j2store_shippingrate_id` int(11) NOT NULL,
  `shipping_method_id` int(11) NOT NULL,
  `geozone_id` int(11) NOT NULL,
  `shipping_rate_price` decimal(12,5) NOT NULL,
  `shipping_rate_weight_start` decimal(11,3) NOT NULL,
  `shipping_rate_weight_end` decimal(11,3) NOT NULL,
  `shipping_rate_handling` decimal(12,5) NOT NULL,
  `created_date` datetime NOT NULL COMMENT 'GMT Only',
  `modified_date` datetime NOT NULL COMMENT 'GMT Only'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_taxprofiles`
--

DROP TABLE IF EXISTS `#__j2store_taxprofiles`;
CREATE TABLE `#__j2store_taxprofiles` (
  `j2store_taxprofile_id` int(11) NOT NULL,
  `taxprofile_name` varchar(255) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_taxrates`
--

DROP TABLE IF EXISTS `#__j2store_taxrates`;
CREATE TABLE `#__j2store_taxrates` (
  `j2store_taxrate_id` int(11) NOT NULL,
  `geozone_id` int(11) NOT NULL,
  `taxrate_name` varchar(255) NOT NULL,
  `tax_percent` decimal(11,3) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_taxrules`
--

DROP TABLE IF EXISTS `#__j2store_taxrules`;
CREATE TABLE `#__j2store_taxrules` (
  `j2store_taxrule_id` int(11) NOT NULL,
  `taxprofile_id` int(11) NOT NULL,
  `taxrate_id` int(11) NOT NULL,
  `address` varchar(255) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_uploads`
--

DROP TABLE IF EXISTS `#__j2store_uploads`;
CREATE TABLE `#__j2store_uploads` (
  `j2store_upload_id` int(11) NOT NULL,
  `original_name` varchar(255) NOT NULL,
  `mangled_name` varchar(255) NOT NULL,
  `saved_name` varchar(255) NOT NULL,
  `mime_type` varchar(255) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_on` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_variants`
--

DROP TABLE IF EXISTS `#__j2store_variants`;
CREATE TABLE `#__j2store_variants` (
  `j2store_variant_id` int(11) NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `is_master` int(11) DEFAULT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upc` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(15,5) DEFAULT NULL COMMENT 'Regular price of the product',
  `pricing_calculator` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping` int(11) NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  `length` decimal(15,5) DEFAULT NULL,
  `width` decimal(15,5) DEFAULT NULL,
  `height` decimal(15,5) DEFAULT NULL,
  `length_class_id` int(11) DEFAULT NULL,
  `weight` decimal(15,5) DEFAULT NULL,
  `weight_class_id` int(11) DEFAULT NULL,
  `created_on` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `modified_on` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modified_by` int(11) DEFAULT NULL,
  `manage_stock` int(11) DEFAULT NULL,
  `quantity_restriction` int(11) NOT NULL,
  `min_out_qty` decimal(15,5) DEFAULT NULL,
  `use_store_config_min_out_qty` int(11) DEFAULT NULL,
  `min_sale_qty` decimal(15,5) DEFAULT NULL,
  `use_store_config_min_sale_qty` int(11) DEFAULT NULL,
  `max_sale_qty` decimal(15,5) DEFAULT NULL,
  `use_store_config_max_sale_qty` int(11) DEFAULT NULL,
  `notify_qty` decimal(15,5) DEFAULT NULL,
  `use_store_config_notify_qty` int(11) DEFAULT NULL,
  `availability` int(11) DEFAULT NULL,
  `sold` decimal(12,4) DEFAULT NULL,
  `allow_backorder` int(11) NOT NULL,
  `isdefault_variant` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__j2store_variants`
--

INSERT INTO `#__j2store_variants` (`j2store_variant_id`, `product_id`, `is_master`, `sku`, `upc`, `price`, `pricing_calculator`, `shipping`, `params`, `length`, `width`, `height`, `length_class_id`, `weight`, `weight_class_id`, `created_on`, `created_by`, `modified_on`, `modified_by`, `manage_stock`, `quantity_restriction`, `min_out_qty`, `use_store_config_min_out_qty`, `min_sale_qty`, `use_store_config_min_sale_qty`, `max_sale_qty`, `use_store_config_max_sale_qty`, `notify_qty`, `use_store_config_notify_qty`, `availability`, `sold`, `allow_backorder`, `isdefault_variant`) VALUES
(1, 1, 1, 'AS124', '', '200.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '125.00000', '124.00000', '126.00000', 1, '100.00000', 2, '2019-07-05 14:32:53', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(10, 10, 1, 'AS125', '', '450.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '145.00000', '178.00000', '125.00000', 1, '120.00000', 2, '2019-07-05 14:30:31', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(11, 11, 1, 'Rapoo_VM210_Neckband_Waterproof_and_Sweatproof_Wireless', '', '150.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-06-26 11:33:07', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(12, 12, 1, 'AS205', '', '600.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '104.00000', '105.00000', '106.00000', 1, '200.00000', 2, '2019-07-05 14:28:10', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(13, 13, 1, 'AS101', '', '200.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '102.00000', '103.00000', '104.00000', 1, '123.00000', 2, '2019-07-05 14:25:19', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(14, 14, 1, 'AS147', '', '100.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '110.00000', '111.00000', '112.00000', 1, '100.00000', 2, '2019-07-05 14:23:08', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(15, 15, 1, 'AS124', '', '340.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '120.00000', '130.00000', '140.00000', 1, '60.00000', 2, '2019-07-05 14:20:23', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(16, 16, 1, 'SNAPTAIN_A15_Foldable_FPV_WiFi_Drone_w_Voice_', '', '200.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-06-26 11:43:51', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(17, 17, 1, 'AS124', '', '200.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '120.00000', '140.00000', '150.00000', 1, '30.00000', 2, '2019-07-05 14:15:31', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(18, 18, 1, 'AS756', '', '800.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '10.00000', '11.00000', '12.00000', 1, '50.00000', 2, '2019-07-05 14:12:54', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(19, 19, 1, 'DJI_Osmo_Action_4K_Camera_with_Deluxe', '', '300.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-06-26 11:46:51', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(20, 20, 1, 'AS345', '', '150.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '23.00000', '24.00000', '25.00000', 1, '100.00000', 2, '2019-07-05 14:09:39', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(21, 21, 1, 'AS789', '', '300.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '10.00000', '11.00000', '12.00000', 1, '120.00000', 2, '2019-07-05 14:06:36', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(22, 22, 1, 'Apple_iMac_ME088LL_A_27-Inch__1TB_Hard_', '', '2323.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-06-26 11:47:52', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(23, 23, 1, 'OtterBox_Defender_Series_Case_for_Pixel_3a', '', '50.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-06-26 11:49:18', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(24, 24, 1, 'AS104', '', '400.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '12.00000', '13.00000', '14.00000', 1, '50.00000', 2, '2019-07-05 13:58:52', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(25, 25, 1, 'AS457', '', '400.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '17.00000', '18.00000', '19.00000', 1, '125.00000', 2, '2019-07-05 14:01:46', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(26, 26, 1, 'AS135', '', '600.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '14.00000', '15.00000', '16.00000', 1, '100.00000', 2, '2019-07-05 13:55:03', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(27, 27, 1, 'AS126', '', '600.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '15.00000', '16.00000', '17.00000', 1, '125.00000', 2, '2019-07-05 13:52:20', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(28, 28, 1, 'AS125', '', '300.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '10.00000', '20.00000', '30.00000', 1, '200.00000', 2, '2019-07-05 13:49:42', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(29, 29, 1, '2_Black_Replacement_latches_for_Pelican_Cases__2_Black_Replacement_latches_for_Pelican_Cases_', '', '600.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-06-26 11:55:22', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(30, 30, 1, 'AS123', '', '500.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '20.00000', '25.00000', '30.00000', 2, '100.00000', 2, '2019-07-05 13:38:41', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(31, 31, 1, 'AS124', '', '400.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '5.00000', '10.00000', '15.00000', 1, '110.00000', 2, '2019-07-05 13:45:23', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(32, 32, 1, 'Learn_about_Nest_Aware_subscriptions_before_you_buy', '', '1000.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-07-01 12:29:59', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(33, 33, 1, 'AS125', '', '500.00000', 'standard', 0, '{\"product_css_class\":\"\"}', '0.00000', '0.00000', '0.00000', 0, '0.00000', 0, '2019-07-05 15:21:46', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0),
(34, 34, 1, 'honor_10_32_3', '', '500.00000', 'standard', 1, '{\"product_css_class\":\"\"}', '18.00000', '18.00000', '12.00000', 2, '220.00000', 2, '2019-07-05 11:55:42', 58, NULL, NULL, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0, NULL, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_vendors`
--

DROP TABLE IF EXISTS `#__j2store_vendors`;
CREATE TABLE `#__j2store_vendors` (
  `j2store_vendor_id` int(11) NOT NULL,
  `j2store_user_id` int(11) NOT NULL,
  `address_id` int(11) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_vouchers`
--

DROP TABLE IF EXISTS `#__j2store_vouchers`;
CREATE TABLE `#__j2store_vouchers` (
  `j2store_voucher_id` int(11) NOT NULL,
  `order_id` varchar(255) NOT NULL,
  `email_to` varchar(255) NOT NULL,
  `voucher_code` varchar(255) NOT NULL,
  `voucher_type` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `email_body` longtext NOT NULL,
  `valid_from` datetime DEFAULT NULL,
  `valid_to` datetime DEFAULT NULL,
  `voucher_value` decimal(15,8) NOT NULL,
  `ordering` int(11) NOT NULL,
  `enabled` int(11) NOT NULL,
  `created_on` datetime NOT NULL,
  `created_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_weights`
--

DROP TABLE IF EXISTS `#__j2store_weights`;
CREATE TABLE `#__j2store_weights` (
  `j2store_weight_id` int(11) NOT NULL,
  `weight_title` varchar(255) NOT NULL,
  `weight_unit` varchar(4) NOT NULL,
  `weight_value` decimal(15,8) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_weights`
--

INSERT INTO `#__j2store_weights` (`j2store_weight_id`, `weight_title`, `weight_unit`, `weight_value`, `enabled`, `ordering`) VALUES
(1, 'Kilogram', 'kg', '1.00000000', 1, 0),
(2, 'Gram', 'g', '1000.00000000', 1, 0),
(3, 'Ounce', 'oz', '35.27400000', 1, 0),
(4, 'Pound', 'lb', '2.20462000', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__j2store_zones`
--

DROP TABLE IF EXISTS `#__j2store_zones`;
CREATE TABLE `#__j2store_zones` (
  `j2store_zone_id` int(11) NOT NULL,
  `country_id` int(11) NOT NULL,
  `zone_code` varchar(255) NOT NULL,
  `zone_name` varchar(255) NOT NULL,
  `enabled` int(11) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__j2store_zones`
--

INSERT INTO `#__j2store_zones` (`j2store_zone_id`, `country_id`, `zone_code`, `zone_name`, `enabled`, `ordering`) VALUES
(1, 1, 'BDS', 'Badakhshan', 1, 0),
(2, 1, 'BDG', 'Badghis', 1, 0),
(3, 1, 'BGL', 'Baghlan', 1, 0),
(4, 1, 'BAL', 'Balkh', 1, 0),
(5, 1, 'BAM', 'Bamian', 1, 0),
(6, 1, 'FRA', 'Farah', 1, 0),
(7, 1, 'FYB', 'Faryab', 1, 0),
(8, 1, 'GHA', 'Ghazni', 1, 0),
(9, 1, 'GHO', 'Ghowr', 1, 0),
(10, 1, 'HEL', 'Helmand', 1, 0),
(11, 1, 'HER', 'Herat', 1, 0),
(12, 1, 'JOW', 'Jowzjan', 1, 0),
(13, 1, 'KAB', 'Kabul', 1, 0),
(14, 1, 'KAN', 'Kandahar', 1, 0),
(15, 1, 'KAP', 'Kapisa', 1, 0),
(16, 1, 'KHO', 'Khost', 1, 0),
(17, 1, 'KNR', 'Konar', 1, 0),
(18, 1, 'KDZ', 'Kondoz', 1, 0),
(19, 1, 'LAG', 'Laghman', 1, 0),
(20, 1, 'LOW', 'Lowgar', 1, 0),
(21, 1, 'NAN', 'Nangrahar', 1, 0),
(22, 1, 'NIM', 'Nimruz', 1, 0),
(23, 1, 'NUR', 'Nurestan', 1, 0),
(24, 1, 'ORU', 'Oruzgan', 1, 0),
(25, 1, 'PIA', 'Paktia', 1, 0),
(26, 1, 'PKA', 'Paktika', 1, 0),
(27, 1, 'PAR', 'Parwan', 1, 0),
(28, 1, 'SAM', 'Samangan', 1, 0),
(29, 1, 'SAR', 'Sar-e Pol', 1, 0),
(30, 1, 'TAK', 'Takhar', 1, 0),
(31, 1, 'WAR', 'Wardak', 1, 0),
(32, 1, 'ZAB', 'Zabol', 1, 0),
(33, 2, 'BR', 'Berat', 1, 0),
(34, 2, 'BU', 'Bulqize', 1, 0),
(35, 2, 'DL', 'Delvine', 1, 0),
(36, 2, 'DV', 'Devoll', 1, 0),
(37, 2, 'DI', 'Diber', 1, 0),
(38, 2, 'DR', 'Durres', 1, 0),
(39, 2, 'EL', 'Elbasan', 1, 0),
(40, 2, 'ER', 'Kolonje', 1, 0),
(41, 2, 'FR', 'Fier', 1, 0),
(42, 2, 'GJ', 'Gjirokaster', 1, 0),
(43, 2, 'GR', 'Gramsh', 1, 0),
(44, 2, 'HA', 'Has', 1, 0),
(45, 2, 'KA', 'Kavaje', 1, 0),
(46, 2, 'KB', 'Kurbin', 1, 0),
(47, 2, 'KC', 'Kucove', 1, 0),
(48, 2, 'KO', 'Korce', 1, 0),
(49, 2, 'KR', 'Kruje', 1, 0),
(50, 2, 'KU', 'Kukes', 1, 0),
(51, 2, 'LB', 'Librazhd', 1, 0),
(52, 2, 'LE', 'Lezhe', 1, 0),
(53, 2, 'LU', 'Lushnje', 1, 0),
(54, 2, 'MM', 'Malesi e Madhe', 1, 0),
(55, 2, 'MK', 'Mallakaster', 1, 0),
(56, 2, 'MT', 'Mat', 1, 0),
(57, 2, 'MR', 'Mirdite', 1, 0),
(58, 2, 'PQ', 'Peqin', 1, 0),
(59, 2, 'PR', 'Permet', 1, 0),
(60, 2, 'PG', 'Pogradec', 1, 0),
(61, 2, 'PU', 'Puke', 1, 0),
(62, 2, 'SH', 'Shkoder', 1, 0),
(63, 2, 'SK', 'Skrapar', 1, 0),
(64, 2, 'SR', 'Sarande', 1, 0),
(65, 2, 'TE', 'Tepelene', 1, 0),
(66, 2, 'TP', 'Tropoje', 1, 0),
(67, 2, 'TR', 'Tirane', 1, 0),
(68, 2, 'VL', 'Vlore', 1, 0),
(69, 3, 'ADR', 'Adrar', 1, 0),
(70, 3, 'ADE', 'Ain Defla', 1, 0),
(71, 3, 'ATE', 'Ain Temouchent', 1, 0),
(72, 3, 'ALG', 'Alger', 1, 0),
(73, 3, 'ANN', 'Annaba', 1, 0),
(74, 3, 'BAT', 'Batna', 1, 0),
(75, 3, 'BEC', 'Bechar', 1, 0),
(76, 3, 'BEJ', 'Bejaia', 1, 0),
(77, 3, 'BIS', 'Biskra', 1, 0),
(78, 3, 'BLI', 'Blida', 1, 0),
(79, 3, 'BBA', 'Bordj Bou Arreridj', 1, 0),
(80, 3, 'BOA', 'Bouira', 1, 0),
(81, 3, 'BMD', 'Boumerdes', 1, 0),
(82, 3, 'CHL', 'Chlef', 1, 0),
(83, 3, 'CON', 'Constantine', 1, 0),
(84, 3, 'DJE', 'Djelfa', 1, 0),
(85, 3, 'EBA', 'El Bayadh', 1, 0),
(86, 3, 'EOU', 'El Oued', 1, 0),
(87, 3, 'ETA', 'El Tarf', 1, 0),
(88, 3, 'GHA', 'Ghardaia', 1, 0),
(89, 3, 'GUE', 'Guelma', 1, 0),
(90, 3, 'ILL', 'Illizi', 1, 0),
(91, 3, 'JIJ', 'Jijel', 1, 0),
(92, 3, 'KHE', 'Khenchela', 1, 0),
(93, 3, 'LAG', 'Laghouat', 1, 0),
(94, 3, 'MUA', 'Muaskar', 1, 0),
(95, 3, 'MED', 'Medea', 1, 0),
(96, 3, 'MIL', 'Mila', 1, 0),
(97, 3, 'MOS', 'Mostaganem', 1, 0),
(98, 3, 'MSI', 'M\'Sila', 1, 0),
(99, 3, 'NAA', 'Naama', 1, 0),
(100, 3, 'ORA', 'Oran', 1, 0),
(101, 3, 'OUA', 'Ouargla', 1, 0),
(102, 3, 'OEB', 'Oum el-Bouaghi', 1, 0),
(103, 3, 'REL', 'Relizane', 1, 0),
(104, 3, 'SAI', 'Saida', 1, 0),
(105, 3, 'SET', 'Setif', 1, 0),
(106, 3, 'SBA', 'Sidi Bel Abbes', 1, 0),
(107, 3, 'SKI', 'Skikda', 1, 0),
(108, 3, 'SAH', 'Souk Ahras', 1, 0),
(109, 3, 'TAM', 'Tamanghasset', 1, 0),
(110, 3, 'TEB', 'Tebessa', 1, 0),
(111, 3, 'TIA', 'Tiaret', 1, 0),
(112, 3, 'TIN', 'Tindouf', 1, 0),
(113, 3, 'TIP', 'Tipaza', 1, 0),
(114, 3, 'TIS', 'Tissemsilt', 1, 0),
(115, 3, 'TOU', 'Tizi Ouzou', 1, 0),
(116, 3, 'TLE', 'Tlemcen', 1, 0),
(117, 4, 'E', 'Eastern', 1, 0),
(118, 4, 'M', 'Manu\'a', 1, 0),
(119, 4, 'R', 'Rose Island', 1, 0),
(120, 4, 'S', 'Swains Island', 1, 0),
(121, 4, 'W', 'Western', 1, 0),
(122, 5, 'ALV', 'Andorra la Vella', 1, 0),
(123, 5, 'CAN', 'Canillo', 1, 0),
(124, 5, 'ENC', 'Encamp', 1, 0),
(125, 5, 'ESE', 'Escaldes-Engordany', 1, 0),
(126, 5, 'LMA', 'La Massana', 1, 0),
(127, 5, 'ORD', 'Ordino', 1, 0),
(128, 5, 'SJL', 'Sant Julia de Loria', 1, 0),
(129, 6, 'BGO', 'Bengo', 1, 0),
(130, 6, 'BGU', 'Benguela', 1, 0),
(131, 6, 'BIE', 'Bie', 1, 0),
(132, 6, 'CAB', 'Cabinda', 1, 0),
(133, 6, 'CCU', 'Cuando-Cubango', 1, 0),
(134, 6, 'CNO', 'Cuanza Norte', 1, 0),
(135, 6, 'CUS', 'Cuanza Sul', 1, 0),
(136, 6, 'CNN', 'Cunene', 1, 0),
(137, 6, 'HUA', 'Huambo', 1, 0),
(138, 6, 'HUI', 'Huila', 1, 0),
(139, 6, 'LUA', 'Luanda', 1, 0),
(140, 6, 'LNO', 'Lunda Norte', 1, 0),
(141, 6, 'LSU', 'Lunda Sul', 1, 0),
(142, 6, 'MAL', 'Malange', 1, 0),
(143, 6, 'MOX', 'Moxico', 1, 0),
(144, 6, 'NAM', 'Namibe', 1, 0),
(145, 6, 'UIG', 'Uige', 1, 0),
(146, 6, 'ZAI', 'Zaire', 1, 0),
(147, 9, 'ASG', 'Saint George', 1, 0),
(148, 9, 'ASJ', 'Saint John', 1, 0),
(149, 9, 'ASM', 'Saint Mary', 1, 0),
(150, 9, 'ASL', 'Saint Paul', 1, 0),
(151, 9, 'ASR', 'Saint Peter', 1, 0),
(152, 9, 'ASH', 'Saint Philip', 1, 0),
(153, 9, 'BAR', 'Barbuda', 1, 0),
(154, 9, 'RED', 'Redonda', 1, 0),
(155, 10, 'AN', 'Antartida e Islas del Atlantico', 1, 0),
(156, 10, 'BA', 'Buenos Aires', 1, 0),
(157, 10, 'CA', 'Catamarca', 1, 0),
(158, 10, 'CH', 'Chaco', 1, 0),
(159, 10, 'CU', 'Chubut', 1, 0),
(160, 10, 'CO', 'Cordoba', 1, 0),
(161, 10, 'CR', 'Corrientes', 1, 0),
(162, 10, 'DF', 'Distrito Federal', 1, 0),
(163, 10, 'ER', 'Entre Rios', 1, 0),
(164, 10, 'FO', 'Formosa', 1, 0),
(165, 10, 'JU', 'Jujuy', 1, 0),
(166, 10, 'LP', 'La Pampa', 1, 0),
(167, 10, 'LR', 'La Rioja', 1, 0),
(168, 10, 'ME', 'Mendoza', 1, 0),
(169, 10, 'MI', 'Misiones', 1, 0),
(170, 10, 'NE', 'Neuquen', 1, 0),
(171, 10, 'RN', 'Rio Negro', 1, 0),
(172, 10, 'SA', 'Salta', 1, 0),
(173, 10, 'SJ', 'San Juan', 1, 0),
(174, 10, 'SL', 'San Luis', 1, 0),
(175, 10, 'SC', 'Santa Cruz', 1, 0),
(176, 10, 'SF', 'Santa Fe', 1, 0),
(177, 10, 'SD', 'Santiago del Estero', 1, 0),
(178, 10, 'TF', 'Tierra del Fuego', 1, 0),
(179, 10, 'TU', 'Tucuman', 1, 0),
(180, 11, 'AGT', 'Aragatsotn', 1, 0),
(181, 11, 'ARR', 'Ararat', 1, 0),
(182, 11, 'ARM', 'Armavir', 1, 0),
(183, 11, 'GEG', 'Geghark\'unik\'', 1, 0),
(184, 11, 'KOT', 'Kotayk\'', 1, 0),
(185, 11, 'LOR', 'Lorri', 1, 0),
(186, 11, 'SHI', 'Shirak', 1, 0),
(187, 11, 'SYU', 'Syunik\'', 1, 0),
(188, 11, 'TAV', 'Tavush', 1, 0),
(189, 11, 'VAY', 'Vayots\' Dzor', 1, 0),
(190, 11, 'YER', 'Yerevan', 1, 0),
(191, 13, 'ACT', 'Australian Capital Territory', 1, 0),
(192, 13, 'NSW', 'New South Wales', 1, 0),
(193, 13, 'NT', 'Northern Territory', 1, 0),
(194, 13, 'QLD', 'Queensland', 1, 0),
(195, 13, 'SA', 'South Australia', 1, 0),
(196, 13, 'TAS', 'Tasmania', 1, 0),
(197, 13, 'VIC', 'Victoria', 1, 0),
(198, 13, 'WA', 'Western Australia', 1, 0),
(199, 14, 'BUR', 'Burgenland', 1, 0),
(200, 14, 'KAR', 'Kärnten', 1, 0),
(201, 14, 'NOS', 'Nieder&ouml;esterreich', 1, 0),
(202, 14, 'OOS', 'Ober&ouml;esterreich', 1, 0),
(203, 14, 'SAL', 'Salzburg', 1, 0),
(204, 14, 'STE', 'Steiermark', 1, 0),
(205, 14, 'TIR', 'Tirol', 1, 0),
(206, 14, 'VOR', 'Vorarlberg', 1, 0),
(207, 14, 'WIE', 'Wien', 1, 0),
(208, 15, 'AB', 'Ali Bayramli', 1, 0),
(209, 15, 'ABS', 'Abseron', 1, 0),
(210, 15, 'AGC', 'AgcabAdi', 1, 0),
(211, 15, 'AGM', 'Agdam', 1, 0),
(212, 15, 'AGS', 'Agdas', 1, 0),
(213, 15, 'AGA', 'Agstafa', 1, 0),
(214, 15, 'AGU', 'Agsu', 1, 0),
(215, 15, 'AST', 'Astara', 1, 0),
(216, 15, 'BA', 'Baki', 1, 0),
(217, 15, 'BAB', 'BabAk', 1, 0),
(218, 15, 'BAL', 'BalakAn', 1, 0),
(219, 15, 'BAR', 'BArdA', 1, 0),
(220, 15, 'BEY', 'Beylaqan', 1, 0),
(221, 15, 'BIL', 'Bilasuvar', 1, 0),
(222, 15, 'CAB', 'Cabrayil', 1, 0),
(223, 15, 'CAL', 'Calilabab', 1, 0),
(224, 15, 'CUL', 'Culfa', 1, 0),
(225, 15, 'DAS', 'Daskasan', 1, 0),
(226, 15, 'DAV', 'Davaci', 1, 0),
(227, 15, 'FUZ', 'Fuzuli', 1, 0),
(228, 15, 'GA', 'Ganca', 1, 0),
(229, 15, 'GAD', 'Gadabay', 1, 0),
(230, 15, 'GOR', 'Goranboy', 1, 0),
(231, 15, 'GOY', 'Goycay', 1, 0),
(232, 15, 'HAC', 'Haciqabul', 1, 0),
(233, 15, 'IMI', 'Imisli', 1, 0),
(234, 15, 'ISM', 'Ismayilli', 1, 0),
(235, 15, 'KAL', 'Kalbacar', 1, 0),
(236, 15, 'KUR', 'Kurdamir', 1, 0),
(237, 15, 'LA', 'Lankaran', 1, 0),
(238, 15, 'LAC', 'Lacin', 1, 0),
(239, 15, 'LAN', 'Lankaran', 1, 0),
(240, 15, 'LER', 'Lerik', 1, 0),
(241, 15, 'MAS', 'Masalli', 1, 0),
(242, 15, 'MI', 'Mingacevir', 1, 0),
(243, 15, 'NA', 'Naftalan', 1, 0),
(244, 15, 'NEF', 'Neftcala', 1, 0),
(245, 15, 'OGU', 'Oguz', 1, 0),
(246, 15, 'ORD', 'Ordubad', 1, 0),
(247, 15, 'QAB', 'Qabala', 1, 0),
(248, 15, 'QAX', 'Qax', 1, 0),
(249, 15, 'QAZ', 'Qazax', 1, 0),
(250, 15, 'QOB', 'Qobustan', 1, 0),
(251, 15, 'QBA', 'Quba', 1, 0),
(252, 15, 'QBI', 'Qubadli', 1, 0),
(253, 15, 'QUS', 'Qusar', 1, 0),
(254, 15, 'SA', 'Saki', 1, 0),
(255, 15, 'SAT', 'Saatli', 1, 0),
(256, 15, 'SAB', 'Sabirabad', 1, 0),
(257, 15, 'SAD', 'Sadarak', 1, 0),
(258, 15, 'SAH', 'Sahbuz', 1, 0),
(259, 15, 'SAK', 'Saki', 1, 0),
(260, 15, 'SAL', 'Salyan', 1, 0),
(261, 15, 'SM', 'Sumqayit', 1, 0),
(262, 15, 'SMI', 'Samaxi', 1, 0),
(263, 15, 'SKR', 'Samkir', 1, 0),
(264, 15, 'SMX', 'Samux', 1, 0),
(265, 15, 'SAR', 'Sarur', 1, 0),
(266, 15, 'SIY', 'Siyazan', 1, 0),
(267, 15, 'SS', 'Susa', 1, 0),
(268, 15, 'SUS', 'Susa', 1, 0),
(269, 15, 'TAR', 'Tartar', 1, 0),
(270, 15, 'TOV', 'Tovuz', 1, 0),
(271, 15, 'UCA', 'Ucar', 1, 0),
(272, 15, 'XA', 'Xankandi', 1, 0),
(273, 15, 'XAC', 'Xacmaz', 1, 0),
(274, 15, 'XAN', 'Xanlar', 1, 0),
(275, 15, 'XIZ', 'Xizi', 1, 0),
(276, 15, 'XCI', 'Xocali', 1, 0),
(277, 15, 'XVD', 'Xocavand', 1, 0),
(278, 15, 'YAR', 'Yardimli', 1, 0),
(279, 15, 'YEV', 'Yevlax', 1, 0),
(280, 15, 'ZAN', 'Zangilan', 1, 0),
(281, 15, 'ZAQ', 'Zaqatala', 1, 0),
(282, 15, 'ZAR', 'Zardab', 1, 0),
(283, 15, 'NX', 'Naxcivan', 1, 0),
(284, 16, 'ACK', 'Acklins', 1, 0),
(285, 16, 'BER', 'Berry Islands', 1, 0),
(286, 16, 'BIM', 'Bimini', 1, 0),
(287, 16, 'BLK', 'Black Point', 1, 0),
(288, 16, 'CAT', 'Cat Island', 1, 0),
(289, 16, 'CAB', 'Central Abaco', 1, 0),
(290, 16, 'CAN', 'Central Andros', 1, 0),
(291, 16, 'CEL', 'Central Eleuthera', 1, 0),
(292, 16, 'FRE', 'City of Freeport', 1, 0),
(293, 16, 'CRO', 'Crooked Island', 1, 0),
(294, 16, 'EGB', 'East Grand Bahama', 1, 0),
(295, 16, 'EXU', 'Exuma', 1, 0),
(296, 16, 'GRD', 'Grand Cay', 1, 0),
(297, 16, 'HAR', 'Harbour Island', 1, 0),
(298, 16, 'HOP', 'Hope Town', 1, 0),
(299, 16, 'INA', 'Inagua', 1, 0),
(300, 16, 'LNG', 'Long Island', 1, 0),
(301, 16, 'MAN', 'Mangrove Cay', 1, 0),
(302, 16, 'MAY', 'Mayaguana', 1, 0),
(303, 16, 'MOO', 'Moore\'s Island', 1, 0),
(304, 16, 'NAB', 'North Abaco', 1, 0),
(305, 16, 'NAN', 'North Andros', 1, 0),
(306, 16, 'NEL', 'North Eleuthera', 1, 0),
(307, 16, 'RAG', 'Ragged Island', 1, 0),
(308, 16, 'RUM', 'Rum Cay', 1, 0),
(309, 16, 'SAL', 'San Salvador', 1, 0),
(310, 16, 'SAB', 'South Abaco', 1, 0),
(311, 16, 'SAN', 'South Andros', 1, 0),
(312, 16, 'SEL', 'South Eleuthera', 1, 0),
(313, 16, 'SWE', 'Spanish Wells', 1, 0),
(314, 16, 'WGB', 'West Grand Bahama', 1, 0),
(315, 17, 'CAP', 'Capital', 1, 0),
(316, 17, 'CEN', 'Central', 1, 0),
(317, 17, 'MUH', 'Muharraq', 1, 0),
(318, 17, 'NOR', 'Northern', 1, 0),
(319, 17, 'SOU', 'Southern', 1, 0),
(320, 18, 'BAR', 'Barisal', 1, 0),
(321, 18, 'CHI', 'Chittagong', 1, 0),
(322, 18, 'DHA', 'Dhaka', 1, 0),
(323, 18, 'KHU', 'Khulna', 1, 0),
(324, 18, 'RAJ', 'Rajshahi', 1, 0),
(325, 18, 'SYL', 'Sylhet', 1, 0),
(326, 19, 'CC', 'Christ Church', 1, 0),
(327, 19, 'AND', 'Saint Andrew', 1, 0),
(328, 19, 'GEO', 'Saint George', 1, 0),
(329, 19, 'JAM', 'Saint James', 1, 0),
(330, 19, 'JOH', 'Saint John', 1, 0),
(331, 19, 'JOS', 'Saint Joseph', 1, 0),
(332, 19, 'LUC', 'Saint Lucy', 1, 0),
(333, 19, 'MIC', 'Saint Michael', 1, 0),
(334, 19, 'PET', 'Saint Peter', 1, 0),
(335, 19, 'PHI', 'Saint Philip', 1, 0),
(336, 19, 'THO', 'Saint Thomas', 1, 0),
(337, 20, 'BR', 'Brestskaya (Brest)', 1, 0),
(338, 20, 'HO', 'Homyel\'skaya (Homyel\')', 1, 0),
(339, 20, 'HM', 'Horad Minsk', 1, 0),
(340, 20, 'HR', 'Hrodzyenskaya (Hrodna)', 1, 0),
(341, 20, 'MA', 'Mahilyowskaya (Mahilyow)', 1, 0),
(342, 20, 'MI', 'Minskaya', 1, 0),
(343, 20, 'VI', 'Vitsyebskaya (Vitsyebsk)', 1, 0),
(344, 21, 'VAN', 'Antwerpen', 1, 0),
(345, 21, 'WBR', 'Brabant Wallon', 1, 0),
(346, 21, 'WHT', 'Hainaut', 1, 0),
(347, 21, 'WLG', 'Liege', 1, 0),
(348, 21, 'VLI', 'Limburg', 1, 0),
(349, 21, 'WLX', 'Luxembourg', 1, 0),
(350, 21, 'WNA', 'Namur', 1, 0),
(351, 21, 'VOV', 'Oost-Vlaanderen', 1, 0),
(352, 21, 'VBR', 'Vlaams Brabant', 1, 0),
(353, 21, 'VWV', 'West-Vlaanderen', 1, 0),
(354, 22, 'BZ', 'Belize', 1, 0),
(355, 22, 'CY', 'Cayo', 1, 0),
(356, 22, 'CR', 'Corozal', 1, 0),
(357, 22, 'OW', 'Orange Walk', 1, 0),
(358, 22, 'SC', 'Stann Creek', 1, 0),
(359, 22, 'TO', 'Toledo', 1, 0),
(360, 23, 'AL', 'Alibori', 1, 0),
(361, 23, 'AK', 'Atakora', 1, 0),
(362, 23, 'AQ', 'Atlantique', 1, 0),
(363, 23, 'BO', 'Borgou', 1, 0),
(364, 23, 'CO', 'Collines', 1, 0),
(365, 23, 'DO', 'Donga', 1, 0),
(366, 23, 'KO', 'Kouffo', 1, 0),
(367, 23, 'LI', 'Littoral', 1, 0),
(368, 23, 'MO', 'Mono', 1, 0),
(369, 23, 'OU', 'Oueme', 1, 0),
(370, 23, 'PL', 'Plateau', 1, 0),
(371, 23, 'ZO', 'Zou', 1, 0),
(372, 24, 'DS', 'Devonshire', 1, 0),
(373, 24, 'HC', 'Hamilton City', 1, 0),
(374, 24, 'HA', 'Hamilton', 1, 0),
(375, 24, 'PG', 'Paget', 1, 0),
(376, 24, 'PB', 'Pembroke', 1, 0),
(377, 24, 'GC', 'Saint George City', 1, 0),
(378, 24, 'SG', 'Saint George\'s', 1, 0),
(379, 24, 'SA', 'Sandys', 1, 0),
(380, 24, 'SM', 'Smith\'s', 1, 0),
(381, 24, 'SH', 'Southampton', 1, 0),
(382, 24, 'WA', 'Warwick', 1, 0),
(383, 25, 'BUM', 'Bumthang', 1, 0),
(384, 25, 'CHU', 'Chukha', 1, 0),
(385, 25, 'DAG', 'Dagana', 1, 0),
(386, 25, 'GAS', 'Gasa', 1, 0),
(387, 25, 'HAA', 'Haa', 1, 0),
(388, 25, 'LHU', 'Lhuntse', 1, 0),
(389, 25, 'MON', 'Mongar', 1, 0),
(390, 25, 'PAR', 'Paro', 1, 0),
(391, 25, 'PEM', 'Pemagatshel', 1, 0),
(392, 25, 'PUN', 'Punakha', 1, 0),
(393, 25, 'SJO', 'Samdrup Jongkhar', 1, 0),
(394, 25, 'SAT', 'Samtse', 1, 0),
(395, 25, 'SAR', 'Sarpang', 1, 0),
(396, 25, 'THI', 'Thimphu', 1, 0),
(397, 25, 'TRG', 'Trashigang', 1, 0),
(398, 25, 'TRY', 'Trashiyangste', 1, 0),
(399, 25, 'TRO', 'Trongsa', 1, 0),
(400, 25, 'TSI', 'Tsirang', 1, 0),
(401, 25, 'WPH', 'Wangdue Phodrang', 1, 0),
(402, 25, 'ZHE', 'Zhemgang', 1, 0),
(403, 26, 'BEN', 'Beni', 1, 0),
(404, 26, 'CHU', 'Chuquisaca', 1, 0),
(405, 26, 'COC', 'Cochabamba', 1, 0),
(406, 26, 'LPZ', 'La Paz', 1, 0),
(407, 26, 'ORU', 'Oruro', 1, 0),
(408, 26, 'PAN', 'Pando', 1, 0),
(409, 26, 'POT', 'Potosi', 1, 0),
(410, 26, 'SCZ', 'Santa Cruz', 1, 0),
(411, 26, 'TAR', 'Tarija', 1, 0),
(412, 27, 'RS', 'Republika Srpska', 1, 0),
(413, 27, 'BRO', 'Brčko District', 1, 0),
(414, 27, 'FUS', 'Unsko-Sanski Kanton', 1, 0),
(415, 27, 'FPO', 'Posavski Kanton', 1, 0),
(416, 27, 'FTU', 'Tuzlanski Kanton', 1, 0),
(417, 27, 'FZE', 'Zeničko-Dobojski Kanton', 1, 0),
(418, 27, 'FBP', 'Bosanskopodrinjski Kanton', 1, 0),
(419, 27, 'FSB', 'Srednjebosanski Kanton', 1, 0),
(420, 27, 'FHN', 'Hercegovačko-neretvanski Kanton', 1, 0),
(421, 27, 'FZH', 'Zapadnohercegovački Kanton', 1, 0),
(422, 27, 'FSA', 'Kanton Sarajevo', 1, 0),
(423, 27, 'FZA', 'Zapadnobosanski Kanton', 1, 0),
(430, 28, 'CE', 'Central', 1, 0),
(431, 28, 'GH', 'Ghanzi', 1, 0),
(432, 28, 'KD', 'Kgalagadi', 1, 0),
(433, 28, 'KT', 'Kgatleng', 1, 0),
(434, 28, 'KW', 'Kweneng', 1, 0),
(435, 28, 'NG', 'Ngamiland', 1, 0),
(436, 28, 'NE', 'North East', 1, 0),
(437, 28, 'NW', 'North West', 1, 0),
(438, 28, 'SE', 'South East', 1, 0),
(439, 28, 'SO', 'Southern', 1, 0),
(440, 30, 'AC', 'Acre', 1, 0),
(441, 30, 'AL', 'Alagoas', 1, 0),
(442, 30, 'AP', 'Amapa', 1, 0),
(443, 30, 'AM', 'Amazonas', 1, 0),
(444, 30, 'BA', 'Bahia', 1, 0),
(445, 30, 'CE', 'Ceara', 1, 0),
(446, 30, 'DF', 'Distrito Federal', 1, 0),
(447, 30, 'ES', 'Espirito Santo', 1, 0),
(448, 30, 'GO', 'Goias', 1, 0),
(449, 30, 'MA', 'Maranhao', 1, 0),
(450, 30, 'MT', 'Mato Grosso', 1, 0),
(451, 30, 'MS', 'Mato Grosso do Sul', 1, 0),
(452, 30, 'MG', 'Minas Gerais', 1, 0),
(453, 30, 'PA', 'Para', 1, 0),
(454, 30, 'PB', 'Paraiba', 1, 0),
(455, 30, 'PR', 'Parana', 1, 0),
(456, 30, 'PE', 'Pernambuco', 1, 0),
(457, 30, 'PI', 'Piaui', 1, 0),
(458, 30, 'RJ', 'Rio de Janeiro', 1, 0),
(459, 30, 'RN', 'Rio Grande do Norte', 1, 0),
(460, 30, 'RS', 'Rio Grande do Sul', 1, 0),
(461, 30, 'RO', 'Rondonia', 1, 0),
(462, 30, 'RR', 'Roraima', 1, 0),
(463, 30, 'SC', 'Santa Catarina', 1, 0),
(464, 30, 'SP', 'Sao Paulo', 1, 0),
(465, 30, 'SE', 'Sergipe', 1, 0),
(466, 30, 'TO', 'Tocantins', 1, 0),
(467, 31, 'PB', 'Peros Banhos', 1, 0),
(468, 31, 'SI', 'Salomon Islands', 1, 0),
(469, 31, 'NI', 'Nelsons Island', 1, 0),
(470, 31, 'TB', 'Three Brothers', 1, 0),
(471, 31, 'EA', 'Eagle Islands', 1, 0),
(472, 31, 'DI', 'Danger Island', 1, 0),
(473, 31, 'EG', 'Egmont Islands', 1, 0),
(474, 31, 'DG', 'Diego Garcia', 1, 0),
(475, 32, 'BEL', 'Belait', 1, 0),
(476, 32, 'BRM', 'Brunei and Muara', 1, 0),
(477, 32, 'TEM', 'Temburong', 1, 0),
(478, 32, 'TUT', 'Tutong', 1, 0),
(479, 33, '', 'Blagoevgrad', 1, 0),
(480, 33, '', 'Burgas', 1, 0),
(481, 33, '', 'Dobrich', 1, 0),
(482, 33, '', 'Gabrovo', 1, 0),
(483, 33, '', 'Haskovo', 1, 0),
(484, 33, '', 'Kardjali', 1, 0),
(485, 33, '', 'Kyustendil', 1, 0),
(486, 33, '', 'Lovech', 1, 0),
(487, 33, '', 'Montana', 1, 0),
(488, 33, '', 'Pazardjik', 1, 0),
(489, 33, '', 'Pernik', 1, 0),
(490, 33, '', 'Pleven', 1, 0),
(491, 33, '', 'Plovdiv', 1, 0),
(492, 33, '', 'Razgrad', 1, 0),
(493, 33, '', 'Shumen', 1, 0),
(494, 33, '', 'Silistra', 1, 0),
(495, 33, '', 'Sliven', 1, 0),
(496, 33, '', 'Smolyan', 1, 0),
(497, 33, '', 'Sofia', 1, 0),
(498, 33, '', 'Sofia - town', 1, 0),
(499, 33, '', 'Stara Zagora', 1, 0),
(500, 33, '', 'Targovishte', 1, 0),
(501, 33, '', 'Varna', 1, 0),
(502, 33, '', 'Veliko Tarnovo', 1, 0),
(503, 33, '', 'Vidin', 1, 0),
(504, 33, '', 'Vratza', 1, 0),
(505, 33, '', 'Yambol', 1, 0),
(506, 34, 'BAL', 'Bale', 1, 0),
(507, 34, 'BAM', 'Bam', 1, 0),
(508, 34, 'BAN', 'Banwa', 1, 0),
(509, 34, 'BAZ', 'Bazega', 1, 0),
(510, 34, 'BOR', 'Bougouriba', 1, 0),
(511, 34, 'BLG', 'Boulgou', 1, 0),
(512, 34, 'BOK', 'Boulkiemde', 1, 0),
(513, 34, 'COM', 'Comoe', 1, 0),
(514, 34, 'GAN', 'Ganzourgou', 1, 0),
(515, 34, 'GNA', 'Gnagna', 1, 0),
(516, 34, 'GOU', 'Gourma', 1, 0),
(517, 34, 'HOU', 'Houet', 1, 0),
(518, 34, 'IOA', 'Ioba', 1, 0),
(519, 34, 'KAD', 'Kadiogo', 1, 0),
(520, 34, 'KEN', 'Kenedougou', 1, 0),
(521, 34, 'KOD', 'Komondjari', 1, 0),
(522, 34, 'KOP', 'Kompienga', 1, 0),
(523, 34, 'KOS', 'Kossi', 1, 0),
(524, 34, 'KOL', 'Koulpelogo', 1, 0),
(525, 34, 'KOT', 'Kouritenga', 1, 0),
(526, 34, 'KOW', 'Kourweogo', 1, 0),
(527, 34, 'LER', 'Leraba', 1, 0),
(528, 34, 'LOR', 'Loroum', 1, 0),
(529, 34, 'MOU', 'Mouhoun', 1, 0),
(530, 34, 'NAH', 'Nahouri', 1, 0),
(531, 34, 'NAM', 'Namentenga', 1, 0),
(532, 34, 'NAY', 'Nayala', 1, 0),
(533, 34, 'NOU', 'Noumbiel', 1, 0),
(534, 34, 'OUB', 'Oubritenga', 1, 0),
(535, 34, 'OUD', 'Oudalan', 1, 0),
(536, 34, 'PAS', 'Passore', 1, 0),
(537, 34, 'PON', 'Poni', 1, 0),
(538, 34, 'SAG', 'Sanguie', 1, 0),
(539, 34, 'SAM', 'Sanmatenga', 1, 0),
(540, 34, 'SEN', 'Seno', 1, 0),
(541, 34, 'SIS', 'Sissili', 1, 0),
(542, 34, 'SOM', 'Soum', 1, 0),
(543, 34, 'SOR', 'Sourou', 1, 0),
(544, 34, 'TAP', 'Tapoa', 1, 0),
(545, 34, 'TUY', 'Tuy', 1, 0),
(546, 34, 'YAG', 'Yagha', 1, 0),
(547, 34, 'YAT', 'Yatenga', 1, 0),
(548, 34, 'ZIR', 'Ziro', 1, 0),
(549, 34, 'ZOD', 'Zondoma', 1, 0),
(550, 34, 'ZOW', 'Zoundweogo', 1, 0),
(551, 35, 'BB', 'Bubanza', 1, 0),
(552, 35, 'BJ', 'Bujumbura', 1, 0),
(553, 35, 'BR', 'Bururi', 1, 0),
(554, 35, 'CA', 'Cankuzo', 1, 0),
(555, 35, 'CI', 'Cibitoke', 1, 0),
(556, 35, 'GI', 'Gitega', 1, 0),
(557, 35, 'KR', 'Karuzi', 1, 0),
(558, 35, 'KY', 'Kayanza', 1, 0),
(559, 35, 'KI', 'Kirundo', 1, 0),
(560, 35, 'MA', 'Makamba', 1, 0),
(561, 35, 'MU', 'Muramvya', 1, 0),
(562, 35, 'MY', 'Muyinga', 1, 0),
(563, 35, 'MW', 'Mwaro', 1, 0),
(564, 35, 'NG', 'Ngozi', 1, 0),
(565, 35, 'RT', 'Rutana', 1, 0),
(566, 35, 'RY', 'Ruyigi', 1, 0),
(567, 36, 'PP', 'Phnom Penh', 1, 0),
(568, 36, 'PS', 'Preah Seihanu (Kompong Som or Sihanoukville)', 1, 0),
(569, 36, 'PA', 'Pailin', 1, 0),
(570, 36, 'KB', 'Keb', 1, 0),
(571, 36, 'BM', 'Banteay Meanchey', 1, 0),
(572, 36, 'BA', 'Battambang', 1, 0),
(573, 36, 'KM', 'Kampong Cham', 1, 0),
(574, 36, 'KN', 'Kampong Chhnang', 1, 0),
(575, 36, 'KU', 'Kampong Speu', 1, 0),
(576, 36, 'KO', 'Kampong Som', 1, 0),
(577, 36, 'KT', 'Kampong Thom', 1, 0),
(578, 36, 'KP', 'Kampot', 1, 0),
(579, 36, 'KL', 'Kandal', 1, 0),
(580, 36, 'KK', 'Kaoh Kong', 1, 0),
(581, 36, 'KR', 'Kratie', 1, 0),
(582, 36, 'MK', 'Mondul Kiri', 1, 0),
(583, 36, 'OM', 'Oddar Meancheay', 1, 0),
(584, 36, 'PU', 'Pursat', 1, 0),
(585, 36, 'PR', 'Preah Vihear', 1, 0),
(586, 36, 'PG', 'Prey Veng', 1, 0),
(587, 36, 'RK', 'Ratanak Kiri', 1, 0),
(588, 36, 'SI', 'Siemreap', 1, 0),
(589, 36, 'ST', 'Stung Treng', 1, 0),
(590, 36, 'SR', 'Svay Rieng', 1, 0),
(591, 36, 'TK', 'Takeo', 1, 0),
(592, 37, 'ADA', 'Adamawa (Adamaoua)', 1, 0),
(593, 37, 'CEN', 'Centre', 1, 0),
(594, 37, 'EST', 'East (Est)', 1, 0),
(595, 37, 'EXN', 'Extreme North (Extreme-Nord)', 1, 0),
(596, 37, 'LIT', 'Littoral', 1, 0),
(597, 37, 'NOR', 'North (Nord)', 1, 0),
(598, 37, 'NOT', 'Northwest (Nord-Ouest)', 1, 0),
(599, 37, 'OUE', 'West (Ouest)', 1, 0),
(600, 37, 'SUD', 'South (Sud)', 1, 0),
(601, 37, 'SOU', 'Southwest (Sud-Ouest).', 1, 0),
(602, 38, 'AB', 'Alberta', 1, 0),
(603, 38, 'BC', 'British Columbia', 1, 0),
(604, 38, 'MB', 'Manitoba', 1, 0),
(605, 38, 'NB', 'New Brunswick', 1, 0),
(606, 38, 'NL', 'Newfoundland and Labrador', 1, 0),
(607, 38, 'NT', 'Northwest Territories', 1, 0),
(608, 38, 'NS', 'Nova Scotia', 1, 0),
(609, 38, 'NU', 'Nunavut', 1, 0),
(610, 38, 'ON', 'Ontario', 1, 0),
(611, 38, 'PE', 'Prince Edward Island', 1, 0),
(612, 38, 'QC', 'Qu&eacute;bec', 1, 0),
(613, 38, 'SK', 'Saskatchewan', 1, 0),
(614, 38, 'YT', 'Yukon Territory', 1, 0),
(615, 39, 'BV', 'Boa Vista', 1, 0),
(616, 39, 'BR', 'Brava', 1, 0),
(617, 39, 'CS', 'Calheta de Sao Miguel', 1, 0),
(618, 39, 'MA', 'Maio', 1, 0),
(619, 39, 'MO', 'Mosteiros', 1, 0),
(620, 39, 'PA', 'Paul', 1, 0),
(621, 39, 'PN', 'Porto Novo', 1, 0),
(622, 39, 'PR', 'Praia', 1, 0),
(623, 39, 'RG', 'Ribeira Grande', 1, 0),
(624, 39, 'SL', 'Sal', 1, 0),
(625, 39, 'CA', 'Santa Catarina', 1, 0),
(626, 39, 'CR', 'Santa Cruz', 1, 0),
(627, 39, 'SD', 'Sao Domingos', 1, 0),
(628, 39, 'SF', 'Sao Filipe', 1, 0),
(629, 39, 'SN', 'Sao Nicolau', 1, 0),
(630, 39, 'SV', 'Sao Vicente', 1, 0),
(631, 39, 'TA', 'Tarrafal', 1, 0),
(632, 40, 'CR', 'Creek', 1, 0),
(633, 40, 'EA', 'Eastern', 1, 0),
(634, 40, 'ML', 'Midland', 1, 0),
(635, 40, 'ST', 'South Town', 1, 0),
(636, 40, 'SP', 'Spot Bay', 1, 0),
(637, 40, 'SK', 'Stake Bay', 1, 0),
(638, 40, 'WD', 'West End', 1, 0),
(639, 40, 'WN', 'Western', 1, 0),
(640, 41, 'BBA', 'Bamingui-Bangoran', 1, 0),
(641, 41, 'BKO', 'Basse-Kotto', 1, 0),
(642, 41, 'HKO', 'Haute-Kotto', 1, 0),
(643, 41, 'HMB', 'Haut-Mbomou', 1, 0),
(644, 41, 'KEM', 'Kemo', 1, 0),
(645, 41, 'LOB', 'Lobaye', 1, 0),
(646, 41, 'MKD', 'Mambéré-Kadéï', 1, 0),
(647, 41, 'MBO', 'Mbomou', 1, 0),
(648, 41, 'NMM', 'Nana-Mambere', 1, 0),
(649, 41, 'OMP', 'Ombella-M\'Poko', 1, 0),
(650, 41, 'OUK', 'Ouaka', 1, 0),
(651, 41, 'OUH', 'Ouham', 1, 0),
(652, 41, 'OPE', 'Ouham-Pende', 1, 0),
(653, 41, 'VAK', 'Vakaga', 1, 0),
(654, 41, 'NGR', 'Nana-Grebizi', 1, 0),
(655, 41, 'SMB', 'Sangha-Mbaere', 1, 0),
(656, 41, 'BAN', 'Bangui', 1, 0),
(657, 42, 'BA', 'Batha', 1, 0),
(658, 42, 'BI', 'Biltine', 1, 0),
(659, 42, 'BE', 'Borkou-Ennedi-Tibesti', 1, 0),
(660, 42, 'CB', 'Chari-Baguirmi', 1, 0),
(661, 42, 'GU', 'Guera', 1, 0),
(662, 42, 'KA', 'Kanem', 1, 0),
(663, 42, 'LA', 'Lac', 1, 0),
(664, 42, 'LC', 'Logone Occidental', 1, 0),
(665, 42, 'LR', 'Logone Oriental', 1, 0),
(666, 42, 'MK', 'Mayo-Kebbi', 1, 0),
(667, 42, 'MC', 'Moyen-Chari', 1, 0),
(668, 42, 'OU', 'Ouaddai', 1, 0),
(669, 42, 'SA', 'Salamat', 1, 0),
(670, 42, 'TA', 'Tandjile', 1, 0),
(671, 43, 'AI', 'Aisen del General Carlos Ibanez', 1, 0),
(672, 43, 'AN', 'Antofagasta', 1, 0),
(673, 43, 'AR', 'Araucania', 1, 0),
(674, 43, 'AT', 'Atacama', 1, 0),
(675, 43, 'BI', 'Bio-Bio', 1, 0),
(676, 43, 'CO', 'Coquimbo', 1, 0),
(677, 43, 'LI', 'Libertador General Bernardo O\'Hi', 1, 0),
(678, 43, 'LL', 'Los Lagos', 1, 0),
(679, 43, 'MA', 'Magallanes y de la Antartica Chi', 1, 0),
(680, 43, 'ML', 'Maule', 1, 0),
(681, 43, 'RM', 'Region Metropolitana', 1, 0),
(682, 43, 'TA', 'Tarapaca', 1, 0),
(683, 43, 'VS', 'Valparaiso', 1, 0),
(684, 44, 'AN', 'Anhui', 1, 0),
(685, 44, 'BE', 'Beijing', 1, 0),
(686, 44, 'CH', 'Chongqing', 1, 0),
(687, 44, 'FU', 'Fujian', 1, 0),
(688, 44, 'GA', 'Gansu', 1, 0),
(689, 44, 'GU', 'Guangdong', 1, 0),
(690, 44, 'GX', 'Guangxi', 1, 0),
(691, 44, 'GZ', 'Guizhou', 1, 0),
(692, 44, 'HA', 'Hainan', 1, 0),
(693, 44, 'HB', 'Hebei', 1, 0),
(694, 44, 'HL', 'Heilongjiang', 1, 0),
(695, 44, 'HE', 'Henan', 1, 0),
(696, 44, 'HK', 'Hong Kong', 1, 0),
(697, 44, 'HU', 'Hubei', 1, 0),
(698, 44, 'HN', 'Hunan', 1, 0),
(699, 44, 'IM', 'Inner Mongolia', 1, 0),
(700, 44, 'JI', 'Jiangsu', 1, 0),
(701, 44, 'JX', 'Jiangxi', 1, 0),
(702, 44, 'JL', 'Jilin', 1, 0),
(703, 44, 'LI', 'Liaoning', 1, 0),
(704, 44, 'MA', 'Macau', 1, 0),
(705, 44, 'NI', 'Ningxia', 1, 0),
(706, 44, 'SH', 'Shaanxi', 1, 0),
(707, 44, 'SA', 'Shandong', 1, 0),
(708, 44, 'SG', 'Shanghai', 1, 0),
(709, 44, 'SX', 'Shanxi', 1, 0),
(710, 44, 'SI', 'Sichuan', 1, 0),
(711, 44, 'TI', 'Tianjin', 1, 0),
(712, 44, 'XI', 'Xinjiang', 1, 0),
(713, 44, 'YU', 'Yunnan', 1, 0),
(714, 44, 'ZH', 'Zhejiang', 1, 0),
(715, 46, 'D', 'Direction Island', 1, 0),
(716, 46, 'H', 'Home Island', 1, 0),
(717, 46, 'O', 'Horsburgh Island', 1, 0),
(718, 46, 'S', 'South Island', 1, 0),
(719, 46, 'W', 'West Island', 1, 0),
(720, 47, 'AMZ', 'Amazonas', 1, 0),
(721, 47, 'ANT', 'Antioquia', 1, 0),
(722, 47, 'ARA', 'Arauca', 1, 0),
(723, 47, 'ATL', 'Atlantico', 1, 0),
(724, 47, 'BDC', 'Bogota D.C.', 1, 0),
(725, 47, 'BOL', 'Bolivar', 1, 0),
(726, 47, 'BOY', 'Boyaca', 1, 0),
(727, 47, 'CAL', 'Caldas', 1, 0),
(728, 47, 'CAQ', 'Caqueta', 1, 0),
(729, 47, 'CAS', 'Casanare', 1, 0),
(730, 47, 'CAU', 'Cauca', 1, 0),
(731, 47, 'CES', 'Cesar', 1, 0),
(732, 47, 'CHO', 'Choco', 1, 0),
(733, 47, 'COR', 'Cordoba', 1, 0),
(734, 47, 'CAM', 'Cundinamarca', 1, 0),
(735, 47, 'GNA', 'Guainia', 1, 0),
(736, 47, 'GJR', 'Guajira', 1, 0),
(737, 47, 'GVR', 'Guaviare', 1, 0),
(738, 47, 'HUI', 'Huila', 1, 0),
(739, 47, 'MAG', 'Magdalena', 1, 0),
(740, 47, 'MET', 'Meta', 1, 0),
(741, 47, 'NAR', 'Narino', 1, 0),
(742, 47, 'NDS', 'Norte de Santander', 1, 0),
(743, 47, 'PUT', 'Putumayo', 1, 0),
(744, 47, 'QUI', 'Quindio', 1, 0),
(745, 47, 'RIS', 'Risaralda', 1, 0),
(746, 47, 'SAP', 'San Andres y Providencia', 1, 0),
(747, 47, 'SAN', 'Santander', 1, 0),
(748, 47, 'SUC', 'Sucre', 1, 0),
(749, 47, 'TOL', 'Tolima', 1, 0),
(750, 47, 'VDC', 'Valle del Cauca', 1, 0),
(751, 47, 'VAU', 'Vaupes', 1, 0),
(752, 47, 'VIC', 'Vichada', 1, 0),
(753, 48, 'G', 'Grande Comore', 1, 0),
(754, 48, 'A', 'Anjouan', 1, 0),
(755, 48, 'M', 'Moheli', 1, 0),
(756, 49, 'BO', 'Bouenza', 1, 0),
(757, 49, 'BR', 'Brazzaville', 1, 0),
(758, 49, 'CU', 'Cuvette', 1, 0),
(759, 49, 'CO', 'Cuvette-Ouest', 1, 0),
(760, 49, 'KO', 'Kouilou', 1, 0),
(761, 49, 'LE', 'Lekoumou', 1, 0),
(762, 49, 'LI', 'Likouala', 1, 0),
(763, 49, 'NI', 'Niari', 1, 0),
(764, 49, 'PL', 'Plateaux', 1, 0),
(765, 49, 'PO', 'Pool', 1, 0),
(766, 49, 'SA', 'Sangha', 1, 0),
(767, 50, 'PU', 'Pukapuka', 1, 0),
(768, 50, 'RK', 'Rakahanga', 1, 0),
(769, 50, 'MK', 'Manihiki', 1, 0),
(770, 50, 'PE', 'Penrhyn', 1, 0),
(771, 50, 'NI', 'Nassau Island', 1, 0),
(772, 50, 'SU', 'Surwarrow', 1, 0),
(773, 50, 'PA', 'Palmerston', 1, 0),
(774, 50, 'AI', 'Aitutaki', 1, 0),
(775, 50, 'MA', 'Manuae', 1, 0),
(776, 50, 'TA', 'Takutea', 1, 0),
(777, 50, 'MT', 'Mitiaro', 1, 0),
(778, 50, 'AT', 'Atiu', 1, 0),
(779, 50, 'MU', 'Mauke', 1, 0),
(780, 50, 'RR', 'Rarotonga', 1, 0),
(781, 50, 'MG', 'Mangaia', 1, 0),
(782, 51, 'AL', 'Alajuela', 1, 0),
(783, 51, 'CA', 'Cartago', 1, 0),
(784, 51, 'GU', 'Guanacaste', 1, 0),
(785, 51, 'HE', 'Heredia', 1, 0),
(786, 51, 'LI', 'Limon', 1, 0),
(787, 51, 'PU', 'Puntarenas', 1, 0),
(788, 51, 'SJ', 'San Jose', 1, 0),
(789, 52, 'ABE', 'Abengourou', 1, 0),
(790, 52, 'ABI', 'Abidjan', 1, 0),
(791, 52, 'ABO', 'Aboisso', 1, 0),
(792, 52, 'ADI', 'Adiake', 1, 0),
(793, 52, 'ADZ', 'Adzope', 1, 0),
(794, 52, 'AGB', 'Agboville', 1, 0),
(795, 52, 'AGN', 'Agnibilekrou', 1, 0),
(796, 52, 'ALE', 'Alepe', 1, 0),
(797, 52, 'BOC', 'Bocanda', 1, 0),
(798, 52, 'BAN', 'Bangolo', 1, 0),
(799, 52, 'BEO', 'Beoumi', 1, 0),
(800, 52, 'BIA', 'Biankouma', 1, 0),
(801, 52, 'BDK', 'Bondoukou', 1, 0),
(802, 52, 'BGN', 'Bongouanou', 1, 0),
(803, 52, 'BFL', 'Bouafle', 1, 0),
(804, 52, 'BKE', 'Bouake', 1, 0),
(805, 52, 'BNA', 'Bouna', 1, 0),
(806, 52, 'BDL', 'Boundiali', 1, 0),
(807, 52, 'DKL', 'Dabakala', 1, 0),
(808, 52, 'DBU', 'Dabou', 1, 0),
(809, 52, 'DAL', 'Daloa', 1, 0),
(810, 52, 'DAN', 'Danane', 1, 0),
(811, 52, 'DAO', 'Daoukro', 1, 0),
(812, 52, 'DIM', 'Dimbokro', 1, 0),
(813, 52, 'DIV', 'Divo', 1, 0),
(814, 52, 'DUE', 'Duekoue', 1, 0),
(815, 52, 'FER', 'Ferkessedougou', 1, 0),
(816, 52, 'GAG', 'Gagnoa', 1, 0),
(817, 52, 'GBA', 'Grand-Bassam', 1, 0),
(818, 52, 'GLA', 'Grand-Lahou', 1, 0),
(819, 52, 'GUI', 'Guiglo', 1, 0),
(820, 52, 'ISS', 'Issia', 1, 0),
(821, 52, 'JAC', 'Jacqueville', 1, 0),
(822, 52, 'KAT', 'Katiola', 1, 0),
(823, 52, 'KOR', 'Korhogo', 1, 0),
(824, 52, 'LAK', 'Lakota', 1, 0),
(825, 52, 'MAN', 'Man', 1, 0),
(826, 52, 'MKN', 'Mankono', 1, 0),
(827, 52, 'MBA', 'Mbahiakro', 1, 0),
(828, 52, 'ODI', 'Odienne', 1, 0),
(829, 52, 'OUM', 'Oume', 1, 0),
(830, 52, 'SAK', 'Sakassou', 1, 0),
(831, 52, 'SPE', 'San-Pedro', 1, 0),
(832, 52, 'SAS', 'Sassandra', 1, 0),
(833, 52, 'SEG', 'Seguela', 1, 0),
(834, 52, 'SIN', 'Sinfra', 1, 0),
(835, 52, 'SOU', 'Soubre', 1, 0),
(836, 52, 'TAB', 'Tabou', 1, 0),
(837, 52, 'TAN', 'Tanda', 1, 0),
(838, 52, 'TIE', 'Tiebissou', 1, 0),
(839, 52, 'TIN', 'Tingrela', 1, 0),
(840, 52, 'TIA', 'Tiassale', 1, 0),
(841, 52, 'TBA', 'Touba', 1, 0),
(842, 52, 'TLP', 'Toulepleu', 1, 0),
(843, 52, 'TMD', 'Toumodi', 1, 0),
(844, 52, 'VAV', 'Vavoua', 1, 0),
(845, 52, 'YAM', 'Yamoussoukro', 1, 0),
(846, 52, 'ZUE', 'Zuenoula', 1, 0),
(847, 53, 'BB', 'Bjelovar-Bilogora', 1, 0),
(848, 53, 'CZ', 'City of Zagreb', 1, 0),
(849, 53, 'DN', 'Dubrovnik-Neretva', 1, 0),
(850, 53, 'IS', 'Istra', 1, 0),
(851, 53, 'KA', 'Karlovac', 1, 0),
(852, 53, 'KK', 'Koprivnica-Krizevci', 1, 0),
(853, 53, 'KZ', 'Krapina-Zagorje', 1, 0),
(854, 53, 'LS', 'Lika-Senj', 1, 0),
(855, 53, 'ME', 'Medimurje', 1, 0),
(856, 53, 'OB', 'Osijek-Baranja', 1, 0),
(857, 53, 'PS', 'Pozega-Slavonia', 1, 0),
(858, 53, 'PG', 'Primorje-Gorski Kotar', 1, 0),
(859, 53, 'SI', 'Sibenik', 1, 0),
(860, 53, 'SM', 'Sisak-Moslavina', 1, 0),
(861, 53, 'SB', 'Slavonski Brod-Posavina', 1, 0),
(862, 53, 'SD', 'Split-Dalmatia', 1, 0),
(863, 53, 'VA', 'Varazdin', 1, 0),
(864, 53, 'VP', 'Virovitica-Podravina', 1, 0),
(865, 53, 'VS', 'Vukovar-Srijem', 1, 0),
(866, 53, 'ZK', 'Zadar-Knin', 1, 0),
(867, 53, 'ZA', 'Zagreb', 1, 0),
(868, 54, 'CA', 'Camaguey', 1, 0),
(869, 54, 'CD', 'Ciego de Avila', 1, 0),
(870, 54, 'CI', 'Cienfuegos', 1, 0),
(871, 54, 'CH', 'Ciudad de La Habana', 1, 0),
(872, 54, 'GR', 'Granma', 1, 0),
(873, 54, 'GU', 'Guantanamo', 1, 0),
(874, 54, 'HO', 'Holguin', 1, 0),
(875, 54, 'IJ', 'Isla de la Juventud', 1, 0),
(876, 54, 'LH', 'La Habana', 1, 0),
(877, 54, 'LT', 'Las Tunas', 1, 0),
(878, 54, 'MA', 'Matanzas', 1, 0),
(879, 54, 'PR', 'Pinar del Rio', 1, 0),
(880, 54, 'SS', 'Sancti Spiritus', 1, 0),
(881, 54, 'SC', 'Santiago de Cuba', 1, 0),
(882, 54, 'VC', 'Villa Clara', 1, 0),
(883, 55, 'F', 'Famagusta', 1, 0),
(884, 55, 'K', 'Kyrenia', 1, 0),
(885, 55, 'A', 'Larnaca', 1, 0),
(886, 55, 'I', 'Limassol', 1, 0),
(887, 55, 'N', 'Nicosia', 1, 0),
(888, 55, 'P', 'Paphos', 1, 0),
(889, 56, 'U', 'Ustecky', 1, 0),
(890, 56, 'C', 'Jihocesky', 1, 0),
(891, 56, 'B', 'Jihomoravsky', 1, 0),
(892, 56, 'K', 'Karlovarsky', 1, 0),
(893, 56, 'H', 'Kralovehradecky', 1, 0),
(894, 56, 'L', 'Liberecky', 1, 0),
(895, 56, 'T', 'Moravskoslezsky', 1, 0),
(896, 56, 'M', 'Olomoucky', 1, 0),
(897, 56, 'E', 'Pardubicky', 1, 0),
(898, 56, 'P', 'Plzensky', 1, 0),
(899, 56, 'A', 'Praha', 1, 0),
(900, 56, 'S', 'Stredocesky', 1, 0),
(901, 56, 'J', 'Vysocina', 1, 0),
(902, 56, 'Z', 'Zlinsky', 1, 0),
(903, 57, 'HS', 'Hovedstaden', 1, 0),
(904, 57, 'MJ', 'Midtjylland', 1, 0),
(905, 57, 'ND', 'Nordjylland', 1, 0),
(906, 57, 'SL', 'Sjælland', 1, 0),
(907, 57, 'SD', 'Syddanmark', 1, 0),
(908, 57, 'FO', 'Faroe Islands', 1, 0),
(909, 57, 'GL', 'Greenland', 1, 0),
(919, 58, 'S', '\'Ali Sabih', 1, 0),
(920, 58, 'K', 'Dikhil', 1, 0),
(921, 58, 'J', 'Djibouti', 1, 0),
(922, 58, 'O', 'Obock', 1, 0),
(923, 58, 'T', 'Tadjoura', 1, 0),
(924, 59, 'AND', 'Saint Andrew Parish', 1, 0),
(925, 59, 'DAV', 'Saint David Parish', 1, 0),
(926, 59, 'GEO', 'Saint George Parish', 1, 0),
(927, 59, 'JOH', 'Saint John Parish', 1, 0),
(928, 59, 'JOS', 'Saint Joseph Parish', 1, 0),
(929, 59, 'LUK', 'Saint Luke Parish', 1, 0),
(930, 59, 'MAR', 'Saint Mark Parish', 1, 0),
(931, 59, 'PAT', 'Saint Patrick Parish', 1, 0),
(932, 59, 'PAU', 'Saint Paul Parish', 1, 0),
(933, 59, 'PET', 'Saint Peter Parish', 1, 0),
(934, 60, 'DN', 'Distrito Nacional', 1, 0),
(935, 60, 'AZ', 'Azua', 1, 0),
(936, 60, 'BC', 'Baoruco', 1, 0),
(937, 60, 'BH', 'Barahona', 1, 0),
(938, 60, 'DJ', 'Dajabon', 1, 0),
(939, 60, 'DU', 'Duarte', 1, 0),
(940, 60, 'EL', 'Elias Pina', 1, 0),
(941, 60, 'SY', 'El Seybo', 1, 0),
(942, 60, 'ET', 'Espaillat', 1, 0),
(943, 60, 'HM', 'Hato Mayor', 1, 0),
(944, 60, 'IN', 'Independencia', 1, 0),
(945, 60, 'AL', 'La Altagracia', 1, 0),
(946, 60, 'RO', 'La Romana', 1, 0),
(947, 60, 'VE', 'La Vega', 1, 0),
(948, 60, 'MT', 'Maria Trinidad Sanchez', 1, 0),
(949, 60, 'MN', 'Monsenor Nouel', 1, 0),
(950, 60, 'MC', 'Monte Cristi', 1, 0),
(951, 60, 'MP', 'Monte Plata', 1, 0),
(952, 60, 'PD', 'Pedernales', 1, 0),
(953, 60, 'PR', 'Peravia (Bani)', 1, 0),
(954, 60, 'PP', 'Puerto Plata', 1, 0),
(955, 60, 'SL', 'Salcedo', 1, 0),
(956, 60, 'SM', 'Samana', 1, 0),
(957, 60, 'SH', 'Sanchez Ramirez', 1, 0),
(958, 60, 'SC', 'San Cristobal', 1, 0),
(959, 60, 'JO', 'San Jose de Ocoa', 1, 0),
(960, 60, 'SJ', 'San Juan', 1, 0),
(961, 60, 'PM', 'San Pedro de Macoris', 1, 0),
(962, 60, 'SA', 'Santiago', 1, 0),
(963, 60, 'ST', 'Santiago Rodriguez', 1, 0),
(964, 60, 'SD', 'Santo Domingo', 1, 0),
(965, 60, 'VA', 'Valverde', 1, 0),
(966, 61, 'AL', 'Aileu', 1, 0),
(967, 61, 'AN', 'Ainaro', 1, 0),
(968, 61, 'BA', 'Baucau', 1, 0),
(969, 61, 'BO', 'Bobonaro', 1, 0),
(970, 61, 'CO', 'Cova Lima', 1, 0),
(971, 61, 'DI', 'Dili', 1, 0),
(972, 61, 'ER', 'Ermera', 1, 0),
(973, 61, 'LA', 'Lautem', 1, 0),
(974, 61, 'LI', 'Liquica', 1, 0),
(975, 61, 'MT', 'Manatuto', 1, 0),
(976, 61, 'MF', 'Manufahi', 1, 0),
(977, 61, 'OE', 'Oecussi', 1, 0),
(978, 61, 'VI', 'Viqueque', 1, 0),
(979, 62, 'AZU', 'Azuay', 1, 0),
(980, 62, 'BOL', 'Bolivar', 1, 0),
(981, 62, 'CAN', 'Ca&ntilde;ar', 1, 0),
(982, 62, 'CAR', 'Carchi', 1, 0),
(983, 62, 'CHI', 'Chimborazo', 1, 0),
(984, 62, 'COT', 'Cotopaxi', 1, 0),
(985, 62, 'EOR', 'El Oro', 1, 0),
(986, 62, 'ESM', 'Esmeraldas', 1, 0),
(987, 62, 'GPS', 'Gal&aacute;pagos', 1, 0),
(988, 62, 'GUA', 'Guayas', 1, 0),
(989, 62, 'IMB', 'Imbabura', 1, 0),
(990, 62, 'LOJ', 'Loja', 1, 0),
(991, 62, 'LRO', 'Los Rios', 1, 0),
(992, 62, 'MAN', 'Manab&iacute;', 1, 0),
(993, 62, 'MSA', 'Morona Santiago', 1, 0),
(994, 62, 'NAP', 'Napo', 1, 0),
(995, 62, 'ORE', 'Orellana', 1, 0),
(996, 62, 'PAS', 'Pastaza', 1, 0),
(997, 62, 'PIC', 'Pichincha', 1, 0),
(998, 62, 'SUC', 'Sucumb&iacute;os', 1, 0),
(999, 62, 'TUN', 'Tungurahua', 1, 0),
(1000, 62, 'ZCH', 'Zamora Chinchipe', 1, 0),
(1001, 63, 'DHY', 'Ad Daqahliyah', 1, 0),
(1002, 63, 'BAM', 'Al Bahr al Ahmar', 1, 0),
(1003, 63, 'BHY', 'Al Buhayrah', 1, 0),
(1004, 63, 'FYM', 'Al Fayyum', 1, 0),
(1005, 63, 'GBY', 'Al Gharbiyah', 1, 0),
(1006, 63, 'IDR', 'Al Iskandariyah', 1, 0),
(1007, 63, 'IML', 'Al Isma\'iliyah', 1, 0),
(1008, 63, 'JZH', 'Al Jizah', 1, 0),
(1009, 63, 'MFY', 'Al Minufiyah', 1, 0),
(1010, 63, 'MNY', 'Al Minya', 1, 0),
(1011, 63, 'QHR', 'Al Qahirah', 1, 0),
(1012, 63, 'QLY', 'Al Qalyubiyah', 1, 0),
(1013, 63, 'WJD', 'Al Wadi al Jadid', 1, 0),
(1014, 63, 'SHQ', 'Ash Sharqiyah', 1, 0),
(1015, 63, 'SWY', 'As Suways', 1, 0),
(1016, 63, 'ASW', 'Aswan', 1, 0),
(1017, 63, 'ASY', 'Asyut', 1, 0),
(1018, 63, 'BSW', 'Bani Suwayf', 1, 0),
(1019, 63, 'BSD', 'Bur Sa\'id', 1, 0),
(1020, 63, 'DMY', 'Dumyat', 1, 0),
(1021, 63, 'JNS', 'Janub Sina\'', 1, 0),
(1022, 63, 'KSH', 'Kafr ash Shaykh', 1, 0),
(1023, 63, 'MAT', 'Matruh', 1, 0),
(1024, 63, 'QIN', 'Qina', 1, 0),
(1025, 63, 'SHS', 'Shamal Sina\'', 1, 0),
(1026, 63, 'SUH', 'Suhaj', 1, 0),
(1027, 64, 'AH', 'Ahuachapan', 1, 0),
(1028, 64, 'CA', 'Cabanas', 1, 0),
(1029, 64, 'CH', 'Chalatenango', 1, 0),
(1030, 64, 'CU', 'Cuscatlan', 1, 0),
(1031, 64, 'LB', 'La Libertad', 1, 0),
(1032, 64, 'PZ', 'La Paz', 1, 0),
(1033, 64, 'UN', 'La Union', 1, 0),
(1034, 64, 'MO', 'Morazan', 1, 0),
(1035, 64, 'SM', 'San Miguel', 1, 0),
(1036, 64, 'SS', 'San Salvador', 1, 0),
(1037, 64, 'SV', 'San Vicente', 1, 0),
(1038, 64, 'SA', 'Santa Ana', 1, 0),
(1039, 64, 'SO', 'Sonsonate', 1, 0),
(1040, 64, 'US', 'Usulutan', 1, 0),
(1041, 65, 'AN', 'Provincia Annobon', 1, 0),
(1042, 65, 'BN', 'Provincia Bioko Norte', 1, 0),
(1043, 65, 'BS', 'Provincia Bioko Sur', 1, 0),
(1044, 65, 'CS', 'Provincia Centro Sur', 1, 0),
(1045, 65, 'KN', 'Provincia Kie-Ntem', 1, 0),
(1046, 65, 'LI', 'Provincia Litoral', 1, 0),
(1047, 65, 'WN', 'Provincia Wele-Nzas', 1, 0),
(1048, 66, 'MA', 'Central (Maekel)', 1, 0),
(1049, 66, 'KE', 'Anseba (Keren)', 1, 0),
(1050, 66, 'DK', 'Southern Red Sea (Debub-Keih-Bahri)', 1, 0),
(1051, 66, 'SK', 'Northern Red Sea (Semien-Keih-Bahri)', 1, 0),
(1052, 66, 'DE', 'Southern (Debub)', 1, 0),
(1053, 66, 'BR', 'Gash-Barka (Barentu)', 1, 0),
(1054, 67, 'HA', 'Harjumaa (Tallinn)', 1, 0),
(1055, 67, 'HI', 'Hiiumaa (Kardla)', 1, 0),
(1056, 67, 'IV', 'Ida-Virumaa (Johvi)', 1, 0),
(1057, 67, 'JA', 'Jarvamaa (Paide)', 1, 0),
(1058, 67, 'JO', 'Jogevamaa (Jogeva)', 1, 0),
(1059, 67, 'LV', 'Laane-Virumaa (Rakvere)', 1, 0),
(1060, 67, 'LA', 'Laanemaa (Haapsalu)', 1, 0),
(1061, 67, 'PA', 'Parnumaa (Parnu)', 1, 0),
(1062, 67, 'PO', 'Polvamaa (Polva)', 1, 0),
(1063, 67, 'RA', 'Raplamaa (Rapla)', 1, 0),
(1064, 67, 'SA', 'Saaremaa (Kuessaare)', 1, 0),
(1065, 67, 'TA', 'Tartumaa (Tartu)', 1, 0),
(1066, 67, 'VA', 'Valgamaa (Valga)', 1, 0),
(1067, 67, 'VI', 'Viljandimaa (Viljandi)', 1, 0),
(1068, 67, 'VO', 'Vorumaa (Voru)', 1, 0),
(1069, 68, 'AF', 'Afar', 1, 0),
(1070, 68, 'AH', 'Amhara', 1, 0),
(1071, 68, 'BG', 'Benishangul-Gumaz', 1, 0),
(1072, 68, 'GB', 'Gambela', 1, 0),
(1073, 68, 'HR', 'Hariai', 1, 0),
(1074, 68, 'OR', 'Oromia', 1, 0),
(1075, 68, 'SM', 'Somali', 1, 0),
(1076, 68, 'SN', 'Southern Nations - Nationalities and Peoples Region', 1, 0),
(1077, 68, 'TG', 'Tigray', 1, 0),
(1078, 68, 'AA', 'Addis Ababa', 1, 0),
(1079, 68, 'DD', 'Dire Dawa', 1, 0),
(1080, 71, 'C', 'Central Division', 1, 0),
(1081, 71, 'N', 'Northern Division', 1, 0),
(1082, 71, 'E', 'Eastern Division', 1, 0),
(1083, 71, 'W', 'Western Division', 1, 0),
(1084, 71, 'R', 'Rotuma', 1, 0),
(1085, 72, 'AL', 'Ahvenanmaan Laani', 1, 0),
(1086, 72, 'ES', 'Etela-Suomen Laani', 1, 0),
(1087, 72, 'IS', 'Ita-Suomen Laani', 1, 0),
(1088, 72, 'LS', 'Lansi-Suomen Laani', 1, 0),
(1089, 72, 'LA', 'Lapin Lanani', 1, 0),
(1090, 72, 'OU', 'Oulun Laani', 1, 0),
(1091, 73, 'AL', 'Alsace', 1, 0),
(1092, 73, 'AQ', 'Aquitaine', 1, 0),
(1093, 73, 'AU', 'Auvergne', 1, 0),
(1094, 73, 'BR', 'Brittany', 1, 0),
(1095, 73, 'BU', 'Burgundy', 1, 0),
(1096, 73, 'CE', 'Center Loire Valley', 1, 0),
(1097, 73, 'CH', 'Champagne', 1, 0),
(1098, 73, 'CO', 'Corse', 1, 0),
(1099, 73, 'FR', 'France Comte', 1, 0),
(1100, 73, 'LA', 'Languedoc Roussillon', 1, 0),
(1101, 73, 'LI', 'Limousin', 1, 0),
(1102, 73, 'LO', 'Lorraine', 1, 0),
(1103, 73, 'MI', 'Midi Pyrenees', 1, 0),
(1104, 73, 'NO', 'Nord Pas de Calais', 1, 0),
(1105, 73, 'NR', 'Normandy', 1, 0),
(1106, 73, 'PA', 'Paris / Ill de France', 1, 0),
(1107, 73, 'PI', 'Picardie', 1, 0),
(1108, 73, 'PO', 'Poitou Charente', 1, 0),
(1109, 73, 'PR', 'Provence', 1, 0),
(1110, 73, 'RH', 'Rhone Alps', 1, 0),
(1111, 73, 'RI', 'Riviera', 1, 0),
(1112, 73, 'WE', 'Western Loire Valley', 1, 0),
(1113, 74, 'Et', 'Etranger', 1, 0),
(1114, 74, '01', 'Ain', 1, 0),
(1115, 74, '02', 'Aisne', 1, 0),
(1116, 74, '03', 'Allier', 1, 0),
(1117, 74, '04', 'Alpes de Haute Provence', 1, 0),
(1118, 74, '05', 'Hautes-Alpes', 1, 0),
(1119, 74, '06', 'Alpes Maritimes', 1, 0),
(1120, 74, '07', 'Ard&egrave;che', 1, 0),
(1121, 74, '08', 'Ardennes', 1, 0),
(1122, 74, '09', 'Ari&egrave;ge', 1, 0),
(1123, 74, '10', 'Aube', 1, 0),
(1124, 74, '11', 'Aude', 1, 0),
(1125, 74, '12', 'Aveyron', 1, 0),
(1126, 74, '13', 'Bouches du Rh&ocirc;ne', 1, 0),
(1127, 74, '14', 'Calvados', 1, 0),
(1128, 74, '15', 'Cantal', 1, 0),
(1129, 74, '16', 'Charente', 1, 0),
(1130, 74, '17', 'Charente Maritime', 1, 0),
(1131, 74, '18', 'Cher', 1, 0),
(1132, 74, '19', 'Corr&egrave;ze', 1, 0),
(1133, 74, '2A', 'Corse du Sud', 1, 0),
(1134, 74, '2B', 'Haute Corse', 1, 0),
(1135, 74, '21', 'C&ocirc;te d&#039;or', 1, 0),
(1136, 74, '22', 'C&ocirc;tes d&#039;Armor', 1, 0),
(1137, 74, '23', 'Creuse', 1, 0),
(1138, 74, '24', 'Dordogne', 1, 0),
(1139, 74, '25', 'Doubs', 1, 0),
(1140, 74, '26', 'Dr&ocirc;me', 1, 0),
(1141, 74, '27', 'Eure', 1, 0),
(1142, 74, '28', 'Eure et Loir', 1, 0),
(1143, 74, '29', 'Finist&egrave;re', 1, 0),
(1144, 74, '30', 'Gard', 1, 0),
(1145, 74, '31', 'Haute Garonne', 1, 0),
(1146, 74, '32', 'Gers', 1, 0),
(1147, 74, '33', 'Gironde', 1, 0),
(1148, 74, '34', 'H&eacute;rault', 1, 0),
(1149, 74, '35', 'Ille et Vilaine', 1, 0),
(1150, 74, '36', 'Indre', 1, 0),
(1151, 74, '37', 'Indre et Loire', 1, 0),
(1152, 74, '38', 'Is&eacute;re', 1, 0),
(1153, 74, '39', 'Jura', 1, 0),
(1154, 74, '40', 'Landes', 1, 0),
(1155, 74, '41', 'Loir et Cher', 1, 0),
(1156, 74, '42', 'Loire', 1, 0),
(1157, 74, '43', 'Haute Loire', 1, 0),
(1158, 74, '44', 'Loire Atlantique', 1, 0),
(1159, 74, '45', 'Loiret', 1, 0),
(1160, 74, '46', 'Lot', 1, 0),
(1161, 74, '47', 'Lot et Garonne', 1, 0),
(1162, 74, '48', 'Loz&egrave;re', 1, 0),
(1163, 74, '49', 'Maine et Loire', 1, 0),
(1164, 74, '50', 'Manche', 1, 0),
(1165, 74, '51', 'Marne', 1, 0),
(1166, 74, '52', 'Haute Marne', 1, 0),
(1167, 74, '53', 'Mayenne', 1, 0),
(1168, 74, '54', 'Meurthe et Moselle', 1, 0),
(1169, 74, '55', 'Meuse', 1, 0),
(1170, 74, '56', 'Morbihan', 1, 0),
(1171, 74, '57', 'Moselle', 1, 0),
(1172, 74, '58', 'Ni&egrave;vre', 1, 0),
(1173, 74, '59', 'Nord', 1, 0),
(1174, 74, '60', 'Oise', 1, 0),
(1175, 74, '61', 'Orne', 1, 0),
(1176, 74, '62', 'Pas de Calais', 1, 0),
(1177, 74, '63', 'Puy de D&ocirc;me', 1, 0),
(1178, 74, '64', 'Pyr&eacute;n&eacute;es Atlantiques', 1, 0),
(1179, 74, '65', 'Hautes Pyr&eacute;n&eacute;es', 1, 0),
(1180, 74, '66', 'Pyr&eacute;n&eacute;es Orientales', 1, 0),
(1181, 74, '67', 'Bas Rhin', 1, 0),
(1182, 74, '68', 'Haut Rhin', 1, 0),
(1183, 74, '69', 'Rh&ocirc;ne', 1, 0),
(1184, 74, '70', 'Haute Sa&ocirc;ne', 1, 0),
(1185, 74, '71', 'Sa&ocirc;ne et Loire', 1, 0),
(1186, 74, '72', 'Sarthe', 1, 0),
(1187, 74, '73', 'Savoie', 1, 0),
(1188, 74, '74', 'Haute Savoie', 1, 0),
(1189, 74, '75', 'Paris', 1, 0),
(1190, 74, '76', 'Seine Maritime', 1, 0),
(1191, 74, '77', 'Seine et Marne', 1, 0),
(1192, 74, '78', 'Yvelines', 1, 0),
(1193, 74, '79', 'Deux S&egrave;vres', 1, 0),
(1194, 74, '80', 'Somme', 1, 0),
(1195, 74, '81', 'Tarn', 1, 0),
(1196, 74, '82', 'Tarn et Garonne', 1, 0),
(1197, 74, '83', 'Var', 1, 0),
(1198, 74, '84', 'Vaucluse', 1, 0),
(1199, 74, '85', 'Vend&eacute;e', 1, 0),
(1200, 74, '86', 'Vienne', 1, 0),
(1201, 74, '87', 'Haute Vienne', 1, 0),
(1202, 74, '88', 'Vosges', 1, 0),
(1203, 74, '89', 'Yonne', 1, 0),
(1204, 74, '90', 'Territoire de Belfort', 1, 0),
(1205, 74, '91', 'Essonne', 1, 0),
(1206, 74, '92', 'Hauts de Seine', 1, 0),
(1207, 74, '93', 'Seine St-Denis', 1, 0),
(1208, 74, '94', 'Val de Marne', 1, 0),
(1209, 74, '95', 'Val d\'Oise', 1, 0),
(1210, 76, 'M', 'Archipel des Marquises', 1, 0),
(1211, 76, 'T', 'Archipel des Tuamotu', 1, 0),
(1212, 76, 'I', 'Archipel des Tubuai', 1, 0),
(1213, 76, 'V', 'Iles du Vent', 1, 0),
(1214, 76, 'S', 'Iles Sous-le-Vent', 1, 0),
(1215, 77, 'C', 'Iles Crozet', 1, 0),
(1216, 77, 'K', 'Iles Kerguelen', 1, 0),
(1217, 77, 'A', 'Ile Amsterdam', 1, 0),
(1218, 77, 'P', 'Ile Saint-Paul', 1, 0),
(1219, 77, 'D', 'Adelie Land', 1, 0),
(1220, 78, 'ES', 'Estuaire', 1, 0),
(1221, 78, 'HO', 'Haut-Ogooue', 1, 0),
(1222, 78, 'MO', 'Moyen-Ogooue', 1, 0),
(1223, 78, 'NG', 'Ngounie', 1, 0),
(1224, 78, 'NY', 'Nyanga', 1, 0),
(1225, 78, 'OI', 'Ogooue-Ivindo', 1, 0),
(1226, 78, 'OL', 'Ogooue-Lolo', 1, 0),
(1227, 78, 'OM', 'Ogooue-Maritime', 1, 0),
(1228, 78, 'WN', 'Woleu-Ntem', 1, 0),
(1229, 79, 'BJ', 'Banjul', 1, 0),
(1230, 79, 'BS', 'Basse', 1, 0),
(1231, 79, 'BR', 'Brikama', 1, 0),
(1232, 79, 'JA', 'Janjangbure', 1, 0),
(1233, 79, 'KA', 'Kanifeng', 1, 0),
(1234, 79, 'KE', 'Kerewan', 1, 0),
(1235, 79, 'KU', 'Kuntaur', 1, 0),
(1236, 79, 'MA', 'Mansakonko', 1, 0),
(1237, 79, 'LR', 'Lower River', 1, 0),
(1238, 79, 'CR', 'Central River', 1, 0),
(1239, 79, 'NB', 'North Bank', 1, 0),
(1240, 79, 'UR', 'Upper River', 1, 0),
(1241, 79, 'WE', 'Western', 1, 0),
(1242, 80, 'AB', 'Abkhazia', 1, 0),
(1243, 80, 'AJ', 'Ajaria', 1, 0),
(1244, 80, 'TB', 'Tbilisi', 1, 0),
(1245, 80, 'GU', 'Guria', 1, 0),
(1246, 80, 'IM', 'Imereti', 1, 0),
(1247, 80, 'KA', 'Kakheti', 1, 0),
(1248, 80, 'KK', 'Kvemo Kartli', 1, 0),
(1249, 80, 'MM', 'Mtskheta-Mtianeti', 1, 0),
(1250, 80, 'RL', 'Racha Lechkhumi and Kvemo Svanet', 1, 0),
(1251, 80, 'SZ', 'Samegrelo-Zemo Svaneti', 1, 0),
(1252, 80, 'SJ', 'Samtskhe-Javakheti', 1, 0),
(1253, 80, 'SK', 'Shida Kartli', 1, 0),
(1254, 81, 'BAW', 'Baden-W&uuml;rttemberg', 1, 0),
(1255, 81, 'BAY', 'Bayern', 1, 0),
(1256, 81, 'BER', 'Berlin', 1, 0),
(1257, 81, 'BRG', 'Brandenburg', 1, 0),
(1258, 81, 'BRE', 'Bremen', 1, 0),
(1259, 81, 'HAM', 'Hamburg', 1, 0),
(1260, 81, 'HES', 'Hessen', 1, 0),
(1261, 81, 'MEC', 'Mecklenburg-Vorpommern', 1, 0),
(1262, 81, 'NDS', 'Niedersachsen', 1, 0),
(1263, 81, 'NRW', 'Nordrhein-Westfalen', 1, 0),
(1264, 81, 'RHE', 'Rheinland-Pfalz', 1, 0),
(1265, 81, 'SAR', 'Saarland', 1, 0),
(1266, 81, 'SAS', 'Sachsen', 1, 0),
(1267, 81, 'SAC', 'Sachsen-Anhalt', 1, 0),
(1268, 81, 'SCN', 'Schleswig-Holstein', 1, 0),
(1269, 81, 'THE', 'Th&uuml;ringen', 1, 0),
(1270, 82, 'AS', 'Ashanti Region', 1, 0),
(1271, 82, 'BA', 'Brong-Ahafo Region', 1, 0),
(1272, 82, 'CE', 'Central Region', 1, 0),
(1273, 82, 'EA', 'Eastern Region', 1, 0),
(1274, 82, 'GA', 'Greater Accra Region', 1, 0),
(1275, 82, 'NO', 'Northern Region', 1, 0),
(1276, 82, 'UE', 'Upper East Region', 1, 0),
(1277, 82, 'UW', 'Upper West Region', 1, 0),
(1278, 82, 'VO', 'Volta Region', 1, 0),
(1279, 82, 'WE', 'Western Region', 1, 0),
(1280, 84, 'AT', 'Attica', 1, 0),
(1281, 84, 'CN', 'Central Greece', 1, 0),
(1282, 84, 'CM', 'Central Macedonia', 1, 0),
(1283, 84, 'CR', 'Crete', 1, 0),
(1284, 84, 'EM', 'East Macedonia and Thrace', 1, 0),
(1285, 84, 'EP', 'Epirus', 1, 0),
(1286, 84, 'II', 'Ionian Islands', 1, 0),
(1287, 84, 'NA', 'North Aegean', 1, 0),
(1288, 84, 'PP', 'Peloponnesos', 1, 0),
(1289, 84, 'SA', 'South Aegean', 1, 0),
(1290, 84, 'TH', 'Thessaly', 1, 0),
(1291, 84, 'WG', 'West Greece', 1, 0),
(1292, 84, 'WM', 'West Macedonia', 1, 0),
(1293, 85, 'A', 'Avannaa', 1, 0),
(1294, 85, 'T', 'Tunu', 1, 0),
(1295, 85, 'K', 'Kitaa', 1, 0),
(1296, 86, 'A', 'Saint Andrew', 1, 0),
(1297, 86, 'D', 'Saint David', 1, 0),
(1298, 86, 'G', 'Saint George', 1, 0),
(1299, 86, 'J', 'Saint John', 1, 0),
(1300, 86, 'M', 'Saint Mark', 1, 0),
(1301, 86, 'P', 'Saint Patrick', 1, 0),
(1302, 86, 'C', 'Carriacou', 1, 0),
(1303, 86, 'Q', 'Petit Martinique', 1, 0),
(1304, 89, 'AV', 'Alta Verapaz', 1, 0),
(1305, 89, 'BV', 'Baja Verapaz', 1, 0),
(1306, 89, 'CM', 'Chimaltenango', 1, 0),
(1307, 89, 'CQ', 'Chiquimula', 1, 0),
(1308, 89, 'PE', 'El Peten', 1, 0),
(1309, 89, 'PR', 'El Progreso', 1, 0),
(1310, 89, 'QC', 'El Quiche', 1, 0),
(1311, 89, 'ES', 'Escuintla', 1, 0),
(1312, 89, 'GU', 'Guatemala', 1, 0),
(1313, 89, 'HU', 'Huehuetenango', 1, 0),
(1314, 89, 'IZ', 'Izabal', 1, 0),
(1315, 89, 'JA', 'Jalapa', 1, 0),
(1316, 89, 'JU', 'Jutiapa', 1, 0),
(1317, 89, 'QZ', 'Quetzaltenango', 1, 0),
(1318, 89, 'RE', 'Retalhuleu', 1, 0),
(1319, 89, 'ST', 'Sacatepequez', 1, 0),
(1320, 89, 'SM', 'San Marcos', 1, 0),
(1321, 89, 'SR', 'Santa Rosa', 1, 0),
(1322, 89, 'SO', 'Solola', 1, 0),
(1323, 89, 'SU', 'Suchitepequez', 1, 0),
(1324, 89, 'TO', 'Totonicapan', 1, 0),
(1325, 89, 'ZA', 'Zacapa', 1, 0),
(1326, 90, 'CNK', 'Conakry', 1, 0),
(1327, 90, 'BYL', 'Beyla', 1, 0),
(1328, 90, 'BFA', 'Boffa', 1, 0),
(1329, 90, 'BOK', 'Boke', 1, 0),
(1330, 90, 'COY', 'Coyah', 1, 0),
(1331, 90, 'DBL', 'Dabola', 1, 0),
(1332, 90, 'DLB', 'Dalaba', 1, 0),
(1333, 90, 'DGR', 'Dinguiraye', 1, 0),
(1334, 90, 'DBR', 'Dubreka', 1, 0),
(1335, 90, 'FRN', 'Faranah', 1, 0),
(1336, 90, 'FRC', 'Forecariah', 1, 0),
(1337, 90, 'FRI', 'Fria', 1, 0),
(1338, 90, 'GAO', 'Gaoual', 1, 0),
(1339, 90, 'GCD', 'Gueckedou', 1, 0),
(1340, 90, 'KNK', 'Kankan', 1, 0),
(1341, 90, 'KRN', 'Kerouane', 1, 0),
(1342, 90, 'KND', 'Kindia', 1, 0),
(1343, 90, 'KSD', 'Kissidougou', 1, 0),
(1344, 90, 'KBA', 'Koubia', 1, 0),
(1345, 90, 'KDA', 'Koundara', 1, 0),
(1346, 90, 'KRA', 'Kouroussa', 1, 0),
(1347, 90, 'LAB', 'Labe', 1, 0),
(1348, 90, 'LLM', 'Lelouma', 1, 0),
(1349, 90, 'LOL', 'Lola', 1, 0),
(1350, 90, 'MCT', 'Macenta', 1, 0),
(1351, 90, 'MAL', 'Mali', 1, 0),
(1352, 90, 'MAM', 'Mamou', 1, 0),
(1353, 90, 'MAN', 'Mandiana', 1, 0),
(1354, 90, 'NZR', 'Nzerekore', 1, 0),
(1355, 90, 'PIT', 'Pita', 1, 0),
(1356, 90, 'SIG', 'Siguiri', 1, 0),
(1357, 90, 'TLM', 'Telimele', 1, 0),
(1358, 90, 'TOG', 'Tougue', 1, 0),
(1359, 90, 'YOM', 'Yomou', 1, 0),
(1360, 91, 'BF', 'Bafata Region', 1, 0),
(1361, 91, 'BB', 'Biombo Region', 1, 0),
(1362, 91, 'BS', 'Bissau Region', 1, 0),
(1363, 91, 'BL', 'Bolama Region', 1, 0),
(1364, 91, 'CA', 'Cacheu Region', 1, 0),
(1365, 91, 'GA', 'Gabu Region', 1, 0),
(1366, 91, 'OI', 'Oio Region', 1, 0),
(1367, 91, 'QU', 'Quinara Region', 1, 0),
(1368, 91, 'TO', 'Tombali Region', 1, 0),
(1369, 92, 'BW', 'Barima-Waini', 1, 0),
(1370, 92, 'CM', 'Cuyuni-Mazaruni', 1, 0),
(1371, 92, 'DM', 'Demerara-Mahaica', 1, 0),
(1372, 92, 'EC', 'East Berbice-Corentyne', 1, 0),
(1373, 92, 'EW', 'Essequibo Islands-West Demerara', 1, 0),
(1374, 92, 'MB', 'Mahaica-Berbice', 1, 0),
(1375, 92, 'PM', 'Pomeroon-Supenaam', 1, 0),
(1376, 92, 'PI', 'Potaro-Siparuni', 1, 0),
(1377, 92, 'UD', 'Upper Demerara-Berbice', 1, 0),
(1378, 92, 'UT', 'Upper Takutu-Upper Essequibo', 1, 0),
(1379, 93, 'AR', 'Artibonite', 1, 0),
(1380, 93, 'CE', 'Centre', 1, 0),
(1381, 93, 'GA', 'Grand\'Anse', 1, 0),
(1382, 93, 'ND', 'Nord', 1, 0),
(1383, 93, 'NE', 'Nord-Est', 1, 0),
(1384, 93, 'NO', 'Nord-Ouest', 1, 0),
(1385, 93, 'OU', 'Ouest', 1, 0),
(1386, 93, 'SD', 'Sud', 1, 0),
(1387, 93, 'SE', 'Sud-Est', 1, 0),
(1388, 94, 'F', 'Flat Island', 1, 0),
(1389, 94, 'M', 'McDonald Island', 1, 0),
(1390, 94, 'S', 'Shag Island', 1, 0),
(1391, 94, 'H', 'Heard Island', 1, 0),
(1392, 95, 'AT', 'Atlantida', 1, 0),
(1393, 95, 'CH', 'Choluteca', 1, 0),
(1394, 95, 'CL', 'Colon', 1, 0),
(1395, 95, 'CM', 'Comayagua', 1, 0),
(1396, 95, 'CP', 'Copan', 1, 0),
(1397, 95, 'CR', 'Cortes', 1, 0),
(1398, 95, 'PA', 'El Paraiso', 1, 0),
(1399, 95, 'FM', 'Francisco Morazan', 1, 0),
(1400, 95, 'GD', 'Gracias a Dios', 1, 0),
(1401, 95, 'IN', 'Intibuca', 1, 0),
(1402, 95, 'IB', 'Islas de la Bahia (Bay Islands)', 1, 0),
(1403, 95, 'PZ', 'La Paz', 1, 0),
(1404, 95, 'LE', 'Lempira', 1, 0),
(1405, 95, 'OC', 'Ocotepeque', 1, 0),
(1406, 95, 'OL', 'Olancho', 1, 0),
(1407, 95, 'SB', 'Santa Barbara', 1, 0),
(1408, 95, 'VA', 'Valle', 1, 0),
(1409, 95, 'YO', 'Yoro', 1, 0),
(1410, 96, 'HCW', 'Central and Western Hong Kong Island', 1, 0),
(1411, 96, 'HEA', 'Eastern Hong Kong Island', 1, 0),
(1412, 96, 'HSO', 'Southern Hong Kong Island', 1, 0),
(1413, 96, 'HWC', 'Wan Chai Hong Kong Island', 1, 0),
(1414, 96, 'KKC', 'Kowloon City Kowloon', 1, 0),
(1415, 96, 'KKT', 'Kwun Tong Kowloon', 1, 0),
(1416, 96, 'KSS', 'Sham Shui Po Kowloon', 1, 0),
(1417, 96, 'KWT', 'Wong Tai Sin Kowloon', 1, 0),
(1418, 96, 'KYT', 'Yau Tsim Mong Kowloon', 1, 0),
(1419, 96, 'NIS', 'Islands New Territories', 1, 0),
(1420, 96, 'NKT', 'Kwai Tsing New Territories', 1, 0),
(1421, 96, 'NNO', 'North New Territories', 1, 0),
(1422, 96, 'NSK', 'Sai Kung New Territories', 1, 0),
(1423, 96, 'NST', 'Sha Tin New Territories', 1, 0),
(1424, 96, 'NTP', 'Tai Po New Territories', 1, 0);
INSERT INTO `#__j2store_zones` (`j2store_zone_id`, `country_id`, `zone_code`, `zone_name`, `enabled`, `ordering`) VALUES
(1425, 96, 'NTW', 'Tsuen Wan New Territories', 1, 0),
(1426, 96, 'NTM', 'Tuen Mun New Territories', 1, 0),
(1427, 96, 'NYL', 'Yuen Long New Territories', 1, 0),
(1428, 97, 'BK', 'Bacs-Kiskun', 1, 0),
(1429, 97, 'BA', 'Baranya', 1, 0),
(1430, 97, 'BE', 'Bekes', 1, 0),
(1431, 97, 'BS', 'Bekescsaba', 1, 0),
(1432, 97, 'BZ', 'Borsod-Abauj-Zemplen', 1, 0),
(1433, 97, 'BU', 'Budapest', 1, 0),
(1434, 97, 'CS', 'Csongrad', 1, 0),
(1435, 97, 'DE', 'Debrecen', 1, 0),
(1436, 97, 'DU', 'Dunaujvaros', 1, 0),
(1437, 97, 'EG', 'Eger', 1, 0),
(1438, 97, 'FE', 'Fejer', 1, 0),
(1439, 97, 'GY', 'Gyor', 1, 0),
(1440, 97, 'GM', 'Gyor-Moson-Sopron', 1, 0),
(1441, 97, 'HB', 'Hajdu-Bihar', 1, 0),
(1442, 97, 'HE', 'Heves', 1, 0),
(1443, 97, 'HO', 'Hodmezovasarhely', 1, 0),
(1444, 97, 'JN', 'Jasz-Nagykun-Szolnok', 1, 0),
(1445, 97, 'KA', 'Kaposvar', 1, 0),
(1446, 97, 'KE', 'Kecskemet', 1, 0),
(1447, 97, 'KO', 'Komarom-Esztergom', 1, 0),
(1448, 97, 'MI', 'Miskolc', 1, 0),
(1449, 97, 'NA', 'Nagykanizsa', 1, 0),
(1450, 97, 'NO', 'Nograd', 1, 0),
(1451, 97, 'NY', 'Nyiregyhaza', 1, 0),
(1452, 97, 'PE', 'Pecs', 1, 0),
(1453, 97, 'PS', 'Pest', 1, 0),
(1454, 97, 'SO', 'Somogy', 1, 0),
(1455, 97, 'SP', 'Sopron', 1, 0),
(1456, 97, 'SS', 'Szabolcs-Szatmar-Bereg', 1, 0),
(1457, 97, 'SZ', 'Szeged', 1, 0),
(1458, 97, 'SE', 'Szekesfehervar', 1, 0),
(1459, 97, 'SL', 'Szolnok', 1, 0),
(1460, 97, 'SM', 'Szombathely', 1, 0),
(1461, 97, 'TA', 'Tatabanya', 1, 0),
(1462, 97, 'TO', 'Tolna', 1, 0),
(1463, 97, 'VA', 'Vas', 1, 0),
(1464, 97, 'VE', 'Veszprem', 1, 0),
(1465, 97, 'ZA', 'Zala', 1, 0),
(1466, 97, 'ZZ', 'Zalaegerszeg', 1, 0),
(1467, 98, 'AL', 'Austurland', 1, 0),
(1468, 98, 'HF', 'Hofuoborgarsvaeoi', 1, 0),
(1469, 98, 'NE', 'Norourland eystra', 1, 0),
(1470, 98, 'NV', 'Norourland vestra', 1, 0),
(1471, 98, 'SL', 'Suourland', 1, 0),
(1472, 98, 'SN', 'Suournes', 1, 0),
(1473, 98, 'VF', 'Vestfiroir', 1, 0),
(1474, 98, 'VL', 'Vesturland', 1, 0),
(1475, 99, 'AN', 'Andaman and Nicobar Islands', 1, 0),
(1476, 99, 'AP', 'Andhra Pradesh', 1, 0),
(1477, 99, 'AR', 'Arunachal Pradesh', 1, 0),
(1478, 99, 'AS', 'Assam', 1, 0),
(1479, 99, 'BI', 'Bihar', 1, 0),
(1480, 99, 'CH', 'Chandigarh', 1, 0),
(1481, 99, 'DA', 'Dadra and Nagar Haveli', 1, 0),
(1482, 99, 'DM', 'Daman and Diu', 1, 0),
(1483, 99, 'DE', 'Delhi', 1, 0),
(1484, 99, 'GO', 'Goa', 1, 0),
(1485, 99, 'GU', 'Gujarat', 1, 0),
(1486, 99, 'HA', 'Haryana', 1, 0),
(1487, 99, 'HP', 'Himachal Pradesh', 1, 0),
(1488, 99, 'JA', 'Jammu and Kashmir', 1, 0),
(1489, 99, 'KA', 'Karnataka', 1, 0),
(1490, 99, 'KE', 'Kerala', 1, 0),
(1491, 99, 'LI', 'Lakshadweep Islands', 1, 0),
(1492, 99, 'MP', 'Madhya Pradesh', 1, 0),
(1493, 99, 'MA', 'Maharashtra', 1, 0),
(1494, 99, 'MN', 'Manipur', 1, 0),
(1495, 99, 'ME', 'Meghalaya', 1, 0),
(1496, 99, 'MI', 'Mizoram', 1, 0),
(1497, 99, 'NA', 'Nagaland', 1, 0),
(1498, 99, 'OR', 'Orissa', 1, 0),
(1499, 99, 'PO', 'Pondicherry', 1, 0),
(1500, 99, 'PU', 'Punjab', 1, 0),
(1501, 99, 'RA', 'Rajasthan', 1, 0),
(1502, 99, 'SI', 'Sikkim', 1, 0),
(1503, 99, 'TN', 'Tamil Nadu', 1, 0),
(1504, 99, 'TR', 'Tripura', 1, 0),
(1505, 99, 'UP', 'Uttar Pradesh', 1, 0),
(1506, 99, 'WB', 'West Bengal', 1, 0),
(1507, 100, 'AC', 'Aceh', 1, 0),
(1508, 100, 'BA', 'Bali', 1, 0),
(1509, 100, 'BT', 'Banten', 1, 0),
(1510, 100, 'BE', 'Bengkulu', 1, 0),
(1511, 100, 'BD', 'BoDeTaBek', 1, 0),
(1512, 100, 'GO', 'Gorontalo', 1, 0),
(1513, 100, 'JK', 'Jakarta Raya', 1, 0),
(1514, 100, 'JA', 'Jambi', 1, 0),
(1515, 100, 'JB', 'Jawa Barat', 1, 0),
(1516, 100, 'JT', 'Jawa Tengah', 1, 0),
(1517, 100, 'JI', 'Jawa Timur', 1, 0),
(1518, 100, 'KB', 'Kalimantan Barat', 1, 0),
(1519, 100, 'KS', 'Kalimantan Selatan', 1, 0),
(1520, 100, 'KT', 'Kalimantan Tengah', 1, 0),
(1521, 100, 'KI', 'Kalimantan Timur', 1, 0),
(1522, 100, 'BB', 'Kepulauan Bangka Belitung', 1, 0),
(1523, 100, 'LA', 'Lampung', 1, 0),
(1524, 100, 'MA', 'Maluku', 1, 0),
(1525, 100, 'MU', 'Maluku Utara', 1, 0),
(1526, 100, 'NB', 'Nusa Tenggara Barat', 1, 0),
(1527, 100, 'NT', 'Nusa Tenggara Timur', 1, 0),
(1528, 100, 'PA', 'Papua', 1, 0),
(1529, 100, 'RI', 'Riau', 1, 0),
(1530, 100, 'SN', 'Sulawesi Selatan', 1, 0),
(1531, 100, 'ST', 'Sulawesi Tengah', 1, 0),
(1532, 100, 'SG', 'Sulawesi Tenggara', 1, 0),
(1533, 100, 'SA', 'Sulawesi Utara', 1, 0),
(1534, 100, 'SB', 'Sumatera Barat', 1, 0),
(1535, 100, 'SS', 'Sumatera Selatan', 1, 0),
(1536, 100, 'SU', 'Sumatera Utara', 1, 0),
(1537, 100, 'YO', 'Yogyakarta', 1, 0),
(1538, 101, 'TEH', 'Tehran', 1, 0),
(1539, 101, 'QOM', 'Qom', 1, 0),
(1540, 101, 'MKZ', 'Markazi', 1, 0),
(1541, 101, 'QAZ', 'Qazvin', 1, 0),
(1542, 101, 'GIL', 'Gilan', 1, 0),
(1543, 101, 'ARD', 'Ardabil', 1, 0),
(1544, 101, 'ZAN', 'Zanjan', 1, 0),
(1545, 101, 'EAZ', 'East Azarbaijan', 1, 0),
(1546, 101, 'WEZ', 'West Azarbaijan', 1, 0),
(1547, 101, 'KRD', 'Kurdistan', 1, 0),
(1548, 101, 'HMD', 'Hamadan', 1, 0),
(1549, 101, 'KRM', 'Kermanshah', 1, 0),
(1550, 101, 'ILM', 'Ilam', 1, 0),
(1551, 101, 'LRS', 'Lorestan', 1, 0),
(1552, 101, 'KZT', 'Khuzestan', 1, 0),
(1553, 101, 'CMB', 'Chahar Mahaal and Bakhtiari', 1, 0),
(1554, 101, 'KBA', 'Kohkiluyeh and Buyer Ahmad', 1, 0),
(1555, 101, 'BSH', 'Bushehr', 1, 0),
(1556, 101, 'FAR', 'Fars', 1, 0),
(1557, 101, 'HRM', 'Hormozgan', 1, 0),
(1558, 101, 'SBL', 'Sistan and Baluchistan', 1, 0),
(1559, 101, 'KRB', 'Kerman', 1, 0),
(1560, 101, 'YZD', 'Yazd', 1, 0),
(1561, 101, 'EFH', 'Esfahan', 1, 0),
(1562, 101, 'SMN', 'Semnan', 1, 0),
(1563, 101, 'MZD', 'Mazandaran', 1, 0),
(1564, 101, 'GLS', 'Golestan', 1, 0),
(1565, 101, 'NKH', 'North Khorasan', 1, 0),
(1566, 101, 'RKH', 'Razavi Khorasan', 1, 0),
(1567, 101, 'SKH', 'South Khorasan', 1, 0),
(1568, 102, 'BD', 'Baghdad', 1, 0),
(1569, 102, 'SD', 'Salah ad Din', 1, 0),
(1570, 102, 'DY', 'Diyala', 1, 0),
(1571, 102, 'WS', 'Wasit', 1, 0),
(1572, 102, 'MY', 'Maysan', 1, 0),
(1573, 102, 'BA', 'Al Basrah', 1, 0),
(1574, 102, 'DQ', 'Dhi Qar', 1, 0),
(1575, 102, 'MU', 'Al Muthanna', 1, 0),
(1576, 102, 'QA', 'Al Qadisyah', 1, 0),
(1577, 102, 'BB', 'Babil', 1, 0),
(1578, 102, 'KB', 'Al Karbala', 1, 0),
(1579, 102, 'NJ', 'An Najaf', 1, 0),
(1580, 102, 'AB', 'Al Anbar', 1, 0),
(1581, 102, 'NN', 'Ninawa', 1, 0),
(1582, 102, 'DH', 'Dahuk', 1, 0),
(1583, 102, 'AL', 'Arbil', 1, 0),
(1584, 102, 'TM', 'At Ta\'mim', 1, 0),
(1585, 102, 'SL', 'As Sulaymaniyah', 1, 0),
(1586, 103, 'CA', 'Carlow', 1, 0),
(1587, 103, 'CV', 'Cavan', 1, 0),
(1588, 103, 'CL', 'Clare', 1, 0),
(1589, 103, 'CO', 'Cork', 1, 0),
(1590, 103, 'DO', 'Donegal', 1, 0),
(1591, 103, 'DU', 'Dublin', 1, 0),
(1592, 103, 'GA', 'Galway', 1, 0),
(1593, 103, 'KE', 'Kerry', 1, 0),
(1594, 103, 'KI', 'Kildare', 1, 0),
(1595, 103, 'KL', 'Kilkenny', 1, 0),
(1596, 103, 'LA', 'Laois', 1, 0),
(1597, 103, 'LE', 'Leitrim', 1, 0),
(1598, 103, 'LI', 'Limerick', 1, 0),
(1599, 103, 'LO', 'Longford', 1, 0),
(1600, 103, 'LU', 'Louth', 1, 0),
(1601, 103, 'MA', 'Mayo', 1, 0),
(1602, 103, 'ME', 'Meath', 1, 0),
(1603, 103, 'MO', 'Monaghan', 1, 0),
(1604, 103, 'OF', 'Offaly', 1, 0),
(1605, 103, 'RO', 'Roscommon', 1, 0),
(1606, 103, 'SL', 'Sligo', 1, 0),
(1607, 103, 'TI', 'Tipperary', 1, 0),
(1608, 103, 'WA', 'Waterford', 1, 0),
(1609, 103, 'WE', 'Westmeath', 1, 0),
(1610, 103, 'WX', 'Wexford', 1, 0),
(1611, 103, 'WI', 'Wicklow', 1, 0),
(1612, 104, 'BS', 'Be\'er Sheva', 1, 0),
(1613, 104, 'BH', 'Bika\'at Hayarden', 1, 0),
(1614, 104, 'EA', 'Eilat and Arava', 1, 0),
(1615, 104, 'GA', 'Galil', 1, 0),
(1616, 104, 'HA', 'Haifa', 1, 0),
(1617, 104, 'JM', 'Jehuda Mountains', 1, 0),
(1618, 104, 'JE', 'Jerusalem', 1, 0),
(1619, 104, 'NE', 'Negev', 1, 0),
(1620, 104, 'SE', 'Semaria', 1, 0),
(1621, 104, 'SH', 'Sharon', 1, 0),
(1622, 104, 'TA', 'Tel Aviv (Gosh Dan)', 1, 0),
(1643, 106, 'CLA', 'Clarendon Parish', 1, 0),
(1644, 106, 'HAN', 'Hanover Parish', 1, 0),
(1645, 106, 'KIN', 'Kingston Parish', 1, 0),
(1646, 106, 'MAN', 'Manchester Parish', 1, 0),
(1647, 106, 'POR', 'Portland Parish', 1, 0),
(1648, 106, 'AND', 'Saint Andrew Parish', 1, 0),
(1649, 106, 'ANN', 'Saint Ann Parish', 1, 0),
(1650, 106, 'CAT', 'Saint Catherine Parish', 1, 0),
(1651, 106, 'ELI', 'Saint Elizabeth Parish', 1, 0),
(1652, 106, 'JAM', 'Saint James Parish', 1, 0),
(1653, 106, 'MAR', 'Saint Mary Parish', 1, 0),
(1654, 106, 'THO', 'Saint Thomas Parish', 1, 0),
(1655, 106, 'TRL', 'Trelawny Parish', 1, 0),
(1656, 106, 'WML', 'Westmoreland Parish', 1, 0),
(1657, 107, 'AI', 'Aichi', 1, 0),
(1658, 107, 'AK', 'Akita', 1, 0),
(1659, 107, 'AO', 'Aomori', 1, 0),
(1660, 107, 'CH', 'Chiba', 1, 0),
(1661, 107, 'EH', 'Ehime', 1, 0),
(1662, 107, 'FK', 'Fukui', 1, 0),
(1663, 107, 'FU', 'Fukuoka', 1, 0),
(1664, 107, 'FS', 'Fukushima', 1, 0),
(1665, 107, 'GI', 'Gifu', 1, 0),
(1666, 107, 'GU', 'Gumma', 1, 0),
(1667, 107, 'HI', 'Hiroshima', 1, 0),
(1668, 107, 'HO', 'Hokkaido', 1, 0),
(1669, 107, 'HY', 'Hyogo', 1, 0),
(1670, 107, 'IB', 'Ibaraki', 1, 0),
(1671, 107, 'IS', 'Ishikawa', 1, 0),
(1672, 107, 'IW', 'Iwate', 1, 0),
(1673, 107, 'KA', 'Kagawa', 1, 0),
(1674, 107, 'KG', 'Kagoshima', 1, 0),
(1675, 107, 'KN', 'Kanagawa', 1, 0),
(1676, 107, 'KO', 'Kochi', 1, 0),
(1677, 107, 'KU', 'Kumamoto', 1, 0),
(1678, 107, 'KY', 'Kyoto', 1, 0),
(1679, 107, 'MI', 'Mie', 1, 0),
(1680, 107, 'MY', 'Miyagi', 1, 0),
(1681, 107, 'MZ', 'Miyazaki', 1, 0),
(1682, 107, 'NA', 'Nagano', 1, 0),
(1683, 107, 'NG', 'Nagasaki', 1, 0),
(1684, 107, 'NR', 'Nara', 1, 0),
(1685, 107, 'NI', 'Niigata', 1, 0),
(1686, 107, 'OI', 'Oita', 1, 0),
(1687, 107, 'OK', 'Okayama', 1, 0),
(1688, 107, 'ON', 'Okinawa', 1, 0),
(1689, 107, 'OS', 'Osaka', 1, 0),
(1690, 107, 'SA', 'Saga', 1, 0),
(1691, 107, 'SI', 'Saitama', 1, 0),
(1692, 107, 'SH', 'Shiga', 1, 0),
(1693, 107, 'SM', 'Shimane', 1, 0),
(1694, 107, 'SZ', 'Shizuoka', 1, 0),
(1695, 107, 'TO', 'Tochigi', 1, 0),
(1696, 107, 'TS', 'Tokushima', 1, 0),
(1697, 107, 'TK', 'Tokyo', 1, 0),
(1698, 107, 'TT', 'Tottori', 1, 0),
(1699, 107, 'TY', 'Toyama', 1, 0),
(1700, 107, 'WA', 'Wakayama', 1, 0),
(1701, 107, 'YA', 'Yamagata', 1, 0),
(1702, 107, 'YM', 'Yamaguchi', 1, 0),
(1703, 107, 'YN', 'Yamanashi', 1, 0),
(1704, 108, 'AM', '\'Amman', 1, 0),
(1705, 108, 'AJ', 'Ajlun', 1, 0),
(1706, 108, 'AA', 'Al \'Aqabah', 1, 0),
(1707, 108, 'AB', 'Al Balqa\'', 1, 0),
(1708, 108, 'AK', 'Al Karak', 1, 0),
(1709, 108, 'AL', 'Al Mafraq', 1, 0),
(1710, 108, 'AT', 'At Tafilah', 1, 0),
(1711, 108, 'AZ', 'Az Zarqa\'', 1, 0),
(1712, 108, 'IR', 'Irbid', 1, 0),
(1713, 108, 'JA', 'Jarash', 1, 0),
(1714, 108, 'MA', 'Ma\'an', 1, 0),
(1715, 108, 'MD', 'Madaba', 1, 0),
(1716, 109, 'AL', 'Almaty', 1, 0),
(1717, 109, 'AC', 'Almaty City', 1, 0),
(1718, 109, 'AM', 'Aqmola', 1, 0),
(1719, 109, 'AQ', 'Aqtobe', 1, 0),
(1720, 109, 'AS', 'Astana City', 1, 0),
(1721, 109, 'AT', 'Atyrau', 1, 0),
(1722, 109, 'BA', 'Batys Qazaqstan', 1, 0),
(1723, 109, 'BY', 'Bayqongyr City', 1, 0),
(1724, 109, 'MA', 'Mangghystau', 1, 0),
(1725, 109, 'ON', 'Ongtustik Qazaqstan', 1, 0),
(1726, 109, 'PA', 'Pavlodar', 1, 0),
(1727, 109, 'QA', 'Qaraghandy', 1, 0),
(1728, 109, 'QO', 'Qostanay', 1, 0),
(1729, 109, 'QY', 'Qyzylorda', 1, 0),
(1730, 109, 'SH', 'Shyghys Qazaqstan', 1, 0),
(1731, 109, 'SO', 'Soltustik Qazaqstan', 1, 0),
(1732, 109, 'ZH', 'Zhambyl', 1, 0),
(1733, 110, 'CE', 'Central', 1, 0),
(1734, 110, 'CO', 'Coast', 1, 0),
(1735, 110, 'EA', 'Eastern', 1, 0),
(1736, 110, 'NA', 'Nairobi Area', 1, 0),
(1737, 110, 'NE', 'North Eastern', 1, 0),
(1738, 110, 'NY', 'Nyanza', 1, 0),
(1739, 110, 'RV', 'Rift Valley', 1, 0),
(1740, 110, 'WE', 'Western', 1, 0),
(1741, 111, 'AG', 'Abaiang', 1, 0),
(1742, 111, 'AM', 'Abemama', 1, 0),
(1743, 111, 'AK', 'Aranuka', 1, 0),
(1744, 111, 'AO', 'Arorae', 1, 0),
(1745, 111, 'BA', 'Banaba', 1, 0),
(1746, 111, 'BE', 'Beru', 1, 0),
(1747, 111, 'bT', 'Butaritari', 1, 0),
(1748, 111, 'KA', 'Kanton', 1, 0),
(1749, 111, 'KR', 'Kiritimati', 1, 0),
(1750, 111, 'KU', 'Kuria', 1, 0),
(1751, 111, 'MI', 'Maiana', 1, 0),
(1752, 111, 'MN', 'Makin', 1, 0),
(1753, 111, 'ME', 'Marakei', 1, 0),
(1754, 111, 'NI', 'Nikunau', 1, 0),
(1755, 111, 'NO', 'Nonouti', 1, 0),
(1756, 111, 'ON', 'Onotoa', 1, 0),
(1757, 111, 'TT', 'Tabiteuea', 1, 0),
(1758, 111, 'TR', 'Tabuaeran', 1, 0),
(1759, 111, 'TM', 'Tamana', 1, 0),
(1760, 111, 'TW', 'Tarawa', 1, 0),
(1761, 111, 'TE', 'Teraina', 1, 0),
(1762, 112, 'CHA', 'Chagang-do', 1, 0),
(1763, 112, 'HAB', 'Hamgyong-bukto', 1, 0),
(1764, 112, 'HAN', 'Hamgyong-namdo', 1, 0),
(1765, 112, 'HWB', 'Hwanghae-bukto', 1, 0),
(1766, 112, 'HWN', 'Hwanghae-namdo', 1, 0),
(1767, 112, 'KAN', 'Kangwon-do', 1, 0),
(1768, 112, 'PYB', 'P\'yongan-bukto', 1, 0),
(1769, 112, 'PYN', 'P\'yongan-namdo', 1, 0),
(1770, 112, 'YAN', 'Ryanggang-do (Yanggang-do)', 1, 0),
(1771, 112, 'NAJ', 'Rason Directly Governed City', 1, 0),
(1772, 112, 'PYO', 'P\'yongyang Special City', 1, 0),
(1773, 113, 'CO', 'Ch\'ungch\'ong-bukto', 1, 0),
(1774, 113, 'CH', 'Ch\'ungch\'ong-namdo', 1, 0),
(1775, 113, 'CD', 'Cheju-do', 1, 0),
(1776, 113, 'CB', 'Cholla-bukto', 1, 0),
(1777, 113, 'CN', 'Cholla-namdo', 1, 0),
(1778, 113, 'IG', 'Inch\'on-gwangyoksi', 1, 0),
(1779, 113, 'KA', 'Kangwon-do', 1, 0),
(1780, 113, 'KG', 'Kwangju-gwangyoksi', 1, 0),
(1781, 113, 'KD', 'Kyonggi-do', 1, 0),
(1782, 113, 'KB', 'Kyongsang-bukto', 1, 0),
(1783, 113, 'KN', 'Kyongsang-namdo', 1, 0),
(1784, 113, 'PG', 'Pusan-gwangyoksi', 1, 0),
(1785, 113, 'SO', 'Soul-t\'ukpyolsi', 1, 0),
(1786, 113, 'TA', 'Taegu-gwangyoksi', 1, 0),
(1787, 113, 'TG', 'Taejon-gwangyoksi', 1, 0),
(1788, 114, 'AL', 'Al \'Asimah', 1, 0),
(1789, 114, 'AA', 'Al Ahmadi', 1, 0),
(1790, 114, 'AF', 'Al Farwaniyah', 1, 0),
(1791, 114, 'AJ', 'Al Jahra\'', 1, 0),
(1792, 114, 'HA', 'Hawalli', 1, 0),
(1793, 115, 'GB', 'Bishkek', 1, 0),
(1794, 115, 'B', 'Batken', 1, 0),
(1795, 115, 'C', 'Chu', 1, 0),
(1796, 115, 'J', 'Jalal-Abad', 1, 0),
(1797, 115, 'N', 'Naryn', 1, 0),
(1798, 115, 'O', 'Osh', 1, 0),
(1799, 115, 'T', 'Talas', 1, 0),
(1800, 115, 'Y', 'Ysyk-Kol', 1, 0),
(1801, 116, 'VT', 'Vientiane', 1, 0),
(1802, 116, 'AT', 'Attapu', 1, 0),
(1803, 116, 'BK', 'Bokeo', 1, 0),
(1804, 116, 'BL', 'Bolikhamxai', 1, 0),
(1805, 116, 'CH', 'Champasak', 1, 0),
(1806, 116, 'HO', 'Houaphan', 1, 0),
(1807, 116, 'KH', 'Khammouan', 1, 0),
(1808, 116, 'LM', 'Louang Namtha', 1, 0),
(1809, 116, 'LP', 'Louangphabang', 1, 0),
(1810, 116, 'OU', 'Oudomxai', 1, 0),
(1811, 116, 'PH', 'Phongsali', 1, 0),
(1812, 116, 'SL', 'Salavan', 1, 0),
(1813, 116, 'SV', 'Savannakhet', 1, 0),
(1814, 116, 'VI', 'Vientiane', 1, 0),
(1815, 116, 'XA', 'Xaignabouli', 1, 0),
(1816, 116, 'XE', 'Xekong', 1, 0),
(1817, 116, 'XI', 'Xiangkhoang', 1, 0),
(1818, 116, 'XN', 'Xaisomboun', 1, 0),
(1819, 117, 'AIZ', 'Aizkraukles Rajons', 1, 0),
(1820, 117, 'ALU', 'Aluksnes Rajons', 1, 0),
(1821, 117, 'BAL', 'Balvu Rajons', 1, 0),
(1822, 117, 'BAU', 'Bauskas Rajons', 1, 0),
(1823, 117, 'CES', 'Cesu Rajons', 1, 0),
(1824, 117, 'DGR', 'Daugavpils Rajons', 1, 0),
(1825, 117, 'DOB', 'Dobeles Rajons', 1, 0),
(1826, 117, 'GUL', 'Gulbenes Rajons', 1, 0),
(1827, 117, 'JEK', 'Jekabpils Rajons', 1, 0),
(1828, 117, 'JGR', 'Jelgavas Rajons', 1, 0),
(1829, 117, 'KRA', 'Kraslavas Rajons', 1, 0),
(1830, 117, 'KUL', 'Kuldigas Rajons', 1, 0),
(1831, 117, 'LPR', 'Liepajas Rajons', 1, 0),
(1832, 117, 'LIM', 'Limbazu Rajons', 1, 0),
(1833, 117, 'LUD', 'Ludzas Rajons', 1, 0),
(1834, 117, 'MAD', 'Madonas Rajons', 1, 0),
(1835, 117, 'OGR', 'Ogres Rajons', 1, 0),
(1836, 117, 'PRE', 'Preilu Rajons', 1, 0),
(1837, 117, 'RZR', 'Rezeknes Rajons', 1, 0),
(1838, 117, 'RGR', 'Rigas Rajons', 1, 0),
(1839, 117, 'SAL', 'Saldus Rajons', 1, 0),
(1840, 117, 'TAL', 'Talsu Rajons', 1, 0),
(1841, 117, 'TUK', 'Tukuma Rajons', 1, 0),
(1842, 117, 'VLK', 'Valkas Rajons', 1, 0),
(1843, 117, 'VLM', 'Valmieras Rajons', 1, 0),
(1844, 117, 'VSR', 'Ventspils Rajons', 1, 0),
(1845, 117, 'DGV', 'Daugavpils', 1, 0),
(1846, 117, 'JGV', 'Jelgava', 1, 0),
(1847, 117, 'JUR', 'Jurmala', 1, 0),
(1848, 117, 'LPK', 'Liepaja', 1, 0),
(1849, 117, 'RZK', 'Rezekne', 1, 0),
(1850, 117, 'RGA', 'Riga', 1, 0),
(1851, 117, 'VSL', 'Ventspils', 1, 0),
(1852, 119, 'BE', 'Berea', 1, 0),
(1853, 119, 'BB', 'Butha-Buthe', 1, 0),
(1854, 119, 'LE', 'Leribe', 1, 0),
(1855, 119, 'MF', 'Mafeteng', 1, 0),
(1856, 119, 'MS', 'Maseru', 1, 0),
(1857, 119, 'MH', 'Mohale\'s Hoek', 1, 0),
(1858, 119, 'MK', 'Mokhotlong', 1, 0),
(1859, 119, 'QN', 'Qacha\'s Nek', 1, 0),
(1860, 119, 'QT', 'Quthing', 1, 0),
(1861, 119, 'TT', 'Thaba-Tseka', 1, 0),
(1862, 120, 'BI', 'Bomi', 1, 0),
(1863, 120, 'BG', 'Bong', 1, 0),
(1864, 120, 'GB', 'Grand Bassa', 1, 0),
(1865, 120, 'CM', 'Grand Cape Mount', 1, 0),
(1866, 120, 'GG', 'Grand Gedeh', 1, 0),
(1867, 120, 'GK', 'Grand Kru', 1, 0),
(1868, 120, 'LO', 'Lofa', 1, 0),
(1869, 120, 'MG', 'Margibi', 1, 0),
(1870, 120, 'ML', 'Maryland', 1, 0),
(1871, 120, 'MS', 'Montserrado', 1, 0),
(1872, 120, 'NB', 'Nimba', 1, 0),
(1873, 120, 'RC', 'River Cess', 1, 0),
(1874, 120, 'SN', 'Sinoe', 1, 0),
(1875, 121, 'AJ', 'Ajdabiya', 1, 0),
(1876, 121, 'AZ', 'Al \'Aziziyah', 1, 0),
(1877, 121, 'FA', 'Al Fatih', 1, 0),
(1878, 121, 'JA', 'Al Jabal al Akhdar', 1, 0),
(1879, 121, 'JU', 'Al Jufrah', 1, 0),
(1880, 121, 'KH', 'Al Khums', 1, 0),
(1881, 121, 'KU', 'Al Kufrah', 1, 0),
(1882, 121, 'NK', 'An Nuqat al Khams', 1, 0),
(1883, 121, 'AS', 'Ash Shati\'', 1, 0),
(1884, 121, 'AW', 'Awbari', 1, 0),
(1885, 121, 'ZA', 'Az Zawiyah', 1, 0),
(1886, 121, 'BA', 'Banghazi', 1, 0),
(1887, 121, 'DA', 'Darnah', 1, 0),
(1888, 121, 'GD', 'Ghadamis', 1, 0),
(1889, 121, 'GY', 'Gharyan', 1, 0),
(1890, 121, 'MI', 'Misratah', 1, 0),
(1891, 121, 'MZ', 'Murzuq', 1, 0),
(1892, 121, 'SB', 'Sabha', 1, 0),
(1893, 121, 'SW', 'Sawfajjin', 1, 0),
(1894, 121, 'SU', 'Surt', 1, 0),
(1895, 121, 'TL', 'Tarabulus (Tripoli)', 1, 0),
(1896, 121, 'TH', 'Tarhunah', 1, 0),
(1897, 121, 'TU', 'Tubruq', 1, 0),
(1898, 121, 'YA', 'Yafran', 1, 0),
(1899, 121, 'ZL', 'Zlitan', 1, 0),
(1900, 122, 'V', 'Vaduz', 1, 0),
(1901, 122, 'A', 'Schaan', 1, 0),
(1902, 122, 'B', 'Balzers', 1, 0),
(1903, 122, 'N', 'Triesen', 1, 0),
(1904, 122, 'E', 'Eschen', 1, 0),
(1905, 122, 'M', 'Mauren', 1, 0),
(1906, 122, 'T', 'Triesenberg', 1, 0),
(1907, 122, 'R', 'Ruggell', 1, 0),
(1908, 122, 'G', 'Gamprin', 1, 0),
(1909, 122, 'L', 'Schellenberg', 1, 0),
(1910, 122, 'P', 'Planken', 1, 0),
(1911, 123, 'AL', 'Alytus', 1, 0),
(1912, 123, 'KA', 'Kaunas', 1, 0),
(1913, 123, 'KL', 'Klaipeda', 1, 0),
(1914, 123, 'MA', 'Marijampole', 1, 0),
(1915, 123, 'PA', 'Panevezys', 1, 0),
(1916, 123, 'SI', 'Siauliai', 1, 0),
(1917, 123, 'TA', 'Taurage', 1, 0),
(1918, 123, 'TE', 'Telsiai', 1, 0),
(1919, 123, 'UT', 'Utena', 1, 0),
(1920, 123, 'VI', 'Vilnius', 1, 0),
(1921, 124, 'DD', 'Diekirch', 1, 0),
(1922, 124, 'DC', 'Clervaux', 1, 0),
(1923, 124, 'DR', 'Redange', 1, 0),
(1924, 124, 'DV', 'Vianden', 1, 0),
(1925, 124, 'DW', 'Wiltz', 1, 0),
(1926, 124, 'GG', 'Grevenmacher', 1, 0),
(1927, 124, 'GE', 'Echternach', 1, 0),
(1928, 124, 'GR', 'Remich', 1, 0),
(1929, 124, 'LL', 'Luxembourg', 1, 0),
(1930, 124, 'LC', 'Capellen', 1, 0),
(1931, 124, 'LE', 'Esch-sur-Alzette', 1, 0),
(1932, 124, 'LM', 'Mersch', 1, 0),
(1933, 125, 'OLF', 'Our Lady Fatima Parish', 1, 0),
(1934, 125, 'ANT', 'St. Anthony Parish', 1, 0),
(1935, 125, 'LAZ', 'St. Lazarus Parish', 1, 0),
(1936, 125, 'CAT', 'Cathedral Parish', 1, 0),
(1937, 125, 'LAW', 'St. Lawrence Parish', 1, 0),
(1938, 127, 'AN', 'Antananarivo', 1, 0),
(1939, 127, 'AS', 'Antsiranana', 1, 0),
(1940, 127, 'FN', 'Fianarantsoa', 1, 0),
(1941, 127, 'MJ', 'Mahajanga', 1, 0),
(1942, 127, 'TM', 'Toamasina', 1, 0),
(1943, 127, 'TL', 'Toliara', 1, 0),
(1944, 128, 'BLK', 'Balaka', 1, 0),
(1945, 128, 'BLT', 'Blantyre', 1, 0),
(1946, 128, 'CKW', 'Chikwawa', 1, 0),
(1947, 128, 'CRD', 'Chiradzulu', 1, 0),
(1948, 128, 'CTP', 'Chitipa', 1, 0),
(1949, 128, 'DDZ', 'Dedza', 1, 0),
(1950, 128, 'DWA', 'Dowa', 1, 0),
(1951, 128, 'KRG', 'Karonga', 1, 0),
(1952, 128, 'KSG', 'Kasungu', 1, 0),
(1953, 128, 'LKM', 'Likoma', 1, 0),
(1954, 128, 'LLG', 'Lilongwe', 1, 0),
(1955, 128, 'MCG', 'Machinga', 1, 0),
(1956, 128, 'MGC', 'Mangochi', 1, 0),
(1957, 128, 'MCH', 'Mchinji', 1, 0),
(1958, 128, 'MLJ', 'Mulanje', 1, 0),
(1959, 128, 'MWZ', 'Mwanza', 1, 0),
(1960, 128, 'MZM', 'Mzimba', 1, 0),
(1961, 128, 'NTU', 'Ntcheu', 1, 0),
(1962, 128, 'NKB', 'Nkhata Bay', 1, 0),
(1963, 128, 'NKH', 'Nkhotakota', 1, 0),
(1964, 128, 'NSJ', 'Nsanje', 1, 0),
(1965, 128, 'NTI', 'Ntchisi', 1, 0),
(1966, 128, 'PHL', 'Phalombe', 1, 0),
(1967, 128, 'RMP', 'Rumphi', 1, 0),
(1968, 128, 'SLM', 'Salima', 1, 0),
(1969, 128, 'THY', 'Thyolo', 1, 0),
(1970, 128, 'ZBA', 'Zomba', 1, 0),
(1971, 129, 'JO', 'Johor', 1, 0),
(1972, 129, 'KE', 'Kedah', 1, 0),
(1973, 129, 'KL', 'Kelantan', 1, 0),
(1974, 129, 'LA', 'Labuan', 1, 0),
(1975, 129, 'ME', 'Melaka', 1, 0),
(1976, 129, 'NS', 'Negeri Sembilan', 1, 0),
(1977, 129, 'PA', 'Pahang', 1, 0),
(1978, 129, 'PE', 'Perak', 1, 0),
(1979, 129, 'PR', 'Perlis', 1, 0),
(1980, 129, 'PP', 'Pulau Pinang', 1, 0),
(1981, 129, 'SA', 'Sabah', 1, 0),
(1982, 129, 'SR', 'Sarawak', 1, 0),
(1983, 129, 'SE', 'Selangor', 1, 0),
(1984, 129, 'TE', 'Terengganu', 1, 0),
(1985, 129, 'WP', 'Wilayah Persekutuan', 1, 0),
(1986, 130, 'THU', 'Thiladhunmathi Uthuru', 1, 0),
(1987, 130, 'THD', 'Thiladhunmathi Dhekunu', 1, 0),
(1988, 130, 'MLU', 'Miladhunmadulu Uthuru', 1, 0),
(1989, 130, 'MLD', 'Miladhunmadulu Dhekunu', 1, 0),
(1990, 130, 'MAU', 'Maalhosmadulu Uthuru', 1, 0),
(1991, 130, 'MAD', 'Maalhosmadulu Dhekunu', 1, 0),
(1992, 130, 'FAA', 'Faadhippolhu', 1, 0),
(1993, 130, 'MAA', 'Male Atoll', 1, 0),
(1994, 130, 'AAU', 'Ari Atoll Uthuru', 1, 0),
(1995, 130, 'AAD', 'Ari Atoll Dheknu', 1, 0),
(1996, 130, 'FEA', 'Felidhe Atoll', 1, 0),
(1997, 130, 'MUA', 'Mulaku Atoll', 1, 0),
(1998, 130, 'NAU', 'Nilandhe Atoll Uthuru', 1, 0),
(1999, 130, 'NAD', 'Nilandhe Atoll Dhekunu', 1, 0),
(2000, 130, 'KLH', 'Kolhumadulu', 1, 0),
(2001, 130, 'HDH', 'Hadhdhunmathi', 1, 0),
(2002, 130, 'HAU', 'Huvadhu Atoll Uthuru', 1, 0),
(2003, 130, 'HAD', 'Huvadhu Atoll Dhekunu', 1, 0),
(2004, 130, 'FMU', 'Fua Mulaku', 1, 0),
(2005, 130, 'ADD', 'Addu', 1, 0),
(2006, 131, 'GA', 'Gao', 1, 0),
(2007, 131, 'KY', 'Kayes', 1, 0),
(2008, 131, 'KD', 'Kidal', 1, 0),
(2009, 131, 'KL', 'Koulikoro', 1, 0),
(2010, 131, 'MP', 'Mopti', 1, 0),
(2011, 131, 'SG', 'Segou', 1, 0),
(2012, 131, 'SK', 'Sikasso', 1, 0),
(2013, 131, 'TB', 'Tombouctou', 1, 0),
(2014, 131, 'CD', 'Bamako Capital District', 1, 0),
(2015, 132, 'ATT', 'Attard', 1, 0),
(2016, 132, 'BAL', 'Balzan', 1, 0),
(2017, 132, 'BGU', 'Birgu', 1, 0),
(2018, 132, 'BKK', 'Birkirkara', 1, 0),
(2019, 132, 'BRZ', 'Birzebbuga', 1, 0),
(2020, 132, 'BOR', 'Bormla', 1, 0),
(2021, 132, 'DIN', 'Dingli', 1, 0),
(2022, 132, 'FGU', 'Fgura', 1, 0),
(2023, 132, 'FLO', 'Floriana', 1, 0),
(2024, 132, 'GDJ', 'Gudja', 1, 0),
(2025, 132, 'GZR', 'Gzira', 1, 0),
(2026, 132, 'GRG', 'Gargur', 1, 0),
(2027, 132, 'GXQ', 'Gaxaq', 1, 0),
(2028, 132, 'HMR', 'Hamrun', 1, 0),
(2029, 132, 'IKL', 'Iklin', 1, 0),
(2030, 132, 'ISL', 'Isla', 1, 0),
(2031, 132, 'KLK', 'Kalkara', 1, 0),
(2032, 132, 'KRK', 'Kirkop', 1, 0),
(2033, 132, 'LIJ', 'Lija', 1, 0),
(2034, 132, 'LUQ', 'Luqa', 1, 0),
(2035, 132, 'MRS', 'Marsa', 1, 0),
(2036, 132, 'MKL', 'Marsaskala', 1, 0),
(2037, 132, 'MXL', 'Marsaxlokk', 1, 0),
(2038, 132, 'MDN', 'Mdina', 1, 0),
(2039, 132, 'MEL', 'Melliea', 1, 0),
(2040, 132, 'MGR', 'Mgarr', 1, 0),
(2041, 132, 'MST', 'Mosta', 1, 0),
(2042, 132, 'MQA', 'Mqabba', 1, 0),
(2043, 132, 'MSI', 'Msida', 1, 0),
(2044, 132, 'MTF', 'Mtarfa', 1, 0),
(2045, 132, 'NAX', 'Naxxar', 1, 0),
(2046, 132, 'PAO', 'Paola', 1, 0),
(2047, 132, 'PEM', 'Pembroke', 1, 0),
(2048, 132, 'PIE', 'Pieta', 1, 0),
(2049, 132, 'QOR', 'Qormi', 1, 0),
(2050, 132, 'QRE', 'Qrendi', 1, 0),
(2051, 132, 'RAB', 'Rabat', 1, 0),
(2052, 132, 'SAF', 'Safi', 1, 0),
(2053, 132, 'SGI', 'San Giljan', 1, 0),
(2054, 132, 'SLU', 'Santa Lucija', 1, 0),
(2055, 132, 'SPB', 'San Pawl il-Bahar', 1, 0),
(2056, 132, 'SGW', 'San Gwann', 1, 0),
(2057, 132, 'SVE', 'Santa Venera', 1, 0),
(2058, 132, 'SIG', 'Siggiewi', 1, 0),
(2059, 132, 'SLM', 'Sliema', 1, 0),
(2060, 132, 'SWQ', 'Swieqi', 1, 0),
(2061, 132, 'TXB', 'Ta Xbiex', 1, 0),
(2062, 132, 'TRX', 'Tarxien', 1, 0),
(2063, 132, 'VLT', 'Valletta', 1, 0),
(2064, 132, 'XGJ', 'Xgajra', 1, 0),
(2065, 132, 'ZBR', 'Zabbar', 1, 0),
(2066, 132, 'ZBG', 'Zebbug', 1, 0),
(2067, 132, 'ZJT', 'Zejtun', 1, 0),
(2068, 132, 'ZRQ', 'Zurrieq', 1, 0),
(2069, 132, 'FNT', 'Fontana', 1, 0),
(2070, 132, 'GHJ', 'Ghajnsielem', 1, 0),
(2071, 132, 'GHR', 'Gharb', 1, 0),
(2072, 132, 'GHS', 'Ghasri', 1, 0),
(2073, 132, 'KRC', 'Kercem', 1, 0),
(2074, 132, 'MUN', 'Munxar', 1, 0),
(2075, 132, 'NAD', 'Nadur', 1, 0),
(2076, 132, 'QAL', 'Qala', 1, 0),
(2077, 132, 'VIC', 'Victoria', 1, 0),
(2078, 132, 'SLA', 'San Lawrenz', 1, 0),
(2079, 132, 'SNT', 'Sannat', 1, 0),
(2080, 132, 'ZAG', 'Xagra', 1, 0),
(2081, 132, 'XEW', 'Xewkija', 1, 0),
(2082, 132, 'ZEB', 'Zebbug', 1, 0),
(2083, 133, 'ALG', 'Ailinginae', 1, 0),
(2084, 133, 'ALL', 'Ailinglaplap', 1, 0),
(2085, 133, 'ALK', 'Ailuk', 1, 0),
(2086, 133, 'ARN', 'Arno', 1, 0),
(2087, 133, 'AUR', 'Aur', 1, 0),
(2088, 133, 'BKR', 'Bikar', 1, 0),
(2089, 133, 'BKN', 'Bikini', 1, 0),
(2090, 133, 'BKK', 'Bokak', 1, 0),
(2091, 133, 'EBN', 'Ebon', 1, 0),
(2092, 133, 'ENT', 'Enewetak', 1, 0),
(2093, 133, 'EKB', 'Erikub', 1, 0),
(2094, 133, 'JBT', 'Jabat', 1, 0),
(2095, 133, 'JLT', 'Jaluit', 1, 0),
(2096, 133, 'JEM', 'Jemo', 1, 0),
(2097, 133, 'KIL', 'Kili', 1, 0),
(2098, 133, 'KWJ', 'Kwajalein', 1, 0),
(2099, 133, 'LAE', 'Lae', 1, 0),
(2100, 133, 'LIB', 'Lib', 1, 0),
(2101, 133, 'LKP', 'Likiep', 1, 0),
(2102, 133, 'MJR', 'Majuro', 1, 0),
(2103, 133, 'MLP', 'Maloelap', 1, 0),
(2104, 133, 'MJT', 'Mejit', 1, 0),
(2105, 133, 'MIL', 'Mili', 1, 0),
(2106, 133, 'NMK', 'Namorik', 1, 0),
(2107, 133, 'NAM', 'Namu', 1, 0),
(2108, 133, 'RGL', 'Rongelap', 1, 0),
(2109, 133, 'RGK', 'Rongrik', 1, 0),
(2110, 133, 'TOK', 'Toke', 1, 0),
(2111, 133, 'UJA', 'Ujae', 1, 0),
(2112, 133, 'UJL', 'Ujelang', 1, 0),
(2113, 133, 'UTK', 'Utirik', 1, 0),
(2114, 133, 'WTH', 'Wotho', 1, 0),
(2115, 133, 'WTJ', 'Wotje', 1, 0),
(2116, 135, 'AD', 'Adrar', 1, 0),
(2117, 135, 'AS', 'Assaba', 1, 0),
(2118, 135, 'BR', 'Brakna', 1, 0),
(2119, 135, 'DN', 'Dakhlet Nouadhibou', 1, 0),
(2120, 135, 'GO', 'Gorgol', 1, 0),
(2121, 135, 'GM', 'Guidimaka', 1, 0),
(2122, 135, 'HC', 'Hodh Ech Chargui', 1, 0),
(2123, 135, 'HG', 'Hodh El Gharbi', 1, 0),
(2124, 135, 'IN', 'Inchiri', 1, 0),
(2125, 135, 'TA', 'Tagant', 1, 0),
(2126, 135, 'TZ', 'Tiris Zemmour', 1, 0),
(2127, 135, 'TR', 'Trarza', 1, 0),
(2128, 135, 'NO', 'Nouakchott', 1, 0),
(2129, 136, 'BR', 'Beau Bassin-Rose Hill', 1, 0),
(2130, 136, 'CU', 'Curepipe', 1, 0),
(2131, 136, 'PU', 'Port Louis', 1, 0),
(2132, 136, 'QB', 'Quatre Bornes', 1, 0),
(2133, 136, 'VP', 'Vacoas-Phoenix', 1, 0),
(2134, 136, 'AG', 'Agalega Islands', 1, 0),
(2135, 136, 'CC', 'Cargados Cara#_ Shoals (Saint Brandon Islands)', 1, 0),
(2136, 136, 'RO', 'Rodrigues', 1, 0),
(2137, 136, 'BL', 'Black River', 1, 0),
(2138, 136, 'FL', 'Flacq', 1, 0),
(2139, 136, 'GP', 'Grand Port', 1, 0),
(2140, 136, 'MO', 'Moka', 1, 0),
(2141, 136, 'PA', 'Pamplemousses', 1, 0),
(2142, 136, 'PW', 'Plaines Wilhems', 1, 0),
(2143, 136, 'PL', 'Port Louis', 1, 0),
(2144, 136, 'RR', 'Riviere du Rempart', 1, 0),
(2145, 136, 'SA', 'Savanne', 1, 0),
(2146, 138, 'BA', 'Baja California Norte', 1, 0),
(2147, 138, 'BJ', 'Baja California Sur', 1, 0),
(2148, 138, 'CE', 'Campeche', 1, 0),
(2149, 138, 'CI', 'Chiapas', 1, 0),
(2150, 138, 'CH', 'Chihuahua', 1, 0),
(2151, 138, 'CU', 'Coahuila de Zaragoza', 1, 0),
(2152, 138, 'CL', 'Colima', 1, 0),
(2153, 138, 'DF', 'Distrito Federal', 1, 0),
(2154, 138, 'DO', 'Durango', 1, 0),
(2155, 138, 'GX', 'Guanajuato', 1, 0),
(2156, 138, 'GR', 'Guerrero', 1, 0),
(2157, 138, 'HL', 'Hidalgo', 1, 0),
(2158, 138, 'JL', 'Jalisco', 1, 0),
(2159, 138, 'MX', 'Estado de México', 1, 0),
(2160, 138, 'MC', 'Michoacan de Ocampo', 1, 0),
(2161, 138, 'MR', 'Morelos', 1, 0),
(2162, 138, 'NA', 'Nayarit', 1, 0),
(2163, 138, 'NN', 'Nuevo Leon', 1, 0),
(2164, 138, 'OA', 'Oaxaca', 1, 0),
(2165, 138, 'PU', 'Puebla', 1, 0),
(2166, 138, 'QU', 'Queretaro de Arteaga', 1, 0),
(2167, 138, 'QR', 'Quintana Roo', 1, 0),
(2168, 138, 'SL', 'San Luis Potosi', 1, 0),
(2169, 138, 'SI', 'Sinaloa', 1, 0),
(2170, 138, 'SO', 'Sonora', 1, 0),
(2171, 138, 'TB', 'Tabasco', 1, 0),
(2172, 138, 'TA', 'Tamaulipas', 1, 0),
(2173, 138, 'TL', 'Tlaxcala', 1, 0),
(2174, 138, 'VC', 'Veracruz-Llave', 1, 0),
(2175, 138, 'YU', 'Yucatan', 1, 0),
(2176, 138, 'ZA', 'Zacatecas', 1, 0),
(2177, 139, 'C', 'Chuuk', 1, 0),
(2178, 139, 'K', 'Kosrae', 1, 0),
(2179, 139, 'P', 'Pohnpei', 1, 0),
(2180, 139, 'Y', 'Yap', 1, 0),
(2181, 140, 'GA', 'Gagauzia', 1, 0),
(2182, 140, 'CU', 'Chisinau', 1, 0),
(2183, 140, 'BA', 'Balti', 1, 0),
(2184, 140, 'CA', 'Cahul', 1, 0),
(2185, 140, 'ED', 'Edinet', 1, 0),
(2186, 140, 'LA', 'Lapusna', 1, 0),
(2187, 140, 'OR', 'Orhei', 1, 0),
(2188, 140, 'SO', 'Soroca', 1, 0),
(2189, 140, 'TI', 'Tighina', 1, 0),
(2190, 140, 'UN', 'Ungheni', 1, 0),
(2191, 140, 'SN', 'Stînga Nistrului', 1, 0),
(2192, 141, 'FV', 'Fontvieille', 1, 0),
(2193, 141, 'LC', 'La Condamine', 1, 0),
(2194, 141, 'MV', 'Monaco-Ville', 1, 0),
(2195, 141, 'MC', 'Monte-Carlo', 1, 0),
(2196, 142, '1', 'Ulanbaatar', 1, 0),
(2197, 142, '035', 'Orhon', 1, 0),
(2198, 142, '037', 'Darhan uul', 1, 0),
(2199, 142, '039', 'Hentiy', 1, 0),
(2200, 142, '041', 'Hovsgol', 1, 0),
(2201, 142, '043', 'Hovd', 1, 0),
(2202, 142, '046', 'Uvs', 1, 0),
(2203, 142, '047', 'Tov', 1, 0),
(2204, 142, '049', 'Selenge', 1, 0),
(2205, 142, '051', 'Suhbaatar', 1, 0),
(2206, 142, '053', 'Omnogovi', 1, 0),
(2207, 142, '055', 'Ovorhangay', 1, 0),
(2208, 142, '057', 'Dzavhan', 1, 0),
(2209, 142, '059', 'DundgovL', 1, 0),
(2210, 142, '061', 'Dornod', 1, 0),
(2211, 142, '063', 'Dornogov', 1, 0),
(2212, 142, '064', 'Govi-Sumber', 1, 0),
(2213, 142, '065', 'Govi-Altay', 1, 0),
(2214, 142, '067', 'Bulgan', 1, 0),
(2215, 142, '069', 'Bayanhongor', 1, 0),
(2216, 142, '071', 'Bayan-Olgiy', 1, 0),
(2217, 142, '073', 'Arhangay', 1, 0),
(2218, 143, 'A', 'Saint Anthony', 1, 0),
(2219, 143, 'G', 'Saint Georges', 1, 0),
(2220, 143, 'P', 'Saint Peter', 1, 0),
(2221, 144, 'AGD', 'Agadir', 1, 0),
(2222, 144, 'HOC', 'Al Hoceima', 1, 0),
(2223, 144, 'AZI', 'Azilal', 1, 0),
(2224, 144, 'BME', 'Beni Mellal', 1, 0),
(2225, 144, 'BSL', 'Ben Slimane', 1, 0),
(2226, 144, 'BLM', 'Boulemane', 1, 0),
(2227, 144, 'CBL', 'Casablanca', 1, 0),
(2228, 144, 'CHA', 'Chaouen', 1, 0),
(2229, 144, 'EJA', 'El Jadida', 1, 0),
(2230, 144, 'EKS', 'El Kelaa des Sraghna', 1, 0),
(2231, 144, 'ERA', 'Er Rachidia', 1, 0),
(2232, 144, 'ESS', 'Essaouira', 1, 0),
(2233, 144, 'FES', 'Fes', 1, 0),
(2234, 144, 'FIG', 'Figuig', 1, 0),
(2235, 144, 'GLM', 'Guelmim', 1, 0),
(2236, 144, 'IFR', 'Ifrane', 1, 0),
(2237, 144, 'KEN', 'Kenitra', 1, 0),
(2238, 144, 'KHM', 'Khemisset', 1, 0),
(2239, 144, 'KHN', 'Khenifra', 1, 0),
(2240, 144, 'KHO', 'Khouribga', 1, 0),
(2241, 144, 'LYN', 'Laayoune', 1, 0),
(2242, 144, 'LAR', 'Larache', 1, 0),
(2243, 144, 'MRK', 'Marrakech', 1, 0),
(2244, 144, 'MKN', 'Meknes', 1, 0),
(2245, 144, 'NAD', 'Nador', 1, 0),
(2246, 144, 'ORZ', 'Ouarzazate', 1, 0),
(2247, 144, 'OUJ', 'Oujda', 1, 0),
(2248, 144, 'RSA', 'Rabat-Sale', 1, 0),
(2249, 144, 'SAF', 'Safi', 1, 0),
(2250, 144, 'SET', 'Settat', 1, 0),
(2251, 144, 'SKA', 'Sidi Kacem', 1, 0),
(2252, 144, 'TGR', 'Tangier', 1, 0),
(2253, 144, 'TAN', 'Tan-Tan', 1, 0),
(2254, 144, 'TAO', 'Taounate', 1, 0),
(2255, 144, 'TRD', 'Taroudannt', 1, 0),
(2256, 144, 'TAT', 'Tata', 1, 0),
(2257, 144, 'TAZ', 'Taza', 1, 0),
(2258, 144, 'TET', 'Tetouan', 1, 0),
(2259, 144, 'TIZ', 'Tiznit', 1, 0),
(2260, 144, 'ADK', 'Ad Dakhla', 1, 0),
(2261, 144, 'BJD', 'Boujdour', 1, 0),
(2262, 144, 'ESM', 'Es Smara', 1, 0),
(2263, 145, 'CD', 'Cabo Delgado', 1, 0),
(2264, 145, 'GZ', 'Gaza', 1, 0),
(2265, 145, 'IN', 'Inhambane', 1, 0),
(2266, 145, 'MN', 'Manica', 1, 0),
(2267, 145, 'MC', 'Maputo (city)', 1, 0),
(2268, 145, 'MP', 'Maputo', 1, 0),
(2269, 145, 'NA', 'Nampula', 1, 0),
(2270, 145, 'NI', 'Niassa', 1, 0),
(2271, 145, 'SO', 'Sofala', 1, 0),
(2272, 145, 'TE', 'Tete', 1, 0),
(2273, 145, 'ZA', 'Zambezia', 1, 0),
(2274, 146, 'AY', 'Ayeyarwady', 1, 0),
(2275, 146, 'BG', 'Bago', 1, 0),
(2276, 146, 'MG', 'Magway', 1, 0),
(2277, 146, 'MD', 'Mandalay', 1, 0),
(2278, 146, 'SG', 'Sagaing', 1, 0),
(2279, 146, 'TN', 'Tanintharyi', 1, 0),
(2280, 146, 'YG', 'Yangon', 1, 0),
(2281, 146, 'CH', 'Chin State', 1, 0),
(2282, 146, 'KC', 'Kachin State', 1, 0),
(2283, 146, 'KH', 'Kayah State', 1, 0),
(2284, 146, 'KN', 'Kayin State', 1, 0),
(2285, 146, 'MN', 'Mon State', 1, 0),
(2286, 146, 'RK', 'Rakhine State', 1, 0),
(2287, 146, 'SH', 'Shan State', 1, 0),
(2288, 147, 'CA', 'Caprivi', 1, 0),
(2289, 147, 'ER', 'Erongo', 1, 0),
(2290, 147, 'HA', 'Hardap', 1, 0),
(2291, 147, 'KR', 'Karas', 1, 0),
(2292, 147, 'KV', 'Kavango', 1, 0),
(2293, 147, 'KH', 'Khomas', 1, 0),
(2294, 147, 'KU', 'Kunene', 1, 0),
(2295, 147, 'OW', 'Ohangwena', 1, 0),
(2296, 147, 'OK', 'Omaheke', 1, 0),
(2297, 147, 'OT', 'Omusati', 1, 0),
(2298, 147, 'ON', 'Oshana', 1, 0),
(2299, 147, 'OO', 'Oshikoto', 1, 0),
(2300, 147, 'OJ', 'Otjozondjupa', 1, 0),
(2301, 148, 'AO', 'Aiwo', 1, 0),
(2302, 148, 'AA', 'Anabar', 1, 0),
(2303, 148, 'AT', 'Anetan', 1, 0),
(2304, 148, 'AI', 'Anibare', 1, 0),
(2305, 148, 'BA', 'Baiti', 1, 0),
(2306, 148, 'BO', 'Boe', 1, 0),
(2307, 148, 'BU', 'Buada', 1, 0),
(2308, 148, 'DE', 'Denigomodu', 1, 0),
(2309, 148, 'EW', 'Ewa', 1, 0),
(2310, 148, 'IJ', 'Ijuw', 1, 0),
(2311, 148, 'ME', 'Meneng', 1, 0),
(2312, 148, 'NI', 'Nibok', 1, 0),
(2313, 148, 'UA', 'Uaboe', 1, 0),
(2314, 148, 'YA', 'Yaren', 1, 0),
(2315, 149, 'BA', 'Bagmati', 1, 0),
(2316, 149, 'BH', 'Bheri', 1, 0),
(2317, 149, 'DH', 'Dhawalagiri', 1, 0),
(2318, 149, 'GA', 'Gandaki', 1, 0),
(2319, 149, 'JA', 'Janakpur', 1, 0),
(2320, 149, 'KA', 'Karnali', 1, 0),
(2321, 149, 'KO', 'Kosi', 1, 0),
(2322, 149, 'LU', 'Lumbini', 1, 0),
(2323, 149, 'MA', 'Mahakali', 1, 0),
(2324, 149, 'ME', 'Mechi', 1, 0),
(2325, 149, 'NA', 'Narayani', 1, 0),
(2326, 149, 'RA', 'Rapti', 1, 0),
(2327, 149, 'SA', 'Sagarmatha', 1, 0),
(2328, 149, 'SE', 'Seti', 1, 0),
(2329, 150, 'DR', 'Drenthe', 1, 0),
(2330, 150, 'FL', 'Flevoland', 1, 0),
(2331, 150, 'FR', 'Friesland', 1, 0),
(2332, 150, 'GE', 'Gelderland', 1, 0),
(2333, 150, 'GR', 'Groningen', 1, 0),
(2334, 150, 'LI', 'Limburg', 1, 0),
(2335, 150, 'NB', 'Noord Brabant', 1, 0),
(2336, 150, 'NH', 'Noord Holland', 1, 0),
(2337, 150, 'OV', 'Overijssel', 1, 0),
(2338, 150, 'UT', 'Utrecht', 1, 0),
(2339, 150, 'ZE', 'Zeeland', 1, 0),
(2340, 150, 'ZH', 'Zuid Holland', 1, 0),
(2341, 152, 'L', 'Iles Loyaute', 1, 0),
(2342, 152, 'N', 'Nord', 1, 0),
(2343, 152, 'S', 'Sud', 1, 0),
(2344, 153, 'AUK', 'Auckland', 1, 0),
(2345, 153, 'BOP', 'Bay of Plenty', 1, 0),
(2346, 153, 'CAN', 'Canterbury', 1, 0),
(2347, 153, 'COR', 'Coromandel', 1, 0),
(2348, 153, 'GIS', 'Gisborne', 1, 0),
(2349, 153, 'FIO', 'Fiordland', 1, 0),
(2350, 153, 'HKB', 'Hawke\'s Bay', 1, 0),
(2351, 153, 'MBH', 'Marlborough', 1, 0),
(2352, 153, 'MWT', 'Manawatu-Wanganui', 1, 0),
(2353, 153, 'MCM', 'Mt Cook-Mackenzie', 1, 0),
(2354, 153, 'NSN', 'Nelson', 1, 0),
(2355, 153, 'NTL', 'Northland', 1, 0),
(2356, 153, 'OTA', 'Otago', 1, 0),
(2357, 153, 'STL', 'Southland', 1, 0),
(2358, 153, 'TKI', 'Taranaki', 1, 0),
(2359, 153, 'WGN', 'Wellington', 1, 0),
(2360, 153, 'WKO', 'Waikato', 1, 0),
(2361, 153, 'WAI', 'Wairprarapa', 1, 0),
(2362, 153, 'WTC', 'West Coast', 1, 0),
(2363, 154, 'AN', 'Atlantico Norte', 1, 0),
(2364, 154, 'AS', 'Atlantico Sur', 1, 0),
(2365, 154, 'BO', 'Boaco', 1, 0),
(2366, 154, 'CA', 'Carazo', 1, 0),
(2367, 154, 'CI', 'Chinandega', 1, 0),
(2368, 154, 'CO', 'Chontales', 1, 0),
(2369, 154, 'ES', 'Esteli', 1, 0),
(2370, 154, 'GR', 'Granada', 1, 0),
(2371, 154, 'JI', 'Jinotega', 1, 0),
(2372, 154, 'LE', 'Leon', 1, 0),
(2373, 154, 'MD', 'Madriz', 1, 0),
(2374, 154, 'MN', 'Managua', 1, 0),
(2375, 154, 'MS', 'Masaya', 1, 0),
(2376, 154, 'MT', 'Matagalpa', 1, 0),
(2377, 154, 'NS', 'Nuevo Segovia', 1, 0),
(2378, 154, 'RS', 'Rio San Juan', 1, 0),
(2379, 154, 'RI', 'Rivas', 1, 0),
(2380, 155, 'AG', 'Agadez', 1, 0),
(2381, 155, 'DF', 'Diffa', 1, 0),
(2382, 155, 'DS', 'Dosso', 1, 0),
(2383, 155, 'MA', 'Maradi', 1, 0),
(2384, 155, 'NM', 'Niamey', 1, 0),
(2385, 155, 'TH', 'Tahoua', 1, 0),
(2386, 155, 'TL', 'Tillaberi', 1, 0),
(2387, 155, 'ZD', 'Zinder', 1, 0),
(2388, 156, 'AB', 'Abia', 1, 0),
(2389, 156, 'CT', 'Abuja Federal Capital Territory', 1, 0),
(2390, 156, 'AD', 'Adamawa', 1, 0),
(2391, 156, 'AK', 'Akwa Ibom', 1, 0),
(2392, 156, 'AN', 'Anambra', 1, 0),
(2393, 156, 'BC', 'Bauchi', 1, 0),
(2394, 156, 'BY', 'Bayelsa', 1, 0),
(2395, 156, 'BN', 'Benue', 1, 0),
(2396, 156, 'BO', 'Borno', 1, 0),
(2397, 156, 'CR', 'Cross River', 1, 0),
(2398, 156, 'DE', 'Delta', 1, 0),
(2399, 156, 'EB', 'Ebonyi', 1, 0),
(2400, 156, 'ED', 'Edo', 1, 0),
(2401, 156, 'EK', 'Ekiti', 1, 0),
(2402, 156, 'EN', 'Enugu', 1, 0),
(2403, 156, 'GO', 'Gombe', 1, 0),
(2404, 156, 'IM', 'Imo', 1, 0),
(2405, 156, 'JI', 'Jigawa', 1, 0),
(2406, 156, 'KD', 'Kaduna', 1, 0),
(2407, 156, 'KN', 'Kano', 1, 0),
(2408, 156, 'KT', 'Katsina', 1, 0),
(2409, 156, 'KE', 'Kebbi', 1, 0),
(2410, 156, 'KO', 'Kogi', 1, 0),
(2411, 156, 'KW', 'Kwara', 1, 0),
(2412, 156, 'LA', 'Lagos', 1, 0),
(2413, 156, 'NA', 'Nassarawa', 1, 0),
(2414, 156, 'NI', 'Niger', 1, 0),
(2415, 156, 'OG', 'Ogun', 1, 0),
(2416, 156, 'ONG', 'Ondo', 1, 0),
(2417, 156, 'OS', 'Osun', 1, 0),
(2418, 156, 'OY', 'Oyo', 1, 0),
(2419, 156, 'PL', 'Plateau', 1, 0),
(2420, 156, 'RI', 'Rivers', 1, 0),
(2421, 156, 'SO', 'Sokoto', 1, 0),
(2422, 156, 'TA', 'Taraba', 1, 0),
(2423, 156, 'YO', 'Yobe', 1, 0),
(2424, 156, 'ZA', 'Zamfara', 1, 0),
(2425, 159, 'N', 'Northern Islands', 1, 0),
(2426, 159, 'R', 'Rota', 1, 0),
(2427, 159, 'S', 'Saipan', 1, 0),
(2428, 159, 'T', 'Tinian', 1, 0),
(2429, 160, 'AK', 'Akershus', 1, 0),
(2430, 160, 'AA', 'Aust-Agder', 1, 0),
(2431, 160, 'BU', 'Buskerud', 1, 0),
(2432, 160, 'FM', 'Finnmark', 1, 0),
(2433, 160, 'HM', 'Hedmark', 1, 0),
(2434, 160, 'HL', 'Hordaland', 1, 0),
(2435, 160, 'MR', 'More og Romdal', 1, 0),
(2436, 160, 'NT', 'Nord-Trondelag', 1, 0),
(2437, 160, 'NL', 'Nordland', 1, 0),
(2438, 160, 'OF', 'Ostfold', 1, 0),
(2439, 160, 'OP', 'Oppland', 1, 0),
(2440, 160, 'OL', 'Oslo', 1, 0),
(2441, 160, 'RL', 'Rogaland', 1, 0),
(2442, 160, 'ST', 'Sor-Trondelag', 1, 0),
(2443, 160, 'SJ', 'Sogn og Fjordane', 1, 0),
(2444, 160, 'SV', 'Svalbard', 1, 0),
(2445, 160, 'TM', 'Telemark', 1, 0),
(2446, 160, 'TR', 'Troms', 1, 0),
(2447, 160, 'VA', 'Vest-Agder', 1, 0),
(2448, 160, 'VF', 'Vestfold', 1, 0),
(2449, 161, 'DA', 'Ad Dakhiliyah', 1, 0),
(2450, 161, 'BA', 'Al Batinah', 1, 0),
(2451, 161, 'WU', 'Al Wusta', 1, 0),
(2452, 161, 'SH', 'Ash Sharqiyah', 1, 0),
(2453, 161, 'ZA', 'Az Zahirah', 1, 0),
(2454, 161, 'MA', 'Masqat', 1, 0),
(2455, 161, 'MU', 'Musandam', 1, 0),
(2456, 161, 'ZU', 'Zufar', 1, 0),
(2457, 162, 'B', 'Balochistan', 1, 0),
(2458, 162, 'T', 'Federally Administered Tribal Areas', 1, 0),
(2459, 162, 'I', 'Islamabad Capital Territory', 1, 0),
(2460, 162, 'N', 'North-West Frontier', 1, 0),
(2461, 162, 'P', 'Punjab', 1, 0),
(2462, 162, 'S', 'Sindh', 1, 0),
(2463, 163, 'AM', 'Aimeliik', 1, 0),
(2464, 163, 'AR', 'Airai', 1, 0),
(2465, 163, 'AN', 'Angaur', 1, 0),
(2466, 163, 'HA', 'Hatohobei', 1, 0),
(2467, 163, 'KA', 'Kayangel', 1, 0),
(2468, 163, 'KO', 'Koror', 1, 0),
(2469, 163, 'ME', 'Melekeok', 1, 0),
(2470, 163, 'NA', 'Ngaraard', 1, 0),
(2471, 163, 'NG', 'Ngarchelong', 1, 0),
(2472, 163, 'ND', 'Ngardmau', 1, 0),
(2473, 163, 'NT', 'Ngatpang', 1, 0),
(2474, 163, 'NC', 'Ngchesar', 1, 0),
(2475, 163, 'NR', 'Ngeremlengui', 1, 0),
(2476, 163, 'NW', 'Ngiwal', 1, 0),
(2477, 163, 'PE', 'Peleliu', 1, 0),
(2478, 163, 'SO', 'Sonsorol', 1, 0),
(2479, 164, 'BT', 'Bocas del Toro', 1, 0),
(2480, 164, 'CH', 'Chiriqui', 1, 0),
(2481, 164, 'CC', 'Cocle', 1, 0),
(2482, 164, 'CL', 'Colon', 1, 0),
(2483, 164, 'DA', 'Darien', 1, 0),
(2484, 164, 'HE', 'Herrera', 1, 0),
(2485, 164, 'LS', 'Los Santos', 1, 0),
(2486, 164, 'PA', 'Panama', 1, 0),
(2487, 164, 'SB', 'San Blas', 1, 0),
(2488, 164, 'VG', 'Veraguas', 1, 0),
(2489, 165, 'BV', 'Bougainville', 1, 0),
(2490, 165, 'CE', 'Central', 1, 0),
(2491, 165, 'CH', 'Chimbu', 1, 0),
(2492, 165, 'EH', 'Eastern Highlands', 1, 0),
(2493, 165, 'EB', 'East New Britain', 1, 0),
(2494, 165, 'ES', 'East Sepik', 1, 0),
(2495, 165, 'EN', 'Enga', 1, 0),
(2496, 165, 'GU', 'Gulf', 1, 0),
(2497, 165, 'MD', 'Madang', 1, 0),
(2498, 165, 'MN', 'Manus', 1, 0),
(2499, 165, 'MB', 'Milne Bay', 1, 0),
(2500, 165, 'MR', 'Morobe', 1, 0),
(2501, 165, 'NC', 'National Capital', 1, 0),
(2502, 165, 'NI', 'New Ireland', 1, 0),
(2503, 165, 'NO', 'Northern', 1, 0),
(2504, 165, 'SA', 'Sandaun', 1, 0),
(2505, 165, 'SH', 'Southern Highlands', 1, 0),
(2506, 165, 'WE', 'Western', 1, 0),
(2507, 165, 'WH', 'Western Highlands', 1, 0),
(2508, 165, 'WB', 'West New Britain', 1, 0),
(2509, 166, 'AG', 'Alto Paraguay', 1, 0),
(2510, 166, 'AN', 'Alto Parana', 1, 0),
(2511, 166, 'AM', 'Amambay', 1, 0),
(2512, 166, 'AS', 'Asuncion', 1, 0),
(2513, 166, 'BO', 'Boqueron', 1, 0),
(2514, 166, 'CG', 'Caaguazu', 1, 0),
(2515, 166, 'CZ', 'Caazapa', 1, 0),
(2516, 166, 'CN', 'Canindeyu', 1, 0),
(2517, 166, 'CE', 'Central', 1, 0),
(2518, 166, 'CC', 'Concepcion', 1, 0),
(2519, 166, 'CD', 'Cordillera', 1, 0),
(2520, 166, 'GU', 'Guaira', 1, 0),
(2521, 166, 'IT', 'Itapua', 1, 0),
(2522, 166, 'MI', 'Misiones', 1, 0),
(2523, 166, 'NE', 'Neembucu', 1, 0),
(2524, 166, 'PA', 'Paraguari', 1, 0),
(2525, 166, 'PH', 'Presidente Hayes', 1, 0),
(2526, 166, 'SP', 'San Pedro', 1, 0),
(2527, 167, 'AM', 'Amazonas', 1, 0),
(2528, 167, 'AN', 'Ancash', 1, 0),
(2529, 167, 'AP', 'Apurimac', 1, 0),
(2530, 167, 'AR', 'Arequipa', 1, 0),
(2531, 167, 'AY', 'Ayacucho', 1, 0),
(2532, 167, 'CJ', 'Cajamarca', 1, 0),
(2533, 167, 'CL', 'Callao', 1, 0),
(2534, 167, 'CU', 'Cusco', 1, 0),
(2535, 167, 'HV', 'Huancavelica', 1, 0),
(2536, 167, 'HO', 'Huanuco', 1, 0),
(2537, 167, 'IC', 'Ica', 1, 0),
(2538, 167, 'JU', 'Junin', 1, 0),
(2539, 167, 'LD', 'La Libertad', 1, 0),
(2540, 167, 'LY', 'Lambayeque', 1, 0),
(2541, 167, 'LI', 'Lima', 1, 0),
(2542, 167, 'LO', 'Loreto', 1, 0),
(2543, 167, 'MD', 'Madre de Dios', 1, 0),
(2544, 167, 'MO', 'Moquegua', 1, 0),
(2545, 167, 'PA', 'Pasco', 1, 0),
(2546, 167, 'PI', 'Piura', 1, 0),
(2547, 167, 'PU', 'Puno', 1, 0),
(2548, 167, 'SM', 'San Martin', 1, 0),
(2549, 167, 'TA', 'Tacna', 1, 0),
(2550, 167, 'TU', 'Tumbes', 1, 0),
(2551, 167, 'UC', 'Ucayali', 1, 0),
(2552, 168, 'ABR', 'Abra', 1, 0),
(2553, 168, 'ANO', 'Agusan del Norte', 1, 0),
(2554, 168, 'ASU', 'Agusan del Sur', 1, 0),
(2555, 168, 'AKL', 'Aklan', 1, 0),
(2556, 168, 'ALB', 'Albay', 1, 0),
(2557, 168, 'ANT', 'Antique', 1, 0),
(2558, 168, 'APY', 'Apayao', 1, 0),
(2559, 168, 'AUR', 'Aurora', 1, 0),
(2560, 168, 'BAS', 'Basilan', 1, 0),
(2561, 168, 'BTA', 'Bataan', 1, 0),
(2562, 168, 'BTE', 'Batanes', 1, 0),
(2563, 168, 'BTG', 'Batangas', 1, 0),
(2564, 168, 'BLR', 'Biliran', 1, 0),
(2565, 168, 'BEN', 'Benguet', 1, 0),
(2566, 168, 'BOL', 'Bohol', 1, 0),
(2567, 168, 'BUK', 'Bukidnon', 1, 0),
(2568, 168, 'BUL', 'Bulacan', 1, 0),
(2569, 168, 'CAG', 'Cagayan', 1, 0),
(2570, 168, 'CNO', 'Camarines Norte', 1, 0),
(2571, 168, 'CSU', 'Camarines Sur', 1, 0),
(2572, 168, 'CAM', 'Camiguin', 1, 0),
(2573, 168, 'CAP', 'Capiz', 1, 0),
(2574, 168, 'CAT', 'Catanduanes', 1, 0),
(2575, 168, 'CAV', 'Cavite', 1, 0),
(2576, 168, 'CEB', 'Cebu', 1, 0),
(2577, 168, 'CMP', 'Compostela', 1, 0),
(2578, 168, 'DNO', 'Davao del Norte', 1, 0),
(2579, 168, 'DSU', 'Davao del Sur', 1, 0),
(2580, 168, 'DOR', 'Davao Oriental', 1, 0),
(2581, 168, 'ESA', 'Eastern Samar', 1, 0),
(2582, 168, 'GUI', 'Guimaras', 1, 0),
(2583, 168, 'IFU', 'Ifugao', 1, 0),
(2584, 168, 'INO', 'Ilocos Norte', 1, 0),
(2585, 168, 'ISU', 'Ilocos Sur', 1, 0),
(2586, 168, 'ILO', 'Iloilo', 1, 0),
(2587, 168, 'ISA', 'Isabela', 1, 0),
(2588, 168, 'KAL', 'Kalinga', 1, 0),
(2589, 168, 'LAG', 'Laguna', 1, 0),
(2590, 168, 'LNO', 'Lanao del Norte', 1, 0),
(2591, 168, 'LSU', 'Lanao del Sur', 1, 0),
(2592, 168, 'UNI', 'La Union', 1, 0),
(2593, 168, 'LEY', 'Leyte', 1, 0),
(2594, 168, 'MAG', 'Maguindanao', 1, 0),
(2595, 168, 'MRN', 'Marinduque', 1, 0),
(2596, 168, 'MSB', 'Masbate', 1, 0),
(2597, 168, 'MIC', 'Mindoro Occidental', 1, 0),
(2598, 168, 'MIR', 'Mindoro Oriental', 1, 0),
(2599, 168, 'MSC', 'Misamis Occidental', 1, 0),
(2600, 168, 'MOR', 'Misamis Oriental', 1, 0),
(2601, 168, 'MOP', 'Mountain', 1, 0),
(2602, 168, 'NOC', 'Negros Occidental', 1, 0),
(2603, 168, 'NOR', 'Negros Oriental', 1, 0),
(2604, 168, 'NCT', 'North Cotabato', 1, 0),
(2605, 168, 'NSM', 'Northern Samar', 1, 0),
(2606, 168, 'NEC', 'Nueva Ecija', 1, 0),
(2607, 168, 'NVZ', 'Nueva Vizcaya', 1, 0),
(2608, 168, 'PLW', 'Palawan', 1, 0),
(2609, 168, 'PMP', 'Pampanga', 1, 0),
(2610, 168, 'PNG', 'Pangasinan', 1, 0),
(2611, 168, 'QZN', 'Quezon', 1, 0),
(2612, 168, 'QRN', 'Quirino', 1, 0),
(2613, 168, 'RIZ', 'Rizal', 1, 0),
(2614, 168, 'ROM', 'Romblon', 1, 0),
(2615, 168, 'SMR', 'Samar', 1, 0),
(2616, 168, 'SRG', 'Sarangani', 1, 0),
(2617, 168, 'SQJ', 'Siquijor', 1, 0),
(2618, 168, 'SRS', 'Sorsogon', 1, 0),
(2619, 168, 'SCO', 'South Cotabato', 1, 0),
(2620, 168, 'SLE', 'Southern Leyte', 1, 0),
(2621, 168, 'SKU', 'Sultan Kudarat', 1, 0),
(2622, 168, 'SLU', 'Sulu', 1, 0),
(2623, 168, 'SNO', 'Surigao del Norte', 1, 0),
(2624, 168, 'SSU', 'Surigao del Sur', 1, 0),
(2625, 168, 'TAR', 'Tarlac', 1, 0),
(2626, 168, 'TAW', 'Tawi-Tawi', 1, 0),
(2627, 168, 'ZBL', 'Zambales', 1, 0),
(2628, 168, 'ZNO', 'Zamboanga del Norte', 1, 0),
(2629, 168, 'ZSU', 'Zamboanga del Sur', 1, 0),
(2630, 168, 'ZSI', 'Zamboanga Sibugay', 1, 0),
(2631, 170, 'DO', 'Dolnoslaskie', 1, 0),
(2632, 170, 'KP', 'Kujawsko-Pomorskie', 1, 0),
(2633, 170, 'LO', 'Lodzkie', 1, 0),
(2634, 170, 'LL', 'Lubelskie', 1, 0),
(2635, 170, 'LU', 'Lubuskie', 1, 0),
(2636, 170, 'ML', 'Malopolskie', 1, 0),
(2637, 170, 'MZ', 'Mazowieckie', 1, 0),
(2638, 170, 'OP', 'Opolskie', 1, 0),
(2639, 170, 'PP', 'Podkarpackie', 1, 0),
(2640, 170, 'PL', 'Podlaskie', 1, 0),
(2641, 170, 'PM', 'Pomorskie', 1, 0),
(2642, 170, 'SL', 'Slaskie', 1, 0),
(2643, 170, 'SW', 'Swietokrzyskie', 1, 0),
(2644, 170, 'WM', 'Warminsko-Mazurskie', 1, 0),
(2645, 170, 'WP', 'Wielkopolskie', 1, 0),
(2646, 170, 'ZA', 'Zachodniopomorskie', 1, 0),
(2647, 198, 'P', 'Saint Pierre', 1, 0),
(2648, 198, 'M', 'Miquelon', 1, 0),
(2649, 171, 'AC', 'A&ccedil;ores', 1, 0),
(2650, 171, 'AV', 'Aveiro', 1, 0),
(2651, 171, 'BE', 'Beja', 1, 0),
(2652, 171, 'BR', 'Braga', 1, 0),
(2653, 171, 'BA', 'Bragan&ccedil;a', 1, 0),
(2654, 171, 'CB', 'Castelo Branco', 1, 0),
(2655, 171, 'CO', 'Coimbra', 1, 0),
(2656, 171, 'EV', '&Eacute;vora', 1, 0),
(2657, 171, 'FA', 'Faro', 1, 0),
(2658, 171, 'GU', 'Guarda', 1, 0),
(2659, 171, 'LE', 'Leiria', 1, 0),
(2660, 171, 'LI', 'Lisboa', 1, 0),
(2661, 171, 'ME', 'Madeira', 1, 0),
(2662, 171, 'PO', 'Portalegre', 1, 0),
(2663, 171, 'PR', 'Porto', 1, 0),
(2664, 171, 'SA', 'Santar&eacute;m', 1, 0),
(2665, 171, 'SE', 'Set&uacute;bal', 1, 0),
(2666, 171, 'VC', 'Viana do Castelo', 1, 0),
(2667, 171, 'VR', 'Vila Real', 1, 0),
(2668, 171, 'VI', 'Viseu', 1, 0),
(2669, 173, 'DW', 'Ad Dawhah', 1, 0),
(2670, 173, 'GW', 'Al Ghuwayriyah', 1, 0),
(2671, 173, 'JM', 'Al Jumayliyah', 1, 0),
(2672, 173, 'KR', 'Al Khawr', 1, 0),
(2673, 173, 'WK', 'Al Wakrah', 1, 0),
(2674, 173, 'RN', 'Ar Rayyan', 1, 0),
(2675, 173, 'JB', 'Jarayan al Batinah', 1, 0),
(2676, 173, 'MS', 'Madinat ash Shamal', 1, 0),
(2677, 173, 'UD', 'Umm Sa\'id', 1, 0),
(2678, 173, 'UL', 'Umm Salal', 1, 0),
(2679, 175, 'AB', 'Alba', 1, 0),
(2680, 175, 'AR', 'Arad', 1, 0),
(2681, 175, 'AG', 'Arges', 1, 0),
(2682, 175, 'BC', 'Bacau', 1, 0),
(2683, 175, 'BH', 'Bihor', 1, 0),
(2684, 175, 'BN', 'Bistrita-Nasaud', 1, 0),
(2685, 175, 'BT', 'Botosani', 1, 0),
(2686, 175, 'BV', 'Brasov', 1, 0),
(2687, 175, 'BR', 'Braila', 1, 0),
(2688, 175, 'B', 'Bucuresti', 1, 0),
(2689, 175, 'BZ', 'Buzau', 1, 0),
(2690, 175, 'CS', 'Caras-Severin', 1, 0),
(2691, 175, 'CL', 'Calarasi', 1, 0),
(2692, 175, 'CJ', 'Cluj', 1, 0),
(2693, 175, 'CT', 'Constanta', 1, 0),
(2694, 175, 'CV', 'Covasna', 1, 0),
(2695, 175, 'DB', 'Dimbovita', 1, 0),
(2696, 175, 'DJ', 'Dolj', 1, 0),
(2697, 175, 'GL', 'Galati', 1, 0),
(2698, 175, 'GR', 'Giurgiu', 1, 0),
(2699, 175, 'GJ', 'Gorj', 1, 0),
(2700, 175, 'HR', 'Harghita', 1, 0),
(2701, 175, 'HD', 'Hunedoara', 1, 0),
(2702, 175, 'IL', 'Ialomita', 1, 0),
(2703, 175, 'IS', 'Iasi', 1, 0),
(2704, 175, 'IF', 'Ilfov', 1, 0),
(2705, 175, 'MM', 'Maramures', 1, 0),
(2706, 175, 'MH', 'Mehedinti', 1, 0),
(2707, 175, 'MS', 'Mures', 1, 0),
(2708, 175, 'NT', 'Neamt', 1, 0),
(2709, 175, 'OT', 'Olt', 1, 0),
(2710, 175, 'PH', 'Prahova', 1, 0),
(2711, 175, 'SM', 'Satu-Mare', 1, 0),
(2712, 175, 'SJ', 'Salaj', 1, 0),
(2713, 175, 'SB', 'Sibiu', 1, 0),
(2714, 175, 'SV', 'Suceava', 1, 0),
(2715, 175, 'TR', 'Teleorman', 1, 0),
(2716, 175, 'TM', 'Timis', 1, 0),
(2717, 175, 'TL', 'Tulcea', 1, 0),
(2718, 175, 'VS', 'Vaslui', 1, 0),
(2719, 175, 'VL', 'Valcea', 1, 0),
(2720, 175, 'VN', 'Vrancea', 1, 0),
(2721, 176, 'AB', 'Abakan', 1, 0),
(2722, 176, 'AG', 'Aginskoye', 1, 0),
(2723, 176, 'AN', 'Anadyr', 1, 0),
(2724, 176, 'AR', 'Arkahangelsk', 1, 0),
(2725, 176, 'AS', 'Astrakhan', 1, 0),
(2726, 176, 'BA', 'Barnaul', 1, 0),
(2727, 176, 'BE', 'Belgorod', 1, 0),
(2728, 176, 'BI', 'Birobidzhan', 1, 0),
(2729, 176, 'BL', 'Blagoveshchensk', 1, 0),
(2730, 176, 'BR', 'Bryansk', 1, 0),
(2731, 176, 'CH', 'Cheboksary', 1, 0),
(2732, 176, 'CL', 'Chelyabinsk', 1, 0),
(2733, 176, 'CR', 'Cherkessk', 1, 0),
(2734, 176, 'CI', 'Chita', 1, 0),
(2735, 176, 'DU', 'Dudinka', 1, 0),
(2736, 176, 'EL', 'Elista', 1, 0),
(2737, 176, 'GO', 'Gomo-Altaysk', 1, 0),
(2738, 176, 'GA', 'Gorno-Altaysk', 1, 0),
(2739, 176, 'GR', 'Groznyy', 1, 0),
(2740, 176, 'IR', 'Irkutsk', 1, 0),
(2741, 176, 'IV', 'Ivanovo', 1, 0),
(2742, 176, 'IZ', 'Izhevsk', 1, 0),
(2743, 176, 'KA', 'Kalinigrad', 1, 0),
(2744, 176, 'KL', 'Kaluga', 1, 0),
(2745, 176, 'KS', 'Kasnodar', 1, 0),
(2746, 176, 'KZ', 'Kazan', 1, 0),
(2747, 176, 'KE', 'Kemerovo', 1, 0),
(2748, 176, 'KH', 'Khabarovsk', 1, 0),
(2749, 176, 'KM', 'Khanty-Mansiysk', 1, 0),
(2750, 176, 'KO', 'Kostroma', 1, 0),
(2751, 176, 'KR', 'Krasnodar', 1, 0),
(2752, 176, 'KN', 'Krasnoyarsk', 1, 0),
(2753, 176, 'KU', 'Kudymkar', 1, 0),
(2754, 176, 'KG', 'Kurgan', 1, 0),
(2755, 176, 'KK', 'Kursk', 1, 0),
(2756, 176, 'KY', 'Kyzyl', 1, 0),
(2757, 176, 'LI', 'Lipetsk', 1, 0),
(2758, 176, 'MA', 'Magadan', 1, 0),
(2759, 176, 'MK', 'Makhachkala', 1, 0),
(2760, 176, 'MY', 'Maykop', 1, 0),
(2761, 176, 'MO', 'Moscow', 1, 0),
(2762, 176, 'MU', 'Murmansk', 1, 0),
(2763, 176, 'NA', 'Nalchik', 1, 0),
(2764, 176, 'NR', 'Naryan Mar', 1, 0),
(2765, 176, 'NZ', 'Nazran', 1, 0),
(2766, 176, 'NI', 'Nizhniy Novgorod', 1, 0),
(2767, 176, 'NO', 'Novgorod', 1, 0),
(2768, 176, 'NV', 'Novosibirsk', 1, 0),
(2769, 176, 'OM', 'Omsk', 1, 0),
(2770, 176, 'OR', 'Orel', 1, 0),
(2771, 176, 'OE', 'Orenburg', 1, 0),
(2772, 176, 'PA', 'Palana', 1, 0),
(2773, 176, 'PE', 'Penza', 1, 0),
(2774, 176, 'PR', 'Perm', 1, 0),
(2775, 176, 'PK', 'Petropavlovsk-Kamchatskiy', 1, 0),
(2776, 176, 'PT', 'Petrozavodsk', 1, 0),
(2777, 176, 'PS', 'Pskov', 1, 0),
(2778, 176, 'RO', 'Rostov-na-Donu', 1, 0),
(2779, 176, 'RY', 'Ryazan', 1, 0),
(2780, 176, 'SL', 'Salekhard', 1, 0),
(2781, 176, 'SA', 'Samara', 1, 0),
(2782, 176, 'SR', 'Saransk', 1, 0),
(2783, 176, 'SV', 'Saratov', 1, 0),
(2784, 176, 'SM', 'Smolensk', 1, 0),
(2785, 176, 'SP', 'St. Petersburg', 1, 0),
(2786, 176, 'ST', 'Stavropol', 1, 0),
(2787, 176, 'SY', 'Syktyvkar', 1, 0),
(2788, 176, 'TA', 'Tambov', 1, 0),
(2789, 176, 'TO', 'Tomsk', 1, 0),
(2790, 176, 'TU', 'Tula', 1, 0),
(2791, 176, 'TR', 'Tura', 1, 0),
(2792, 176, 'TV', 'Tver', 1, 0),
(2793, 176, 'TY', 'Tyumen', 1, 0),
(2794, 176, 'UF', 'Ufa', 1, 0),
(2795, 176, 'UL', 'Ul\'yanovsk', 1, 0),
(2796, 176, 'UU', 'Ulan-Ude', 1, 0),
(2797, 176, 'US', 'Ust\'-Ordynskiy', 1, 0),
(2798, 176, 'VL', 'Vladikavkaz', 1, 0),
(2799, 176, 'VA', 'Vladimir', 1, 0),
(2800, 176, 'VV', 'Vladivostok', 1, 0),
(2801, 176, 'VG', 'Volgograd', 1, 0),
(2802, 176, 'VD', 'Vologda', 1, 0),
(2803, 176, 'VO', 'Voronezh', 1, 0),
(2804, 176, 'VY', 'Vyatka', 1, 0),
(2805, 176, 'YA', 'Yakutsk', 1, 0),
(2806, 176, 'YR', 'Yaroslavl', 1, 0),
(2807, 176, 'YE', 'Yekaterinburg', 1, 0),
(2808, 176, 'YO', 'Yoshkar-Ola', 1, 0),
(2809, 177, 'BU', 'Butare', 1, 0),
(2810, 177, 'BY', 'Byumba', 1, 0),
(2811, 177, 'CY', 'Cyangugu', 1, 0),
(2812, 177, 'GK', 'Gikongoro', 1, 0),
(2813, 177, 'GS', 'Gisenyi', 1, 0),
(2814, 177, 'GT', 'Gitarama', 1, 0),
(2815, 177, 'KG', 'Kibungo', 1, 0),
(2816, 177, 'KY', 'Kibuye', 1, 0),
(2817, 177, 'KR', 'Kigali Rurale', 1, 0),
(2818, 177, 'KV', 'Kigali-ville', 1, 0),
(2819, 177, 'RU', 'Ruhengeri', 1, 0),
(2820, 177, 'UM', 'Umutara', 1, 0),
(2821, 178, 'CCN', 'Christ Church Nichola Town', 1, 0);
INSERT INTO `#__j2store_zones` (`j2store_zone_id`, `country_id`, `zone_code`, `zone_name`, `enabled`, `ordering`) VALUES
(2822, 178, 'SAS', 'Saint Anne Sandy Point', 1, 0),
(2823, 178, 'SGB', 'Saint George Basseterre', 1, 0),
(2824, 178, 'SGG', 'Saint George Gingerland', 1, 0),
(2825, 178, 'SJW', 'Saint James Windward', 1, 0),
(2826, 178, 'SJC', 'Saint John Capesterre', 1, 0),
(2827, 178, 'SJF', 'Saint John Figtree', 1, 0),
(2828, 178, 'SMC', 'Saint Mary Cayon', 1, 0),
(2829, 178, 'CAP', 'Saint Paul Capesterre', 1, 0),
(2830, 178, 'CHA', 'Saint Paul Charlestown', 1, 0),
(2831, 178, 'SPB', 'Saint Peter Basseterre', 1, 0),
(2832, 178, 'STL', 'Saint Thomas Lowland', 1, 0),
(2833, 178, 'STM', 'Saint Thomas Middle Island', 1, 0),
(2834, 178, 'TPP', 'Trinity Palmetto Point', 1, 0),
(2835, 179, 'AR', 'Anse-la-Raye', 1, 0),
(2836, 179, 'CA', 'Castries', 1, 0),
(2837, 179, 'CH', 'Choiseul', 1, 0),
(2838, 179, 'DA', 'Dauphin', 1, 0),
(2839, 179, 'DE', 'Dennery', 1, 0),
(2840, 179, 'GI', 'Gros-Islet', 1, 0),
(2841, 179, 'LA', 'Laborie', 1, 0),
(2842, 179, 'MI', 'Micoud', 1, 0),
(2843, 179, 'PR', 'Praslin', 1, 0),
(2844, 179, 'SO', 'Soufriere', 1, 0),
(2845, 179, 'VF', 'Vieux-Fort', 1, 0),
(2846, 180, 'C', 'Charlotte', 1, 0),
(2847, 180, 'R', 'Grenadines', 1, 0),
(2848, 180, 'A', 'Saint Andrew', 1, 0),
(2849, 180, 'D', 'Saint David', 1, 0),
(2850, 180, 'G', 'Saint George', 1, 0),
(2851, 180, 'P', 'Saint Patrick', 1, 0),
(2852, 181, 'AN', 'A\'ana', 1, 0),
(2853, 181, 'AI', 'Aiga-i-le-Tai', 1, 0),
(2854, 181, 'AT', 'Atua', 1, 0),
(2855, 181, 'FA', 'Fa\'asaleleaga', 1, 0),
(2856, 181, 'GE', 'Gaga\'emauga', 1, 0),
(2857, 181, 'GF', 'Gagaifomauga', 1, 0),
(2858, 181, 'PA', 'Palauli', 1, 0),
(2859, 181, 'SA', 'Satupa\'itea', 1, 0),
(2860, 181, 'TU', 'Tuamasaga', 1, 0),
(2861, 181, 'VF', 'Va\'a-o-Fonoti', 1, 0),
(2862, 181, 'VS', 'Vaisigano', 1, 0),
(2863, 182, 'AC', 'Acquaviva', 1, 0),
(2864, 182, 'BM', 'Borgo Maggiore', 1, 0),
(2865, 182, 'CH', 'Chiesanuova', 1, 0),
(2866, 182, 'DO', 'Domagnano', 1, 0),
(2867, 182, 'FA', 'Faetano', 1, 0),
(2868, 182, 'FI', 'Fiorentino', 1, 0),
(2869, 182, 'MO', 'Montegiardino', 1, 0),
(2870, 182, 'SM', 'Citta di San Marino', 1, 0),
(2871, 182, 'SE', 'Serravalle', 1, 0),
(2872, 183, 'S', 'Sao Tome', 1, 0),
(2873, 183, 'P', 'Principe', 1, 0),
(2874, 184, 'BH', 'Al Bahah', 1, 0),
(2875, 184, 'HS', 'Al Hudud ash Shamaliyah', 1, 0),
(2876, 184, 'JF', 'Al Jawf', 1, 0),
(2877, 184, 'MD', 'Al Madinah', 1, 0),
(2878, 184, 'QS', 'Al Qasim', 1, 0),
(2879, 184, 'RD', 'Ar Riyad', 1, 0),
(2880, 184, 'AQ', 'Ash Sharqiyah (Eastern)', 1, 0),
(2881, 184, 'AS', '\'Asir', 1, 0),
(2882, 184, 'HL', 'Ha\'il', 1, 0),
(2883, 184, 'JZ', 'Jizan', 1, 0),
(2884, 184, 'ML', 'Makkah', 1, 0),
(2885, 184, 'NR', 'Najran', 1, 0),
(2886, 184, 'TB', 'Tabuk', 1, 0),
(2887, 185, 'DA', 'Dakar', 1, 0),
(2888, 185, 'DI', 'Diourbel', 1, 0),
(2889, 185, 'FA', 'Fatick', 1, 0),
(2890, 185, 'KA', 'Kaolack', 1, 0),
(2891, 185, 'KO', 'Kolda', 1, 0),
(2892, 185, 'LO', 'Louga', 1, 0),
(2893, 185, 'MA', 'Matam', 1, 0),
(2894, 185, 'SL', 'Saint-Louis', 1, 0),
(2895, 185, 'TA', 'Tambacounda', 1, 0),
(2896, 185, 'TH', 'Thies', 1, 0),
(2897, 185, 'ZI', 'Ziguinchor', 1, 0),
(2898, 186, 'AP', 'Anse aux Pins', 1, 0),
(2899, 186, 'AB', 'Anse Boileau', 1, 0),
(2900, 186, 'AE', 'Anse Etoile', 1, 0),
(2901, 186, 'AL', 'Anse Louis', 1, 0),
(2902, 186, 'AR', 'Anse Royale', 1, 0),
(2903, 186, 'BL', 'Baie Lazare', 1, 0),
(2904, 186, 'BS', 'Baie Sainte Anne', 1, 0),
(2905, 186, 'BV', 'Beau Vallon', 1, 0),
(2906, 186, 'BA', 'Bel Air', 1, 0),
(2907, 186, 'BO', 'Bel Ombre', 1, 0),
(2908, 186, 'CA', 'Cascade', 1, 0),
(2909, 186, 'GL', 'Glacis', 1, 0),
(2910, 186, 'GM', 'Grand\' Anse (on Mahe)', 1, 0),
(2911, 186, 'GP', 'Grand\' Anse (on Praslin)', 1, 0),
(2912, 186, 'DG', 'La Digue', 1, 0),
(2913, 186, 'RA', 'La Riviere Anglaise', 1, 0),
(2914, 186, 'MB', 'Mont Buxton', 1, 0),
(2915, 186, 'MF', 'Mont Fleuri', 1, 0),
(2916, 186, 'PL', 'Plaisance', 1, 0),
(2917, 186, 'PR', 'Pointe La Rue', 1, 0),
(2918, 186, 'PG', 'Port Glaud', 1, 0),
(2919, 186, 'SL', 'Saint Louis', 1, 0),
(2920, 186, 'TA', 'Takamaka', 1, 0),
(2921, 187, 'E', 'Eastern', 1, 0),
(2922, 187, 'N', 'Northern', 1, 0),
(2923, 187, 'S', 'Southern', 1, 0),
(2924, 187, 'W', 'Western', 1, 0),
(2925, 189, 'BA', 'Banskobystricky', 1, 0),
(2926, 189, 'BR', 'Bratislavsky', 1, 0),
(2927, 189, 'KO', 'Kosicky', 1, 0),
(2928, 189, 'NI', 'Nitriansky', 1, 0),
(2929, 189, 'PR', 'Presovsky', 1, 0),
(2930, 189, 'TC', 'Trenciansky', 1, 0),
(2931, 189, 'TV', 'Trnavsky', 1, 0),
(2932, 189, 'ZI', 'Zilinsky', 1, 0),
(2933, 191, 'CE', 'Central', 1, 0),
(2934, 191, 'CH', 'Choiseul', 1, 0),
(2935, 191, 'GC', 'Guadalcanal', 1, 0),
(2936, 191, 'HO', 'Honiara', 1, 0),
(2937, 191, 'IS', 'Isabel', 1, 0),
(2938, 191, 'MK', 'Makira', 1, 0),
(2939, 191, 'ML', 'Malaita', 1, 0),
(2940, 191, 'RB', 'Rennell and Bellona', 1, 0),
(2941, 191, 'TM', 'Temotu', 1, 0),
(2942, 191, 'WE', 'Western', 1, 0),
(2943, 192, 'AW', 'Awdal', 1, 0),
(2944, 192, 'BK', 'Bakool', 1, 0),
(2945, 192, 'BN', 'Banaadir', 1, 0),
(2946, 192, 'BR', 'Bari', 1, 0),
(2947, 192, 'BY', 'Bay', 1, 0),
(2948, 192, 'GA', 'Galguduud', 1, 0),
(2949, 192, 'GE', 'Gedo', 1, 0),
(2950, 192, 'HI', 'Hiiraan', 1, 0),
(2951, 192, 'JD', 'Jubbada Dhexe', 1, 0),
(2952, 192, 'JH', 'Jubbada Hoose', 1, 0),
(2953, 192, 'MU', 'Mudug', 1, 0),
(2954, 192, 'NU', 'Nugaal', 1, 0),
(2955, 192, 'SA', 'Sanaag', 1, 0),
(2956, 192, 'SD', 'Shabeellaha Dhexe', 1, 0),
(2957, 192, 'SH', 'Shabeellaha Hoose', 1, 0),
(2958, 192, 'SL', 'Sool', 1, 0),
(2959, 192, 'TO', 'Togdheer', 1, 0),
(2960, 192, 'WG', 'Woqooyi Galbeed', 1, 0),
(2961, 193, 'EC', 'Eastern Cape', 1, 0),
(2962, 193, 'FS', 'Free State', 1, 0),
(2963, 193, 'GT', 'Gauteng', 1, 0),
(2964, 193, 'KN', 'KwaZulu-Natal', 1, 0),
(2965, 193, 'LP', 'Limpopo', 1, 0),
(2966, 193, 'MP', 'Mpumalanga', 1, 0),
(2967, 193, 'NW', 'North West', 1, 0),
(2968, 193, 'NC', 'Northern Cape', 1, 0),
(2969, 193, 'WC', 'Western Cape', 1, 0),
(2970, 195, 'CA', 'La Coru&ntilde;a', 1, 0),
(2971, 195, 'AL', '&Aacute;lava', 1, 0),
(2972, 195, 'AB', 'Albacete', 1, 0),
(2973, 195, 'AC', 'Alicante', 1, 0),
(2974, 195, 'AM', 'Almeria', 1, 0),
(2975, 195, 'AS', 'Asturias', 1, 0),
(2976, 195, 'AV', '&Aacute;vila', 1, 0),
(2977, 195, 'BJ', 'Badajoz', 1, 0),
(2978, 195, 'IB', 'Baleares', 1, 0),
(2979, 195, 'BA', 'Barcelona', 1, 0),
(2980, 195, 'BU', 'Burgos', 1, 0),
(2981, 195, 'CC', 'C&aacute;ceres', 1, 0),
(2982, 195, 'CZ', 'C&aacute;diz', 1, 0),
(2983, 195, 'CT', 'Cantabria', 1, 0),
(2984, 195, 'CL', 'Castell&oacute;n', 1, 0),
(2985, 195, 'CE', 'Ceuta', 1, 0),
(2986, 195, 'CR', 'Ciudad Real', 1, 0),
(2987, 195, 'CD', 'C&oacute;rdoba', 1, 0),
(2988, 195, 'CU', 'Cuenca', 1, 0),
(2989, 195, 'GI', 'Girona', 1, 0),
(2990, 195, 'GD', 'Granada', 1, 0),
(2991, 195, 'GJ', 'Guadalajara', 1, 0),
(2992, 195, 'GP', 'Guip&uacute;zcoa', 1, 0),
(2993, 195, 'HL', 'Huelva', 1, 0),
(2994, 195, 'HS', 'Huesca', 1, 0),
(2995, 195, 'JN', 'Ja&eacute;n', 1, 0),
(2996, 195, 'RJ', 'La Rioja', 1, 0),
(2997, 195, 'PM', 'Las Palmas', 1, 0),
(2998, 195, 'LE', 'Leon', 1, 0),
(2999, 195, 'LL', 'Lleida', 1, 0),
(3000, 195, 'LG', 'Lugo', 1, 0),
(3001, 195, 'MD', 'Madrid', 1, 0),
(3002, 195, 'MA', 'Malaga', 1, 0),
(3003, 195, 'ML', 'Melilla', 1, 0),
(3004, 195, 'MU', 'Murcia', 1, 0),
(3005, 195, 'NV', 'Navarra', 1, 0),
(3006, 195, 'OU', 'Ourense', 1, 0),
(3007, 195, 'PL', 'Palencia', 1, 0),
(3008, 195, 'PO', 'Pontevedra', 1, 0),
(3009, 195, 'SL', 'Salamanca', 1, 0),
(3010, 195, 'SC', 'Santa Cruz de Tenerife', 1, 0),
(3011, 195, 'SG', 'Segovia', 1, 0),
(3012, 195, 'SV', 'Sevilla', 1, 0),
(3013, 195, 'SO', 'Soria', 1, 0),
(3014, 195, 'TA', 'Tarragona', 1, 0),
(3015, 195, 'TE', 'Teruel', 1, 0),
(3016, 195, 'TO', 'Toledo', 1, 0),
(3017, 195, 'VC', 'Valencia', 1, 0),
(3018, 195, 'VD', 'Valladolid', 1, 0),
(3019, 195, 'VZ', 'Vizcaya', 1, 0),
(3020, 195, 'ZM', 'Zamora', 1, 0),
(3021, 195, 'ZR', 'Zaragoza', 1, 0),
(3022, 196, 'CE', 'Central', 1, 0),
(3023, 196, 'EA', 'Eastern', 1, 0),
(3024, 196, 'NC', 'North Central', 1, 0),
(3025, 196, 'NO', 'Northern', 1, 0),
(3026, 196, 'NW', 'North Western', 1, 0),
(3027, 196, 'SA', 'Sabaragamuwa', 1, 0),
(3028, 196, 'SO', 'Southern', 1, 0),
(3029, 196, 'UV', 'Uva', 1, 0),
(3030, 196, 'WE', 'Western', 1, 0),
(3031, 197, 'A', 'Ascension', 1, 0),
(3032, 197, 'S', 'Saint Helena', 1, 0),
(3033, 197, 'T', 'Tristan da Cunha', 1, 0),
(3034, 199, 'ANL', 'A\'ali an Nil', 1, 0),
(3035, 199, 'BAM', 'Al Bahr al Ahmar', 1, 0),
(3036, 199, 'BRT', 'Al Buhayrat', 1, 0),
(3037, 199, 'JZR', 'Al Jazirah', 1, 0),
(3038, 199, 'KRT', 'Al Khartum', 1, 0),
(3039, 199, 'QDR', 'Al Qadarif', 1, 0),
(3040, 199, 'WDH', 'Al Wahdah', 1, 0),
(3041, 199, 'ANB', 'An Nil al Abyad', 1, 0),
(3042, 199, 'ANZ', 'An Nil al Azraq', 1, 0),
(3043, 199, 'ASH', 'Ash Shamaliyah', 1, 0),
(3044, 199, 'BJA', 'Bahr al Jabal', 1, 0),
(3045, 199, 'GIS', 'Gharb al Istiwa\'iyah', 1, 0),
(3046, 199, 'GBG', 'Gharb Bahr al Ghazal', 1, 0),
(3047, 199, 'GDA', 'Gharb Darfur', 1, 0),
(3048, 199, 'GKU', 'Gharb Kurdufan', 1, 0),
(3049, 199, 'JDA', 'Janub Darfur', 1, 0),
(3050, 199, 'JKU', 'Janub Kurdufan', 1, 0),
(3051, 199, 'JQL', 'Junqali', 1, 0),
(3052, 199, 'KSL', 'Kassala', 1, 0),
(3053, 199, 'NNL', 'Nahr an Nil', 1, 0),
(3054, 199, 'SBG', 'Shamal Bahr al Ghazal', 1, 0),
(3055, 199, 'SDA', 'Shamal Darfur', 1, 0),
(3056, 199, 'SKU', 'Shamal Kurdufan', 1, 0),
(3057, 199, 'SIS', 'Sharq al Istiwa\'iyah', 1, 0),
(3058, 199, 'SNR', 'Sinnar', 1, 0),
(3059, 199, 'WRB', 'Warab', 1, 0),
(3060, 200, 'BR', 'Brokopondo', 1, 0),
(3061, 200, 'CM', 'Commewijne', 1, 0),
(3062, 200, 'CR', 'Coronie', 1, 0),
(3063, 200, 'MA', 'Marowijne', 1, 0),
(3064, 200, 'NI', 'Nickerie', 1, 0),
(3065, 200, 'PA', 'Para', 1, 0),
(3066, 200, 'PM', 'Paramaribo', 1, 0),
(3067, 200, 'SA', 'Saramacca', 1, 0),
(3068, 200, 'SI', 'Sipaliwini', 1, 0),
(3069, 200, 'WA', 'Wanica', 1, 0),
(3070, 202, 'H', 'Hhohho', 1, 0),
(3071, 202, 'L', 'Lubombo', 1, 0),
(3072, 202, 'M', 'Manzini', 1, 0),
(3073, 202, 'S', 'Shishelweni', 1, 0),
(3074, 203, 'K', 'Blekinge', 1, 0),
(3075, 203, 'W', 'Dalama', 1, 0),
(3076, 203, 'X', 'G&auml;vleborg', 1, 0),
(3077, 203, 'I', 'Gotland', 1, 0),
(3078, 203, 'N', 'Halland', 1, 0),
(3079, 203, 'Z', 'J&auml;mtland', 1, 0),
(3080, 203, 'F', 'J&ouml;nk&ouml;ping', 1, 0),
(3081, 203, 'H', 'Kalmar', 1, 0),
(3082, 203, 'G', 'Kronoberg', 1, 0),
(3083, 203, 'BD', 'Norrbotten', 1, 0),
(3084, 203, 'T', '&Ouml;rebro', 1, 0),
(3085, 203, 'E', '&Ouml;sterg&ouml;tland', 1, 0),
(3086, 203, 'M', 'Sk&aring;ne', 1, 0),
(3087, 203, 'D', 'S&ouml;dermanland', 1, 0),
(3088, 203, 'AB', 'Stockholm', 1, 0),
(3089, 203, 'C', 'Uppsala', 1, 0),
(3090, 203, 'S', 'V&auml;rmland', 1, 0),
(3091, 203, 'AC', 'V&auml;sterbotten', 1, 0),
(3092, 203, 'Y', 'V&auml;sternorrland', 1, 0),
(3093, 203, 'U', 'V&auml;stmanland', 1, 0),
(3094, 203, 'O', 'V&auml;stra G&ouml;taland', 1, 0),
(3095, 204, 'AG', 'Aargau', 1, 0),
(3096, 204, 'AR', 'Appenzell Ausserrhoden', 1, 0),
(3097, 204, 'AI', 'Appenzell Innerrhoden', 1, 0),
(3098, 204, 'BS', 'Basel-Stadt', 1, 0),
(3099, 204, 'BL', 'Basel-Landschaft', 1, 0),
(3100, 204, 'BE', 'Bern', 1, 0),
(3101, 204, 'FR', 'Fribourg', 1, 0),
(3102, 204, 'GE', 'Gen&egrave;ve', 1, 0),
(3103, 204, 'GL', 'Glarus', 1, 0),
(3104, 204, 'GR', 'Graub&uuml;nden', 1, 0),
(3105, 204, 'JU', 'Jura', 1, 0),
(3106, 204, 'LU', 'Luzern', 1, 0),
(3107, 204, 'NE', 'Neuch&acirc;tel', 1, 0),
(3108, 204, 'NW', 'Nidwald', 1, 0),
(3109, 204, 'OW', 'Obwald', 1, 0),
(3110, 204, 'SG', 'St. Gallen', 1, 0),
(3111, 204, 'SH', 'Schaffhausen', 1, 0),
(3112, 204, 'SZ', 'Schwyz', 1, 0),
(3113, 204, 'SO', 'Solothurn', 1, 0),
(3114, 204, 'TG', 'Thurgau', 1, 0),
(3115, 204, 'TI', 'Ticino', 1, 0),
(3116, 204, 'UR', 'Uri', 1, 0),
(3117, 204, 'VS', 'Valais', 1, 0),
(3118, 204, 'VD', 'Vaud', 1, 0),
(3119, 204, 'ZG', 'Zug', 1, 0),
(3120, 204, 'ZH', 'Z&uuml;rich', 1, 0),
(3121, 205, 'HA', 'Al Hasakah', 1, 0),
(3122, 205, 'LA', 'Al Ladhiqiyah', 1, 0),
(3123, 205, 'QU', 'Al Qunaytirah', 1, 0),
(3124, 205, 'RQ', 'Ar Raqqah', 1, 0),
(3125, 205, 'SU', 'As Suwayda', 1, 0),
(3126, 205, 'DA', 'Dara', 1, 0),
(3127, 205, 'DZ', 'Dayr az Zawr', 1, 0),
(3128, 205, 'DI', 'Dimashq', 1, 0),
(3129, 205, 'HL', 'Halab', 1, 0),
(3130, 205, 'HM', 'Hamah', 1, 0),
(3131, 205, 'HI', 'Hims', 1, 0),
(3132, 205, 'ID', 'Idlib', 1, 0),
(3133, 205, 'RD', 'Rif Dimashq', 1, 0),
(3134, 205, 'TA', 'Tartus', 1, 0),
(3135, 206, 'CH', 'Chang-hua', 1, 0),
(3136, 206, 'CI', 'Chia-i', 1, 0),
(3137, 206, 'HS', 'Hsin-chu', 1, 0),
(3138, 206, 'HL', 'Hua-lien', 1, 0),
(3139, 206, 'IL', 'I-lan', 1, 0),
(3140, 206, 'KH', 'Kao-hsiung county', 1, 0),
(3141, 206, 'KM', 'Kin-men', 1, 0),
(3142, 206, 'LC', 'Lien-chiang', 1, 0),
(3143, 206, 'ML', 'Miao-li', 1, 0),
(3144, 206, 'NT', 'Nan-t\'ou', 1, 0),
(3145, 206, 'PH', 'P\'eng-hu', 1, 0),
(3146, 206, 'PT', 'P\'ing-tung', 1, 0),
(3147, 206, 'TG', 'T\'ai-chung', 1, 0),
(3148, 206, 'TA', 'T\'ai-nan', 1, 0),
(3149, 206, 'TP', 'T\'ai-pei county', 1, 0),
(3150, 206, 'TT', 'T\'ai-tung', 1, 0),
(3151, 206, 'TY', 'T\'ao-yuan', 1, 0),
(3152, 206, 'YL', 'Yun-lin', 1, 0),
(3153, 206, 'CC', 'Chia-i city', 1, 0),
(3154, 206, 'CL', 'Chi-lung', 1, 0),
(3155, 206, 'HC', 'Hsin-chu', 1, 0),
(3156, 206, 'TH', 'T\'ai-chung', 1, 0),
(3157, 206, 'TN', 'T\'ai-nan', 1, 0),
(3158, 206, 'KC', 'Kao-hsiung city', 1, 0),
(3159, 206, 'TC', 'T\'ai-pei city', 1, 0),
(3160, 207, 'GB', 'Gorno-Badakhstan', 1, 0),
(3161, 207, 'KT', 'Khatlon', 1, 0),
(3162, 207, 'SU', 'Sughd', 1, 0),
(3163, 208, 'AR', 'Arusha', 1, 0),
(3164, 208, 'DS', 'Dar es Salaam', 1, 0),
(3165, 208, 'DO', 'Dodoma', 1, 0),
(3166, 208, 'IR', 'Iringa', 1, 0),
(3167, 208, 'KA', 'Kagera', 1, 0),
(3168, 208, 'KI', 'Kigoma', 1, 0),
(3169, 208, 'KJ', 'Kilimanjaro', 1, 0),
(3170, 208, 'LN', 'Lindi', 1, 0),
(3171, 208, 'MY', 'Manyara', 1, 0),
(3172, 208, 'MR', 'Mara', 1, 0),
(3173, 208, 'MB', 'Mbeya', 1, 0),
(3174, 208, 'MO', 'Morogoro', 1, 0),
(3175, 208, 'MT', 'Mtwara', 1, 0),
(3176, 208, 'MW', 'Mwanza', 1, 0),
(3177, 208, 'PN', 'Pemba North', 1, 0),
(3178, 208, 'PS', 'Pemba South', 1, 0),
(3179, 208, 'PW', 'Pwani', 1, 0),
(3180, 208, 'RK', 'Rukwa', 1, 0),
(3181, 208, 'RV', 'Ruvuma', 1, 0),
(3182, 208, 'SH', 'Shinyanga', 1, 0),
(3183, 208, 'SI', 'Singida', 1, 0),
(3184, 208, 'TB', 'Tabora', 1, 0),
(3185, 208, 'TN', 'Tanga', 1, 0),
(3186, 208, 'ZC', 'Zanzibar Central/South', 1, 0),
(3187, 208, 'ZN', 'Zanzibar North', 1, 0),
(3188, 208, 'ZU', 'Zanzibar Urban/West', 1, 0),
(3189, 209, 'Amnat Charoen', 'Amnat Charoen', 1, 0),
(3190, 209, 'Ang Thong', 'Ang Thong', 1, 0),
(3191, 209, 'Ayutthaya', 'Ayutthaya', 1, 0),
(3192, 209, 'Bangkok', 'Bangkok', 1, 0),
(3193, 209, 'Buriram', 'Buriram', 1, 0),
(3194, 209, 'Chachoengsao', 'Chachoengsao', 1, 0),
(3195, 209, 'Chai Nat', 'Chai Nat', 1, 0),
(3196, 209, 'Chaiyaphum', 'Chaiyaphum', 1, 0),
(3197, 209, 'Chanthaburi', 'Chanthaburi', 1, 0),
(3198, 209, 'Chiang Mai', 'Chiang Mai', 1, 0),
(3199, 209, 'Chiang Rai', 'Chiang Rai', 1, 0),
(3200, 209, 'Chon Buri', 'Chon Buri', 1, 0),
(3201, 209, 'Chumphon', 'Chumphon', 1, 0),
(3202, 209, 'Kalasin', 'Kalasin', 1, 0),
(3203, 209, 'Kamphaeng Phet', 'Kamphaeng Phet', 1, 0),
(3204, 209, 'Kanchanaburi', 'Kanchanaburi', 1, 0),
(3205, 209, 'Khon Kaen', 'Khon Kaen', 1, 0),
(3206, 209, 'Krabi', 'Krabi', 1, 0),
(3207, 209, 'Lampang', 'Lampang', 1, 0),
(3208, 209, 'Lamphun', 'Lamphun', 1, 0),
(3209, 209, 'Loei', 'Loei', 1, 0),
(3210, 209, 'Lop Buri', 'Lop Buri', 1, 0),
(3211, 209, 'Mae Hong Son', 'Mae Hong Son', 1, 0),
(3212, 209, 'Maha Sarakham', 'Maha Sarakham', 1, 0),
(3213, 209, 'Mukdahan', 'Mukdahan', 1, 0),
(3214, 209, 'Nakhon Nayok', 'Nakhon Nayok', 1, 0),
(3215, 209, 'Nakhon Pathom', 'Nakhon Pathom', 1, 0),
(3216, 209, 'Nakhon Phanom', 'Nakhon Phanom', 1, 0),
(3217, 209, 'Nakhon Ratchasima', 'Nakhon Ratchasima', 1, 0),
(3218, 209, 'Nakhon Sawan', 'Nakhon Sawan', 1, 0),
(3219, 209, 'Nakhon Si Thammarat', 'Nakhon Si Thammarat', 1, 0),
(3220, 209, 'Nan', 'Nan', 1, 0),
(3221, 209, 'Narathiwat', 'Narathiwat', 1, 0),
(3222, 209, 'Nong Bua Lamphu', 'Nong Bua Lamphu', 1, 0),
(3223, 209, 'Nong Khai', 'Nong Khai', 1, 0),
(3224, 209, 'Nonthaburi', 'Nonthaburi', 1, 0),
(3225, 209, 'Pathum Thani', 'Pathum Thani', 1, 0),
(3226, 209, 'Pattani', 'Pattani', 1, 0),
(3227, 209, 'Phangnga', 'Phangnga', 1, 0),
(3228, 209, 'Phatthalung', 'Phatthalung', 1, 0),
(3229, 209, 'Phayao', 'Phayao', 1, 0),
(3230, 209, 'Phetchabun', 'Phetchabun', 1, 0),
(3231, 209, 'Phetchaburi', 'Phetchaburi', 1, 0),
(3232, 209, 'Phichit', 'Phichit', 1, 0),
(3233, 209, 'Phitsanulok', 'Phitsanulok', 1, 0),
(3234, 209, 'Phrae', 'Phrae', 1, 0),
(3235, 209, 'Phuket', 'Phuket', 1, 0),
(3236, 209, 'Prachin Buri', 'Prachin Buri', 1, 0),
(3237, 209, 'Prachuap Khiri Khan', 'Prachuap Khiri Khan', 1, 0),
(3238, 209, 'Ranong', 'Ranong', 1, 0),
(3239, 209, 'Ratchaburi', 'Ratchaburi', 1, 0),
(3240, 209, 'Rayong', 'Rayong', 1, 0),
(3241, 209, 'Roi Et', 'Roi Et', 1, 0),
(3242, 209, 'Sa Kaeo', 'Sa Kaeo', 1, 0),
(3243, 209, 'Sakon Nakhon', 'Sakon Nakhon', 1, 0),
(3244, 209, 'Samut Prakan', 'Samut Prakan', 1, 0),
(3245, 209, 'Samut Sakhon', 'Samut Sakhon', 1, 0),
(3246, 209, 'Samut Songkhram', 'Samut Songkhram', 1, 0),
(3247, 209, 'Sara Buri', 'Sara Buri', 1, 0),
(3248, 209, 'Satun', 'Satun', 1, 0),
(3249, 209, 'Sing Buri', 'Sing Buri', 1, 0),
(3250, 209, 'Sisaket', 'Sisaket', 1, 0),
(3251, 209, 'Songkhla', 'Songkhla', 1, 0),
(3252, 209, 'Sukhothai', 'Sukhothai', 1, 0),
(3253, 209, 'Suphan Buri', 'Suphan Buri', 1, 0),
(3254, 209, 'Surat Thani', 'Surat Thani', 1, 0),
(3255, 209, 'Surin', 'Surin', 1, 0),
(3256, 209, 'Tak', 'Tak', 1, 0),
(3257, 209, 'Trang', 'Trang', 1, 0),
(3258, 209, 'Trat', 'Trat', 1, 0),
(3259, 209, 'Ubon Ratchathani', 'Ubon Ratchathani', 1, 0),
(3260, 209, 'Udon Thani', 'Udon Thani', 1, 0),
(3261, 209, 'Uthai Thani', 'Uthai Thani', 1, 0),
(3262, 209, 'Uttaradit', 'Uttaradit', 1, 0),
(3263, 209, 'Yala', 'Yala', 1, 0),
(3264, 209, 'Yasothon', 'Yasothon', 1, 0),
(3265, 210, 'K', 'Kara', 1, 0),
(3266, 210, 'P', 'Plateaux', 1, 0),
(3267, 210, 'S', 'Savanes', 1, 0),
(3268, 210, 'C', 'Centrale', 1, 0),
(3269, 210, 'M', 'Maritime', 1, 0),
(3270, 211, 'A', 'Atafu', 1, 0),
(3271, 211, 'F', 'Fakaofo', 1, 0),
(3272, 211, 'N', 'Nukunonu', 1, 0),
(3273, 212, 'H', 'Ha\'apai', 1, 0),
(3274, 212, 'T', 'Tongatapu', 1, 0),
(3275, 212, 'V', 'Vava\'u', 1, 0),
(3276, 213, 'CT', 'Couva/Tabaquite/Talparo', 1, 0),
(3277, 213, 'DM', 'Diego Martin', 1, 0),
(3278, 213, 'MR', 'Mayaro/Rio Claro', 1, 0),
(3279, 213, 'PD', 'Penal/Debe', 1, 0),
(3280, 213, 'PT', 'Princes Town', 1, 0),
(3281, 213, 'SG', 'Sangre Grande', 1, 0),
(3282, 213, 'SL', 'San Juan/Laventille', 1, 0),
(3283, 213, 'SI', 'Siparia', 1, 0),
(3284, 213, 'TP', 'Tunapuna/Piarco', 1, 0),
(3285, 213, 'PS', 'Port of Spain', 1, 0),
(3286, 213, 'SF', 'San Fernando', 1, 0),
(3287, 213, 'AR', 'Arima', 1, 0),
(3288, 213, 'PF', 'Point Fortin', 1, 0),
(3289, 213, 'CH', 'Chaguanas', 1, 0),
(3290, 213, 'TO', 'Tobago', 1, 0),
(3291, 214, 'AR', 'Ariana', 1, 0),
(3292, 214, 'BJ', 'Beja', 1, 0),
(3293, 214, 'BA', 'Ben Arous', 1, 0),
(3294, 214, 'BI', 'Bizerte', 1, 0),
(3295, 214, 'GB', 'Gabes', 1, 0),
(3296, 214, 'GF', 'Gafsa', 1, 0),
(3297, 214, 'JE', 'Jendouba', 1, 0),
(3298, 214, 'KR', 'Kairouan', 1, 0),
(3299, 214, 'KS', 'Kasserine', 1, 0),
(3300, 214, 'KB', 'Kebili', 1, 0),
(3301, 214, 'KF', 'Kef', 1, 0),
(3302, 214, 'MH', 'Mahdia', 1, 0),
(3303, 214, 'MN', 'Manouba', 1, 0),
(3304, 214, 'ME', 'Medenine', 1, 0),
(3305, 214, 'MO', 'Monastir', 1, 0),
(3306, 214, 'NA', 'Nabeul', 1, 0),
(3307, 214, 'SF', 'Sfax', 1, 0),
(3308, 214, 'SD', 'Sidi', 1, 0),
(3309, 214, 'SL', 'Siliana', 1, 0),
(3310, 214, 'SO', 'Sousse', 1, 0),
(3311, 214, 'TA', 'Tataouine', 1, 0),
(3312, 214, 'TO', 'Tozeur', 1, 0),
(3313, 214, 'TU', 'Tunis', 1, 0),
(3314, 214, 'ZA', 'Zaghouan', 1, 0),
(3315, 215, 'ADA', 'Adana', 1, 0),
(3316, 215, 'ADI', 'Adiyaman', 1, 0),
(3317, 215, 'AFY', 'Afyonkarahisar', 1, 0),
(3318, 215, 'AGR', 'Agri', 1, 0),
(3319, 215, 'AKS', 'Aksaray', 1, 0),
(3320, 215, 'AMA', 'Amasya', 1, 0),
(3321, 215, 'ANK', 'Ankara', 1, 0),
(3322, 215, 'ANT', 'Antalya', 1, 0),
(3323, 215, 'ARD', 'Ardahan', 1, 0),
(3324, 215, 'ART', 'Artvin', 1, 0),
(3325, 215, 'AYI', 'Aydin', 1, 0),
(3326, 215, 'BAL', 'Balikesir', 1, 0),
(3327, 215, 'BAR', 'Bartin', 1, 0),
(3328, 215, 'BAT', 'Batman', 1, 0),
(3329, 215, 'BAY', 'Bayburt', 1, 0),
(3330, 215, 'BIL', 'Bilecik', 1, 0),
(3331, 215, 'BIN', 'Bingol', 1, 0),
(3332, 215, 'BIT', 'Bitlis', 1, 0),
(3333, 215, 'BOL', 'Bolu', 1, 0),
(3334, 215, 'BRD', 'Burdur', 1, 0),
(3335, 215, 'BRS', 'Bursa', 1, 0),
(3336, 215, 'CKL', 'Canakkale', 1, 0),
(3337, 215, 'CKR', 'Cankiri', 1, 0),
(3338, 215, 'COR', 'Corum', 1, 0),
(3339, 215, 'DEN', 'Denizli', 1, 0),
(3340, 215, 'DIY', 'Diyarbakir', 1, 0),
(3341, 215, 'DUZ', 'Duzce', 1, 0),
(3342, 215, 'EDI', 'Edirne', 1, 0),
(3343, 215, 'ELA', 'Elazig', 1, 0),
(3344, 215, 'EZC', 'Erzincan', 1, 0),
(3345, 215, 'EZR', 'Erzurum', 1, 0),
(3346, 215, 'ESK', 'Eskisehir', 1, 0),
(3347, 215, 'GAZ', 'Gaziantep', 1, 0),
(3348, 215, 'GIR', 'Giresun', 1, 0),
(3349, 215, 'GMS', 'Gumushane', 1, 0),
(3350, 215, 'HKR', 'Hakkari', 1, 0),
(3351, 215, 'HTY', 'Hatay', 1, 0),
(3352, 215, 'IGD', 'Igdir', 1, 0),
(3353, 215, 'ISP', 'Isparta', 1, 0),
(3354, 215, 'IST', 'Istanbul', 1, 0),
(3355, 215, 'IZM', 'Izmir', 1, 0),
(3356, 215, 'KAH', 'Kahramanmaras', 1, 0),
(3357, 215, 'KRB', 'Karabuk', 1, 0),
(3358, 215, 'KRM', 'Karaman', 1, 0),
(3359, 215, 'KRS', 'Kars', 1, 0),
(3360, 215, 'KAS', 'Kastamonu', 1, 0),
(3361, 215, 'KAY', 'Kayseri', 1, 0),
(3362, 215, 'KLS', 'Kilis', 1, 0),
(3363, 215, 'KRK', 'Kirikkale', 1, 0),
(3364, 215, 'KLR', 'Kirklareli', 1, 0),
(3365, 215, 'KRH', 'Kirsehir', 1, 0),
(3366, 215, 'KOC', 'Kocaeli', 1, 0),
(3367, 215, 'KON', 'Konya', 1, 0),
(3368, 215, 'KUT', 'Kutahya', 1, 0),
(3369, 215, 'MAL', 'Malatya', 1, 0),
(3370, 215, 'MAN', 'Manisa', 1, 0),
(3371, 215, 'MAR', 'Mardin', 1, 0),
(3372, 215, 'MER', 'Mersin', 1, 0),
(3373, 215, 'MUG', 'Mugla', 1, 0),
(3374, 215, 'MUS', 'Mus', 1, 0),
(3375, 215, 'NEV', 'Nevsehir', 1, 0),
(3376, 215, 'NIG', 'Nigde', 1, 0),
(3377, 215, 'ORD', 'Ordu', 1, 0),
(3378, 215, 'OSM', 'Osmaniye', 1, 0),
(3379, 215, 'RIZ', 'Rize', 1, 0),
(3380, 215, 'SAK', 'Sakarya', 1, 0),
(3381, 215, 'SAM', 'Samsun', 1, 0),
(3382, 215, 'SAN', 'Sanliurfa', 1, 0),
(3383, 215, 'SII', 'Siirt', 1, 0),
(3384, 215, 'SIN', 'Sinop', 1, 0),
(3385, 215, 'SIR', 'Sirnak', 1, 0),
(3386, 215, 'SIV', 'Sivas', 1, 0),
(3387, 215, 'TEL', 'Tekirdag', 1, 0),
(3388, 215, 'TOK', 'Tokat', 1, 0),
(3389, 215, 'TRA', 'Trabzon', 1, 0),
(3390, 215, 'TUN', 'Tunceli', 1, 0),
(3391, 215, 'USK', 'Usak', 1, 0),
(3392, 215, 'VAN', 'Van', 1, 0),
(3393, 215, 'YAL', 'Yalova', 1, 0),
(3394, 215, 'YOZ', 'Yozgat', 1, 0),
(3395, 215, 'ZON', 'Zonguldak', 1, 0),
(3396, 216, 'A', 'Ahal Welayaty', 1, 0),
(3397, 216, 'B', 'Balkan Welayaty', 1, 0),
(3398, 216, 'D', 'Dashhowuz Welayaty', 1, 0),
(3399, 216, 'L', 'Lebap Welayaty', 1, 0),
(3400, 216, 'M', 'Mary Welayaty', 1, 0),
(3401, 217, 'AC', 'Ambergris Cays', 1, 0),
(3402, 217, 'DC', 'Dellis Cay', 1, 0),
(3403, 217, 'FC', 'French Cay', 1, 0),
(3404, 217, 'LW', 'Little Water Cay', 1, 0),
(3405, 217, 'RC', 'Parrot Cay', 1, 0),
(3406, 217, 'PN', 'Pine Cay', 1, 0),
(3407, 217, 'SL', 'Salt Cay', 1, 0),
(3408, 217, 'GT', 'Grand Turk', 1, 0),
(3409, 217, 'SC', 'South Caicos', 1, 0),
(3410, 217, 'EC', 'East Caicos', 1, 0),
(3411, 217, 'MC', 'Middle Caicos', 1, 0),
(3412, 217, 'NC', 'North Caicos', 1, 0),
(3413, 217, 'PR', 'Providenciales', 1, 0),
(3414, 217, 'WC', 'West Caicos', 1, 0),
(3415, 218, 'NMG', 'Nanumanga', 1, 0),
(3416, 218, 'NLK', 'Niulakita', 1, 0),
(3417, 218, 'NTO', 'Niutao', 1, 0),
(3418, 218, 'FUN', 'Funafuti', 1, 0),
(3419, 218, 'NME', 'Nanumea', 1, 0),
(3420, 218, 'NUI', 'Nui', 1, 0),
(3421, 218, 'NFT', 'Nukufetau', 1, 0),
(3422, 218, 'NLL', 'Nukulaelae', 1, 0),
(3423, 218, 'VAI', 'Vaitupu', 1, 0),
(3424, 219, 'KAL', 'Kalangala', 1, 0),
(3425, 219, 'KMP', 'Kampala', 1, 0),
(3426, 219, 'KAY', 'Kayunga', 1, 0),
(3427, 219, 'KIB', 'Kiboga', 1, 0),
(3428, 219, 'LUW', 'Luwero', 1, 0),
(3429, 219, 'MAS', 'Masaka', 1, 0),
(3430, 219, 'MPI', 'Mpigi', 1, 0),
(3431, 219, 'MUB', 'Mubende', 1, 0),
(3432, 219, 'MUK', 'Mukono', 1, 0),
(3433, 219, 'NKS', 'Nakasongola', 1, 0),
(3434, 219, 'RAK', 'Rakai', 1, 0),
(3435, 219, 'SEM', 'Sembabule', 1, 0),
(3436, 219, 'WAK', 'Wakiso', 1, 0),
(3437, 219, 'BUG', 'Bugiri', 1, 0),
(3438, 219, 'BUS', 'Busia', 1, 0),
(3439, 219, 'IGA', 'Iganga', 1, 0),
(3440, 219, 'JIN', 'Jinja', 1, 0),
(3441, 219, 'KAB', 'Kaberamaido', 1, 0),
(3442, 219, 'KML', 'Kamuli', 1, 0),
(3443, 219, 'KPC', 'Kapchorwa', 1, 0),
(3444, 219, 'KTK', 'Katakwi', 1, 0),
(3445, 219, 'KUM', 'Kumi', 1, 0),
(3446, 219, 'MAY', 'Mayuge', 1, 0),
(3447, 219, 'MBA', 'Mbale', 1, 0),
(3448, 219, 'PAL', 'Pallisa', 1, 0),
(3449, 219, 'SIR', 'Sironko', 1, 0),
(3450, 219, 'SOR', 'Soroti', 1, 0),
(3451, 219, 'TOR', 'Tororo', 1, 0),
(3452, 219, 'ADJ', 'Adjumani', 1, 0),
(3453, 219, 'APC', 'Apac', 1, 0),
(3454, 219, 'ARU', 'Arua', 1, 0),
(3455, 219, 'GUL', 'Gulu', 1, 0),
(3456, 219, 'KIT', 'Kitgum', 1, 0),
(3457, 219, 'KOT', 'Kotido', 1, 0),
(3458, 219, 'LIR', 'Lira', 1, 0),
(3459, 219, 'MRT', 'Moroto', 1, 0),
(3460, 219, 'MOY', 'Moyo', 1, 0),
(3461, 219, 'NAK', 'Nakapiripirit', 1, 0),
(3462, 219, 'NEB', 'Nebbi', 1, 0),
(3463, 219, 'PAD', 'Pader', 1, 0),
(3464, 219, 'YUM', 'Yumbe', 1, 0),
(3465, 219, 'BUN', 'Bundibugyo', 1, 0),
(3466, 219, 'BSH', 'Bushenyi', 1, 0),
(3467, 219, 'HOI', 'Hoima', 1, 0),
(3468, 219, 'KBL', 'Kabale', 1, 0),
(3469, 219, 'KAR', 'Kabarole', 1, 0),
(3470, 219, 'KAM', 'Kamwenge', 1, 0),
(3471, 219, 'KAN', 'Kanungu', 1, 0),
(3472, 219, 'KAS', 'Kasese', 1, 0),
(3473, 219, 'KBA', 'Kibaale', 1, 0),
(3474, 219, 'KIS', 'Kisoro', 1, 0),
(3475, 219, 'KYE', 'Kyenjojo', 1, 0),
(3476, 219, 'MSN', 'Masindi', 1, 0),
(3477, 219, 'MBR', 'Mbarara', 1, 0),
(3478, 219, 'NTU', 'Ntungamo', 1, 0),
(3479, 219, 'RUK', 'Rukungiri', 1, 0),
(3480, 220, 'CK', 'Cherkasy', 1, 0),
(3481, 220, 'CH', 'Chernihiv', 1, 0),
(3482, 220, 'CV', 'Chernivtsi', 1, 0),
(3483, 220, 'CR', 'Crimea', 1, 0),
(3484, 220, 'DN', 'Dnipropetrovs\'k', 1, 0),
(3485, 220, 'DO', 'Donets\'k', 1, 0),
(3486, 220, 'IV', 'Ivano-Frankivs\'k', 1, 0),
(3487, 220, 'KL', 'Kharkiv Kherson', 1, 0),
(3488, 220, 'KM', 'Khmel\'nyts\'kyy', 1, 0),
(3489, 220, 'KR', 'Kirovohrad', 1, 0),
(3490, 220, 'KV', 'Kiev', 1, 0),
(3491, 220, 'KY', 'Kyyiv', 1, 0),
(3492, 220, 'LU', 'Luhans\'k', 1, 0),
(3493, 220, 'LV', 'L\'viv', 1, 0),
(3494, 220, 'MY', 'Mykolayiv', 1, 0),
(3495, 220, 'OD', 'Odesa', 1, 0),
(3496, 220, 'PO', 'Poltava', 1, 0),
(3497, 220, 'RI', 'Rivne', 1, 0),
(3498, 220, 'SE', 'Sevastopol', 1, 0),
(3499, 220, 'SU', 'Sumy', 1, 0),
(3500, 220, 'TE', 'Ternopil\'', 1, 0),
(3501, 220, 'VI', 'Vinnytsya', 1, 0),
(3502, 220, 'VO', 'Volyn\'', 1, 0),
(3503, 220, 'ZK', 'Zakarpattya', 1, 0),
(3504, 220, 'ZA', 'Zaporizhzhya', 1, 0),
(3505, 220, 'ZH', 'Zhytomyr', 1, 0),
(3506, 221, 'AZ', 'Abu Zaby', 1, 0),
(3507, 221, 'AJ', '\'Ajman', 1, 0),
(3508, 221, 'FU', 'Al Fujayrah', 1, 0),
(3509, 221, 'SH', 'Ash Shariqah', 1, 0),
(3510, 221, 'DU', 'Dubayy', 1, 0),
(3511, 221, 'RK', 'R\'as al Khaymah', 1, 0),
(3512, 221, 'UQ', 'Umm al Qaywayn', 1, 0),
(3513, 222, 'ABN', 'Aberdeen', 1, 0),
(3514, 222, 'ABNS', 'Aberdeenshire', 1, 0),
(3515, 222, 'ANG', 'Anglesey', 1, 0),
(3516, 222, 'AGS', 'Angus', 1, 0),
(3517, 222, 'ARY', 'Argyll and Bute', 1, 0),
(3518, 222, 'BEDS', 'Bedfordshire', 1, 0),
(3519, 222, 'BERKS', 'Berkshire', 1, 0),
(3520, 222, 'BLA', 'Blaenau Gwent', 1, 0),
(3521, 222, 'BRI', 'Bridgend', 1, 0),
(3522, 222, 'BSTL', 'Bristol', 1, 0),
(3523, 222, 'BUCKS', 'Buckinghamshire', 1, 0),
(3524, 222, 'CAE', 'Caerphilly', 1, 0),
(3525, 222, 'CAMBS', 'Cambridgeshire', 1, 0),
(3526, 222, 'CDF', 'Cardiff', 1, 0),
(3527, 222, 'CARM', 'Carmarthenshire', 1, 0),
(3528, 222, 'CDGN', 'Ceredigion', 1, 0),
(3529, 222, 'CHES', 'Cheshire', 1, 0),
(3530, 222, 'CLACK', 'Clackmannanshire', 1, 0),
(3531, 222, 'CON', 'Conwy', 1, 0),
(3532, 222, 'CORN', 'Cornwall', 1, 0),
(3533, 222, 'DNBG', 'Denbighshire', 1, 0),
(3534, 222, 'DERBY', 'Derbyshire', 1, 0),
(3535, 222, 'DVN', 'Devon', 1, 0),
(3536, 222, 'DOR', 'Dorset', 1, 0),
(3537, 222, 'DGL', 'Dumfries and Galloway', 1, 0),
(3538, 222, 'DUND', 'Dundee', 1, 0),
(3539, 222, 'DHM', 'Durham', 1, 0),
(3540, 222, 'ARYE', 'East Ayrshire', 1, 0),
(3541, 222, 'DUNBE', 'East Dunbartonshire', 1, 0),
(3542, 222, 'LOTE', 'East Lothian', 1, 0),
(3543, 222, 'RENE', 'East Renfrewshire', 1, 0),
(3544, 222, 'ERYS', 'East Riding of Yorkshire', 1, 0),
(3545, 222, 'SXE', 'East Sussex', 1, 0),
(3546, 222, 'EDIN', 'Edinburgh', 1, 0),
(3547, 222, 'ESX', 'Essex', 1, 0),
(3548, 222, 'FALK', 'Falkirk', 1, 0),
(3549, 222, 'FFE', 'Fife', 1, 0),
(3550, 222, 'FLINT', 'Flintshire', 1, 0),
(3551, 222, 'GLAS', 'Glasgow', 1, 0),
(3552, 222, 'GLOS', 'Gloucestershire', 1, 0),
(3553, 222, 'LDN', 'Greater London', 1, 0),
(3554, 222, 'MCH', 'Greater Manchester', 1, 0),
(3555, 222, 'GDD', 'Gwynedd', 1, 0),
(3556, 222, 'HANTS', 'Hampshire', 1, 0),
(3557, 222, 'HWR', 'Herefordshire', 1, 0),
(3558, 222, 'HERTS', 'Hertfordshire', 1, 0),
(3559, 222, 'HLD', 'Highlands', 1, 0),
(3560, 222, 'IVER', 'Inverclyde', 1, 0),
(3561, 222, 'IOW', 'Isle of Wight', 1, 0),
(3562, 222, 'KNT', 'Kent', 1, 0),
(3563, 222, 'LANCS', 'Lancashire', 1, 0),
(3564, 222, 'LEICS', 'Leicestershire', 1, 0),
(3565, 222, 'LINCS', 'Lincolnshire', 1, 0),
(3566, 222, 'MSY', 'Merseyside', 1, 0),
(3567, 222, 'MERT', 'Merthyr Tydfil', 1, 0),
(3568, 222, 'MLOT', 'Midlothian', 1, 0),
(3569, 222, 'MMOUTH', 'Monmouthshire', 1, 0),
(3570, 222, 'MORAY', 'Moray', 1, 0),
(3571, 222, 'NPRTAL', 'Neath Port Talbot', 1, 0),
(3572, 222, 'NEWPT', 'Newport', 1, 0),
(3573, 222, 'NOR', 'Norfolk', 1, 0),
(3574, 222, 'ARYN', 'North Ayrshire', 1, 0),
(3575, 222, 'LANN', 'North Lanarkshire', 1, 0),
(3576, 222, 'YSN', 'North Yorkshire', 1, 0),
(3577, 222, 'NHM', 'Northamptonshire', 1, 0),
(3578, 222, 'NLD', 'Northumberland', 1, 0),
(3579, 222, 'NOT', 'Nottinghamshire', 1, 0),
(3580, 222, 'ORK', 'Orkney Islands', 1, 0),
(3581, 222, 'OFE', 'Oxfordshire', 1, 0),
(3582, 222, 'PEM', 'Pembrokeshire', 1, 0),
(3583, 222, 'PERTH', 'Perth and Kinross', 1, 0),
(3584, 222, 'PWS', 'Powys', 1, 0),
(3585, 222, 'REN', 'Renfrewshire', 1, 0),
(3586, 222, 'RHON', 'Rhondda Cynon Taff', 1, 0),
(3587, 222, 'RUT', 'Rutland', 1, 0),
(3588, 222, 'BOR', 'Scottish Borders', 1, 0),
(3589, 222, 'SHET', 'Shetland Islands', 1, 0),
(3590, 222, 'SPE', 'Shropshire', 1, 0),
(3591, 222, 'SOM', 'Somerset', 1, 0),
(3592, 222, 'ARYS', 'South Ayrshire', 1, 0),
(3593, 222, 'LANS', 'South Lanarkshire', 1, 0),
(3594, 222, 'YSS', 'South Yorkshire', 1, 0),
(3595, 222, 'SFD', 'Staffordshire', 1, 0),
(3596, 222, 'STIR', 'Stirling', 1, 0),
(3597, 222, 'SFK', 'Suffolk', 1, 0),
(3598, 222, 'SRY', 'Surrey', 1, 0),
(3599, 222, 'SWAN', 'Swansea', 1, 0),
(3600, 222, 'TORF', 'Torfaen', 1, 0),
(3601, 222, 'TWR', 'Tyne and Wear', 1, 0),
(3602, 222, 'VGLAM', 'Vale of Glamorgan', 1, 0),
(3603, 222, 'WARKS', 'Warwickshire', 1, 0),
(3604, 222, 'WDUN', 'West Dunbartonshire', 1, 0),
(3605, 222, 'WLOT', 'West Lothian', 1, 0),
(3606, 222, 'WMD', 'West Midlands', 1, 0),
(3607, 222, 'SXW', 'West Sussex', 1, 0),
(3608, 222, 'YSW', 'West Yorkshire', 1, 0),
(3609, 222, 'WIL', 'Western Isles', 1, 0),
(3610, 222, 'WLT', 'Wiltshire', 1, 0),
(3611, 222, 'WORCS', 'Worcestershire', 1, 0),
(3612, 222, 'WRX', 'Wrexham', 1, 0),
(3613, 223, 'AL', 'Alabama', 1, 0),
(3614, 223, 'AK', 'Alaska', 1, 0),
(3615, 223, 'AS', 'American Samoa', 1, 0),
(3616, 223, 'AZ', 'Arizona', 1, 0),
(3617, 223, 'AR', 'Arkansas', 1, 0),
(3618, 223, 'AF', 'Armed Forces Africa', 1, 0),
(3619, 223, 'AA', 'Armed Forces Americas', 1, 0),
(3620, 223, 'AC', 'Armed Forces Canada', 1, 0),
(3621, 223, 'AE', 'Armed Forces Europe', 1, 0),
(3622, 223, 'AM', 'Armed Forces Middle East', 1, 0),
(3623, 223, 'AP', 'Armed Forces Pacific', 1, 0),
(3624, 223, 'CA', 'California', 1, 0),
(3625, 223, 'CO', 'Colorado', 1, 0),
(3626, 223, 'CT', 'Connecticut', 1, 0),
(3627, 223, 'DE', 'Delaware', 1, 0),
(3628, 223, 'DC', 'District of Columbia', 1, 0),
(3629, 223, 'FM', 'Federated States Of Micronesia', 1, 0),
(3630, 223, 'FL', 'Florida', 1, 0),
(3631, 223, 'GA', 'Georgia', 1, 0),
(3632, 223, 'GU', 'Guam', 1, 0),
(3633, 223, 'HI', 'Hawaii', 1, 0),
(3634, 223, 'ID', 'Idaho', 1, 0),
(3635, 223, 'IL', 'Illinois', 1, 0),
(3636, 223, 'IN', 'Indiana', 1, 0),
(3637, 223, 'IA', 'Iowa', 1, 0),
(3638, 223, 'KS', 'Kansas', 1, 0),
(3639, 223, 'KY', 'Kentucky', 1, 0),
(3640, 223, 'LA', 'Louisiana', 1, 0),
(3641, 223, 'ME', 'Maine', 1, 0),
(3642, 223, 'MH', 'Marshall Islands', 1, 0),
(3643, 223, 'MD', 'Maryland', 1, 0),
(3644, 223, 'MA', 'Massachusetts', 1, 0),
(3645, 223, 'MI', 'Michigan', 1, 0),
(3646, 223, 'MN', 'Minnesota', 1, 0),
(3647, 223, 'MS', 'Mississippi', 1, 0),
(3648, 223, 'MO', 'Missouri', 1, 0),
(3649, 223, 'MT', 'Montana', 1, 0),
(3650, 223, 'NE', 'Nebraska', 1, 0),
(3651, 223, 'NV', 'Nevada', 1, 0),
(3652, 223, 'NH', 'New Hampshire', 1, 0),
(3653, 223, 'NJ', 'New Jersey', 1, 0),
(3654, 223, 'NM', 'New Mexico', 1, 0),
(3655, 223, 'NY', 'New York', 1, 0),
(3656, 223, 'NC', 'North Carolina', 1, 0),
(3657, 223, 'ND', 'North Dakota', 1, 0),
(3658, 223, 'MP', 'Northern Mariana Islands', 1, 0),
(3659, 223, 'OH', 'Ohio', 1, 0),
(3660, 223, 'OK', 'Oklahoma', 1, 0),
(3661, 223, 'OR', 'Oregon', 1, 0),
(3662, 223, 'PW', 'Palau', 1, 0),
(3663, 223, 'PA', 'Pennsylvania', 1, 0),
(3664, 223, 'PR', 'Puerto Rico', 1, 0),
(3665, 223, 'RI', 'Rhode Island', 1, 0),
(3666, 223, 'SC', 'South Carolina', 1, 0),
(3667, 223, 'SD', 'South Dakota', 1, 0),
(3668, 223, 'TN', 'Tennessee', 1, 0),
(3669, 223, 'TX', 'Texas', 1, 0),
(3670, 223, 'UT', 'Utah', 1, 0),
(3671, 223, 'VT', 'Vermont', 1, 0),
(3672, 223, 'VI', 'Virgin Islands', 1, 0),
(3673, 223, 'VA', 'Virginia', 1, 0),
(3674, 223, 'WA', 'Washington', 1, 0),
(3675, 223, 'WV', 'West Virginia', 1, 0),
(3676, 223, 'WI', 'Wisconsin', 1, 0),
(3677, 223, 'WY', 'Wyoming', 1, 0),
(3678, 224, 'BI', 'Baker Island', 1, 0),
(3679, 224, 'HI', 'Howland Island', 1, 0),
(3680, 224, 'JI', 'Jarvis Island', 1, 0),
(3681, 224, 'JA', 'Johnston Atoll', 1, 0),
(3682, 224, 'KR', 'Kingman Reef', 1, 0),
(3683, 224, 'MA', 'Midway Atoll', 1, 0),
(3684, 224, 'NI', 'Navassa Island', 1, 0),
(3685, 224, 'PA', 'Palmyra Atoll', 1, 0),
(3686, 224, 'WI', 'Wake Island', 1, 0),
(3687, 225, 'AR', 'Artigas', 1, 0),
(3688, 225, 'CA', 'Canelones', 1, 0),
(3689, 225, 'CL', 'Cerro Largo', 1, 0),
(3690, 225, 'CO', 'Colonia', 1, 0),
(3691, 225, 'DU', 'Durazno', 1, 0),
(3692, 225, 'FS', 'Flores', 1, 0),
(3693, 225, 'FA', 'Florida', 1, 0),
(3694, 225, 'LA', 'Lavalleja', 1, 0),
(3695, 225, 'MA', 'Maldonado', 1, 0),
(3696, 225, 'MO', 'Montevideo', 1, 0),
(3697, 225, 'PA', 'Paysandu', 1, 0),
(3698, 225, 'RN', 'Rio Negro', 1, 0),
(3699, 225, 'RV', 'Rivera', 1, 0),
(3700, 225, 'RO', 'Rocha', 1, 0),
(3701, 225, 'SL', 'Salto', 1, 0),
(3702, 225, 'SJ', 'San Jose', 1, 0),
(3703, 225, 'SO', 'Soriano', 1, 0),
(3704, 225, 'TA', 'Tacuarembo', 1, 0),
(3705, 225, 'TT', 'Treinta y Tres', 1, 0),
(3706, 226, 'AN', 'Andijon', 1, 0),
(3707, 226, 'BU', 'Buxoro', 1, 0),
(3708, 226, 'FA', 'Farg\'ona', 1, 0),
(3709, 226, 'JI', 'Jizzax', 1, 0),
(3710, 226, 'NG', 'Namangan', 1, 0),
(3711, 226, 'NW', 'Navoiy', 1, 0),
(3712, 226, 'QA', 'Qashqadaryo', 1, 0),
(3713, 226, 'QR', 'Qoraqalpog\'iston Republikasi', 1, 0),
(3714, 226, 'SA', 'Samarqand', 1, 0),
(3715, 226, 'SI', 'Sirdaryo', 1, 0),
(3716, 226, 'SU', 'Surxondaryo', 1, 0),
(3717, 226, 'TK', 'Toshkent City', 1, 0),
(3718, 226, 'TO', 'Toshkent Region', 1, 0),
(3719, 226, 'XO', 'Xorazm', 1, 0),
(3720, 227, 'MA', 'Malampa', 1, 0),
(3721, 227, 'PE', 'Penama', 1, 0),
(3722, 227, 'SA', 'Sanma', 1, 0),
(3723, 227, 'SH', 'Shefa', 1, 0),
(3724, 227, 'TA', 'Tafea', 1, 0),
(3725, 227, 'TO', 'Torba', 1, 0),
(3726, 229, 'AM', 'Amazonas', 1, 0),
(3727, 229, 'AN', 'Anzoategui', 1, 0),
(3728, 229, 'AP', 'Apure', 1, 0),
(3729, 229, 'AR', 'Aragua', 1, 0),
(3730, 229, 'BA', 'Barinas', 1, 0),
(3731, 229, 'BO', 'Bolivar', 1, 0),
(3732, 229, 'CA', 'Carabobo', 1, 0),
(3733, 229, 'CO', 'Cojedes', 1, 0),
(3734, 229, 'DA', 'Delta Amacuro', 1, 0),
(3735, 229, 'DF', 'Dependencias Federales', 1, 0),
(3736, 229, 'DI', 'Distrito Federal', 1, 0),
(3737, 229, 'FA', 'Falcon', 1, 0),
(3738, 229, 'GU', 'Guarico', 1, 0),
(3739, 229, 'LA', 'Lara', 1, 0),
(3740, 229, 'ME', 'Merida', 1, 0),
(3741, 229, 'MI', 'Miranda', 1, 0),
(3742, 229, 'MO', 'Monagas', 1, 0),
(3743, 229, 'NE', 'Nueva Esparta', 1, 0),
(3744, 229, 'PO', 'Portuguesa', 1, 0),
(3745, 229, 'SU', 'Sucre', 1, 0),
(3746, 229, 'TA', 'Tachira', 1, 0),
(3747, 229, 'TR', 'Trujillo', 1, 0),
(3748, 229, 'VA', 'Vargas', 1, 0),
(3749, 229, 'YA', 'Yaracuy', 1, 0),
(3750, 229, 'ZU', 'Zulia', 1, 0),
(3751, 230, 'AG', 'An Giang', 1, 0),
(3752, 230, 'BG', 'Bac Giang', 1, 0),
(3753, 230, 'BK', 'Bac Kan', 1, 0),
(3754, 230, 'BL', 'Bac Lieu', 1, 0),
(3755, 230, 'BC', 'Bac Ninh', 1, 0),
(3756, 230, 'BR', 'Ba Ria-Vung Tau', 1, 0),
(3757, 230, 'BN', 'Ben Tre', 1, 0),
(3758, 230, 'BH', 'Binh Dinh', 1, 0),
(3759, 230, 'BU', 'Binh Duong', 1, 0),
(3760, 230, 'BP', 'Binh Phuoc', 1, 0),
(3761, 230, 'BT', 'Binh Thuan', 1, 0),
(3762, 230, 'CM', 'Ca Mau', 1, 0),
(3763, 230, 'CT', 'Can Tho', 1, 0),
(3764, 230, 'CB', 'Cao Bang', 1, 0),
(3765, 230, 'DL', 'Dak Lak', 1, 0),
(3766, 230, 'DG', 'Dak Nong', 1, 0),
(3767, 230, 'DN', 'Da Nang', 1, 0),
(3768, 230, 'DB', 'Dien Bien', 1, 0),
(3769, 230, 'DI', 'Dong Nai', 1, 0),
(3770, 230, 'DT', 'Dong Thap', 1, 0),
(3771, 230, 'GL', 'Gia Lai', 1, 0),
(3772, 230, 'HG', 'Ha Giang', 1, 0),
(3773, 230, 'HD', 'Hai Duong', 1, 0),
(3774, 230, 'HP', 'Hai Phong', 1, 0),
(3775, 230, 'HM', 'Ha Nam', 1, 0),
(3776, 230, 'HI', 'Ha Noi', 1, 0),
(3777, 230, 'HT', 'Ha Tay', 1, 0),
(3778, 230, 'HH', 'Ha Tinh', 1, 0),
(3779, 230, 'HB', 'Hoa Binh', 1, 0),
(3780, 230, 'HC', 'Ho Chi Minh City', 1, 0),
(3781, 230, 'HU', 'Hau Giang', 1, 0),
(3782, 230, 'HY', 'Hung Yen', 1, 0),
(3783, 232, 'C', 'Saint Croix', 1, 0),
(3784, 232, 'J', 'Saint John', 1, 0),
(3785, 232, 'T', 'Saint Thomas', 1, 0),
(3786, 233, 'A', 'Alo', 1, 0),
(3787, 233, 'S', 'Sigave', 1, 0),
(3788, 233, 'W', 'Wallis', 1, 0),
(3789, 235, 'AB', 'Abyan', 1, 0),
(3790, 235, 'AD', 'Adan', 1, 0),
(3791, 235, 'AM', 'Amran', 1, 0),
(3792, 235, 'BA', 'Al Bayda', 1, 0),
(3793, 235, 'DA', 'Ad Dali', 1, 0),
(3794, 235, 'DH', 'Dhamar', 1, 0),
(3795, 235, 'HD', 'Hadramawt', 1, 0),
(3796, 235, 'HJ', 'Hajjah', 1, 0),
(3797, 235, 'HU', 'Al Hudaydah', 1, 0),
(3798, 235, 'IB', 'Ibb', 1, 0),
(3799, 235, 'JA', 'Al Jawf', 1, 0),
(3800, 235, 'LA', 'Lahij', 1, 0),
(3801, 235, 'MA', 'Ma\'rib', 1, 0),
(3802, 235, 'MR', 'Al Mahrah', 1, 0),
(3803, 235, 'MW', 'Al Mahwit', 1, 0),
(3804, 235, 'SD', 'Sa\'dah', 1, 0),
(3805, 235, 'SN', 'San\'a', 1, 0),
(3806, 235, 'SH', 'Shabwah', 1, 0),
(3807, 235, 'TA', 'Ta\'izz', 1, 0),
(3812, 237, 'BC', 'Bas-Congo', 1, 0),
(3813, 237, 'BN', 'Bandundu', 1, 0),
(3814, 237, 'EQ', 'Equateur', 1, 0),
(3815, 237, 'KA', 'Katanga', 1, 0),
(3816, 237, 'KE', 'Kasai-Oriental', 1, 0),
(3817, 237, 'KN', 'Kinshasa', 1, 0),
(3818, 237, 'KW', 'Kasai-Occidental', 1, 0),
(3819, 237, 'MA', 'Maniema', 1, 0),
(3820, 237, 'NK', 'Nord-Kivu', 1, 0),
(3821, 237, 'OR', 'Orientale', 1, 0),
(3822, 237, 'SK', 'Sud-Kivu', 1, 0),
(3823, 238, 'CE', 'Central', 1, 0),
(3824, 238, 'CB', 'Copperbelt', 1, 0),
(3825, 238, 'EA', 'Eastern', 1, 0),
(3826, 238, 'LP', 'Luapula', 1, 0),
(3827, 238, 'LK', 'Lusaka', 1, 0),
(3828, 238, 'NO', 'Northern', 1, 0),
(3829, 238, 'NW', 'North-Western', 1, 0),
(3830, 238, 'SO', 'Southern', 1, 0),
(3831, 238, 'WE', 'Western', 1, 0),
(3832, 239, 'BU', 'Bulawayo', 1, 0),
(3833, 239, 'HA', 'Harare', 1, 0),
(3834, 239, 'ML', 'Manicaland', 1, 0),
(3835, 239, 'MC', 'Mashonaland Central', 1, 0),
(3836, 239, 'ME', 'Mashonaland East', 1, 0),
(3837, 239, 'MW', 'Mashonaland West', 1, 0),
(3838, 239, 'MV', 'Masvingo', 1, 0),
(3839, 239, 'MN', 'Matabeleland North', 1, 0),
(3840, 239, 'MS', 'Matabeleland South', 1, 0),
(3841, 239, 'MD', 'Midlands', 1, 0),
(3842, 105, 'AG', 'Agrigento', 1, 0),
(3843, 105, 'AL', 'Alessandria', 1, 0),
(3844, 105, 'AN', 'Ancona', 1, 0),
(3845, 105, 'AO', 'Aosta', 1, 0),
(3846, 105, 'AR', 'Arezzo', 1, 0),
(3847, 105, 'AP', 'Ascoli Piceno', 1, 0),
(3848, 105, 'AT', 'Asti', 1, 0),
(3849, 105, 'AV', 'Avellino', 1, 0),
(3850, 105, 'BA', 'Bari', 1, 0),
(3851, 105, 'BT', 'Barletta-Andria-Trani', 1, 0),
(3852, 105, 'BL', 'Belluno', 1, 0),
(3853, 105, 'BN', 'Benevento', 1, 0),
(3854, 105, 'BG', 'Bergamo', 1, 0),
(3855, 105, 'BI', 'Biella', 1, 0),
(3856, 105, 'BO', 'Bologna', 1, 0),
(3857, 105, 'BZ', 'Bolzano', 1, 0),
(3858, 105, 'BS', 'Brescia', 1, 0),
(3859, 105, 'BR', 'Brindisi', 1, 0),
(3860, 105, 'CA', 'Cagliari', 1, 0),
(3861, 105, 'CL', 'Caltanissetta', 1, 0),
(3862, 105, 'CB', 'Campobasso', 1, 0),
(3863, 105, 'CI', 'Carbonia-Iglesias', 1, 0),
(3864, 105, 'CE', 'Caserta', 1, 0),
(3865, 105, 'CT', 'Catania', 1, 0),
(3866, 105, 'CZ', 'Catanzaro', 1, 0),
(3867, 105, 'CH', 'Chieti', 1, 0),
(3868, 105, 'CO', 'Como', 1, 0),
(3869, 105, 'CS', 'Cosenza', 1, 0),
(3870, 105, 'CR', 'Cremona', 1, 0),
(3871, 105, 'KR', 'Crotone', 1, 0),
(3872, 105, 'CN', 'Cuneo', 1, 0),
(3873, 105, 'EN', 'Enna', 1, 0),
(3874, 105, 'FM', 'Fermo', 1, 0),
(3875, 105, 'FE', 'Ferrara', 1, 0),
(3876, 105, 'FI', 'Firenze', 1, 0),
(3877, 105, 'FG', 'Foggia', 1, 0),
(3878, 105, 'FC', 'Forl', 1, 0),
(3879, 105, 'FR', 'Frosinone', 1, 0),
(3880, 105, 'GE', 'Genova', 1, 0),
(3881, 105, 'GO', 'Gorizia', 1, 0),
(3882, 105, 'GR', 'Grosseto', 1, 0),
(3883, 105, 'IM', 'Imperia', 1, 0),
(3884, 105, 'IS', 'Isernia', 1, 0),
(3885, 105, 'SP', 'La Spezia', 1, 0),
(3886, 105, 'AQ', 'L\'Aquila', 1, 0),
(3887, 105, 'LT', 'Latina', 1, 0),
(3888, 105, 'LE', 'Lecce', 1, 0),
(3889, 105, 'LC', 'Lecco', 1, 0),
(3890, 105, 'LI', 'Livorno', 1, 0),
(3891, 105, 'LO', 'Lodi', 1, 0),
(3892, 105, 'LU', 'Lucca', 1, 0),
(3893, 105, 'MC', 'Macerata', 1, 0),
(3894, 105, 'MN', 'Mantova', 1, 0),
(3895, 105, 'MS', 'Massa-Carrara', 1, 0),
(3896, 105, 'MT', 'Matera', 1, 0),
(3897, 105, 'ME', 'Messina', 1, 0),
(3898, 105, 'MI', 'Milano', 1, 0),
(3899, 105, 'MO', 'Modena', 1, 0),
(3900, 105, 'MB', 'Monza e della Brianza', 1, 0),
(3901, 105, 'NA', 'Napoli', 1, 0),
(3902, 105, 'NO', 'Novara', 1, 0),
(3903, 105, 'NU', 'Nuoro', 1, 0),
(3904, 105, 'OT', 'Olbia-Tempio', 1, 0),
(3905, 105, 'OR', 'Oristano', 1, 0),
(3906, 105, 'PD', 'Padova', 1, 0),
(3907, 105, 'PA', 'Palermo', 1, 0),
(3908, 105, 'PR', 'Parma', 1, 0),
(3909, 105, 'PV', 'Pavia', 1, 0),
(3910, 105, 'PG', 'Perugia', 1, 0),
(3911, 105, 'PU', 'Pesaro e Urbino', 1, 0),
(3912, 105, 'PE', 'Pescara', 1, 0),
(3913, 105, 'PC', 'Piacenza', 1, 0),
(3914, 105, 'PI', 'Pisa', 1, 0),
(3915, 105, 'PT', 'Pistoia', 1, 0),
(3916, 105, 'PN', 'Pordenone', 1, 0),
(3917, 105, 'PZ', 'Potenza', 1, 0),
(3918, 105, 'PO', 'Prato', 1, 0),
(3919, 105, 'RG', 'Ragusa', 1, 0),
(3920, 105, 'RA', 'Ravenna', 1, 0),
(3921, 105, 'RC', 'Reggio Calabria', 1, 0),
(3922, 105, 'RE', 'Reggio Emilia', 1, 0),
(3923, 105, 'RI', 'Rieti', 1, 0),
(3924, 105, 'RN', 'Rimini', 1, 0),
(3925, 105, 'RM', 'Roma', 1, 0),
(3926, 105, 'RO', 'Rovigo', 1, 0),
(3927, 105, 'SA', 'Salerno', 1, 0),
(3928, 105, 'VS', 'Medio Campidano', 1, 0),
(3929, 105, 'SS', 'Sassari', 1, 0),
(3930, 105, 'SV', 'Savona', 1, 0),
(3931, 105, 'SI', 'Siena', 1, 0),
(3932, 105, 'SR', 'Siracusa', 1, 0),
(3933, 105, 'SO', 'Sondrio', 1, 0),
(3934, 105, 'TA', 'Taranto', 1, 0),
(3935, 105, 'TE', 'Teramo', 1, 0),
(3936, 105, 'TR', 'Terni', 1, 0),
(3937, 105, 'TO', 'Torino', 1, 0),
(3938, 105, 'OG', 'Ogliastra', 1, 0),
(3939, 105, 'TP', 'Trapani', 1, 0),
(3940, 105, 'TN', 'Trento', 1, 0),
(3941, 105, 'TV', 'Treviso', 1, 0),
(3942, 105, 'TS', 'Trieste', 1, 0),
(3943, 105, 'UD', 'Udine', 1, 0),
(3944, 105, 'VA', 'Varese', 1, 0),
(3945, 105, 'VE', 'Venezia', 1, 0),
(3946, 105, 'VB', 'Verbano-Cusio-Ossola', 1, 0),
(3947, 105, 'VC', 'Vercelli', 1, 0),
(3948, 105, 'VR', 'Verona', 1, 0),
(3949, 105, 'VV', 'Vibo Valentia', 1, 0),
(3950, 105, 'VI', 'Vicenza', 1, 0),
(3951, 105, 'VT', 'Viterbo', 1, 0),
(3952, 240, 'VO', 'Vojvodina', 1, 0),
(3953, 240, 'BG', 'Beograd', 1, 0),
(3954, 240, 'ZA', 'Šumadija i Zapadna Srbija', 1, 0),
(3955, 240, 'JI', 'Južna i Istočna Srbija', 1, 0),
(3956, 240, 'KM', 'Kosovo i Metohija', 1, 0),
(3957, 241, 'AN', 'Andrijevica', 1, 0),
(3958, 241, 'BA', 'Berane', 1, 0),
(3959, 241, 'BD', 'Budva', 1, 0),
(3960, 241, 'BP', 'Bijelo Polje', 1, 0),
(3961, 241, 'BR', 'Bar', 1, 0),
(3962, 241, 'CT', 'Cetinje', 1, 0),
(3963, 241, 'DG', 'Danilovgrad', 1, 0),
(3964, 241, 'HN', 'Herceg Novi', 1, 0),
(3965, 241, 'KL', 'Kolašin', 1, 0),
(3966, 241, 'KO', 'Kotor', 1, 0),
(3967, 241, 'MK', 'Mojkovac', 1, 0),
(3968, 241, 'NK', 'Nikšić', 1, 0),
(3969, 241, 'PG', 'Podgorica', 1, 0),
(3970, 241, 'PL', 'Plav', 1, 0),
(3971, 241, 'PŽ', 'Plužine', 1, 0),
(3972, 241, 'PV', 'Pljevlja', 1, 0),
(3973, 241, 'RO', 'Rožaje', 1, 0),
(3974, 241, 'ŠN', 'Šavnik', 1, 0),
(3975, 241, 'TV', 'Tivat', 1, 0),
(3976, 241, 'UL', 'Ulcinj', 1, 0),
(3977, 241, 'ŽB', 'Žabljak', 1, 0),
(3978, 138, 'AG', 'Aguascalientes', 1, 0),
(3979, 83, '83', 'Gibraltar', 1, 0),
(3980, 188, '188', 'Singapore', 1, 0),
(3981, 190, '190', 'Slovenia', 1, 0),
(3982, 222, 'ANT', 'Antrim', 1, 0),
(3983, 222, 'ARM', 'Armagh', 1, 0),
(3984, 222, 'DOW', 'Down', 1, 0),
(3985, 222, 'FER', 'Fermanagh', 1, 0),
(3986, 222, 'DGN', 'Dungannon and South Tyrone', 1, 0),
(3987, 222, 'DRY', 'Derry', 1, 0),
(3988, 118, 'AK', 'Akkar', 1, 0),
(3989, 118, 'BH', 'Baalbek-Hermel', 1, 0),
(3990, 118, 'BA', 'Beirut', 1, 0),
(3991, 118, 'BI', 'Beqaa', 1, 0),
(3992, 118, 'JL', 'Mount Lebanon', 1, 0),
(3993, 118, 'NA', 'Nabatieh', 1, 0),
(3994, 118, 'AS', 'North', 1, 0),
(3995, 118, 'JA', 'South', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__languages`
--

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__languages`
--

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 290, 'en-GB', 'English (en-GB)', 'En', 'en', 'en_gb', '', '', '', '', 1, 1, 1),
(2, 286, 'ar-AA', 'Arabic Unitag (العربية الموحدة)', 'Ar', 'ar', 'ar_aa', '', '', '', '', 1, 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 417, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 243, 248, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 244, 245, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 246, 247, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 249, 252, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 250, 251, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 253, 258, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 254, 255, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 256, 257, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 259, 260, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 261, 262, 0, '*', 1),
(18, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 263, 264, 0, '*', 1),
(19, 'main', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 265, 266, 0, '*', 1),
(20, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 267, 268, 0, '', 1),
(21, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 269, 270, 0, '*', 1),
(22, 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 0, 'class:associations', 0, '', 271, 272, 0, '*', 1),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 187, 196, 1, '*', 0),
(105, 'mainmenu', 'Portfolio', 'portfolio', '', 'portfolio', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 1, 1, 10007, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"catid\":\"18\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"popup_image\":\"default\",\"limit\":\"9\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Portfolio\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 197, 202, 0, '*', 0),
(106, 'secondary-menu', 'Gallery', 'gallery', '', 'pages/related-pages/gallery', 'index.php?option=com_speasyimagegallery&view=album&id=2', 'component', 1, 250, 3, 10008, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout\":\"default\",\"column\":\"4\",\"column_sm\":\"6\",\"column_xs\":\"6\",\"gutter\":\"30\",\"gutter_sm\":\"20\",\"gutter_xs\":\"10\",\"show_title\":\"1\",\"show_desc\":\"1\",\"show_count\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Gallery\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 231, 232, 0, '*', 0),
(107, 'secondary-menu', 'About', 'about', '', 'pages/core-pages/about', 'index.php?option=com_sppagebuilder&view=page&id=6', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"About Us\",\"helixultimate_page_subtitle\":\"Who We Are\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 207, 208, 0, '*', 0),
(108, 'secondary-menu', 'Pages', 'pages', '', 'pages', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"full\\\",\\\"megamenu\\\":1,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\" custom-megamenu\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"#2ba84a\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"4\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"98\\\",\\\"items\\\":[{\\\"type\\\":\\\"module\\\",\\\"item_id\\\":98}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"8\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"249,250,133\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":249},{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":250},{\\\"type\\\":\\\"module\\\",\\\"item_id\\\":133}]}]}]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 205, 238, 0, '*', 0),
(109, 'secondary-menu', 'Login', 'login', '', 'pages/related-pages/login', 'index.php?option=com_users&view=login', 'component', 1, 250, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Login\",\"helixultimate_page_subtitle\":\"Indigo Login Form\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 229, 230, 0, '*', 0),
(110, 'secondary-menu', 'Registration', 'registration', '', 'pages/related-pages/registration', 'index.php?option=com_users&view=registration', 'component', 1, 250, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Registration\",\"helixultimate_page_subtitle\":\"Indigo Registration Form\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 225, 226, 0, '*', 0),
(111, 'secondary-menu', '404', '404', '', 'pages/related-pages/404', 'index.php?Itemid=404', 'url', 1, 250, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 233, 234, 0, '*', 0),
(112, 'secondary-menu', 'Coming Soon', 'coming-soon', '', 'pages/related-pages/coming-soon', '?tmpl=comingsoon', 'url', 1, 250, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 235, 236, 0, '*', 0),
(113, 'secondary-menu', 'Contact', 'contact', '', 'pages/related-pages/contact', 'index.php?option=com_sppagebuilder&view=page&id=31', 'component', 1, 250, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Contact us\",\"helixultimate_page_subtitle\":\"Get Us Touch\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header.jpg\"}', 223, 224, 0, '*', 0),
(114, 'secondary-menu', 'Services', 'core-services', '', 'pages/core-pages/core-services', 'index.php?option=com_sppagebuilder&view=page&id=7', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Our Service\",\"helixultimate_page_subtitle\":\"What We Do\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 209, 210, 0, '*', 0),
(115, 'secondary-menu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_content&view=category&layout=blog&id=11', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"8\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"created\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"0\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"News & Blog\",\"helixultimate_page_subtitle\":\"What We Say\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 239, 240, 0, '*', 0),
(116, 'company', 'About', 'about-us', '', 'about-us', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"107\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 273, 274, 0, '*', 0),
(117, 'company', 'Services', 'our-services', '', 'our-services', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"114\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 275, 276, 0, '*', 0),
(118, 'company', 'Portfolio', 'our-portfolio', '', 'our-portfolio', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"105\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 277, 278, 0, '*', 0),
(119, 'company', 'Gallery', 'photo-gallery', '', 'photo-gallery', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"106\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 279, 280, 0, '*', 0),
(120, 'company', 'Blog', 'blogs', '', 'blogs', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"115\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 281, 282, 0, '*', 0),
(160, 'main', 'COM_SPEASYIMAGEGALLERY', 'com-speasyimagegallery', '', 'com-speasyimagegallery', 'index.php?option=com_speasyimagegallery', 'component', 1, 1, 1, 10008, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 283, 284, 0, '', 1),
(165, 'bottom-01', 'Work', 'work', '', 'work', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"105\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 285, 286, 0, '*', 0),
(166, 'bottom-01', 'About', 'about-bottom', '', 'about-bottom', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"107\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 287, 288, 0, '*', 0),
(167, 'bottom-01', 'Team', 'team', '', 'team', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"174\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 289, 290, 0, '*', 0),
(168, 'bottom-01', 'Services', 'services', '', 'services', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"114\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 291, 292, 0, '*', 0),
(169, 'bottom-02', 'Blog', 'blog-bottom', '', 'blog-bottom', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"115\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 13, 14, 0, '*', 0),
(170, 'bottom-02', 'Portfolio', 'portfolio-bottom', '', 'portfolio-bottom', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"248\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 11, 12, 0, '*', 0),
(171, 'bottom-02', 'Contact Us', 'contact-us', '', 'contact-us', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"113\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 17, 18, 0, '*', 0),
(172, 'secondary-menu', 'Services 2', 'services-2', '', 'pages/core-pages/services-2', 'index.php?option=com_sppagebuilder&view=page&id=8', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Our Service\",\"helixultimate_page_subtitle\":\"What We Do\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 213, 214, 0, '*', 0),
(174, 'secondary-menu', 'Team', 'team', '', 'pages/core-pages/team', 'index.php?option=com_sppagebuilder&view=page&id=10', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 215, 216, 0, '*', 0),
(175, 'mainmenu', 'Agency', 'agency', '', 'home/agency', 'index.php?option=com_sppagebuilder&view=page&id=11', 'component', 1, 101, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 188, 189, 0, '*', 0),
(178, 'mainmenu', 'Shop', 'shop', '', 'shop', 'index.php?option=com_j2store&view=products&catid[0]=17', 'component', 1, 1, 1, 10021, 0, '0000-00-00 00:00:00', 0, 1, ' ', 12, '{\"subtemplate\":\"bootstrap3\",\"orderby_sec\":\"\",\"list_order_direction\":\"ASC\",\"category_order_direction\":\"ASC\",\"order_date\":\"\",\"addtocart_button_class\":\"\",\"choosebtn_class\":\"\",\"show_qty_field\":\"1\",\"product_option_price\":\"1\",\"product_option_price_prefix\":\"1\",\"image_for_product_options\":\"1\",\"breadcrumb_category_inclusion\":\"1\",\"custom_css\":\"\",\"page_limit\":\"9\",\"list_no_of_columns\":\"3\",\"show_subcategory_content\":\"3\",\"show_feature_only\":\"0\",\"list_show_title\":\"1\",\"list_link_title\":\"1\",\"list_show_short_desc\":\"0\",\"list_show_long_desc\":\"0\",\"list_show_product_base_price\":\"1\",\"list_show_product_special_price\":\"1\",\"list_show_discount_percentage\":\"1\",\"list_show_image\":\"1\",\"list_image_type\":\"thumbimage\",\"list_image_thumbnail_width\":\"350\",\"list_image_link_to_product\":\"1\",\"list_show_product_sku\":\"1\",\"list_show_product_stock\":\"1\",\"list_show_cart\":\"1\",\"list_enable_quickview\":\"0\",\"list_show_top_filter\":\"1\",\"list_show_filter\":\"1\",\"list_filter_position\":\"right\",\"list_show_filter_sorting\":\"1\",\"list_show_filter_search\":\"1\",\"list_show_filter_category\":\"1\",\"list_filter_category_toggle\":\"1\",\"list_show_filter_category_all\":\"1\",\"list_filter_selected_categories\":[\"14\",\"15\",\"17\"],\"list_show_filter_price\":\"1\",\"list_price_filter_upper_limit\":\"1000\",\"list_price_round_digit\":\"100\",\"list_show_product_filter\":\"1\",\"list_product_filter_list_type\":\"selected\",\"list_product_filter_search_logic_rel\":\"OR\",\"list_filter_productfilter_toggle\":\"1\",\"list_show_manfacturer_filter\":\"1\",\"list_manufacturer_filter_list_type\":\"selected\",\"list_show_vendor_filter\":\"1\",\"list_vendor_filter_list_type\":\"selected\",\"item_show_page_heading\":\"1\",\"item_show_title\":\"1\",\"item_title_headertag\":\"2\",\"item_show_sdesc\":\"1\",\"item_show_ldesc\":\"1\",\"item_show_product_base_price\":\"1\",\"item_show_product_special_price\":\"1\",\"item_show_discount_percentage\":\"1\",\"item_show_product_sku\":\"1\",\"item_show_product_stock\":\"1\",\"item_show_product_main_image\":\"1\",\"item_show_product_additional_image\":\"1\",\"item_product_main_image_width\":\"530\",\"item_product_additional_image_width\":\"154\",\"item_product_upsell_image_width\":\"\",\"item_product_cross_image_width\":\"\",\"item_enable_image_zoom\":\"1\",\"item_show_product_manufacturer_name\":\"1\",\"item_show_product_upsells\":\"0\",\"item_show_product_cross_sells\":\"0\",\"item_related_product_columns\":\"3\",\"item_show_product_specification\":\"1\",\"item_use_tabs\":\"1\",\"item_show_back_to\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Shop\",\"helixultimate_page_subtitle\":\"Indigo Shop\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 203, 204, 0, '*', 0),
(179, 'secondary-menu', 'About 2', 'about2', '', 'pages/core-pages/about2', 'index.php?option=com_sppagebuilder&view=page&id=29', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"About us\",\"helixultimate_page_subtitle\":\"Who We Are\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"#202020\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-header.jpg\"}', 211, 212, 0, '*', 0),
(180, 'secondary-menu', 'Pricing', 'pricing', '', 'pages/core-pages/pricing', 'index.php?option=com_sppagebuilder&view=page&id=30', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Pricing Table\",\"helixultimate_page_subtitle\":\"Flexible plans\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/pricing-header.jpg\"}', 217, 218, 0, '*', 0),
(182, 'secondary-menu', 'Contact 2', 'contact-2', '', 'pages/related-pages/contact-2', 'index.php?option=com_sppagebuilder&view=page&id=32', 'component', 1, 250, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Contact us\",\"helixultimate_page_subtitle\":\"Get Us Touch\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 227, 228, 0, '*', 0),
(183, 'mainmenu', 'Shop', 'home-shop', '', 'home/home-shop', 'index.php?option=com_sppagebuilder&view=page&id=33', 'component', 1, 101, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 12, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 190, 191, 0, '*', 0),
(184, 'mainmenu', 'Classic', 'portfolio-classic', '', 'portfolio/portfolio-classic', 'index.php?option=com_spsimpleportfolio&view=items&layout=indigo:classic', 'component', 1, 105, 2, 10007, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"catid\":\"19\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"popup_image\":\"default\",\"limit\":\"6\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"projects-list\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Portfolio\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 200, 201, 0, '*', 0),
(185, 'mainmenu', 'Classic', 'classic', '', 'home/classic', 'index.php?option=com_sppagebuilder&view=page&id=51', 'component', 1, 101, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 192, 193, 0, '*', 0),
(186, 'secondary-menu', 'Team 2', 'team-2', '', 'pages/core-pages/team-2', 'index.php?option=com_sppagebuilder&view=page&id=123', 'component', 1, 249, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"TEAM\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 219, 220, 0, '*', 0),
(187, 'secondary-menu', 'Addons', 'addons', '', 'addons', '', 'heading', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"full\\\",\\\"megamenu\\\":1,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"188\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":188}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"189\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":189}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"190\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":190}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"191\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":191}]}]}]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 293, 406, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(188, 'secondary-menu', 'Addon List 01', 'addon-list-01', '', 'addons/addon-list-01', '', 'heading', 1, 187, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 294, 321, 0, '*', 0),
(189, 'secondary-menu', 'Addon List 02', 'addon-list-2', '', 'addons/addon-list-2', '', 'heading', 1, 187, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 322, 349, 0, '*', 0),
(190, 'secondary-menu', 'Addon List 03', 'addon-list-3', '', 'addons/addon-list-3', '', 'heading', 1, 187, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 350, 377, 0, '*', 0),
(191, 'secondary-menu', 'Addon List 04', 'addon-list-04', '', 'addons/addon-list-04', '', 'heading', 1, 187, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 378, 405, 0, '*', 0),
(192, 'secondary-menu', 'Accordion', 'accordion', '', 'addons/addon-list-01/accordion', 'index.php?option=com_sppagebuilder&view=page&id=122', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 295, 296, 0, '*', 0),
(193, 'secondary-menu', 'Alert', 'alert', '', 'addons/addon-list-01/alert', 'index.php?option=com_sppagebuilder&view=page&id=119', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 297, 298, 0, '*', 0),
(194, 'secondary-menu', 'Animation Number', 'animation-number', '', 'addons/addon-list-01/animation-number', 'index.php?option=com_sppagebuilder&view=page&id=115', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 299, 300, 0, '*', 0),
(195, 'secondary-menu', 'Articles', 'articles', '', 'addons/addon-list-01/articles', 'index.php?option=com_sppagebuilder&view=page&id=114', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 301, 302, 0, '*', 0),
(196, 'secondary-menu', 'Audio', 'audio', '', 'addons/addon-list-01/audio', 'index.php?option=com_sppagebuilder&view=page&id=97', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 303, 304, 0, '*', 0),
(197, 'secondary-menu', 'Article Scroller', 'article-scroller', '', 'addons/addon-list-01/article-scroller', 'index.php?option=com_sppagebuilder&view=page&id=113', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 305, 306, 0, '*', 0),
(198, 'secondary-menu', 'Animation Heading', 'animation-heading', '', 'addons/addon-list-01/animation-heading', 'index.php?option=com_sppagebuilder&view=page&id=120', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 307, 308, 0, '*', 0),
(199, 'secondary-menu', 'Button', 'button', '', 'addons/addon-list-01/button', 'index.php?option=com_sppagebuilder&view=page&id=99', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 309, 310, 0, '*', 0),
(200, 'secondary-menu', 'Button Group', 'button-group', '', 'addons/addon-list-01/button-group', 'index.php?option=com_sppagebuilder&view=page&id=100', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 311, 312, 0, '*', 0),
(201, 'secondary-menu', 'Block Number', 'block-number', '', 'addons/addon-list-01/block-number', 'index.php?option=com_sppagebuilder&view=page&id=98', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 313, 314, 0, '*', 0),
(202, 'secondary-menu', 'Carousel', 'carousel', '', 'addons/addon-list-01/carousel', 'index.php?option=com_sppagebuilder&view=page&id=101', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 315, 316, 0, '*', 0),
(203, 'secondary-menu', 'Carousel Pro', 'carousel-pro', '', 'addons/addon-list-01/carousel-pro', 'index.php?option=com_sppagebuilder&view=page&id=102', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 317, 318, 0, '*', 0),
(204, 'secondary-menu', 'Clients', 'clients', '', 'addons/addon-list-01/clients', 'index.php?option=com_sppagebuilder&view=page&id=103', 'component', 1, 188, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 319, 320, 0, '*', 0),
(205, 'secondary-menu', 'Countdown', 'countdown', '', 'addons/addon-list-2/countdown', 'index.php?option=com_sppagebuilder&view=page&id=104', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 323, 324, 0, '*', 0),
(206, 'secondary-menu', 'Contact Form', 'contact-form', '', 'addons/addon-list-2/contact-form', 'index.php?option=com_sppagebuilder&view=page&id=118', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 325, 326, 0, '*', 0),
(207, 'secondary-menu', 'Progress Bar', 'progress-bar', '', 'addons/addon-list-04/progress-bar', 'index.php?option=com_sppagebuilder&view=page&id=86', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 379, 380, 0, '*', 0),
(208, 'secondary-menu', 'Pie Progress', 'pie-progress', '', 'addons/addon-list-04/pie-progress', 'index.php?option=com_sppagebuilder&view=page&id=83', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 381, 382, 0, '*', 0),
(209, 'secondary-menu', 'Raw html', 'raw-html', '', 'addons/addon-list-04/raw-html', 'index.php?option=com_sppagebuilder&view=page&id=87', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 383, 384, 0, '*', 0),
(210, 'secondary-menu', 'Text Block', 'text-block', '', 'addons/addon-list-04/text-block', 'index.php?option=com_sppagebuilder&view=page&id=93', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 385, 386, 0, '*', 0),
(211, 'secondary-menu', 'Tabs', 'tabs', '', 'addons/addon-list-04/tabs', 'index.php?option=com_sppagebuilder&view=page&id=90', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 387, 388, 0, '*', 0),
(212, 'secondary-menu', 'Testimonials', 'testimonials', '', 'addons/addon-list-04/testimonials', 'index.php?option=com_sppagebuilder&view=page&id=91', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 389, 390, 0, '*', 0),
(213, 'secondary-menu', 'Testimonial Pro', 'testimonial-pro', '', 'addons/addon-list-04/testimonial-pro', 'index.php?option=com_sppagebuilder&view=page&id=92', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 391, 392, 0, '*', 0),
(214, 'secondary-menu', 'Soundcloud', 'soundcloud', '', 'addons/addon-list-04/soundcloud', 'index.php?option=com_sppagebuilder&view=page&id=89', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 393, 394, 0, '*', 0),
(215, 'secondary-menu', 'Slidshow', 'slidshow', '', 'addons/addon-list-04/slidshow', 'index.php?option=com_sppagebuilder&view=page&id=77', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 395, 396, 0, '*', 0),
(216, 'secondary-menu', 'Social Share', 'social-share', '', 'addons/addon-list-04/social-share', 'index.php?option=com_sppagebuilder&view=page&id=88', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 397, 398, 0, '*', 0),
(217, 'secondary-menu', 'Video', 'video', '', 'addons/addon-list-04/video', 'index.php?option=com_sppagebuilder&view=page&id=96', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 399, 400, 0, '*', 0),
(218, 'secondary-menu', 'Timeline', 'timeline', '', 'addons/addon-list-04/timeline', 'index.php?option=com_sppagebuilder&view=page&id=94', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 401, 402, 0, '*', 0),
(219, 'secondary-menu', 'Twitter Feed', 'twitter-feed', '', 'addons/addon-list-04/twitter-feed', 'index.php?option=com_sppagebuilder&view=page&id=95', 'component', 1, 191, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 403, 404, 0, '*', 0),
(220, 'secondary-menu', 'Image', 'image', '', 'addons/addon-list-3/image', 'index.php?option=com_sppagebuilder&view=page&id=72', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 351, 352, 0, '*', 0),
(221, 'secondary-menu', 'Image Overlay', 'image-overlay', '', 'addons/addon-list-3/image-overlay', 'index.php?option=com_sppagebuilder&view=page&id=75', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 353, 354, 0, '*', 0),
(222, 'secondary-menu', 'Image Layout', 'image-layout', '', 'addons/addon-list-3/image-layout', 'index.php?option=com_sppagebuilder&view=page&id=74', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 357, 358, 0, '*', 0),
(223, 'secondary-menu', 'Image Content', 'image-content', '', 'addons/addon-list-3/image-content', 'index.php?option=com_sppagebuilder&view=page&id=73', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 355, 356, 0, '*', 0),
(224, 'secondary-menu', 'Instagram Gallery', 'instagram-gallery', '', 'addons/addon-list-3/instagram-gallery', 'index.php?option=com_sppagebuilder&view=page&id=76', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 359, 360, 0, '*', 0),
(225, 'secondary-menu', 'Joomla Module', 'joomla-module', '', 'addons/addon-list-3/joomla-module', 'index.php?option=com_sppagebuilder&view=page&id=117', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 361, 362, 0, '*', 0),
(226, 'secondary-menu', 'Modal Popup', 'modal-popup', '', 'addons/addon-list-3/modal-popup', 'index.php?option=com_sppagebuilder&view=page&id=78', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 363, 364, 0, '*', 0),
(227, 'secondary-menu', 'Navigation', 'navigation', '', 'addons/addon-list-3/navigation', 'index.php?option=com_sppagebuilder&view=page&id=79', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 365, 366, 0, '*', 0),
(228, 'secondary-menu', 'Opt-in Form', 'opt-in-form', '', 'addons/addon-list-3/opt-in-form', 'index.php?option=com_sppagebuilder&view=page&id=81', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 367, 368, 0, '*', 0),
(229, 'secondary-menu', 'Open Street Map', 'open-street-map', '', 'addons/addon-list-3/open-street-map', 'index.php?option=com_sppagebuilder&view=page&id=80', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 369, 370, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(230, 'secondary-menu', 'Pricing Table', 'pricing-table', '', 'addons/addon-list-3/pricing-table', 'index.php?option=com_sppagebuilder&view=page&id=85', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 371, 372, 0, '*', 0),
(231, 'secondary-menu', 'Price List', 'price-list', '', 'addons/addon-list-3/price-list', 'index.php?option=com_sppagebuilder&view=page&id=84', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 373, 374, 0, '*', 0),
(232, 'secondary-menu', 'Person', 'person', '', 'addons/addon-list-3/person', 'index.php?option=com_sppagebuilder&view=page&id=82', 'component', 1, 190, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 375, 376, 0, '*', 0),
(233, 'secondary-menu', 'Divider', 'divider', '', 'addons/addon-list-2/divider', 'index.php?option=com_sppagebuilder&view=page&id=105', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 327, 328, 0, '*', 0),
(234, 'secondary-menu', 'Empty Space', 'empty-space', '', 'addons/addon-list-2/empty-space', 'index.php?option=com_sppagebuilder&view=page&id=106', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 329, 330, 0, '*', 0),
(235, 'secondary-menu', 'Feature Box', 'feature-box', '', 'addons/addon-list-2/feature-box', 'index.php?option=com_sppagebuilder&view=page&id=107', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 331, 332, 0, '*', 0),
(236, 'secondary-menu', 'Flip Box', 'flip-box', '', 'addons/addon-list-2/flip-box', 'index.php?option=com_sppagebuilder&view=page&id=109', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 333, 334, 0, '*', 0),
(237, 'secondary-menu', 'Flickr Gallery', 'flickr-gallery', '', 'addons/addon-list-2/flickr-gallery', 'index.php?option=com_sppagebuilder&view=page&id=108', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 335, 336, 0, '*', 0),
(238, 'secondary-menu', 'Form Builder', 'form-builder', '', 'addons/addon-list-2/form-builder', 'index.php?option=com_sppagebuilder&view=page&id=110', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 337, 338, 0, '*', 0),
(239, 'secondary-menu', 'Google Map', 'google-map', '', 'addons/addon-list-2/google-map', 'index.php?option=com_sppagebuilder&view=page&id=112', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 339, 340, 0, '*', 0),
(240, 'secondary-menu', 'Gallery', 'gallery', '', 'addons/addon-list-2/gallery', 'index.php?option=com_sppagebuilder&view=page&id=111', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 341, 342, 0, '*', 0),
(241, 'secondary-menu', 'Heading', 'heading', '', 'addons/addon-list-2/heading', 'index.php?option=com_sppagebuilder&view=page&id=121', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 343, 344, 0, '*', 0),
(242, 'secondary-menu', 'Icon', 'icon', '', 'addons/addon-list-2/icon', 'index.php?option=com_sppagebuilder&view=page&id=70', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 345, 346, 0, '*', 0),
(243, 'secondary-menu', 'Icon Group', 'icon-group', '', 'addons/addon-list-2/icon-group', 'index.php?option=com_sppagebuilder&view=page&id=71', 'component', 1, 189, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 347, 348, 0, '*', 0),
(244, 'mainmenu', 'Creative', 'creative', '', 'home/creative', 'index.php?option=com_sppagebuilder&view=page&id=125', 'component', 1, 101, 2, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 194, 195, 0, '*', 0),
(246, 'home-ar', 'Home', 'home-ar', '', 'home-ar', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 407, 408, 1, 'ar-AA', 0),
(247, 'home-en', 'Home', 'home-en', '', 'home-en', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\" home-page\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 409, 410, 1, 'en-GB', 0),
(248, 'mainmenu', 'Default', 'portfolio-default', '', 'portfolio/portfolio-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 105, 2, 10007, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_filter\":\"1\",\"catid\":\"18\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"popup_image\":\"default\",\"limit\":\"9\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Portfolio\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 198, 199, 0, '*', 0),
(249, 'secondary-menu', 'Core pages', 'core-pages', '', 'pages/core-pages', '', 'heading', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 206, 221, 0, '*', 0),
(250, 'secondary-menu', 'Related Pages', 'related-pages', '', 'pages/related-pages', '', 'heading', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 222, 237, 0, '*', 0),
(251, 'full-menu', 'Pages', 'pages-2', '', 'pages-2', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"full\\\",\\\"megamenu\\\":1,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\" custom-megamenu\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_bg_color\\\":\\\"#2ba84a\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"4\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"98\\\",\\\"items\\\":[{\\\"type\\\":\\\"module\\\",\\\"item_id\\\":98}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"8\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"252,260,133\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":252},{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":260},{\\\"type\\\":\\\"module\\\",\\\"item_id\\\":133}]}]}]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 39, 72, 0, '*', 0),
(252, 'full-menu', 'Core pages', 'core-pages', '', 'pages-2/core-pages', '', 'heading', 1, 251, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 40, 55, 0, '*', 0),
(253, 'full-menu', 'About', 'about', '', 'pages-2/core-pages/about', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"107\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"About Us\",\"helixultimate_page_subtitle\":\"Who We Are\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 41, 42, 0, '*', 0),
(254, 'full-menu', 'About 2', 'about2', '', 'pages-2/core-pages/about2', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"179\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"About us\",\"helixultimate_page_subtitle\":\"Who We Are\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"#202020\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-header.jpg\"}', 43, 44, 0, '*', 0),
(255, 'full-menu', 'Services', 'core-services', '', 'pages-2/core-pages/core-services', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"114\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Our Service\",\"helixultimate_page_subtitle\":\"What We Do\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 45, 46, 0, '*', 0),
(256, 'full-menu', 'Services 2', 'services-2', '', 'pages-2/core-pages/services-2', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"172\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Our Service\",\"helixultimate_page_subtitle\":\"What We Do\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 47, 48, 0, '*', 0),
(257, 'full-menu', 'Team', 'team', '', 'pages-2/core-pages/team', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"174\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 49, 50, 0, '*', 0),
(258, 'full-menu', 'Team 2', 'team-2', '', 'pages-2/core-pages/team-2', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"186\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"TEAM\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 51, 52, 0, '*', 0),
(259, 'full-menu', 'Pricing', 'pricing', '', 'pages-2/core-pages/pricing', 'index.php?Itemid=', 'alias', 1, 252, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"180\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Pricing Table\",\"helixultimate_page_subtitle\":\"Flexible plans\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/pricing-header.jpg\"}', 53, 54, 0, '*', 0),
(260, 'full-menu', 'Related Pages', 'related-pages', '', 'pages-2/related-pages', '', 'heading', 1, 251, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 56, 71, 0, '*', 0),
(261, 'full-menu', 'Gallery', 'gallery', '', 'pages-2/related-pages/gallery', 'index.php?Itemid=', 'alias', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"106\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Gallery\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 57, 58, 0, '*', 0),
(262, 'full-menu', 'Contact', 'contact', '', 'pages-2/related-pages/contact', 'index.php?Itemid=', 'alias', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"113\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Contact us\",\"helixultimate_page_subtitle\":\"Get Us Touch\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header.jpg\"}', 59, 60, 0, '*', 0),
(263, 'full-menu', 'Contact 2', 'contact-2', '', 'pages-2/related-pages/contact-2', 'index.php?Itemid=', 'alias', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"182\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Contact us\",\"helixultimate_page_subtitle\":\"Get Us Touch\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 61, 62, 0, '*', 0),
(264, 'full-menu', 'Login', 'login', '', 'pages-2/related-pages/login', 'index.php?Itemid=', 'alias', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"109\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 63, 64, 0, '*', 0),
(265, 'full-menu', 'Registration', 'registration', '', 'pages-2/related-pages/registration', 'index.php?Itemid=', 'alias', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"110\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 65, 66, 0, '*', 0),
(266, 'full-menu', '404', '404', '', 'pages-2/related-pages/404', 'index.php?Itemid=404', 'url', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 67, 68, 0, '*', 0),
(267, 'full-menu', 'Coming Soon', 'coming-soon', '', 'pages-2/related-pages/coming-soon', '?tmpl=comingsoon', 'url', 1, 260, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 69, 70, 0, '*', 0),
(268, 'full-menu', 'Blog', 'blog-2', '', 'blog-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"115\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"News & Blog\",\"helixultimate_page_subtitle\":\"What We Say\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 37, 38, 0, '*', 0),
(269, 'full-menu', 'Addons', 'addons-2', '', 'addons-2', '', 'heading', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"full\\\",\\\"megamenu\\\":1,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"270\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":270}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"285\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":285}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"313\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":313}]},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":\\\"3\\\",\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"340\\\",\\\"items\\\":[{\\\"type\\\":\\\"menu_item\\\",\\\"item_id\\\":340}]}]}]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 73, 186, 0, '*', 0),
(270, 'full-menu', 'Addon List 01', 'addon-list-01', '', 'addons-2/addon-list-01', '', 'heading', 1, 269, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 74, 101, 0, '*', 0),
(271, 'full-menu', 'Accordion', 'accordion', '', 'addons-2/addon-list-01/accordion', 'index.php?option=com_sppagebuilder&view=page&id=122', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 75, 76, 0, '*', 0),
(272, 'full-menu', 'Alert', 'alert', '', 'addons-2/addon-list-01/alert', 'index.php?option=com_sppagebuilder&view=page&id=119', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 77, 78, 0, '*', 0),
(273, 'full-menu', 'Animation Number', 'animation-number', '', 'addons-2/addon-list-01/animation-number', 'index.php?option=com_sppagebuilder&view=page&id=115', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 79, 80, 0, '*', 0),
(274, 'full-menu', 'Articles', 'articles', '', 'addons-2/addon-list-01/articles', 'index.php?option=com_sppagebuilder&view=page&id=114', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 81, 82, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(275, 'full-menu', 'Audio', 'audio', '', 'addons-2/addon-list-01/audio', 'index.php?option=com_sppagebuilder&view=page&id=97', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 83, 84, 0, '*', 0),
(276, 'full-menu', 'Article Scroller', 'article-scroller', '', 'addons-2/addon-list-01/article-scroller', 'index.php?option=com_sppagebuilder&view=page&id=113', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 85, 86, 0, '*', 0),
(277, 'full-menu', 'Animation Heading', 'animation-heading', '', 'addons-2/addon-list-01/animation-heading', 'index.php?option=com_sppagebuilder&view=page&id=120', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 87, 88, 0, '*', 0),
(278, 'full-menu', 'Button', 'button', '', 'addons-2/addon-list-01/button', 'index.php?option=com_sppagebuilder&view=page&id=99', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 89, 90, 0, '*', 0),
(279, 'full-menu', 'Button Group', 'button-group', '', 'addons-2/addon-list-01/button-group', 'index.php?option=com_sppagebuilder&view=page&id=100', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 91, 92, 0, '*', 0),
(280, 'full-menu', 'Block Number', 'block-number', '', 'addons-2/addon-list-01/block-number', 'index.php?option=com_sppagebuilder&view=page&id=98', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 93, 94, 0, '*', 0),
(281, 'full-menu', 'Carousel', 'carousel', '', 'addons-2/addon-list-01/carousel', 'index.php?option=com_sppagebuilder&view=page&id=101', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 95, 96, 0, '*', 0),
(282, 'full-menu', 'Carousel Pro', 'carousel-pro', '', 'addons-2/addon-list-01/carousel-pro', 'index.php?option=com_sppagebuilder&view=page&id=102', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 97, 98, 0, '*', 0),
(283, 'full-menu', 'Clients', 'clients', '', 'addons-2/addon-list-01/clients', 'index.php?option=com_sppagebuilder&view=page&id=103', 'component', 1, 270, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 99, 100, 0, '*', 0),
(285, 'full-menu', 'Addon List 02', 'addon-list-2', '', 'addons-2/addon-list-2', '', 'heading', 1, 269, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 102, 129, 0, '*', 0),
(287, 'full-menu', 'Countdown', 'countdown', '', 'addons-2/addon-list-2/countdown', 'index.php?option=com_sppagebuilder&view=page&id=104', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 103, 104, 0, '*', 0),
(289, 'full-menu', 'Contact Form', 'contact-form', '', 'addons-2/addon-list-2/contact-form', 'index.php?option=com_sppagebuilder&view=page&id=118', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 105, 106, 0, '*', 0),
(291, 'full-menu', 'Divider', 'divider', '', 'addons-2/addon-list-2/divider', 'index.php?option=com_sppagebuilder&view=page&id=105', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 107, 108, 0, '*', 0),
(293, 'full-menu', 'Empty Space', 'empty-space', '', 'addons-2/addon-list-2/empty-space', 'index.php?option=com_sppagebuilder&view=page&id=106', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 109, 110, 0, '*', 0),
(295, 'full-menu', 'Feature Box', 'feature-box', '', 'addons-2/addon-list-2/feature-box', 'index.php?option=com_sppagebuilder&view=page&id=107', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 111, 112, 0, '*', 0),
(297, 'full-menu', 'Flip Box', 'flip-box', '', 'addons-2/addon-list-2/flip-box', 'index.php?option=com_sppagebuilder&view=page&id=109', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 113, 114, 0, '*', 0),
(299, 'full-menu', 'Flickr Gallery', 'flickr-gallery', '', 'addons-2/addon-list-2/flickr-gallery', 'index.php?option=com_sppagebuilder&view=page&id=108', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 115, 116, 0, '*', 0),
(301, 'full-menu', 'Form Builder', 'form-builder', '', 'addons-2/addon-list-2/form-builder', 'index.php?option=com_sppagebuilder&view=page&id=110', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 117, 118, 0, '*', 0),
(303, 'full-menu', 'Google Map', 'google-map', '', 'addons-2/addon-list-2/google-map', 'index.php?option=com_sppagebuilder&view=page&id=112', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 119, 120, 0, '*', 0),
(305, 'full-menu', 'Gallery', 'gallery', '', 'addons-2/addon-list-2/gallery', 'index.php?option=com_sppagebuilder&view=page&id=111', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 121, 122, 0, '*', 0),
(307, 'full-menu', 'Heading', 'heading', '', 'addons-2/addon-list-2/heading', 'index.php?option=com_sppagebuilder&view=page&id=121', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 123, 124, 0, '*', 0),
(309, 'full-menu', 'Icon', 'icon', '', 'addons-2/addon-list-2/icon', 'index.php?option=com_sppagebuilder&view=page&id=70', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 125, 126, 0, '*', 0),
(311, 'full-menu', 'Icon Group', 'icon-group', '', 'addons-2/addon-list-2/icon-group', 'index.php?option=com_sppagebuilder&view=page&id=71', 'component', 1, 285, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 127, 128, 0, '*', 0),
(313, 'full-menu', 'Addon List 03', 'addon-list-3', '', 'addons-2/addon-list-3', '', 'heading', 1, 269, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 130, 157, 0, '*', 0),
(315, 'full-menu', 'Image', 'image', '', 'addons-2/addon-list-3/image', 'index.php?option=com_sppagebuilder&view=page&id=72', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 131, 132, 0, '*', 0),
(317, 'full-menu', 'Image Overlay', 'image-overlay', '', 'addons-2/addon-list-3/image-overlay', 'index.php?option=com_sppagebuilder&view=page&id=75', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 133, 134, 0, '*', 0),
(319, 'full-menu', 'Image Content', 'image-content', '', 'addons-2/addon-list-3/image-content', 'index.php?option=com_sppagebuilder&view=page&id=73', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 135, 136, 0, '*', 0),
(320, 'full-menu', 'Image Layout', 'image-layout', '', 'addons-2/addon-list-3/image-layout', 'index.php?option=com_sppagebuilder&view=page&id=74', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 137, 138, 0, '*', 0),
(322, 'full-menu', 'Instagram Gallery', 'instagram-gallery', '', 'addons-2/addon-list-3/instagram-gallery', 'index.php?option=com_sppagebuilder&view=page&id=76', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 139, 140, 0, '*', 0),
(324, 'full-menu', 'Joomla Module', 'joomla-module', '', 'addons-2/addon-list-3/joomla-module', 'index.php?option=com_sppagebuilder&view=page&id=117', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 141, 142, 0, '*', 0),
(326, 'full-menu', 'Modal Popup', 'modal-popup', '', 'addons-2/addon-list-3/modal-popup', 'index.php?option=com_sppagebuilder&view=page&id=78', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 143, 144, 0, '*', 0),
(328, 'full-menu', 'Navigation', 'navigation', '', 'addons-2/addon-list-3/navigation', 'index.php?option=com_sppagebuilder&view=page&id=79', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 145, 146, 0, '*', 0),
(330, 'full-menu', 'Opt-in Form', 'opt-in-form', '', 'addons-2/addon-list-3/opt-in-form', 'index.php?option=com_sppagebuilder&view=page&id=81', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 147, 148, 0, '*', 0),
(332, 'full-menu', 'Open Street Map', 'open-street-map', '', 'addons-2/addon-list-3/open-street-map', 'index.php?option=com_sppagebuilder&view=page&id=80', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 149, 150, 0, '*', 0),
(334, 'full-menu', 'Pricing Table', 'pricing-table', '', 'addons-2/addon-list-3/pricing-table', 'index.php?option=com_sppagebuilder&view=page&id=85', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 151, 152, 0, '*', 0),
(336, 'full-menu', 'Price List', 'price-list', '', 'addons-2/addon-list-3/price-list', 'index.php?option=com_sppagebuilder&view=page&id=84', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 153, 154, 0, '*', 0),
(338, 'full-menu', 'Person', 'person', '', 'addons-2/addon-list-3/person', 'index.php?option=com_sppagebuilder&view=page&id=82', 'component', 1, 313, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 155, 156, 0, '*', 0),
(340, 'full-menu', 'Addon List 04', 'addon-list-04', '', 'addons-2/addon-list-04', '', 'heading', 1, 269, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 158, 185, 0, '*', 0),
(342, 'full-menu', 'Progress Bar', 'progress-bar', '', 'addons-2/addon-list-04/progress-bar', 'index.php?option=com_sppagebuilder&view=page&id=86', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 159, 160, 0, '*', 0),
(344, 'full-menu', 'Pie Progress', 'pie-progress', '', 'addons-2/addon-list-04/pie-progress', 'index.php?option=com_sppagebuilder&view=page&id=83', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 161, 162, 0, '*', 0),
(346, 'full-menu', 'Raw html', 'raw-html', '', 'addons-2/addon-list-04/raw-html', 'index.php?option=com_sppagebuilder&view=page&id=87', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 163, 164, 0, '*', 0),
(348, 'full-menu', 'Text Block', 'text-block', '', 'addons-2/addon-list-04/text-block', 'index.php?option=com_sppagebuilder&view=page&id=93', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 165, 166, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(350, 'full-menu', 'Tabs', 'tabs', '', 'addons-2/addon-list-04/tabs', 'index.php?option=com_sppagebuilder&view=page&id=90', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 167, 168, 0, '*', 0),
(352, 'full-menu', 'Testimonials', 'testimonials', '', 'addons-2/addon-list-04/testimonials', 'index.php?option=com_sppagebuilder&view=page&id=91', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 169, 170, 0, '*', 0),
(354, 'full-menu', 'Testimonial Pro', 'testimonial-pro', '', 'addons-2/addon-list-04/testimonial-pro', 'index.php?option=com_sppagebuilder&view=page&id=92', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 171, 172, 0, '*', 0),
(356, 'full-menu', 'Soundcloud', 'soundcloud', '', 'addons-2/addon-list-04/soundcloud', 'index.php?option=com_sppagebuilder&view=page&id=89', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 173, 174, 0, '*', 0),
(358, 'full-menu', 'Slidshow', 'slidshow', '', 'addons-2/addon-list-04/slidshow', 'index.php?option=com_sppagebuilder&view=page&id=77', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 175, 176, 0, '*', 0),
(360, 'full-menu', 'Social Share', 'social-share', '', 'addons-2/addon-list-04/social-share', 'index.php?option=com_sppagebuilder&view=page&id=88', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 177, 178, 0, '*', 0),
(362, 'full-menu', 'Video', 'video', '', 'addons-2/addon-list-04/video', 'index.php?option=com_sppagebuilder&view=page&id=96', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 179, 180, 0, '*', 0),
(364, 'full-menu', 'Timeline', 'timeline', '', 'addons-2/addon-list-04/timeline', 'index.php?option=com_sppagebuilder&view=page&id=94', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 181, 182, 0, '*', 0),
(366, 'full-menu', 'Twitter Feed', 'twitter-feed', '', 'addons-2/addon-list-04/twitter-feed', 'index.php?option=com_sppagebuilder&view=page&id=95', 'component', 1, 340, 3, 10000, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"Addon List\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 183, 184, 0, '*', 0),
(401, 'full-menu', 'Home', 'home-2', '', 'home-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"101\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 19, 28, 0, '*', 0),
(404, 'full-menu', 'Agency', 'agency', '', 'home-2/agency', 'index.php?Itemid=', 'alias', 1, 401, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"175\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 20, 21, 0, '*', 0),
(405, 'full-menu', 'Shop', 'home-shop', '', 'home-2/home-shop', 'index.php?Itemid=', 'alias', 1, 401, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 12, '{\"aliasoptions\":\"183\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 22, 23, 0, '*', 0),
(406, 'full-menu', 'Classic', 'classic', '', 'home-2/classic', 'index.php?Itemid=', 'alias', 1, 401, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"185\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 24, 25, 0, '*', 0),
(407, 'full-menu', 'Creative', 'creative', '', 'home-2/creative', 'index.php?Itemid=', 'alias', 1, 401, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"aliasoptions\":\"244\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Team\",\"helixultimate_page_subtitle\":\"Our Core Members\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/team-title-bg.jpg\"}', 26, 27, 0, '*', 0),
(408, 'full-menu', 'Portfolio', 'portfolio-2', '', 'portfolio-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"105\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Portfolio\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 29, 34, 0, '*', 0),
(409, 'full-menu', 'Default', 'portfolio-default', '', 'portfolio-2/portfolio-default', 'index.php?Itemid=', 'alias', 1, 408, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"248\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Portfolio\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 30, 31, 0, '*', 0),
(410, 'full-menu', 'Classic', 'portfolio-classic', '', 'portfolio-2/portfolio-classic', 'index.php?Itemid=', 'alias', 1, 408, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"184\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Portfolio\",\"helixultimate_page_subtitle\":\"Solutions for Every Industry\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/service-2-header.jpg\"}', 32, 33, 0, '*', 0),
(411, 'full-menu', 'Shop', 'shop-2', '', 'shop-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"178\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Shop\",\"helixultimate_page_subtitle\":\"Indigo Shop\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/contact-header2.jpg\"}', 35, 36, 0, '*', 0),
(412, 'hidden-menu', 'Blog', 'all-blogs', '', 'all-blogs', 'index.php?option=com_content&view=category&layout=blog&id=9', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"8\",\"num_columns\":\"2\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"created\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"0\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"News & Blog\",\"helixultimate_page_subtitle\":\"What We Say\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/sub-header\\/about-sub-header.jpg\"}', 241, 242, 0, '*', 0),
(413, 'bottom-02', 'Pricing', 'pricing', '', 'pricing', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"aliasoptions\":\"180\",\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 15, 16, 0, '*', 0),
(417, 'main', 'J2Store', 'j2store', '', 'j2store', 'index.php?option=com_j2store', 'component', 1, 1, 1, 10021, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 411, 412, 0, '', 1),
(420, 'main', 'COM_SPSIMPLEPORTFOLIO', 'com-spsimpleportfolio', '', 'com-spsimpleportfolio', 'index.php?option=com_spsimpleportfolio', 'component', 1, 1, 1, 10007, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 413, 414, 0, '', 1),
(421, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10000, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 415, 416, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0),
(2, 75, 'company', 'Company', '', 0),
(3, 76, 'quick-links', 'Quick Links', '', 0),
(4, 94, 'secondary-menu', 'Secondary Menu', '', 0),
(5, 95, 'bottom-01', 'Bottom-01', '', 0),
(6, 96, 'bottom-02', 'Bottom-02', '', 0),
(7, 287, 'home-ar', 'Home Ar', '', 0),
(8, 288, 'home-en', 'Home En', '', 0),
(9, 293, 'full-menu', 'Full Menu', '', 0),
(10, 305, 'hidden-menu', 'Hidden Menu', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 40, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 41, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(4, 42, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(8, 43, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 44, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 45, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(12, 46, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 47, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 48, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 49, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 52, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 53, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(87, 55, 'Sample Data', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_sampledata', 6, 1, '{}', 1, '*'),
(89, 58, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(90, 59, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*'),
(96, 84, 'Joomla Module', 'Mega Menu', '<div><img src=\"images/gallery1-small.jpg\" alt=\"image\" /></div>', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(98, 88, 'Latest Articles (Megamenu)', 'Mega Menu', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 0, '{\"catid\":[22],\"count\":1,\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(99, 89, 'Offcanvas', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"full-menu\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(100, 97, 'Bottom-01', '', '', 1, 'bottom1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"bottom-01\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(101, 98, 'Bottom-02', '', '', 1, 'bottom2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"bottom-02\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(102, 99, 'Contact Info', 'For Bottom3 Position', '', 1, 'bottom3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(103, 100, 'Subscribe to our newsletter', '', '', 1, 'bottom4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(104, 101, 'Footer-01', '', '', 1, 'footer1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(105, 102, 'Footer-02', '', '', 1, 'footer2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(106, 136, 'Categories', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{\"parent\":9,\"show_description\":0,\"numitems\":0,\"show_children\":0,\"count\":0,\"maxlevel\":0,\"layout\":\"_:default\",\"item_heading\":4,\"moduleclass_sfx\":\"\",\"owncache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(107, 137, 'Latest Post', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[9,11,12],\"count\":4,\"show_featured\":\"\",\"ordering\":\"p_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(108, 138, 'Latest Portfolio', 'For Agency Home', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 0, '{\"show_filter\":\"0\",\"category_id\":\"18\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"popup_image\":\"default\",\"limit\":\"3\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(109, 141, 'J2 Store Chart', '', '', 1, 'j2store-module-position-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_chart', 1, 1, '', 1, '*'),
(110, 142, 'J2 Store Stats Mini', '', '', 1, 'j2store-module-position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_stats_mini', 1, 1, '', 1, '*'),
(111, 143, 'J2 Store Orders', '', '', 1, 'j2store-module-position-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_orders', 1, 1, '', 1, '*'),
(112, 144, 'J2 Store Stats', '', '', 1, 'j2store-module-position-5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_stats', 1, 1, '', 1, '*'),
(113, 145, 'J2Store Administrator Menu', '', '', 2, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_menu', 1, 1, '', 1, '*'),
(115, 147, 'J2 Store Cart', '', '', 1, 'top2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_cart', 1, 0, '{\"moduleclass_sfx\":\"\",\"cart_module_title\":\"Cart\",\"link_type\":\"link\",\"layout\":\"_:minicart\",\"check_empty\":\"0\",\"quantity_count\":\"1\",\"show_thumbimage\":\"1\",\"show_product_qty\":\"1\",\"show_cart_remove\":\"1\",\"enable_checkout\":\"1\",\"enable_view_cart\":\"1\",\"minicart_cart_icon_class\":\" \",\"custom_css\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(116, 161, 'Featured Products', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2products', 1, 1, '{\"module_subtemplate\":\"Carousel\",\"menu_id\":\"\",\"content_integration\":\"joomla\",\"sort_by\":\"\",\"product_source_type\":\"category\",\"catids\":[\"17\"],\"include_subcategories\":\"1\",\"include_subcat_level\":\"0\",\"number_of_coloums\":\"3\",\"number_of_coloums_Desktop\":\"3\",\"number_of_coloums_DesktopSmall\":\"3\",\"number_of_coloums_Tablet\":\"3\",\"number_of_coloums_TabletSmall\":\"2\",\"number_of_coloums_Mobile\":\"1\",\"show_navigation\":\"0\",\"number_of_items\":\"6\",\"show_feature_only\":\"1\",\"show_title\":\"1\",\"link_title\":\"1\",\"show_sku\":\"0\",\"show_price\":\"1\",\"show_price_taxinfo\":\"1\",\"show_special_price\":\"1\",\"show_offers\":\"1\",\"show_stock\":\"0\",\"show_beforedisplaycontent\":\"1\",\"show_afterdisplaycontent\":\"1\",\"list_show_cart\":\"2\",\"show_introtext\":\"0\",\"introtext_limit\":\"50\",\"show_quickview\":\"0\",\"show_image\":\"1\",\"link_image\":\"1\",\"image_type\":\"thumbimage\",\"image_size_width\":\"350\",\"image_size_height\":\"385\",\"image_position\":\"top\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(119, 164, 'J2Store Categories', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_categories', 1, 1, '{\"menuitem_id\":\"178\",\"parent\":\"17\",\"show_description\":\"0\",\"numitems\":\"0\",\"browse_link\":\"1\",\"show_children\":\"0\",\"category_bootstrap_version\":\"2\",\"category_display_view\":\"list_view\",\"categories_per_row\":\"4\",\"count\":\"4\",\"maxlevel\":\"0\",\"show_image\":\"1\",\"image_height\":\"40\",\"image_width\":\"40\",\"layout\":\"_:default\",\"item_heading\":\"4\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(121, 171, 'Latest Products', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2products', 1, 0, '{\"module_subtemplate\":\"Bootstrap3\",\"menu_id\":\"\",\"content_integration\":\"joomla\",\"sort_by\":\"\",\"product_source_type\":\"category\",\"catids\":[\"17\"],\"include_subcategories\":\"1\",\"include_subcat_level\":\"0\",\"number_of_coloums\":\"4\",\"number_of_coloums_Desktop\":\"3\",\"number_of_coloums_DesktopSmall\":\"3\",\"number_of_coloums_Tablet\":\"3\",\"number_of_coloums_TabletSmall\":\"2\",\"number_of_coloums_Mobile\":\"1\",\"show_navigation\":\"0\",\"number_of_items\":\"8\",\"show_feature_only\":\"0\",\"show_title\":\"1\",\"link_title\":\"1\",\"show_sku\":\"0\",\"show_price\":\"1\",\"show_price_taxinfo\":\"1\",\"show_special_price\":\"1\",\"show_offers\":\"1\",\"show_stock\":\"0\",\"show_beforedisplaycontent\":\"1\",\"show_afterdisplaycontent\":\"1\",\"list_show_cart\":\"2\",\"show_introtext\":\"0\",\"introtext_limit\":\"50\",\"show_quickview\":\"0\",\"show_image\":\"1\",\"link_image\":\"1\",\"image_type\":\"thumbimage\",\"image_size_width\":\"350\",\"image_size_height\":\"385\",\"image_position\":\"top\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(122, 256, 'Login / Registration', '', '', 1, 'top2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 0, '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":1,\"name\":0,\"profilelink\":0,\"usesecure\":0,\"usetext\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(124, 260, 'Latest Portfolio', 'For Creative Home', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 0, '{\"show_filter\":\"1\",\"category_id\":\"21\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"popup_image\":\"default\",\"limit\":\"4\",\"layout\":\"indigo:classic\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(125, 289, 'Language Switcher', '', '', 1, 'top1', 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', 1, 'mod_languages', 1, 0, '{\"header_text\":\"\",\"footer_text\":\"\",\"dropdown\":0,\"dropdownimage\":0,\"lineheight\":0,\"image\":0,\"show_active\":1,\"full_name\":1,\"inline\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(126, 291, 'Latest Post', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 0, '{\"catid\":[9,11,12],\"count\":3,\"show_featured\":\"\",\"ordering\":\"p_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(127, 294, 'Search', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":100,\"text\":\"\",\"button\":1,\"button_pos\":\"right\",\"imagebutton\":0,\"button_text\":\"\",\"opensearch\":1,\"opensearch_title\":\"\",\"set_itemid\":0,\"layout\":\"indigo:topsearch\",\"moduleclass_sfx\":\" pull-right my-top-search\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(128, 295, 'J2 Store Cart', 'for home shop ', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2store_cart', 1, 0, '{\"moduleclass_sfx\":\"store-cart\",\"cart_module_title\":\"\",\"link_type\":\"link\",\"layout\":\"_:minicart\",\"check_empty\":\"0\",\"quantity_count\":\"1\",\"show_thumbimage\":\"1\",\"show_product_qty\":\"1\",\"show_cart_remove\":\"1\",\"enable_checkout\":\"1\",\"enable_view_cart\":\"1\",\"minicart_cart_icon_class\":\" \",\"custom_css\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(129, 296, 'Login / Registration', 'for home shop', '', 1, 'menu', 0, '0000-00-00 00:00:00', '2020-01-21 05:51:17', '0000-00-00 00:00:00', 1, 'mod_login', 1, 0, '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":1,\"name\":0,\"profilelink\":0,\"usesecure\":0,\"usetext\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"login-modal-wrap\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(130, 297, 'Language Switcher', 'for home Shop', '', 1, 'top2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_languages', 1, 0, '{\"header_text\":\"\",\"footer_text\":\"\",\"dropdown\":0,\"dropdownimage\":0,\"lineheight\":0,\"image\":0,\"show_active\":1,\"full_name\":1,\"inline\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"language-switcher\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(131, 298, 'Social Icons', 'For Home Shop', '', 1, 'top2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(132, 300, 'Latest Products', 'For Shop Details Page', '', 1, 'position2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_j2products', 1, 1, '{\"module_subtemplate\":\"Carousel\",\"menu_id\":\"\",\"content_integration\":\"joomla\",\"sort_by\":\"\",\"product_source_type\":\"category\",\"catids\":[\"17\"],\"include_subcategories\":\"1\",\"include_subcat_level\":\"0\",\"number_of_coloums\":\"4\",\"number_of_coloums_Desktop\":\"4\",\"number_of_coloums_DesktopSmall\":\"3\",\"number_of_coloums_Tablet\":\"3\",\"number_of_coloums_TabletSmall\":\"2\",\"number_of_coloums_Mobile\":\"1\",\"show_navigation\":\"0\",\"number_of_items\":\"4\",\"show_feature_only\":\"1\",\"show_title\":\"1\",\"link_title\":\"1\",\"show_sku\":\"0\",\"show_price\":\"1\",\"show_price_taxinfo\":\"1\",\"show_special_price\":\"1\",\"show_offers\":\"1\",\"show_stock\":\"0\",\"show_beforedisplaycontent\":\"1\",\"show_afterdisplaycontent\":\"1\",\"list_show_cart\":\"2\",\"show_introtext\":\"0\",\"introtext_limit\":\"50\",\"show_quickview\":\"0\",\"show_image\":\"1\",\"link_image\":\"1\",\"image_type\":\"thumbimage\",\"image_size_width\":\"200\",\"image_size_height\":\"385\",\"image_position\":\"top\",\"moduleclass_sfx\":\"product-details-bottom\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(133, 306, 'Banner(Megamenu)', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(134, 307, 'Blog Listing Top', '', '', 1, 'position1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(135, 308, 'Search Right Sidebar', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_search', 1, 1, '{\"label\":\"\",\"width\":\"\",\"text\":\"\",\"button\":0,\"button_pos\":\"left\",\"imagebutton\":0,\"button_text\":\"\",\"opensearch\":1,\"opensearch_title\":\"\",\"set_itemid\":0,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(0, 0),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(79, 0),
(86, 0),
(87, 0),
(89, 0),
(90, 0),
(96, 0),
(98, 0),
(99, 0),
(100, 0),
(101, 0),
(102, 0),
(103, 0),
(104, 0),
(105, 0),
(106, 115),
(107, 115),
(108, 0),
(109, 0),
(110, 0),
(111, 0),
(112, 0),
(113, 0),
(115, -405),
(115, -183),
(116, 0),
(121, 0),
(122, -405),
(122, -183),
(124, 0),
(125, -405),
(125, -183),
(126, 115),
(127, 183),
(127, 405),
(128, 183),
(128, 405),
(129, 183),
(129, 405),
(130, 183),
(131, 183),
(131, 405),
(132, 178),
(133, 0),
(134, 115),
(135, 115);

-- --------------------------------------------------------

--
-- Table structure for table `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__overrider`
--

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__postinstall_messages`
--

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) UNSIGNED NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__postinstall_messages`
--

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.2.0', 1),
(3, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(4, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(5, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(6, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1),
(7, 700, 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', 1, 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', 1),
(8, 700, 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', 1),
(9, 700, 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', 1, 'message', '', '', '', '', '3.9.0', 1),
(10, 700, 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', 1, 'message', '', '', '', '', '3.9.0', 1),
(11, 700, 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__privacy_consents`
--

DROP TABLE IF EXISTS `#__privacy_consents`;
CREATE TABLE `#__privacy_consents` (
  `id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__privacy_requests`
--

DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE `#__privacy_requests` (
  `id` int(10) UNSIGNED NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__schemas`
--

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__schemas`
--

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.9.10-2019-07-09'),
(10000, '3.6.2-2019-08-20'),
(10007, '1.8-2020-21-01');

-- --------------------------------------------------------

--
-- Table structure for table `#__speasyimagegallery_albums`
--

DROP TABLE IF EXISTS `#__speasyimagegallery_albums`;
CREATE TABLE `#__speasyimagegallery_albums` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `image` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if item is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__speasyimagegallery_albums`
--

INSERT INTO `#__speasyimagegallery_albums` (`id`, `asset_id`, `title`, `alias`, `image`, `description`, `published`, `catid`, `created`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`) VALUES
(1, 65, 'Album', 'album', 'images/gallery1.jpg', '', 1, 0, '2018-02-22 09:25:09', 871, '2019-07-02 09:39:13', 58, 0, '0000-00-00 00:00:00', '', 0, '', '', 1, 185, '', 0, '*'),
(2, 262, 'indigo', 'indigo', 'images/gallery1.jpg', '', 1, 0, '2019-07-02 09:40:34', 58, '2019-07-02 10:19:34', 58, 0, '0000-00-00 00:00:00', '', 0, '', '', 1, 37, '', 1, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__speasyimagegallery_images`
--

DROP TABLE IF EXISTS `#__speasyimagegallery_images`;
CREATE TABLE `#__speasyimagegallery_images` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `album_id` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__speasyimagegallery_images`
--

INSERT INTO `#__speasyimagegallery_images` (`id`, `asset_id`, `album_id`, `title`, `alt`, `filename`, `description`, `state`, `created`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `images`, `ordering`, `language`) VALUES
(1, 0, 1, 'Gallery6', 'Gallery6', 'gallery6.jpg', '', 1, '2018-02-22 03:02:15', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery6.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery6_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery6_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery6_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery6_y_thumb.jpg\"}', 8, ''),
(2, 0, 1, 'Gallery1', 'Gallery1', 'gallery1.jpg', '', 1, '2018-02-22 03:02:15', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery1.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery1_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery1_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery1_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery1_y_thumb.jpg\"}', 13, ''),
(3, 0, 1, 'Gallery4', 'Gallery4', 'gallery4.jpg', '', 1, '2018-02-22 03:02:15', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery4.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery4_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery4_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery4_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery4_y_thumb.jpg\"}', 10, ''),
(4, 0, 1, 'Gallery3', 'Gallery3', 'gallery3.jpg', '', 1, '2018-02-22 03:02:15', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery3.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery3_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery3_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery3_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery3_y_thumb.jpg\"}', 11, ''),
(5, 0, 1, 'Gallery5', 'Gallery5', 'gallery5.jpg', '', 1, '2018-02-22 03:02:15', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery5.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery5_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery5_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery5_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery5_y_thumb.jpg\"}', 9, ''),
(6, 0, 1, 'Gallery2', 'Gallery2', 'gallery2.jpg', '', 1, '2018-02-22 03:02:15', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery2.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery2_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery2_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery2_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery2_y_thumb.jpg\"}', 12, ''),
(7, 0, 1, 'Gallery10', 'Gallery10', 'gallery10.jpg', '', 1, '2018-02-22 03:02:16', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery10.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery10_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery10_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery10_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery10_y_thumb.jpg\"}', 4, ''),
(8, 0, 1, 'Gallery7', 'Gallery7', 'gallery7.jpg', '', 1, '2018-02-22 03:02:16', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery7.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery7_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery7_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery7_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery7_y_thumb.jpg\"}', 7, ''),
(9, 0, 1, 'Gallery8', 'Gallery8', 'gallery8.jpg', '', 1, '2018-02-22 03:02:16', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery8.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery8_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery8_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery8_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery8_y_thumb.jpg\"}', 6, ''),
(10, 0, 1, 'Gallery12', 'Gallery12', 'gallery12.jpg', '', 1, '2018-02-22 03:02:16', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery12.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery12_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery12_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery12_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery12_y_thumb.jpg\"}', 2, ''),
(11, 0, 1, 'Gallery11', 'Gallery11', 'gallery11.jpg', '', 1, '2018-02-22 03:02:16', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery11.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery11_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery11_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery11_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery11_y_thumb.jpg\"}', 3, ''),
(12, 0, 1, 'Gallery9', 'Gallery9', 'gallery9.jpg', '', 1, '2018-02-22 03:02:16', 871, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery9.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery9_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery9_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery9_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/1\\/images\\/gallery9_y_thumb.jpg\"}', 5, ''),
(15, 0, 2, 'Corporate Design', 'Gallery12', 'gallery12.jpg', '', 1, '2019-07-02 09:07:00', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery12.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery12_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery12_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery12_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery12_y_thumb.jpg\"}', 1, ''),
(16, 0, 2, 'Corporate Design', 'Gallery11', 'gallery11.jpg', '', 1, '2019-07-02 09:07:04', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery11.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery11_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery11_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery11_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery11_y_thumb.jpg\"}', 2, ''),
(17, 0, 2, 'Corporate Design', 'Gallery10', 'gallery10.jpg', '', 1, '2019-07-02 09:07:07', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery10.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery10_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery10_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery10_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery10_y_thumb.jpg\"}', 3, ''),
(18, 0, 2, 'Corporate Design', 'Gallery9', 'gallery9.jpg', '', 1, '2019-07-02 09:07:12', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery9.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery9_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery9_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery9_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery9_y_thumb.jpg\"}', 4, ''),
(19, 0, 2, 'Corporate Design', 'Gallery8', 'gallery8.jpg', '', 1, '2019-07-02 09:07:17', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery8.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery8_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery8_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery8_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery8_y_thumb.jpg\"}', 5, ''),
(20, 0, 2, 'Corporate Design', 'Gallery7', 'gallery7.jpg', '', 1, '2019-07-02 09:07:22', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery7.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery7_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery7_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery7_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery7_y_thumb.jpg\"}', 6, ''),
(21, 0, 2, 'Corporate Design', 'Gallery6', 'gallery6.jpg', '', 1, '2019-07-02 09:07:28', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery6.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery6_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery6_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery6_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery6_y_thumb.jpg\"}', 7, ''),
(22, 0, 2, 'Corporate Design', 'Gallery5', 'gallery5.jpg', '', 1, '2019-07-02 09:07:32', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery5.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery5_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery5_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery5_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery5_y_thumb.jpg\"}', 8, ''),
(23, 0, 2, 'Corporate Design', 'Gallery4', 'gallery4.jpg', '', 1, '2019-07-02 09:07:37', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery4.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery4_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery4_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery4_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery4_y_thumb.jpg\"}', 9, ''),
(24, 0, 2, 'Corporate Design', 'Gallery3', 'gallery3.jpg', '', 1, '2019-07-02 09:07:44', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery3.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery3_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery3_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery3_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery3_y_thumb.jpg\"}', 10, ''),
(25, 0, 2, 'Corporate Design', 'Gallery2', 'gallery2.jpg', '', 1, '2019-07-02 09:07:49', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery2.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery2_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery2_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery2_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery2_y_thumb.jpg\"}', 11, ''),
(26, 0, 2, 'Corporate Design', 'Gallery1', 'gallery1.jpg', '', 1, '2019-07-02 09:07:53', 58, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '{\"original\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery1.jpg\",\"mini\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery1_mini.jpg\",\"thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery1_thumb.jpg\",\"x_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery1_x_thumb.jpg\",\"y_thumb\":\"images\\/speasyimagegallery\\/albums\\/2\\/images\\/gallery1_y_thumb.jpg\"}', 12, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__spmedia`
--

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__spmedia`
--

INSERT INTO `#__spmedia` (`id`, `title`, `path`, `thumb`, `alt`, `caption`, `description`, `type`, `extension`, `created_on`, `created_by`, `modified_on`, `modified_by`) VALUES
(10, 'client4', 'images/2018/02/22/client4.png', '', 'client4', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(11, 'avatar', 'images/2018/02/22/avatar.jpg', '', 'avatar', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(12, 'client1', 'images/2018/02/22/client1.png', '', 'client1', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(13, 'client2', 'images/2018/02/22/client2.png', '', 'client2', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(14, 'client3', 'images/2018/02/22/client3.png', '', 'client3', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(15, 'hero', 'images/2018/02/22/hero.jpg', 'images/2018/02/22/_spmedia_thumbs/hero.jpg', 'hero', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(16, 'img1', 'images/2018/02/22/img1.jpg', 'images/2018/02/22/_spmedia_thumbs/img1.jpg', 'img1', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(17, 'img2', 'images/2018/02/22/img2.jpg', 'images/2018/02/22/_spmedia_thumbs/img2.jpg', 'img2', '', '', 'image', 'com_sppagebuilder', '2018-02-22 07:27:01', 871, '0000-00-00 00:00:00', 0),
(18, 'person1', 'images/2018/02/22/person1.jpg', 'images/2018/02/22/_spmedia_thumbs/person1.jpg', 'person1', '', '', 'image', 'com_sppagebuilder', '2018-02-22 18:09:48', 871, '0000-00-00 00:00:00', 0),
(19, 'person2', 'images/2018/02/22/person2.jpg', 'images/2018/02/22/_spmedia_thumbs/person2.jpg', 'person2', '', '', 'image', 'com_sppagebuilder', '2018-02-22 18:09:48', 871, '0000-00-00 00:00:00', 0),
(20, 'person3', 'images/2018/02/22/person3.jpg', 'images/2018/02/22/_spmedia_thumbs/person3.jpg', 'person3', '', '', 'image', 'com_sppagebuilder', '2018-02-22 18:09:48', 871, '0000-00-00 00:00:00', 0),
(21, 'slider-01', 'images/2019/05/27/slider-01.jpg', 'images/2019/05/27/_spmedia_thumbs/slider-01.jpg', 'slider-01', '', '', 'image', 'com_sppagebuilder', '2019-05-27 08:41:18', 58, '0000-00-00 00:00:00', 0),
(22, 'we-are-indigo', 'images/2019/05/29/we-are-indigo.png', 'images/2019/05/29/_spmedia_thumbs/we-are-indigo.png', 'we-are-indigo', '', '', 'image', 'com_sppagebuilder', '2019-05-29 06:49:28', 58, '0000-00-00 00:00:00', 0),
(23, 'footer-logo', 'images/2019/05/29/footer-logo.png', '', 'footer-logo', '', '', 'image', 'com_sppagebuilder', '2019-05-29 07:46:49', 58, '0000-00-00 00:00:00', 0),
(27, 'home-top-portfolio-01', 'images/2019/05/31/home-top-portfolio-01.jpg', 'images/2019/05/31/_spmedia_thumbs/home-top-portfolio-01.jpg', 'home-top-portfolio-01', '', '', 'image', 'com_sppagebuilder', '2019-05-31 06:26:58', 58, '0000-00-00 00:00:00', 0),
(28, 'home-top-portfolio-02', 'images/2019/05/31/home-top-portfolio-02.jpg', 'images/2019/05/31/_spmedia_thumbs/home-top-portfolio-02.jpg', 'home-top-portfolio-02', '', '', 'image', 'com_sppagebuilder', '2019-05-31 06:27:02', 58, '0000-00-00 00:00:00', 0),
(29, 'home-top-portfolio-03', 'images/2019/05/31/home-top-portfolio-03.jpg', 'images/2019/05/31/_spmedia_thumbs/home-top-portfolio-03.jpg', 'home-top-portfolio-03', '', '', 'image', 'com_sppagebuilder', '2019-05-31 06:27:05', 58, '0000-00-00 00:00:00', 0),
(30, 'home-portfolio-tab-01', 'images/2019/05/31/home-portfolio-tab-01.png', 'images/2019/05/31/_spmedia_thumbs/home-portfolio-tab-01.png', 'home-portfolio-tab-01', '', '', 'image', 'com_sppagebuilder', '2019-05-31 06:27:47', 58, '0000-00-00 00:00:00', 0),
(31, 'home-testimonial-01', 'images/2019/05/31/home-testimonial-01.jpg', 'images/2019/05/31/_spmedia_thumbs/home-testimonial-01.jpg', 'home-testimonial-01', '', '', 'image', 'com_sppagebuilder', '2019-05-31 06:29:19', 58, '0000-00-00 00:00:00', 0),
(32, 'home-testimonial-02', 'images/2019/05/31/home-testimonial-02.jpg', 'images/2019/05/31/_spmedia_thumbs/home-testimonial-02.jpg', 'home-testimonial-02', '', '', 'image', 'com_sppagebuilder', '2019-05-31 06:29:32', 58, '0000-00-00 00:00:00', 0),
(34, 'about-top', 'images/2019/06/10/about-top.jpg', 'images/2019/06/10/_spmedia_thumbs/about-top.jpg', 'about-top', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:31:35', 58, '0000-00-00 00:00:00', 0),
(35, 'about-our-culture', 'images/2019/06/10/about-our-culture.png', 'images/2019/06/10/_spmedia_thumbs/about-our-culture.png', 'about-our-culture', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:32:15', 58, '0000-00-00 00:00:00', 0),
(36, 'team-01', 'images/2019/06/10/team-01.jpg', 'images/2019/06/10/_spmedia_thumbs/team-01.jpg', 'team-01', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:36:29', 58, '0000-00-00 00:00:00', 0),
(37, 'team-02', 'images/2019/06/10/team-02.jpg', 'images/2019/06/10/_spmedia_thumbs/team-02.jpg', 'team-02', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:36:33', 58, '0000-00-00 00:00:00', 0),
(38, 'team-03', 'images/2019/06/10/team-03.jpg', 'images/2019/06/10/_spmedia_thumbs/team-03.jpg', 'team-03', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:36:37', 58, '0000-00-00 00:00:00', 0),
(39, 'team-04', 'images/2019/06/10/team-04.jpg', 'images/2019/06/10/_spmedia_thumbs/team-04.jpg', 'team-04', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:36:40', 58, '0000-00-00 00:00:00', 0),
(41, 'slider-03', 'images/2019/06/10/slider-03.jpg', 'images/2019/06/10/_spmedia_thumbs/slider-03.jpg', 'slider-03', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:48:09', 58, '0000-00-00 00:00:00', 0),
(42, 'slider-02', 'images/2019/06/10/slider-02.jpg', 'images/2019/06/10/_spmedia_thumbs/slider-02.jpg', 'slider-02', '', '', 'image', 'com_sppagebuilder', '2019-06-10 06:48:14', 58, '0000-00-00 00:00:00', 0),
(45, 'person', 'images/2019/06/10/person.png', 'images/2019/06/10/_spmedia_thumbs/person.png', 'person', '', '', 'image', 'com_sppagebuilder', '2019-06-10 11:53:27', 58, '0000-00-00 00:00:00', 0),
(46, 'bitmap', 'images/2019/06/10/bitmap.jpg', 'images/2019/06/10/_spmedia_thumbs/bitmap.jpg', 'bitmap', '', '', 'image', 'com_sppagebuilder', '2019-06-10 11:59:13', 58, '0000-00-00 00:00:00', 0),
(47, 'home-feature-01', 'images/2019/06/11/home-feature-01.svg', '', 'home-feature-01', '', '', 'image', 'com_sppagebuilder', '2019-06-11 11:37:15', 58, '0000-00-00 00:00:00', 0),
(48, 'home-feature-02', 'images/2019/06/11/home-feature-02.svg', '', 'home-feature-02', '', '', 'image', 'com_sppagebuilder', '2019-06-11 11:37:18', 58, '0000-00-00 00:00:00', 0),
(49, 'home-feature-03', 'images/2019/06/11/home-feature-03.svg', '', 'home-feature-03', '', '', 'image', 'com_sppagebuilder', '2019-06-11 11:37:21', 58, '0000-00-00 00:00:00', 0),
(50, 'indigo-client-01', 'images/2019/06/11/indigo-client-01.svg', '', 'indigo-client-01', '', '', 'image', 'com_sppagebuilder', '2019-06-11 12:12:04', 58, '0000-00-00 00:00:00', 0),
(51, 'indigo-client-02', 'images/2019/06/11/indigo-client-02.svg', '', 'indigo-client-02', '', '', 'image', 'com_sppagebuilder', '2019-06-11 12:12:07', 58, '0000-00-00 00:00:00', 0),
(52, 'indigo-client-03', 'images/2019/06/11/indigo-client-03.svg', '', 'indigo-client-03', '', '', 'image', 'com_sppagebuilder', '2019-06-11 12:12:13', 58, '0000-00-00 00:00:00', 0),
(53, 'indigo-client-04', 'images/2019/06/11/indigo-client-04.svg', '', 'indigo-client-04', '', '', 'image', 'com_sppagebuilder', '2019-06-11 12:12:17', 58, '0000-00-00 00:00:00', 0),
(54, 'indigo-client-05', 'images/2019/06/11/indigo-client-05.svg', '', 'indigo-client-05', '', '', 'image', 'com_sppagebuilder', '2019-06-11 12:12:21', 58, '0000-00-00 00:00:00', 0),
(55, 'indigo-client-06', 'images/2019/06/11/indigo-client-06.svg', '', 'indigo-client-06', '', '', 'image', 'com_sppagebuilder', '2019-06-11 12:12:24', 58, '0000-00-00 00:00:00', 0),
(56, 'indigo-client-07', 'images/2019/06/11/indigo-client-07.svg', '', 'indigo-client-07', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:10:33', 58, '0000-00-00 00:00:00', 0),
(57, 'indigo-client-08', 'images/2019/06/11/indigo-client-08.svg', '', 'indigo-client-08', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:10:37', 58, '0000-00-00 00:00:00', 0),
(58, 'indigo-client-09', 'images/2019/06/11/indigo-client-09.svg', '', 'indigo-client-09', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:10:40', 58, '0000-00-00 00:00:00', 0),
(59, 'indigo-client-10', 'images/2019/06/11/indigo-client-10.svg', '', 'indigo-client-10', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:10:58', 58, '0000-00-00 00:00:00', 0),
(60, 'indigo-client-11', 'images/2019/06/11/indigo-client-11.svg', '', 'indigo-client-11', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:11:01', 58, '0000-00-00 00:00:00', 0),
(61, 'indigo-client-12', 'images/2019/06/11/indigo-client-12.svg', '', 'indigo-client-12', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:11:04', 58, '0000-00-00 00:00:00', 0),
(62, 'testimonial-02', 'images/2019/06/11/testimonial-02.svg', '', 'testimonial-02', '', '', 'image', 'com_sppagebuilder', '2019-06-11 13:25:52', 58, '0000-00-00 00:00:00', 0),
(63, 'home-testimonial-03', 'images/2019/06/12/home-testimonial-03.svg', '', 'home-testimonial-03', '', '', 'image', 'com_sppagebuilder', '2019-06-12 09:43:48', 58, '0000-00-00 00:00:00', 0),
(64, 'footer-logo', 'images/2019/06/12/footer-logo.svg', '', 'footer-logo', '', '', 'image', 'com_sppagebuilder', '2019-06-12 10:00:01', 58, '0000-00-00 00:00:00', 0),
(65, 'about-feature-01', 'images/2019/06/12/about-feature-01.svg', '', 'about-feature-01', '', '', 'image', 'com_sppagebuilder', '2019-06-12 10:12:07', 58, '0000-00-00 00:00:00', 0),
(66, 'about-feature-02', 'images/2019/06/12/about-feature-02.svg', '', 'about-feature-02', '', '', 'image', 'com_sppagebuilder', '2019-06-12 10:12:10', 58, '0000-00-00 00:00:00', 0),
(67, 'about-feature-03', 'images/2019/06/12/about-feature-03.svg', '', 'about-feature-03', '', '', 'image', 'com_sppagebuilder', '2019-06-12 10:12:14', 58, '0000-00-00 00:00:00', 0),
(68, 'service-02-feature-bg', 'images/2019/06/13/service-02-feature-bg.png', 'images/2019/06/13/_spmedia_thumbs/service-02-feature-bg.png', 'service-02-feature-bg', '', '', 'image', 'com_sppagebuilder', '2019-06-13 08:04:35', 58, '0000-00-00 00:00:00', 0),
(69, 'indigo-client-01', 'images/2019/06/13/indigo-client-01.svg', '', 'indigo-client-01', '', '', 'image', 'com_sppagebuilder', '2019-06-13 10:13:42', 58, '0000-00-00 00:00:00', 0),
(71, 'home-feature-04', 'images/2019/06/13/home-feature-04.svg', '', 'home-feature-04', '', '', 'image', 'com_sppagebuilder', '2019-06-13 10:16:03', 58, '0000-00-00 00:00:00', 0),
(72, 'service-2-cta-bg', 'images/2019/06/13/service-2-cta-bg.jpg', 'images/2019/06/13/_spmedia_thumbs/service-2-cta-bg.jpg', 'service-2-cta-bg', '', '', 'image', 'com_sppagebuilder', '2019-06-13 10:29:38', 58, '0000-00-00 00:00:00', 0),
(73, 'service-icon6', 'images/2019/06/13/service-icon6.svg', '', 'service-icon6', '', '', 'image', 'com_sppagebuilder', '2019-06-13 11:12:40', 58, '0000-00-00 00:00:00', 0),
(74, 'service-icon4', 'images/2019/06/13/service-icon4.svg', '', 'service-icon4', '', '', 'image', 'com_sppagebuilder', '2019-06-13 11:12:40', 58, '0000-00-00 00:00:00', 0),
(75, 'service-icon7', 'images/2019/06/13/service-icon7.svg', '', 'service-icon7', '', '', 'image', 'com_sppagebuilder', '2019-06-13 11:12:40', 58, '0000-00-00 00:00:00', 0),
(76, 'service-icon5', 'images/2019/06/13/service-icon5.svg', '', 'service-icon5', '', '', 'image', 'com_sppagebuilder', '2019-06-13 11:12:40', 58, '0000-00-00 00:00:00', 0),
(77, 'blog-details-slider-01', 'images/2019/06/13/blog-details-slider-01.jpg', 'images/2019/06/13/_spmedia_thumbs/blog-details-slider-01.jpg', 'blog-details-slider-01', '', '', 'image', 'com_sppagebuilder', '2019-06-13 14:14:01', 58, '0000-00-00 00:00:00', 0),
(78, 'shell', 'images/2019/06/14/shell.svg', '', 'shell', '', '', 'image', 'com_sppagebuilder', '2019-06-14 05:56:55', 58, '0000-00-00 00:00:00', 0),
(79, 'macro', 'images/2019/06/14/macro.svg', '', 'macro', '', '', 'image', 'com_sppagebuilder', '2019-06-14 05:57:05', 58, '0000-00-00 00:00:00', 0),
(87, 'blog-details-slider-02', 'images/2019/06/14/blog-details-slider-02.jpg', 'images/2019/06/14/_spmedia_thumbs/blog-details-slider-02.jpg', 'blog-details-slider-02', '', '', 'image', 'com_sppagebuilder', '2019-06-14 08:11:40', 58, '0000-00-00 00:00:00', 0),
(88, 'blog-details-slider-03', 'images/2019/06/14/blog-details-slider-03.jpg', 'images/2019/06/14/_spmedia_thumbs/blog-details-slider-03.jpg', 'blog-details-slider-03', '', '', 'image', 'com_sppagebuilder', '2019-06-14 08:11:43', 58, '0000-00-00 00:00:00', 0),
(89, 'team12x', 'images/2019/06/14/team12x.jpg', 'images/2019/06/14/_spmedia_thumbs/team12x.jpg', 'team12x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(90, 'team32x', 'images/2019/06/14/team32x.jpg', 'images/2019/06/14/_spmedia_thumbs/team32x.jpg', 'team32x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(91, 'team52x', 'images/2019/06/14/team52x.jpg', 'images/2019/06/14/_spmedia_thumbs/team52x.jpg', 'team52x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(92, 'team22x', 'images/2019/06/14/team22x.jpg', 'images/2019/06/14/_spmedia_thumbs/team22x.jpg', 'team22x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(93, 'team42x', 'images/2019/06/14/team42x.jpg', 'images/2019/06/14/_spmedia_thumbs/team42x.jpg', 'team42x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(94, 'team62x', 'images/2019/06/14/team62x.jpg', 'images/2019/06/14/_spmedia_thumbs/team62x.jpg', 'team62x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(95, 'team72x', 'images/2019/06/14/team72x.jpg', 'images/2019/06/14/_spmedia_thumbs/team72x.jpg', 'team72x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:46:38', 58, '0000-00-00 00:00:00', 0),
(96, 'blog-details-01', 'images/2019/06/14/blog-details-01.jpg', 'images/2019/06/14/_spmedia_thumbs/blog-details-01.jpg', 'blog-details-01', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:52:57', 58, '0000-00-00 00:00:00', 0),
(97, 'blog-details-02', 'images/2019/06/14/blog-details-02.png', 'images/2019/06/14/_spmedia_thumbs/blog-details-02.png', 'blog-details-02', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:53:03', 58, '0000-00-00 00:00:00', 0),
(98, 'slider-v2-img1', 'images/2019/06/14/slider-v2-img1.jpg', 'images/2019/06/14/_spmedia_thumbs/slider-v2-img1.jpg', 'slider-v2-img1', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:54:17', 58, '0000-00-00 00:00:00', 0),
(99, 'indigo-play-icon', 'images/2019/06/14/indigo-play-icon.svg', '', 'indigo-play-icon', '', '', 'image', 'com_sppagebuilder', '2019-06-14 09:59:27', 58, '0000-00-00 00:00:00', 0),
(100, 'blog-details-021', 'images/2019/06/14/blog-details-021.png', 'images/2019/06/14/_spmedia_thumbs/blog-details-021.png', 'blog-details-021', '', '', 'image', 'com_sppagebuilder', '2019-06-14 10:00:59', 58, '0000-00-00 00:00:00', 0),
(101, 'blog-details-testimonial', 'images/2019/06/14/blog-details-testimonial.png', '', 'blog-details-testimonial', '', '', 'image', 'com_sppagebuilder', '2019-06-14 10:26:22', 58, '0000-00-00 00:00:00', 0),
(102, 'smile-face', 'images/2019/06/14/smile-face.png', 'images/2019/06/14/_spmedia_thumbs/smile-face.png', 'smile-face', '', '', 'image', 'com_sppagebuilder', '2019-06-14 10:34:45', 58, '0000-00-00 00:00:00', 0),
(103, 'client-img12x', 'images/2019/06/14/client-img12x.jpg', 'images/2019/06/14/_spmedia_thumbs/client-img12x.jpg', 'client-img12x', '', '', 'image', 'com_sppagebuilder', '2019-06-14 11:32:24', 58, '0000-00-00 00:00:00', 0),
(104, 'stats-fun-facts-bg', 'images/2019/06/17/stats-fun-facts-bg.jpg', 'images/2019/06/17/_spmedia_thumbs/stats-fun-facts-bg.jpg', 'stats-fun-facts-bg', '', '', 'image', 'com_sppagebuilder', '2019-06-17 12:03:37', 58, '0000-00-00 00:00:00', 0),
(105, 'about-img1', 'images/2019/06/19/about-img1.jpg', 'images/2019/06/19/_spmedia_thumbs/about-img1.jpg', 'about-img1', '', '', 'image', 'com_sppagebuilder', '2019-06-19 10:23:18', 58, '0000-00-00 00:00:00', 0),
(106, 'headphone', 'images/2019/06/19/headphone.png', 'images/2019/06/19/_spmedia_thumbs/headphone.png', 'headphone', '', '', 'image', 'com_sppagebuilder', '2019-06-19 10:44:09', 58, '0000-00-00 00:00:00', 0),
(107, 'slider-bg-img', 'images/2019/06/19/slider-bg-img.png', 'images/2019/06/19/_spmedia_thumbs/slider-bg-img.png', 'slider-bg-img', '', '', 'image', 'com_sppagebuilder', '2019-06-19 10:46:28', 58, '0000-00-00 00:00:00', 0),
(108, 'about-img2', 'images/2019/06/19/about-img2.jpg', 'images/2019/06/19/_spmedia_thumbs/about-img2.jpg', 'about-img2', '', '', 'image', 'com_sppagebuilder', '2019-06-19 11:16:13', 58, '0000-00-00 00:00:00', 0),
(116, 'about2-team1', 'images/2019/06/19/about2-team1.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team1.jpg', 'about2-team1', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:26', 58, '0000-00-00 00:00:00', 0),
(117, 'about2-team2', 'images/2019/06/19/about2-team2.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team2.jpg', 'about2-team2', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:29', 58, '0000-00-00 00:00:00', 0),
(118, 'about2-team3', 'images/2019/06/19/about2-team3.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team3.jpg', 'about2-team3', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:32', 58, '0000-00-00 00:00:00', 0),
(119, 'about2-team4', 'images/2019/06/19/about2-team4.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team4.jpg', 'about2-team4', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:35', 58, '0000-00-00 00:00:00', 0),
(120, 'about2-team5', 'images/2019/06/19/about2-team5.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team5.jpg', 'about2-team5', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:39', 58, '0000-00-00 00:00:00', 0),
(121, 'about2-team6', 'images/2019/06/19/about2-team6.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team6.jpg', 'about2-team6', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:42', 58, '0000-00-00 00:00:00', 0),
(122, 'about2-team7', 'images/2019/06/19/about2-team7.jpg', 'images/2019/06/19/_spmedia_thumbs/about2-team7.jpg', 'about2-team7', '', '', 'image', 'com_sppagebuilder', '2019-06-19 12:12:45', 58, '0000-00-00 00:00:00', 0),
(123, 'about-img3', 'images/2019/06/20/about-img3.jpg', 'images/2019/06/20/_spmedia_thumbs/about-img3.jpg', 'about-img3', '', '', 'image', 'com_sppagebuilder', '2019-06-20 05:12:12', 58, '0000-00-00 00:00:00', 0),
(124, 'pen', 'images/2019/06/20/pen.svg', '', 'pen', '', '', 'image', 'com_sppagebuilder', '2019-06-20 09:21:38', 58, '0000-00-00 00:00:00', 0),
(125, 'rocket', 'images/2019/06/20/rocket.svg', '', 'rocket', '', '', 'image', 'com_sppagebuilder', '2019-06-20 09:21:41', 58, '0000-00-00 00:00:00', 0),
(126, 'star', 'images/2019/06/20/star.svg', '', 'star', '', '', 'image', 'com_sppagebuilder', '2019-06-20 12:05:50', 58, '0000-00-00 00:00:00', 0),
(127, 'shop-cat32x', 'images/2019/06/24/shop-cat32x.jpg', 'images/2019/06/24/_spmedia_thumbs/shop-cat32x.jpg', 'shop-cat32x', '', '', 'image', 'com_sppagebuilder', '2019-06-24 10:18:29', 58, '0000-00-00 00:00:00', 0),
(128, 'shop-cat42x', 'images/2019/06/24/shop-cat42x.jpg', 'images/2019/06/24/_spmedia_thumbs/shop-cat42x.jpg', 'shop-cat42x', '', '', 'image', 'com_sppagebuilder', '2019-06-24 10:18:29', 58, '0000-00-00 00:00:00', 0),
(129, 'shop-cat12x', 'images/2019/06/24/shop-cat12x.jpg', 'images/2019/06/24/_spmedia_thumbs/shop-cat12x.jpg', 'shop-cat12x', '', '', 'image', 'com_sppagebuilder', '2019-06-24 10:18:29', 58, '0000-00-00 00:00:00', 0),
(130, 'shop-cat22x', 'images/2019/06/24/shop-cat22x.jpg', 'images/2019/06/24/_spmedia_thumbs/shop-cat22x.jpg', 'shop-cat22x', '', '', 'image', 'com_sppagebuilder', '2019-06-24 10:18:29', 58, '0000-00-00 00:00:00', 0),
(131, 'shop-cat4', 'images/2019/06/24/shop-cat4.jpg', 'images/2019/06/24/_spmedia_thumbs/shop-cat4.jpg', 'shop-cat4', '', '', 'image', 'com_sppagebuilder', '2019-06-24 12:33:25', 58, '0000-00-00 00:00:00', 0),
(132, 'shield-2', 'images/2019/06/25/shield-2.svg', '', 'shield-2', '', '', 'image', 'com_sppagebuilder', '2019-06-25 10:14:48', 58, '0000-00-00 00:00:00', 0),
(133, 'trolley', 'images/2019/06/25/trolley.svg', '', 'trolley', '', '', 'image', 'com_sppagebuilder', '2019-06-25 10:14:53', 58, '0000-00-00 00:00:00', 0),
(134, 'packed', 'images/2019/06/25/packed.svg', '', 'packed', '', '', 'image', 'com_sppagebuilder', '2019-06-25 10:15:01', 58, '0000-00-00 00:00:00', 0),
(135, 'delivered', 'images/2019/06/25/delivered.svg', '', 'delivered', '', '', 'image', 'com_sppagebuilder', '2019-06-25 10:15:04', 58, '0000-00-00 00:00:00', 0),
(137, 'hero-bg12', 'images/2019/06/26/hero-bg12.jpg', 'images/2019/06/26/_spmedia_thumbs/hero-bg12.jpg', 'hero-bg12', '', '', 'image', 'com_sppagebuilder', '2019-06-26 11:56:41', 58, '0000-00-00 00:00:00', 0),
(138, 'demo-thumb1', 'images/2019/06/27/demo-thumb1.jpg', 'images/2019/06/27/_spmedia_thumbs/demo-thumb1.jpg', 'demo-thumb1', '', '', 'image', 'com_sppagebuilder', '2019-06-27 10:12:25', 58, '0000-00-00 00:00:00', 0),
(139, 'col-bg22x', 'images/2019/06/27/col-bg22x.jpg', 'images/2019/06/27/_spmedia_thumbs/col-bg22x.jpg', 'col-bg22x', '', '', 'image', 'com_sppagebuilder', '2019-06-27 10:30:35', 58, '0000-00-00 00:00:00', 0),
(140, 'work-img012x', 'images/2019/06/27/work-img012x.jpg', 'images/2019/06/27/_spmedia_thumbs/work-img012x.jpg', 'work-img012x', '', '', 'image', 'com_sppagebuilder', '2019-06-27 12:14:57', 58, '0000-00-00 00:00:00', 0),
(141, 'work-img032x', 'images/2019/06/27/work-img032x.jpg', 'images/2019/06/27/_spmedia_thumbs/work-img032x.jpg', 'work-img032x', '', '', 'image', 'com_sppagebuilder', '2019-06-27 12:14:57', 58, '0000-00-00 00:00:00', 0),
(143, 'group-29', 'images/2019/06/27/group-29.jpg', 'images/2019/06/27/_spmedia_thumbs/group-29.jpg', 'group-29', '', '', 'image', 'com_sppagebuilder', '2019-06-27 12:39:38', 58, '0000-00-00 00:00:00', 0),
(144, 'portfolio-image-01', 'images/2019/06/28/portfolio-image-01.jpg', 'images/2019/06/28/_spmedia_thumbs/portfolio-image-01.jpg', 'portfolio-image-01', '', '', 'image', 'com_sppagebuilder', '2019-06-28 06:44:25', 58, '0000-00-00 00:00:00', 0),
(145, 'its-me', 'images/2019/06/28/its-me.png', 'images/2019/06/28/_spmedia_thumbs/its-me.png', 'its-me', '', '', 'image', 'com_sppagebuilder', '2019-06-28 12:03:15', 58, '0000-00-00 00:00:00', 0),
(146, 'modal-bg2x', 'images/2019/06/28/modal-bg2x.jpg', 'images/2019/06/28/_spmedia_thumbs/modal-bg2x.jpg', 'modal-bg2x', '', '', 'image', 'com_sppagebuilder', '2019-06-28 12:10:58', 58, '0000-00-00 00:00:00', 0),
(147, 'work-img01', 'images/2019/07/01/work-img01.jpg', '', 'work-img01', '', '', 'image', 'com_sppagebuilder', '2019-07-01 12:07:03', 58, '0000-00-00 00:00:00', 0),
(148, '5', 'images/2019/07/01/5.jpg', 'images/2019/07/01/_spmedia_thumbs/5.jpg', '5', '', '', 'image', 'com_sppagebuilder', '2019-07-01 12:40:43', 58, '0000-00-00 00:00:00', 0),
(149, 'work-img012x', 'images/2019/07/01/work-img012x.jpg', 'images/2019/07/01/_spmedia_thumbs/work-img012x.jpg', 'work-img012x', '', '', 'image', 'com_sppagebuilder', '2019-07-01 12:45:21', 58, '0000-00-00 00:00:00', 0),
(150, 'work-img022x', 'images/2019/07/01/work-img022x.jpg', 'images/2019/07/01/_spmedia_thumbs/work-img022x.jpg', 'work-img022x', '', '', 'image', 'com_sppagebuilder', '2019-07-01 12:45:21', 58, '0000-00-00 00:00:00', 0),
(151, 'work-img032x', 'images/2019/07/01/work-img032x.jpg', 'images/2019/07/01/_spmedia_thumbs/work-img032x.jpg', 'work-img032x', '', '', 'image', 'com_sppagebuilder', '2019-07-01 12:45:21', 58, '0000-00-00 00:00:00', 0),
(152, 'rainbow-face2x', 'images/2019/07/02/rainbow-face2x.jpg', 'images/2019/07/02/_spmedia_thumbs/rainbow-face2x.jpg', 'rainbow-face2x', '', '', 'image', 'com_sppagebuilder', '2019-07-02 04:43:33', 58, '0000-00-00 00:00:00', 0),
(153, 'clients_1', 'images/2019/07/05/clients_1.png', '', 'clients_1', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(154, 'clients_5', 'images/2019/07/05/clients_5.png', '', 'clients_5', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(156, 'clients_3', 'images/2019/07/05/clients_3.png', '', 'clients_3', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(157, 'clients_6', 'images/2019/07/05/clients_6.png', '', 'clients_6', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(158, 'clients_2', 'images/2019/07/05/clients_2.png', '', 'clients_2', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(159, 'clients_8', 'images/2019/07/05/clients_8.png', '', 'clients_8', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(160, 'clients_9', 'images/2019/07/05/clients_9.png', '', 'clients_9', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(161, 'clients_7', 'images/2019/07/05/clients_7.png', '', 'clients_7', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(162, 'clients_10', 'images/2019/07/05/clients_10.png', '', 'clients_10', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(163, 'clients_11', 'images/2019/07/05/clients_11.png', '', 'clients_11', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(164, 'clients_12', 'images/2019/07/05/clients_12.png', '', 'clients_12', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:46:04', 58, '0000-00-00 00:00:00', 0),
(165, 'tab-2', 'images/2019/07/05/tab-2.jpg', 'images/2019/07/05/_spmedia_thumbs/tab-2.jpg', 'tab-2', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:49:19', 58, '0000-00-00 00:00:00', 0),
(166, 'tab-3', 'images/2019/07/05/tab-3.jpg', 'images/2019/07/05/_spmedia_thumbs/tab-3.jpg', 'tab-3', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:49:36', 58, '0000-00-00 00:00:00', 0),
(167, 'tab-4', 'images/2019/07/05/tab-4.jpg', 'images/2019/07/05/_spmedia_thumbs/tab-4.jpg', 'tab-4', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:50:26', 58, '0000-00-00 00:00:00', 0),
(168, 'tab-1', 'images/2019/07/05/tab-1.jpg', 'images/2019/07/05/_spmedia_thumbs/tab-1.jpg', 'tab-1', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:50:40', 58, '0000-00-00 00:00:00', 0),
(169, 'feedback_3', 'images/2019/07/05/feedback_3.jpg', '', 'feedback_3', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:59:20', 58, '0000-00-00 00:00:00', 0),
(170, 'feedback_1', 'images/2019/07/05/feedback_1.jpg', '', 'feedback_1', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:59:20', 58, '0000-00-00 00:00:00', 0),
(171, 'feedback_5', 'images/2019/07/05/feedback_5.jpg', '', 'feedback_5', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:59:20', 58, '0000-00-00 00:00:00', 0),
(172, 'feedback_2', 'images/2019/07/05/feedback_2.jpg', '', 'feedback_2', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:59:20', 58, '0000-00-00 00:00:00', 0),
(173, 'feedback_4', 'images/2019/07/05/feedback_4.jpg', '', 'feedback_4', '', '', 'image', 'com_sppagebuilder', '2019-07-05 06:59:20', 58, '0000-00-00 00:00:00', 0),
(174, 'simple-edit', 'images/2019/07/05/simple-edit.png', '', 'simple-edit', '', '', 'image', 'com_sppagebuilder', '2019-07-05 07:00:56', 58, '0000-00-00 00:00:00', 0),
(175, 'main-slider2', 'images/2019/07/05/main-slider2.jpg', 'images/2019/07/05/_spmedia_thumbs/main-slider2.jpg', 'main-slider2', '', '', 'image', 'com_sppagebuilder', '2019-07-05 07:04:55', 58, '0000-00-00 00: